library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Clock_Generator is
    port(
        clk                         : in  std_logic;
        reset                       : in  std_logic;   
		  DIVIDER                     : in  std_logic_vector(31 downto 0);
		  error_flag_divider_zero     : out std_logic := '0';
		  Terminal_count              : out std_logic := '0';
		  clock_out                   : out std_logic
    );
end Clock_Generator;

architecture behaviour of Clock_Generator is

    signal rising_count  : integer := 0; 
    signal falling_count : integer := 0; 
	 signal total_count : integer;
	 signal clock_div : std_logic:='0';
	 signal divider_int : integer;
	 
begin

divider_int <= to_integer(signed(divider));

    process(clk, reset)
    begin
        -- Reset asincrono
        if (reset = '1')then
            rising_count <= -1;  
            falling_count <= 0; 
				clock_div <= '0';
				error_flag_divider_zero <= '0';
        else
            if rising_edge(clk) then
                rising_count <= rising_count + 1;
            end if;

            if falling_edge(clk) then
                falling_count <= falling_count + 1;
            end if;
				
				if (divider_int = 0) then
				   error_flag_divider_zero <= '1';
				end if;
				
				if (divider_int = 1) then
				   Terminal_count <= '1';
					error_flag_divider_zero <= '0';

				end if;
				
				if (divider_int > 1) then
				error_flag_divider_zero <= '0';
				   if ((total_count = divider_int-2) and (clock_div = '0')) then
	               Terminal_count <= '1';
	            end if;
				end if;
				
				
				if (total_count = divider_int-1) then
	            clock_div <= not clock_div;
					rising_count <= 0;
               falling_count <= 0;
					if (divider_int > 1) then
					   Terminal_count <= '0';
					end if;
	         end if;
				
				if (total_count > divider_int-1) then
					rising_count <= 0;
               falling_count <= 0;
	         end if;
				
        end if;
    end process;
	 
    total_count <= rising_count + falling_count;
	 
	 clock_out <= clock_div;

end behaviour;

		  