library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CU_Pattern_Generator is
port(
     Clock                         : in   std_logic;
     Reset                         : in   std_logic;
	  start                         : in   std_logic;
	  stop                          : in   std_logic;
	  error_flag_divider_zero       : in   std_logic;
	  terminal_count_clock          : in   std_logic;
 	  trigger_out                   : in   std_logic;
	  working_mode_to_fsm           : in   std_logic;
	  rd                            : in   std_logic;
	  wr                            : in   std_logic;
	  end_loop_reps                 : in   std_logic;
	  out_error_state               : in   std_logic;
	  setting                       : in   std_logic_vector(3 downto 0);
	  sel_data_read                 : out  std_logic_vector(3 downto 0);
	  reset_addr_management         : out  std_logic;
	  en_reg_loop_max_register      : out  std_logic;
	  reset_loop                    : out  std_logic;
	  enable_loop_counter           : out  std_logic;
	  rd_from_fsm                   : out  std_logic;
	  wr_from_fsm                   : out  std_logic;
	  sel_addr                      : out  std_logic;
	  en_addr_management            : out  std_logic;
	  reset_from_cu                 : out  std_logic;
	  reset_start_reg               : out  std_logic;
	  done                          : out  std_logic;
	  error                         : out  std_logic;
	  en_reg_divider_clock          : out  std_logic;
	  en_reg_clk_sel                : out  std_logic;
	  enable_pattern_reg            : out  std_logic;
     en_reg_mask_output_enable     : out  std_logic;	
	  en_reg_mask_trigger           : out  std_logic;
	  en_reg_mask_trigger_condition : out  std_logic;
	  enable_trigger                : out  std_logic;
	  en_reg_working_mode           : out  std_logic;
     en_reg_start                  : out  std_logic;
	  en_reg_data_memory            : out  std_logic;
	  en_reg_addr_memory            : out  std_logic;
	  en_reg_data_read_memory	     : out  std_logic
);
	   
		  
end CU_Pattern_Generator;
		  
architecture Structure of CU_Pattern_Generator is

type State_type is (s0_reset, s1_idle, s2_wr_clock_divider_reg, s3_rd_clock_divider_reg, s4_wr_clock_selection_reg,
                    s5_rd_clock_selection_reg, s6_wr_addr_reg, s7_rd_addr_reg, s8_wr_data_reg, s9_rd_data_reg, 
						  s10_wr_trigger_mask_reg, s11_rd_trigger_mask_reg, s12_wr_trigger_condition_reg, s13_rd_trigger_condition_reg, 
						  s14_wr_start_reg, s15_rd_start_reg, s16_wr_working_mode_reg, s17_rd_working_mode_reg, s18_wr_mask_OE_reg,
						  s19_rd_mask_OE_reg, s20_wr_max_loop_reg, s21_rd_max_loop_reg, s22_divider_check, s23_loop_active, 
						  s24_memory_active, s25_trigger_active, s26_trigger_value, s27_wait_clock_sample, s28_generate_pattern,
						  s29_update_addr_loop, s29_1_update_addr_loop, s30_done, s31_error, s32_update_addr_write_memory, s32_1_update_addr_write_memory, s33_wr_data_on_memory, s34_rd_data_memory, s35_upgrade_register);
						  
signal present_state : State_type;
signal next_state : State_type ;

begin

State_registers : process(clock)
begin
   if (clock='1' and clock'event) then
	     if (Reset='1') then
	       present_state <= s0_reset;
		  end if;
		  if (Reset='0') then
		     if (Stop='1') then
			  present_state <= s1_idle;
			  end if;
			  if(Stop = '0') then
			  present_state <= next_state;
			  end if;
		  end if;
	end if;
end process State_registers;

State_transitions : process (Clock, Reset, start, stop, error_flag_divider_zero, terminal_count_clock, trigger_out,
     	                       working_mode_to_fsm, rd, wr, end_loop_reps, out_error_state, setting, present_state)
begin  

next_state <= s0_reset;

case present_state is
     when s0_reset => next_state <= s1_idle;
					 
	  when s1_idle =>  case start is
	                      when '1' => next_state <= s22_divider_check;
						       when others => case wr is
								                when '1' => case setting is 
								                               when "0000" => next_state <= s1_idle;
								 				                   when "0001" => next_state <= s2_wr_clock_divider_reg;
								 				                   when "0010" => next_state <= s4_wr_clock_selection_reg;
								 			                      when "0011" => next_state <= s6_wr_addr_reg;
								 				                   when "0100" => next_state <= s8_wr_data_reg;
								 			            	       when "0101" => next_state <= s10_wr_trigger_mask_reg;
            			            	 		             when "0110" => next_state <= s12_wr_trigger_condition_reg;
										            				 when "0111" => next_state <= s14_wr_start_reg;
												            		 when "1000" => next_state <= s16_wr_working_mode_reg;
												            		 when "1001" => next_state <= s18_wr_mask_OE_reg;
												            		 when "1010" => next_state <= s20_wr_max_loop_reg;
											            			 when others => next_state <= s1_idle;
																	end case;
								 				     when others => case rd is 
														                 when '1' => case setting is 
								                                                  when "0000" => next_state <= s1_idle;
								 				                                      when "0001" => next_state <= s3_rd_clock_divider_reg;
								 				                                      when "0010" => next_state <= s5_rd_clock_selection_reg;
								 			                                         when "0011" => next_state <= s7_rd_addr_reg;
								 				                                      when "0100" => next_state <= s9_rd_data_reg;
								 			                                         when "0101" => next_state <= s11_rd_trigger_mask_reg;
            			            	 		                                when "0110" => next_state <= s13_rd_trigger_condition_reg;
										               	 	                       when "0111" => next_state <= s15_rd_start_reg;
												            	                       when "1000" => next_state <= s17_rd_working_mode_reg;
												            	                       when "1001" => next_state <= s19_rd_mask_OE_reg;
												                                      when "1010" => next_state <= s21_rd_max_loop_reg;
																								  when "1011" => next_state <= s34_rd_data_memory;
											            	  	                       when others => next_state <= s1_idle;
																				 		     end case;
																				 when others => next_state <= s1_idle;
																			 end case;
												     end case;
					      end case;
							
     when s2_wr_clock_divider_reg => next_state <= s1_idle;
													 
     when s3_rd_clock_divider_reg => next_state <= s30_done;
	  
     when s4_wr_clock_selection_reg => next_state <= s1_idle;
	  
     when s5_rd_clock_selection_reg => next_state <= s30_done;
	  
     when s6_wr_addr_reg => next_state <= s1_idle;
	  
     when s7_rd_addr_reg => next_state <= s30_done;
	  
     when s8_wr_data_reg => next_state <= s33_wr_data_on_memory;
	  
	  
	  when s33_wr_data_on_memory => case working_mode_to_fsm is
	                                   when '1' => next_state <= s32_update_addr_write_memory;
										        when others => next_state <= s30_done;
									        end case;
	  
	  when s9_rd_data_reg => next_state <= s30_done;
	  
	  when s10_wr_trigger_mask_reg => next_state <= s1_idle;
	  
     when s11_rd_trigger_mask_reg => next_state <= s30_done;
	  
     when s12_wr_trigger_condition_reg => next_state <= s1_idle;
	  
     when s13_rd_trigger_condition_reg => next_state <= s30_done;
	  
     when s14_wr_start_reg => next_state <= s1_idle;
	  
     when s15_rd_start_reg => next_state <= s30_done;
	  
	  when s16_wr_working_mode_reg => next_state <= s1_idle;
	  
	  when s17_rd_working_mode_reg => next_state <= s30_done;
	  
     when s18_wr_mask_OE_reg => next_state <= s1_idle;
	  
     when s19_rd_mask_OE_reg => next_state <= s30_done;
	  
     when s20_wr_max_loop_reg => next_state <= s1_idle;
	  
	  when s21_rd_max_loop_reg => next_state <= s30_done;	
	
     when s34_rd_data_memory => next_state <= s35_upgrade_register;
	 
	  when s35_upgrade_register => case rd is
	                                 when '0' => case working_mode_to_fsm is 
			                                         when '0' => next_state <= s30_done;
																  when others => next_state <= s32_update_addr_write_memory;
																end case;
	                                 when others => next_state <= s35_upgrade_register;
											 end case;
												
--	                               case working_mode_to_fsm is 
--			                           when '0' => case rd is
--	                                               when '0' => next_state <= s30_done;
--												              when others =>  next_state <= s35_upgrade_register;
--											               end case;
--											   when others => case rd is
--	                                                  when '0' => next_state <= s32_update_addr_write_memory;
--												                 when others =>  next_state <= s35_upgrade_register;
--											                  end case;
--											 end case;
	  
	  when s22_divider_check => case error_flag_divider_zero is
	                                     when '0' => next_state <= s23_loop_active;
													 when others => next_state <= s31_error;
												  end case;
	  
	  when s23_loop_active => case end_loop_reps is 
			                      when '0' => next_state <= s24_memory_active;
				  		             when others => next_state <= s31_error;
							       end case;
									 
	  when s24_memory_active => next_state <= s25_trigger_active;

								 
	  when s25_trigger_active => next_state <= s26_trigger_value;
	  
										  
	  when s26_trigger_value => case trigger_out is 
			                          when '1' => next_state <= s27_wait_clock_sample;
				  		                 when others => next_state <= s31_error;
							           end case;
										  
	  when s27_wait_clock_sample => case terminal_count_clock is 
			                          when '1' => next_state <= s28_generate_pattern;
				  		                 when others => next_state <= s27_wait_clock_sample;
							           end case;
	 
	  when s28_generate_pattern => case working_mode_to_fsm is 
			                          when '0' => next_state <= s30_done;
				  		                 when others => case end_loop_reps is 
			                                            when '0' => next_state <= s29_update_addr_loop;
				  		                                   when others => next_state <= s30_done;
							                             end case;
							             end case;
											 
	  WHEN s29_update_addr_loop => next_state <= s29_1_update_addr_loop;
	  
	  WHEN s29_1_update_addr_loop => next_state <= s1_idle; -- DA RISOLVERE
												  
	  
	  when s30_done => next_state <= s1_idle;
	 
	  when s31_error => case out_error_state is
	                       when '1' => next_state <= s1_idle;
								  when others => next_state <= s31_error;
							  end case;
	  
	  when s32_update_addr_write_memory => next_state <= s32_1_update_addr_write_memory;
	  
	  when s32_1_update_addr_write_memory => case end_loop_reps is 
			                                     when '0' => next_state <= s1_idle;
				  		                            when others => next_state <= s30_done;
							                       end case;
	  
end case;
end process State_transitions;

Control_State : process(present_state)
	begin

		case present_state is
			when s0_reset => 	sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '1';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '1';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '1';
									reset_addr_management         <= '1';




						  
			when s1_idle => 	sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';--AGIIUNGERE UNO STATO CHE RESETTI ALLA FINE DEL LOOP
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        --done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';


			
							
     when s2_wr_clock_divider_reg => sel_data_read       <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '1';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
													 
     when s3_rd_clock_divider_reg => sel_data_read       <= "0001"; 
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
     when s4_wr_clock_selection_reg => sel_data_read     <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '1';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s5_rd_clock_selection_reg => sel_data_read     <= "0010";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s6_wr_addr_reg => sel_data_read                <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '1';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s7_rd_addr_reg => sel_data_read                <= "0011";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s8_wr_data_reg => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';--NON SO SE ORA O AL COLPO DI CLK DOPO METTENDO UN NUOVO STATO
	                       -- sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '1';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
	  when s33_wr_data_on_memory => sel_data_read          <= "0000";
	                         en_reg_loop_max_register      <= '0';
	                         reset_loop                    <= '0';
	                         enable_loop_counter           <= '0';
	                         rd_from_fsm                   <= '0';
	                         wr_from_fsm                   <= '1';
	                         --sel_addr                      <= '0';
	                         en_addr_management            <= '0';
	                         reset_from_cu                 <= '0';
	                         done                          <= '0';
	                         error                         <= '0';
	                         en_reg_divider_clock          <= '0';
	                         en_reg_clk_sel                <= '0';
	                         enable_pattern_reg            <= '0';
                            en_reg_mask_output_enable     <= '0';
	                         en_reg_mask_trigger           <= '0';
	                         en_reg_mask_trigger_condition <= '0';
	                         enable_trigger                <= '0';
	                         en_reg_working_mode           <= '0';
                            en_reg_start                  <= '0';
	                         en_reg_data_memory            <= '0';
	                         en_reg_addr_memory            <= '0';
	                         en_reg_data_read_memory	    <= '0';
									 reset_start_reg               <= '0';
									 reset_addr_management         <= '0';
	  
	  when s9_rd_data_reg => sel_data_read                <= "0100";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
	  when s10_wr_trigger_mask_reg => sel_data_read       <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '1';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s11_rd_trigger_mask_reg => sel_data_read       <= "0101";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s12_wr_trigger_condition_reg =>sel_data_read   <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '1';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s13_rd_trigger_condition_reg => sel_data_read  <= "0110";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s14_wr_start_reg => sel_data_read              <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '1';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s15_rd_start_reg => sel_data_read              <= "0111";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
	  when s34_rd_data_memory => sel_data_read              <= "1011";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '1';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
		when s35_upgrade_register => sel_data_read              <= "1011";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
									
	  
	  when s16_wr_working_mode_reg => sel_data_read       <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '1';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
	  when s17_rd_working_mode_reg => sel_data_read       <= "1000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s18_wr_mask_OE_reg => sel_data_read            <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '1';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s19_rd_mask_OE_reg => sel_data_read            <= "1001";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
     when s20_wr_max_loop_reg => sel_data_read           <= "0000";
	                        en_reg_loop_max_register      <= '1';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
	  when s21_rd_max_loop_reg =>sel_data_read            <= "1010";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '1';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
	  when s22_divider_check => sel_data_read             <= "0000";    --LASCIO TUTTO COSI PERCHE IL CONTROLLO è COMBINATORIO
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';--PROVA
	  
	  when s23_loop_active => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '1';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									 
	  when s24_memory_active => sel_data_read             <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '1';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
	  when s25_trigger_active => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '1';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
										  
	  when s26_trigger_value => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
										  
	  when s27_wait_clock_sample => sel_data_read         <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	 
	  when s28_generate_pattern => sel_data_read          <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '1';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
											 
	  WHEN s29_update_addr_loop => sel_data_read          <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '1';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '1';
									reset_addr_management         <= '0';
									
		WHEN s29_1_update_addr_loop => sel_data_read          <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '1';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
	  
	  when s30_done => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '1';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '1';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '1';
									reset_addr_management         <= '1';
	 
	  when s31_error => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '1';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '1';
									reset_addr_management         <= '0';
	  
	  when s32_update_addr_write_memory => sel_data_read                 <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '1';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        --sel_addr                      <= '0';
	                        en_addr_management            <= '1';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';
									
		WHEN s32_1_update_addr_write_memory => sel_data_read          <= "0000";
	                        en_reg_loop_max_register      <= '0';
	                        reset_loop                    <= '0';
	                        enable_loop_counter           <= '0';
	                        rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        sel_addr                      <= '1';
	                        en_addr_management            <= '0';
	                        reset_from_cu                 <= '0';
	                        done                          <= '0';
	                        error                         <= '0';
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        enable_pattern_reg            <= '0';
                           en_reg_mask_output_enable     <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        enable_trigger                <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_start                  <= '0';
	                        en_reg_data_memory            <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_data_read_memory	      <= '0';
									reset_start_reg               <= '0';
									reset_addr_management         <= '0';

		end case;
	end process;
	
end Structure;