library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity FSM_Slave_SPI_to_Avalon is
port(
     clock               : in std_logic;
     Serial_Rising_Edge  : in std_logic;
	  Serial_Falling_Edge : in std_logic;
	  TC8                 : in std_logic;
	  TC32                : in std_logic;
	  SS                  : in std_logic;
	  wr                  : in std_logic;
	  rd                  : in std_logic;
	  clr                 : in std_logic;
	  waitrequest         : in std_logic;
	  ld_cmd             : out std_logic;
	  wr_mem              : out std_logic;
	  rd_mem              : out std_logic;
	  en_cnt              : out std_logic;
	  en_miso             : out std_logic;
	  SS_En               : out std_logic;
	  shift_SCLK          : out std_logic;
	  Shiftcommand        : out std_logic;
	  reset_cnt           : out std_logic;
	  shiftaddress        : out std_logic;
	  shiftdata           : out std_logic;
	  loaddata            : out std_logic;
	  shiftreaddata       : out std_logic;
	  rst_cmd_reg         : out std_logic;
	  reset_system        : out std_logic
	 );
		  
end FSM_Slave_SPI_to_Avalon;
		  
architecture Structure of FSM_Slave_SPI_to_Avalon is

type State_type is (s0_reset, s1_idle, s2_sclk, s3_opcode_samp, s4_wait_1, s5_wait_2, 
                    s6_address_samp, s7_wait3_wr, s8_wait4_wr, s9_data_samp, 
                    s10_wait5_wr, s11_write_mem, s12_wait5_wr, s13_wait3_rd, s14_wait4_rd, 
						  s15_read_data, s16_wait5_rd, s17_send_data, s18_wait6_rd, s19_wait7_rd);

signal present_state : State_type;
signal next_state : State_type ;

begin

State_registers : process(clock)
begin
   if (clock='1' and clock'event) then
	     if (clr='1') then
	       present_state <= s0_reset;
		  else
			  present_state <= next_state;
		  end if;
	end if;
end process State_registers;

State_transitions : process (clock, Serial_Rising_Edge, Serial_Falling_Edge, TC8, TC32, SS, wr, rd, clr, waitrequest, present_state)
begin  

next_state <= s0_reset;

case present_state is
     when s0_reset => next_state <= s1_idle;
					 
	  when s1_idle =>  case SS is
	                     when '0' => next_state <= s2_sclk;
						      when others => next_state <= s1_idle;
					       end case;
					             			 
	  when s2_sclk => case Serial_Rising_Edge is
	                    when '1' => next_state <= s3_opcode_samp;
						     when others => next_state <= s2_sclk;
					      end case;
	  
     when s3_opcode_samp =>  next_state <= s4_wait_1;
	  
	  when s4_wait_1 =>case TC8 is
	                       when '1' => next_state <= s5_wait_2;
					           when others => case Serial_Rising_Edge is
	                                         when '1' =>  next_state <= s3_opcode_samp;
					                             when others => next_state <= s4_wait_1;
					                          end case;	 
					        end CASE;  
					  
	  when s5_wait_2 => case Serial_Rising_Edge is
							     when '1' => case (wr XOR rd) is
								                 when '1' => next_state <= s6_address_samp;
													  when others => next_state <= s1_idle;
												  end case;
								  when others => next_state <= s5_wait_2;
								end case;
					 
	  when s6_address_samp => case wr is
					                 when '1' => case rd is
					                                when '1' => next_state <= s1_idle;
						                             when others => next_state <= s7_wait3_wr;
					                             end case;
						              when others => case rd is
					                                when '1' => next_state <= s13_wait3_rd;
						                             when others => next_state <= s1_idle;
					                             end case;
					              end case;
	  
	  
	  when s7_wait3_wr => case TC32 is
					             when '1' => next_state <= s8_wait4_wr;
						          when others => case Serial_Rising_Edge is
					                               when '1' =>  next_state <= s6_address_samp;
						                            when others =>  next_state <= s7_wait3_wr;
					                            end case;
					          end case;			
					 
	  when s8_wait4_wr => case Serial_Rising_Edge is
					             when '1' => next_state <= s9_data_samp;
						          when others => next_state <= s8_wait4_wr;
					        end case;
	  
	  when s9_data_samp =>  next_state <= s10_wait5_wr;
					 
	  when s10_wait5_wr =>case TC32 is
					             when '1' => case waitrequest is 
									                when '0' => next_state <= s11_write_mem;
														 when others => next_state <= s10_wait5_wr;
													 end case;
						          when others => case Serial_Rising_Edge is
					                               when '1' =>  next_state <= s9_data_samp;
						                            when others =>  next_state <= s10_wait5_wr;
					                            end case;
					          end case;	
					 
	  when s11_write_mem => case SS is
						            when '0' => next_state <= s12_wait5_wr;	    		 
									   when others => next_state <= s1_idle;
									end case;  
					 
	  when s12_wait5_wr => case Serial_Rising_Edge is
					                 when '1' => next_state <= s0_reset;
						              when others => next_state <= s12_wait5_wr;
					           end case;
	  
	  when s13_wait3_rd =>case TC32 is
					             when '1' => next_state <= s14_wait4_rd;
						          when others => case Serial_Rising_Edge is
					                               when '1' =>  next_state <= s6_address_samp;
						                            when others =>  next_state <= s13_wait3_rd;
					                            end case;
					          end case;	
				 
	  when s14_wait4_rd => case Serial_Falling_Edge is
					                 when '1' => case waitrequest is
	                                            when '0' => next_state <= s15_read_data;
										                 when others => next_state <= s14_wait4_rd;
									                 end case;
						              when others => next_state <= s14_wait4_rd;
					           end case;
	  
	  
	  when s15_read_data => next_state <= s16_wait5_rd;

	  when s16_wait5_rd => case Serial_Falling_Edge is
					                 when '1' => next_state <= s17_send_data;
						              when others => next_state <= s16_wait5_rd;
					           end case;
	  	  
	  when s17_send_data => next_state <= s18_wait6_rd;
	  
	  when s18_wait6_rd => case TC32 is
					               when '1' => case SS is
					                                when '0' => next_state <= s19_wait7_rd;
						                             when OTHERS => next_state <= s1_idle;
					                           end case;
						            when OTHERS => case Serial_Falling_Edge is
					                                 when '1' => next_state <= s17_send_data;
						                              when others =>  next_state <= s18_wait6_rd;
					                              end case; 	
									  
					          end case; 	
					       
	  when s19_wait7_rd => case Serial_Rising_Edge is
					                 when '1' => next_state <= s12_wait5_wr;
						              when others => next_state <= s19_wait7_rd;
					           end case;
   when others => next_state <= s1_idle; 
     
end case;
end process State_transitions;

Control_State : process(present_state)
	begin

		case present_state is
			when s0_reset => 	reset_cnt <= '1';
									en_cnt <= '0';
									SS_En <= '0';
									shift_SCLK <= '0';
									Shiftcommand <= '0';
									shiftaddress <= '0';
									shiftdata <= '0';
									shiftreaddata <= '0';
									loaddata <= '0';
									wr_mem <= '0';
									rd_mem <= '0';
									en_miso <= '0';
									rst_cmd_reg <= '0';
									ld_cmd <= '0';
									reset_system <= '1';
						  
			when s1_idle => 	reset_cnt <= '1';
									en_cnt <= '0';
									SS_En <= '0';
									shift_SCLK <= '1';
									Shiftcommand <= '0';
									shiftaddress <= '0';
									shiftdata <= '0';
									shiftreaddata <= '0';
									loaddata <= '0';
									wr_mem <= '0';
									rd_mem <= '0';
									en_miso <= '0';
									rst_cmd_reg <= '1';
									ld_cmd <= '0';
									reset_system <= '0';
						  
		   when s2_sclk => 	reset_cnt <= '0';
									en_cnt <= '0';
									SS_En <= '1';
									shift_SCLK <= '1';
									Shiftcommand <= '0';
									shiftaddress <= '0';
									shiftdata <= '0';
									shiftreaddata <= '0';
									loaddata <= '0';
									wr_mem <= '0';
									rd_mem <= '0';
									en_miso <= '0';
									rst_cmd_reg <= '0';
									ld_cmd <= '0';
									reset_system <= '0';
		              
         when s3_opcode_samp => 	reset_cnt <= '0';
											en_cnt <= '1';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '1';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
											rst_cmd_reg <= '0';
									      ld_cmd <= '1';
											reset_system <= '0';
			
			when s4_wait_1 =>		reset_cnt <= '0';
										en_cnt <= '0';
										SS_En <= '1';
										shift_SCLK <= '1';
										Shiftcommand <= '0';
										shiftaddress <= '0';
										shiftdata <= '0';
										shiftreaddata <= '0';
										loaddata <= '0';
										wr_mem <= '0';
										rd_mem <= '0';
										en_miso <= '0';
									   rst_cmd_reg <= '0';
										ld_cmd <= '1';
										reset_system <= '0';
			
			when s5_wait_2 =>		reset_cnt <= '1';
										en_cnt <= '0';
										SS_En <= '1';
										shift_SCLK <= '1';
										Shiftcommand <= '0';
										shiftaddress <= '0';
										shiftdata <= '0';
										shiftreaddata <= '0';
										loaddata <= '0';
										wr_mem <= '0';
										rd_mem <= '0';
										en_miso <= '0';
			                  	rst_cmd_reg <= '0';
										ld_cmd <= '0';
										reset_system <= '0';

						 
			when s6_address_samp =>		reset_cnt <= '0';
												en_cnt <= '1';
												SS_En <= '1';
												shift_SCLK <= '1';
												Shiftcommand <= '0';
												shiftaddress <= '1';
												shiftdata <= '0';
												shiftreaddata <= '0';
												loaddata <= '0';
												wr_mem <= '0';
												rd_mem <= '0';
												en_miso <= '0';
		                              rst_cmd_reg <= '0';
									         ld_cmd <= '0';
												reset_system <= '0';
						  
			when s7_wait3_wr =>		reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
											rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			          
		   when s8_wait4_wr =>		reset_cnt <= '1';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
			                        rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			
		   when s9_data_samp =>		reset_cnt <= '0';
											en_cnt <= '1';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '1';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
                                 rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			
		   when s10_wait5_wr => 	reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
		                           rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			          
			when s11_write_mem => 	reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '1';
											rd_mem <= '0';
											en_miso <= '0';
											rst_cmd_reg <= '1';
										   ld_cmd <= '0';	
											reset_system <= '0';
						
						  
			when s12_wait5_wr =>		reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
									      rst_cmd_reg <= '1';
										   ld_cmd <= '0';	
											reset_system <= '0';
		

			when s13_wait3_rd =>		reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
                                 rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			            
         when s14_wait4_rd =>		reset_cnt <= '1';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
											rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';

							
			when s15_read_data =>	reset_cnt <= '0';
											en_cnt <= '1';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '1';
											wr_mem <= '0';
											rd_mem <= '1';
											en_miso <= '0';
										 	rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
										
			when s16_wait5_rd =>		reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '1';
											wr_mem <= '0';
											rd_mem <= '1';
											en_miso <= '1';
		                           rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			
			when s17_send_data => 	reset_cnt <= '0';
											en_cnt <= '1';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '1';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '1';
			                        rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
										
			when s18_wait6_rd =>		reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '1';
			                        rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';
			
			when s19_wait7_rd => 	reset_cnt <= '0';
											en_cnt <= '0';
											SS_En <= '1';
											shift_SCLK <= '1';
											Shiftcommand <= '0';
											shiftaddress <= '0';
											shiftdata <= '0';
											shiftreaddata <= '0';
											loaddata <= '0';
											wr_mem <= '0';
											rd_mem <= '0';
											en_miso <= '0';
											rst_cmd_reg <= '0';
											ld_cmd <= '0';
											reset_system <= '0';

			when others =>    reset_cnt <= '1';
									en_cnt <= '0';
									SS_En <= '0';
									shift_SCLK <= '0';
									Shiftcommand <= '0';
									shiftaddress <= '0'; 
									shiftdata <= '0';
									shiftreaddata <= '0';
									loaddata <= '0';
									wr_mem <= '0';
									rd_mem <= '0';
									en_miso <= '0';
				               rst_cmd_reg <= '0';
				               ld_cmd <= '0';					
									reset_system <= '0';
		end case;
	end process;
	
end Structure;
-----------------------------------------------------------------------------------------------	
--library ieee;
--use ieee.std_logic_1164.all;
--use ieee.numeric_std.all;
--entity FSM_Slave_SPI_to_Avalon is
--port(
--     clock               : in std_logic;
--     Serial_Rising_Edge  : in std_logic;
--	  Serial_Falling_Edge : in std_logic;
--	  TC8                 : in std_logic;
--	  TC32                : in std_logic;
--	  SS                  : in std_logic;
--	  wr                  : in std_logic;
--	  rd                  : in std_logic;
--	  clr                 : in std_logic;
--	  waitrequest         : in std_logic;
--	  wr_mem              : out std_logic;
--	  rd_mem              : out std_logic;
--	  en_cnt              : out std_logic;
--	  en_miso             : out std_logic;
--	  SS_En               : out std_logic;
--	  shift_SCLK          : out std_logic;
--	  Shiftcommand        : out std_logic;
--	  reset_cnt           : out std_logic;
--	  shiftaddress        : out std_logic;
--	  shiftdata           : out std_logic;
--	  loaddata            : out std_logic;
--	  shiftreaddata       : out std_logic;
--	  state               : out std_logic_vector(4 downto 0)
--	 );
--		  
--end FSM_Slave_SPI_to_Avalon;
--		  
--architecture Structure of FSM_Slave_SPI_to_Avalon is
--
--type State_type is (s0_reset, s1_idle, s2_sclk, s3_opcode_samp, s4_wait_1, s5_wait_2, 
--                    s6_address_samp, s7_wait3_wr, s8_wait4_wr, s9_data_samp, 
--                    s10_wait5_wr, s11_write_mem, s12_wait5_wr, s13_wait3_rd, s14_wait4_rd, 
--						  s15_read_data, s16_wait5_rd, s17_send_data, s18_wait6_rd, s19_wait7_rd);
--
--signal present_state : State_type;
--
--begin
--
--State_transitions : process(clock, clr)
--begin
--	     if (clr='1') then
--	       present_state <= s0_reset;		  
--		  elsif (clock='1' and clock'event) then
--case present_state is
--     when s0_reset => present_state <= s1_idle;
--					 
--	  when s1_idle =>  case SS is
--	                     when '1' => present_state <= s2_sclk;
--						      when others => present_state <= s1_idle;
--					       end case;
--					             			 
--	  when s2_sclk => case Serial_Rising_Edge is
--	                    when '1' => present_state <= s3_opcode_samp;
--						     when others => present_state <= s2_sclk;
--					      end case;
--	  
--     when s3_opcode_samp =>  present_state <= s4_wait_1;
--	  
--	  when s4_wait_1 =>case TC8 is
--	                       when '1' => present_state <= s5_wait_2;
--					           when others => case Serial_Rising_Edge is
--	                                         when '1' =>  present_state <= s3_opcode_samp;
--					                             when others => present_state <= s4_wait_1;
--					                          end case;	 
--					        end CASE;  
--					  
--	  when s5_wait_2 =>case Serial_Rising_Edge is
--							     when '1' => case (wr XOR rd) is
--								                 when '1' => present_state <= s6_address_samp;
--													  when others => present_state <= s1_idle;
--												  end case;
--								  when others => present_state <= s5_wait_2;
--								end case;
--					 
--	  when s6_address_samp => case wr is
--					                 when '1' => case rd is
--					                                when '1' => present_state <= s1_idle;
--						                             when others => present_state <= s7_wait3_wr;
--					                             end case;
--						              when others => case rd is
--					                                when '1' => present_state <= s13_wait3_rd;
--						                             when others => present_state <= s1_idle;
--					                             end case;
--					              end case;
--	  
--	  
--	  when s7_wait3_wr =>case TC32 is
--					             when '1' => present_state <= s8_wait4_wr;
--						          when others => case Serial_Rising_Edge is
--					                               when '1' =>  present_state <= s6_address_samp;
--						                            when others =>  present_state <= s7_wait3_wr;
--					                            end case;
--					          end case;			
--					 
--	  when s8_wait4_wr => case Serial_Rising_Edge is
--					             when '1' => present_state <= s9_data_samp;
--						          when others => present_state <= s8_wait4_wr;
--					        end case;
--	  
--	  when s9_data_samp =>  present_state <= s10_wait5_wr;
--					 
--	  when s10_wait5_wr =>case TC32 is
--					             when '1' => case waitrequest is 
--									                when '0' => present_state <= s11_write_mem;
--														 when others => present_state <= s10_wait5_wr;
--													 end case;
--						          when others => case Serial_Rising_Edge is
--					                               when '1' =>  present_state <= s9_data_samp;
--						                            when others =>  present_state <= s10_wait5_wr;
--					                            end case;
--					          end case;	
--					 
--	  when s11_write_mem => case SS is
--						            when '1' => present_state <= s12_wait5_wr;	    		 
--									   when others => present_state <= s1_idle;
--									end case;  
--					 
--	  when s12_wait5_wr => case Serial_Rising_Edge is
--					                 when '1' => present_state <= s1_idle;
--						              when others => present_state <= s12_wait5_wr;
--					           end case;
--	  
--	  when s13_wait3_rd =>case TC32 is
--					             when '1' => present_state <= s14_wait4_rd;
--						          when others => case Serial_Rising_Edge is
--					                               when '1' =>  present_state <= s6_address_samp;
--						                            when others =>  present_state <= s13_wait3_rd;
--					                            end case;
--					          end case;	
--				 
--	  when s14_wait4_rd =>case Serial_Rising_Edge is
--					                 when '1' => case waitrequest is
--	                                            when '0' => present_state <= s15_read_data;
--										                 when others => present_state <= s14_wait4_rd;
--									                 end case;
--						              when others => present_state <= s14_wait4_rd;
--					           end case;
--	  
--	  
--	  when s15_read_data => present_state <= s16_wait5_rd;
--	                  
--					  
--
--	  when s16_wait5_rd => case Serial_Rising_Edge is
--					                 when '1' => present_state <= s17_send_data;
--						              when others => present_state <= s16_wait5_rd;
--					           end case;
--								  
--								 
--	  	  
--	  when s17_send_data => present_state <= s18_wait6_rd;
--	  
--	  when s18_wait6_rd =>case TC32 is
--					               when '1' => case SS is
--					                                when '1' => present_state <= s19_wait7_rd;
--						                             when OTHERS => present_state <= s1_idle;
--					                           end case;
--						            when OTHERS => case Serial_Rising_Edge is
--					                                 when '1' => present_state <= s17_send_data;
--						                              when others =>  present_state <= s18_wait6_rd;
--					                              end case; 	
--									  
--					          end case; 	
--					       
--	  when s19_wait7_rd => case Serial_Rising_Edge is
--					                 when '1' => present_state <= s12_wait5_wr;
--						              when others => present_state <= s19_wait7_rd;
--					           end case;
--								  
--	 when others => present_state <= s1_idle; 
--end case;
--end if;
--end process State_transitions;
--
--Control_State : process(present_state)
--	begin
--
--	   reset_cnt <= '1'; en_cnt <= '0'; SS_En <= '0'; shift_SCLK <= '0'; Shiftcommand <= '0'; shiftaddress <= '0';
--		shiftdata <= '0'; shiftreaddata <= '0'; loaddata <= '0'; wr_mem <= '0'; rd_mem <= '0'; en_miso <= '0';
--	   
--		case present_state is
--			when s0_reset => 	reset_cnt <= '1';
--									en_cnt <= '0';
--									SS_En <= '0';
--									shift_SCLK <= '0';
--									Shiftcommand <= '0';
--									shiftaddress <= '0'; 
--									shiftdata <= '0';
--									shiftreaddata <= '0';
--									loaddata <= '0';
--									wr_mem <= '0';
--									rd_mem <= '0';
--									en_miso <= '0';
--									state <= "00000";
--						  
--			when s1_idle => 	reset_cnt <= '1';
--									en_cnt <= '0';
--									SS_En <= '0';
--									shift_SCLK <= '0';
--									Shiftcommand <= '0';
--									shiftaddress <= '0';
--									shiftdata <= '0';
--									shiftreaddata <= '0';
--									loaddata <= '0';
--									wr_mem <= '0';
--									rd_mem <= '0';
--									en_miso <= '0';
--									state <= "00001";
--
--						  
--		   when s2_sclk => 	reset_cnt <= '0';
--									en_cnt <= '0';
--									SS_En <= '1';
--									shift_SCLK <= '1';
--									Shiftcommand <= '0';
--									shiftaddress <= '0';
--									shiftdata <= '0';
--									shiftreaddata <= '0';
--									loaddata <= '0';
--									wr_mem <= '0';
--									rd_mem <= '0';
--									en_miso <= '0';
--									state <= "00010";
--							
--		              
--         when s3_opcode_samp => 	reset_cnt <= '0';
--											en_cnt <= '1';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '1';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "00011";
--			
--			
--			when s4_wait_1 =>		reset_cnt <= '0';
--										en_cnt <= '0';
--										SS_En <= '1';
--										shift_SCLK <= '1';
--										Shiftcommand <= '0';
--										shiftaddress <= '0';
--										shiftdata <= '0';
--										shiftreaddata <= '0';
--										loaddata <= '0';
--										wr_mem <= '0';
--										rd_mem <= '0';
--										en_miso <= '0';
--										state <= "00100";
--	  
--			
--			when s5_wait_2 =>		reset_cnt <= '1';
--										en_cnt <= '0';
--										SS_En <= '1';
--										shift_SCLK <= '1';
--										Shiftcommand <= '0';
--										shiftaddress <= '0';
--										shiftdata <= '0';
--										shiftreaddata <= '0';
--										loaddata <= '0';
--										wr_mem <= '0';
--										rd_mem <= '0';
--										en_miso <= '0';
--										state <= "00101";
--			                  
--						 
--			when s6_address_samp =>		reset_cnt <= '0';
--												en_cnt <= '1';
--												SS_En <= '1';
--												shift_SCLK <= '1';
--												Shiftcommand <= '0';
--												shiftaddress <= '1';
--												shiftdata <= '0';
--												shiftreaddata <= '0';
--												loaddata <= '0';
--												wr_mem <= '0';
--												rd_mem <= '0';
--												en_miso <= '0';
--												state <= "00110";
--		
--
--						  
--			when s7_wait3_wr =>		reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "00111";
--											
--			          
--		   when s8_wait4_wr =>		reset_cnt <= '1';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--										   state <= "01000";	
--			
--			
--		   when s9_data_samp =>		reset_cnt <= '0';
--											en_cnt <= '1';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '1';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "01001";
--
--			
--		   when s10_wait5_wr => 	reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "01010";
--		
--			          
--			when s11_write_mem => 	reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '1';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "01011";
--						
--						  
--			when s12_wait5_wr =>		reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0'; --QUA LO METTEVO A 1 PER LA PRIVA VOLTA
--								         state <= "01100";			
--		
--
--			when s13_wait3_rd =>		reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "01101";
--
--			            
--         when s14_wait4_rd =>		reset_cnt <= '1';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '1';
--											en_miso <= '0';
--											state <= "01110";
--											
--
--							
--			when s15_read_data =>	reset_cnt <= '0';
--											en_cnt <= '1';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '1';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "01111";
--										 	
--										
--			when s16_wait5_rd =>		reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '1';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '1';
--											state <= "10000";
--		
--			
--			when s17_send_data => 	reset_cnt <= '0';
--											en_cnt <= '1';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '1';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '1';
--											state <= "10001";
--			
--										
--			when s18_wait6_rd =>		reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '1';
--											state <= "10010";
--			
--			
--			when s19_wait7_rd => 	reset_cnt <= '0';
--											en_cnt <= '0';
--											SS_En <= '1';
--											shift_SCLK <= '1';
--											Shiftcommand <= '0';
--											shiftaddress <= '0';
--											shiftdata <= '0';
--											shiftreaddata <= '0';
--											loaddata <= '0';
--											wr_mem <= '0';
--											rd_mem <= '0';
--											en_miso <= '0';
--											state <= "10011";
--											
--			when others =>    reset_cnt <= '1';
--									en_cnt <= '0';
--									SS_En <= '0';
--									shift_SCLK <= '0';
--									Shiftcommand <= '0';
--									shiftaddress <= '0'; 
--									shiftdata <= '0';
--									shiftreaddata <= '0';
--									loaddata <= '0';
--									wr_mem <= '0';
--									rd_mem <= '0';
--									en_miso <= '0';
--									state <= "11111";
--
--						  	
--		end case;
--	end process;
--	
--end Structure;
--		              