library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity Logic_Analyzer_System is
	port (
		clock_sink_clk            : in  std_logic                     := '0';             --    clock_sink.clk
		reset_sink_reset          : in  std_logic                     := '0';             --    reset_sink.reset
		mosi                      : in  std_logic                     := '0';             --   conduit_end.mosi
		ss                        : in  std_logic                     := '0';             --              .ss
		sclk                      : in  std_logic                     := '0';		--              .sclk
		external_clock            : in std_logic;
		miso                      : out std_logic;                                        --              .miso
		out_error_state           : in std_logic;
		done                      : out std_logic;
	   error                     : out std_logic;
		en_miso                   : out std_logic
	);
end entity Logic_Analyzer_System;

architecture structure of Logic_Analyzer_System is

signal write_data : std_logic_vector(31 downto 0);
signal read_data  : std_logic_vector(31 downto 0);
signal address    : std_logic_vector(31 downto 0);
signal write_i    : std_logic;
signal read_i     : std_logic;

begin

Logic_Analyzer : entity work.Logic_Analyzer
port map(

   clock                          => clock_sink_clk,
	reset                          => reset_sink_reset,
	rd                             => read_i,
	wr                             => write_i,
	external_clock                 => external_clock,
	setting                        => address(3 downto 0),
	clock_divider                  => write_data,
	sel_clk                        => write_data,
   addr_memory                    => write_data,
	pattern_in                     => write_data,
	mask_trigger                   => write_data,
	value_trigger_condition        => write_data,
	loop_max_value                 => write_data,
	working_mode                   => write_data,
	done                           => done,
	error                          => error,
	out_error_state                => out_error_state,
	readdata_reg_out               => read_data
	);
	
SPI_Avalon_Component : entity work.SPI_Avalon_Component 
	port map(
		avalon_master_address     => address,
		avalon_master_read        => read_i,                                   
		avalon_master_readdata    => read_data,
		avalon_master_waitrequest => '0',    
		avalon_master_write       => write_i,                         
		avalon_master_writedata   => write_data,              
		clock_sink_clk            => clock_sink_clk,
		reset_sink_reset          => reset_sink_reset,
		mosi                      => mosi,
		ss                        => ss,
		miso                      => miso,
		sclk                      => sclk,
		en_miso                   => en_miso
);
	
end structure;