library ieee;
use ieee.std_logic_1164.all;

entity TRIGGER is
port(
      clock                   : in std_logic;
		enable                  : in std_logic;
		mask_in                 : in std_logic_vector(31 downto 0);
		data_in                 : in std_logic_vector(31 downto 0);
		value_trigger_condition : in std_logic_vector(31 downto 0);
		trigger_out             : out std_logic
		);
end TRIGGER;

architecture Behaviour of TRIGGER is
begin

process(clock, enable)
begin
if(clock = '1' AND clock'event) then
   if (enable = '1') then
      if((data_in AND mask_in) = value_trigger_condition) then
         trigger_out <= '1';
      else
         trigger_out <= '0';
      end if;
	else
	   trigger_out <= '0';
	end if;
end if;
end process;

end behaviour;