library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity PIPO32bit is
    Port (
        clock     : in  STD_LOGIC;
        reset     : in  STD_LOGIC;
        enable    : in  STD_LOGIC; 
        data_in   : in  STD_LOGIC_VECTOR(31 downto 0);
        data_out  : out STD_LOGIC_VECTOR(31 downto 0)
    );
end entity PIPO32bit;

architecture Behavioral of PIPO32bit is

    signal reg_value : STD_LOGIC_VECTOR(31 downto 0) := (others => '0');
	 
begin

process (clock)
begin
    if (clock'event AND clock ='1') then
        if reset = '1' then
            reg_value <= (others => '0');
        elsif enable = '1' then
            reg_value <= data_in;
        end if;
    end if;
end process;

    
data_out <= reg_value;

end architecture Behavioral;
