library ieee;
use ieee.std_logic_1164.all;

entity Logic_Analyzer is
port(
   clock                          : in  std_logic;
	reset                          : in  std_logic;
	rd                             : in  std_logic;
	wr                             : in  std_logic;
	external_clock                 : in  std_logic;
	out_error_state               : in  std_logic;--------
	setting                        : in  std_logic_vector(3 downto 0);
	clock_divider                  : in  std_logic_vector(31 downto 0);
	sel_clk                        : in  std_logic_vector(31 downto 0);
   addr_memory                    : in  std_logic_vector(31 downto 0);
	pattern_in                     : in  std_logic_vector(31 downto 0);
	mask_trigger                   : in  std_logic_vector(31 downto 0);
	value_trigger_condition        : in  std_logic_vector(31 downto 0);
	loop_max_value                 : in  std_logic_vector(31 downto 0);
	working_mode                   : in  std_logic_vector(31 downto 0);
	done                           : out std_logic;
	error                          : out std_logic;
	readdata_reg_out               : out std_logic_vector(31 downto 0)
	);
end Logic_Analyzer;

architecture structure of Logic_Analyzer is

signal en_reg_divider_clock_i           : STD_LOGIC;
signal en_reg_clk_sel_i                 : STD_LOGIC;
signal en_reg_addr_memory_i             : STD_LOGIC;
signal en_reg_mask_trigger_i            : STD_LOGIC;
signal en_reg_mask_trigger_condition_i  : STD_LOGIC;
signal en_reg_loop_max_register_i       : STD_LOGIC;
signal en_reg_working_mode_i            : STD_LOGIC;
signal en_reg_data_read_i               : STD_LOGIC;
signal rd_from_fsm_i                    : STD_LOGIC;
signal wr_from_fsm_i                    : STD_LOGIC;
signal enable_loop_counter_i            : STD_LOGIC;
signal enable_trigger_i                 : STD_LOGIC;
signal reset_loop_i                     : STD_LOGIC;
signal reset_addr_management_i          : STD_LOGIC;
signal sel_addr_i                       : STD_LOGIC;
signal en_addr_management_i             : STD_LOGIC;
signal error_flag_divider_zero_i        : STD_LOGIC;
signal terminal_count_clock_i           : STD_LOGIC;
signal working_mode_to_fsm_i            : STD_LOGIC;
signal trigger_out_i                    : STD_LOGIC;
signal end_loop_reps_i                  : STD_LOGIC;
signal reset_from_cu_i                  : STD_LOGIC;
signal reset_glitch_i                   : STD_LOGIC;
signal flag_one_i                       : STD_LOGIC;
signal sel_data_read_i                  : STD_LOGIC_VECTOR(3 DOWNTO 0);
signal counter_loop_i                   : STD_LOGIC;
begin

DP_LOGIC_ANALYZER : entity work.DP_Logic_Analyzer
port map(
   clock                          => clock,
	reset                          => reset_from_cu_i,
	en_reg_divider_clock           => en_reg_divider_clock_i,
	en_reg_clk_sel                 => en_reg_clk_sel_i,
	en_reg_addr_memory             => en_reg_addr_memory_i,
	en_reg_mask_trigger            => en_reg_mask_trigger_i,
	en_reg_mask_trigger_condition  => en_reg_mask_trigger_condition_i,
	en_reg_loop_max_register       => en_reg_loop_max_register_i,
	en_reg_working_mode            => en_reg_working_mode_i,
   en_reg_data_read               => en_reg_data_read_i,
	clock_divider                  => clock_divider,
	external_clock                 => external_clock,
	sel_clk                        => sel_clk,
   addr_memory                    => addr_memory,
	pattern_in                     => pattern_in,
	mask_trigger                   => mask_trigger,
	value_trigger_condition        => value_trigger_condition,
	loop_max_value                 => loop_max_value,
	working_mode                   => working_mode,
   rd_from_fsm                    => rd_from_fsm_i,
	wr_from_fsm                    => wr_from_fsm_i,
	sel_data_read                  => sel_data_read_i,
	enable_loop_counter            => enable_loop_counter_i,
	enable_trigger                 => enable_trigger_i,
	reset_loop                     => reset_loop_i,
	reset_glitch                   => reset_glitch_i,
	reset_addr_management          => reset_addr_management_i,
	sel_addr                       => sel_addr_i,
	flag_one                       => flag_one_i,
	en_addr_management             => en_addr_management_i,
	error_flag_divider_zero        => error_flag_divider_zero_i,
	terminal_count_clock           => terminal_count_clock_i,
	working_mode_to_fsm            => working_mode_to_fsm_i,
	trigger_out                    => trigger_out_i,
	end_loop_reps                  => end_loop_reps_i,
	counter_loop                   => counter_loop_i,
	readdata_reg                   => readdata_reg_out
	);
	
CU_LOGIC_ANALYZER : entity work.CU_Logic_Analyzer
port map(
   clock                         => clock,
	reset                         => reset,
	error_flag_divider_zero       => error_flag_divider_zero_i,
	terminal_count_clock          => terminal_count_clock_i,
	working_mode_to_fsm           => working_mode_to_fsm_i,
	trigger_out                   => trigger_out_i,
	end_loop_reps                 => end_loop_reps_i,
   rd                            => rd,
	wr                            => wr,
	setting                       => setting,
	counter_loop                  => counter_loop_i,
	flag_one                      => flag_one_i,
   reset_from_cu                 => reset_from_cu_i,
	en_reg_divider_clock          => en_reg_divider_clock_i,
	en_reg_clk_sel                => en_reg_clk_sel_i,
	en_reg_addr_memory            => en_reg_addr_memory_i,
	en_reg_mask_trigger           => en_reg_mask_trigger_i,
	en_reg_mask_trigger_condition => en_reg_mask_trigger_condition_i,
	en_reg_loop_max_register      => en_reg_loop_max_register_i,
	en_reg_working_mode           => en_reg_working_mode_i,
   en_reg_data_read              => en_reg_data_read_i,
   rd_from_fsm                   => rd_from_fsm_i,
	wr_from_fsm                   => wr_from_fsm_i,
	enable_loop_counter           => enable_loop_counter_i,
	enable_trigger                => enable_trigger_i,
	reset_loop                    => reset_loop_i,
	reset_addr_management         => reset_addr_management_i,
	reset_glitch                  => reset_glitch_i,
	sel_addr                      => sel_addr_i,
	en_addr_management            => en_addr_management_i,
	done                          => done,
	error                         => error,
	sel_data_read                 => sel_data_read_i,
	out_error_state               => out_error_state
	);

end structure;