library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity Glitch_Detector is
port(
   clock       : in  std_logic;
	reset       : in  std_logic;
	LA_Clock    : in  std_logic;
	pattern_in  : in  std_logic;
   glitch      : out std_logic);

end Glitch_Detector;

architecture behaviour of Glitch_Detector is

signal edge_i : std_logic;

begin

DP_Glitch : entity work.DP_Glitch_Detector
port map(
   clock       => clock,
	pattern_in  => pattern_in,
   edge        => edge_i);
	
CU_Glitch : entity work.CU_Glitch_Detector
port map(
   clock     => clock,
	reset     => reset,
	edge      => edge_i,
	LA_Clock  => LA_Clock,
	glitch    => glitch);
end behaviour;