library ieee;
use ieee.std_logic_1164.all;

entity DP_Logic_analyzer is
port(  
   clock                         : in  std_logic;
	reset                         : in  std_logic;
	en_reg_divider_clock          : in  std_logic;
	en_reg_clk_sel                : in  std_logic;
	en_reg_addr_memory            : in  std_logic;
	en_reg_mask_trigger           : in  std_logic;
	en_reg_mask_trigger_condition : in  std_logic;
	en_reg_loop_max_register      : in  std_logic;
	en_reg_working_mode           : in  std_logic;
   en_reg_data_read              : in  std_logic;
	external_clock                : in  std_logic;
	rd_from_fsm                   : in  std_logic;
	wr_from_fsm                   : in  std_logic;
	enable_loop_counter           : in  std_logic;
	enable_trigger                : in  std_logic;
	reset_loop                    : in  std_logic;
	reset_addr_management         : in  std_logic;
	sel_addr                      : in  std_logic;
	en_addr_management            : in  std_logic;
	reset_glitch                  : in  std_logic;
	sel_data_read                 : in  std_logic_vector(3 downto 0);
	clock_divider                 : in  std_logic_vector(31 downto 0);
	sel_clk                       : in  std_logic_vector(31 downto 0);
   addr_memory                   : in  std_logic_vector(31 downto 0);	
	pattern_in                    : in  std_logic_vector(31 downto 0);
	mask_trigger                  : in  std_logic_vector(31 downto 0);
	value_trigger_condition       : in  std_logic_vector(31 downto 0);
	loop_max_value                : in  std_logic_vector(31 downto 0);
	working_mode                  : in  std_logic_vector(31 downto 0);
	counter_loop                  : out std_logic;
	flag_one                      : out std_logic;
	clock_used                    : out std_logic;
	error_flag_divider_zero       : out std_logic;
	terminal_count_clock          : out std_logic;
	working_mode_to_fsm           : out std_logic;
	trigger_out                   : out std_logic;
	end_loop_reps                 : out std_logic;
	readdata_reg                  : out std_logic_vector(31 downto 0));

end DP_Logic_analyzer;

architecture structure of DP_Logic_analyzer is

signal internal_clock_i          : std_logic;
signal sel_clk_i                 : std_logic;
signal working_mode_to_fsm_i     : std_logic;
signal clock_used_i              : std_logic;
signal clock_divider_i           : std_logic_vector(31 downto 0);
signal sel_clk_out_reg           : std_logic_vector(31 downto 0);
signal addr_memory_i             : std_logic_vector(31 downto 0);
signal glitch_vector_i           : std_logic_vector(31 downto 0);
signal mask_trigger_i            : std_logic_vector(31 downto 0);
signal value_trigger_condition_i : std_logic_vector(31 downto 0);
signal loop_max_value_i          : std_logic_vector(31 downto 0);
signal working_mode_out_reg      : std_logic_vector(31 downto 0);
signal readdata_memory_sample_i  : std_logic_vector(31 downto 0);
signal readdata_memory_glitch_i  : std_logic_vector(31 downto 0);
signal out_mux_readdata_i        : std_logic_vector(31 downto 0);
signal new_addr_memory_i         : std_logic_vector(31 downto 0);
signal addr_used_i               : std_logic_vector(31 downto 0);

begin

CLOCK_DIVIDER_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_divider_clock,
        data_in   => clock_divider,
        data_out  => clock_divider_i);
		  
CLOCK_GENERATOR : entity work.Clock_Generator
    port map(
        clk                      => clock,
        reset                    => reset,
		  DIVIDER                  => clock_divider_i,
		  error_flag_divider_zero  => error_flag_divider_zero,
		  Terminal_count           => terminal_count_clock,
		  clock_out                => internal_clock_i);
		  
		  
CLOCK_SELECTOR_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_clk_sel,
        data_in   => sel_clk,
        data_out  => sel_clk_out_reg);

sel_clk_i <= sel_clk_out_reg(0);	  

MUX_CLOCK : entity work.mux_2_to_1
    Port map (
        a   => internal_clock_i,
        b   => external_clock,
        sel => sel_clk_i,
        y   => clock_used_i);

ADDR_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_addr_memory,
        data_in   => addr_memory,
        data_out  => addr_memory_i);
		  
MUX_ADDR : entity work.mux_2_to_1_vector
    Port map( 
	     a   => addr_memory_i,
        b   => new_addr_memory_i,
        sel => sel_addr,
        y   => addr_used_i);
	
ADDR_MEMORY_MANAGEMENT : entity work.ADDR_Manager 
    port map(
        clock         => clock,
		  reset         => reset_addr_management,
	     enable_adder  => en_addr_management,
	     address_in    => addr_used_i,
	     address_out   => new_addr_memory_i
	);	

	
GLITCH_DETECTOR : entity work.Glitch_Detector_32Bit
port map(
   clock       => clock,
	reset       => reset_glitch,
	LA_Clock    => clock_used_i,
	pattern_in  => pattern_in,
   glitch      => glitch_vector_i);

RAM_Glitch : entity work.memory
	port map(
	   Clock    => clock,
		reset    => reset,
		RD       => rd_from_fsm,
		WR       => wr_from_fsm,
		address  => addr_used_i(7 downto 0),
		data_in  => glitch_vector_i,
		data_out => readdata_memory_glitch_i);	

		  
RAM_MEMORY : entity work.memory
	port map(
	   Clock    => clock,
		reset    => reset,
		RD       => rd_from_fsm,
		WR       => wr_from_fsm,
		address  => addr_used_i(7 downto 0),
		data_in  => pattern_in,
		data_out => readdata_memory_sample_i);
		

MUX_READDATA : entity work.mux_16_to_1 --DA SISTEMARE
    Port map(
        in_a   =>   (others => '0'),                --0000
        in_b   =>   clock_divider_i,                --0001
        in_c   =>   sel_clk_out_reg,                --0010
        in_d   =>   addr_memory_i,                  --0011
        in_e   =>   (others => '0'),--data_memory_i,--0100
        in_f   =>   mask_trigger_i,                 --0101
        in_g   =>   value_trigger_condition_i,      --0110
        in_h   =>   (others => '0'),                --0111
        in_i   =>   working_mode_out_reg,           --1000
        in_j   =>   (others => '0'),                --1001
        in_k   =>   loop_max_value_i,               --1010
        in_l   =>   readdata_memory_sample_i,       --1011
        in_m   =>   readdata_memory_glitch_i,       --1100
        in_n   =>   (others => '0'),                --1101
        in_o   =>   (others => '0'),                --1110
        in_p   =>   (others => '0'),                --1111
        sel    =>   sel_data_read,
        out_y  =>   out_mux_readdata_i);

READDATA_REGISTER : entity work.PIPO32bit
    Port map(
        clock     => clock,
        reset     => reset,
        enable    => en_reg_data_read,
        data_in   => out_mux_readdata_i,
        data_out  => readdata_reg);	
		  
TRIGGER_MASK_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_mask_trigger,
        data_in   => mask_trigger,
        data_out  => mask_trigger_i);

TRIGGER_CONDITION_MASK_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_mask_trigger_condition,
        data_in   => value_trigger_condition,
        data_out  => value_trigger_condition_i);
		  
TRIGGER_MANAGER : entity work.TRIGGER
port map(
      clock                   => clock,
		enable                  => enable_trigger,
		mask_in                 => mask_trigger_i,
		data_in                 => pattern_in,
		value_trigger_condition => value_trigger_condition_i,
		trigger_out             => trigger_out);
		  
MAX_LOOP_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_loop_max_register,
        data_in   => loop_max_value,
        data_out  => loop_max_value_i);

LOOP_MANAGEMENT: entity work.Loop_Management
    port map (
        clock      => clock,
        reset      => reset_loop,
        enable_cnt => enable_loop_counter,
	     Max_Rep    => loop_max_value_i,
		  flag_one   => flag_one, 
		  counter_loop =>	counter_loop,
	     End_Loop   => end_loop_reps);	
		  
WORKING_MODE_REGISTER : entity work.PIPO32bit
    Port map (
        clock     => clock,
        reset     => reset,
        enable    => en_reg_working_mode,
        data_in   => working_mode,
        data_out  => working_mode_out_reg);
		  
working_mode_to_fsm_i <= working_mode_out_reg(0);
working_mode_to_fsm <= working_mode_to_fsm_i;

end structure;