--library ieee;
--use ieee.std_logic_1164.all;
--use ieee.numeric_std.all;
--
--entity CU_Logic_Analyzer is
--port(
--
--   clock                         : in  std_logic;
--	reset                         : in  std_logic;
--	error_flag_divider_zero       : in  std_logic;
--	terminal_count_clock          : in  std_logic;
--	working_mode_to_fsm           : in  std_logic;
--	trigger_out                   : in  std_logic;
--	end_loop_reps                 : in  std_logic;
--   rd                            : in  std_logic;
--	wr                            : in  std_logic;
--	flag_one                      : in  std_logic;
--	counter_loop                  : in  std_logic;
--	setting                       : in  std_logic_vector(3 downto 0);	
--   reset_from_cu                 : out std_logic;	
--	en_reg_divider_clock          : out std_logic;
--	en_reg_clk_sel                : out std_logic;
--	en_reg_addr_memory            : out std_logic;
--	en_reg_mask_trigger           : out std_logic;
--	en_reg_mask_trigger_condition : out std_logic;
--	en_reg_loop_max_register      : out std_logic;
--	en_reg_working_mode           : out std_logic;
--   en_reg_data_read              : out std_logic;
--   rd_from_fsm                   : out std_logic;
--	wr_from_fsm                   : out std_logic;
--	enable_loop_counter           : out std_logic;
--	enable_trigger                : out std_logic;
--	reset_loop                    : out std_logic;
--	reset_addr_management         : out std_logic;
--	sel_addr                      : out std_logic;
--	en_addr_management            : out std_logic;
--	done                          : out std_logic;
--	error                         : out std_logic;
--	reset_glitch                  : out std_logic;
--	sel_data_read                 : out std_logic_vector(3 downto 0)
--
--);
--
--end CU_Logic_Analyzer;
--		  
--architecture Structure of CU_Logic_Analyzer is
--
--type State_type is (s0_reset, s1_idle, s2_wr_clock_divider_reg, s3_rd_clock_divider_reg, s4_wr_clock_selection_reg,
--                    s5_rd_clock_selection_reg, s6_wr_addr_reg, s6_1_enable_addr_manager, s7_rd_addr_reg, s8_wr_trigger_mask_reg, s9_rd_trigger_mask_reg,
--						  s10_wr_trigger_condition_reg, s11_rd_trigger_condition_reg, s12_wr_working_mode_reg,
--						  s13_rd_working_mode_reg, s14_wr_max_loop_reg, s15_rd_max_loop_reg, --s16_rd_samples, s16_1_rd_samples,
--						 -- s16_2_loop_read_first, s16_3_enable_read_reg, s16_4_update_loop, s16_5_update_address, s16_6_wait, 
--						  
--						  s16_1_Enable_Loop, s16_2_Disable_loop, s16_3_rd_sample, s16_4_addr_loop_first, s16_5_addr_loop_upgrade,
--						  s16_6_reset_addr_loop, s16_7_enable_addr_manager,
--						  
--						  
--						  s17_rd_glitch, s17_1_rd_glitch,
--						  s17_2_loop_read_first, s17_3_enable_read_reg, s17_4_update_loop, s17_5_update_address, s17_6_wait, s18_divider_check, s19_loop_active, s20_trigger_active, s21_trigger_value, s22_glitch_manager, 
--						  s23_wait_clock_sample, s24_sample_writing, s25_done, s26_error, s27_addr_loop_upgrade, s27_1_addr_loop_first, 
--						  s29_wait_clock_sample, s30_reset_addr_loop, s31_enable_addr_manager);
--						  
--signal present_state : State_type;
--signal next_state : State_type ;
--
--begin
--
--State_registers : process(clock)
--begin
--   if (clock='1' and clock'event) then
--	     if (Reset='1') then
--	       present_state <= s0_reset;
--		  else
--			 present_state <= next_state;
--		  end if;
--	end if;
--end process State_registers;
--
--State_transitions : process (	clock, reset, error_flag_divider_zero, terminal_count_clock, flag_one, counter_loop,
--                              working_mode_to_fsm, trigger_out, end_loop_reps, rd, wr, setting, present_state)
--begin  
--
--next_state <= s0_reset;
--
--case present_state is
--     when s0_reset => next_state <= s1_idle;
--					 
--	  when s1_idle =>  case wr is
--			                when '1' => case setting is 
--			                              when "0000" => next_state <= s1_idle;
--								 				   when "0001" => next_state <= s2_wr_clock_divider_reg;
--						                     when "0010" => next_state <= s4_wr_clock_selection_reg;
--		 			                        when "0011" => next_state <= s6_wr_addr_reg;
--		 			            	         when "0101" => next_state <= s8_wr_trigger_mask_reg;
--           			            	      when "0110" => next_state <= s10_wr_trigger_condition_reg;
--								         		when "1000" => next_state <= s12_wr_working_mode_reg;
--								         		when "1010" => next_state <= s14_wr_max_loop_reg;
--													when "1011" => next_state <= s18_divider_check;
--								      			when others => next_state <= s1_idle;
--												 end case;	
--								 when others => case rd is 
--											         when '1' => case setting is 
--								                                when "0000" => next_state <= s1_idle;
--								 				                    when "0001" => next_state <= s3_rd_clock_divider_reg;
--								 				                    when "0010" => next_state <= s5_rd_clock_selection_reg;
--								 			                       when "0011" => next_state <= s7_rd_addr_reg;
--								 			                       when "0101" => next_state <= s9_rd_trigger_mask_reg;
--            			            	 		              when "0110" => next_state <= s11_rd_trigger_condition_reg;
--												           	        when "1000" => next_state <= s13_rd_working_mode_reg;
--												                    when "1010" => next_state <= s15_rd_max_loop_reg;
--																		  when "1011" => next_state <= s16_1_Enable_Loop; 
--																		                 --case working_mode_to_fsm is
--																		                  -- when '0' => next_state <= s16_rd_samples;
--																					         -- when others => case counter_loop is
--																								--                  when '0' => next_state <= s16_2_loop_read_first;
--																								--						when others => next_state <= s16_5_update_address;
--																								--					 end case;
--																					       -- end case;				
--																		  when "1100" => case working_mode_to_fsm is
--																		                   when '0' => next_state <= s17_rd_glitch;
--																					          when others => case counter_loop is
--																								                  when '0' => next_state <= s17_2_loop_read_first;
--																														when others => next_state <= s17_5_update_address;
--																													 end case;
--																					        end case;			 
--											           	  	        when others => next_state <= s1_idle;
--																		end case;
--														when others =>	next_state <= s1_idle;		
--													 end case;
--					          end case;
--							
--     when s2_wr_clock_divider_reg => next_state <= s1_idle;
--													 
--     when s3_rd_clock_divider_reg => next_state <= s25_done;
--	  
--     when s4_wr_clock_selection_reg => next_state <= s1_idle;
--	  
--     when s5_rd_clock_selection_reg => next_state <= s25_done;
--	  
--	  when s6_wr_addr_reg => next_state <= s6_1_enable_addr_manager;
--	  
--	  when s6_1_enable_addr_manager => next_state <= s1_idle;
--													 
--     when s7_rd_addr_reg => next_state <= s25_done;
--	  
--	  when s8_wr_trigger_mask_reg => next_state <= s1_idle;
--													 
--     when s9_rd_trigger_mask_reg => next_state <= s25_done;
--	  
--     when s10_wr_trigger_condition_reg => next_state <= s1_idle;
--	  
--     when s11_rd_trigger_condition_reg => next_state <= s25_done;
--	  
--	  when s12_wr_working_mode_reg => next_state <= s1_idle;
--													 
--     when s13_rd_working_mode_reg => next_state <= s25_done;
--	  
--	  when s14_wr_max_loop_reg => next_state <= s1_idle;
--	  
--     when s15_rd_max_loop_reg => next_state <= s25_done;
--	  
--	  when s16_1_Enable_Loop => case end_loop_reps is 
-- 		                           when '0' => next_state <= s16_2_Disable_loop;
--				  		               when others => next_state <= s26_error;
--							          end case;
--	  
--	  when s16_2_Disable_loop => case terminal_count_clock is 
--		                            when '1' => case working_mode_to_fsm is 
--			                                         when '0' => next_state <= s16_3_rd_sample;
--										                    when others => case flag_one is
--																                   when '0' => next_state <= s16_5_addr_loop_upgrade;
--															                      when others => next_state <= s16_3_rd_sample;
--																					  end case;
--															 end case;							 
--				  		                when others => next_state <= s16_2_Disable_loop;
--							           end case;
--										  
--	  when s16_3_rd_sample =>  case working_mode_to_fsm is 
--			                        when '0' => next_state <= s16_6_reset_addr_loop;
--										   when others => case flag_one is
--																  when '0' => next_state <= s16_6_reset_addr_loop;
--															     when others => next_state <= s16_4_addr_loop_first;
--																end case;
--										end case;
--										
--	 when s16_4_addr_loop_first => next_state <= s1_idle;
--
--	 when s16_5_addr_loop_upgrade => case end_loop_reps is 
-- 		                           when '0' => next_state <= s1_idle;
--				  		               when others => next_state <= s16_6_reset_addr_loop;
--							          end case;
--	 
--	 when s16_6_reset_addr_loop => next_state <= s16_7_enable_addr_manager;		
--
--	 when s16_7_enable_addr_manager => next_state <= s25_done;
--	 
--	  
----	  when s16_rd_samples => case terminal_count_clock is 
----			                      when '1' =>  next_state <= s16_1_rd_samples;        
----				  		             when others => next_state <= s16_rd_samples;
----							       end case;
----									 
----	                       
----	  when s16_1_rd_samples => case rd is
----	                             when '0'    =>  next_state <= s25_done;
----										  when others => next_state <= s16_1_rd_samples;
----										end case;
----										
----	  when s16_2_loop_read_first => case terminal_count_clock is 
----			                      when '1' =>  next_state <= s16_3_enable_read_reg;        
----				  		             when others => next_state <= s16_2_loop_read_first;
----							       end case;
----									 
----	  when s16_3_enable_read_reg => case rd is
----	                                  when '0'    =>  next_state <= s16_4_update_loop;
----										       when others => next_state <= s16_3_enable_read_reg;
----										     end case;							 
----											  
----	  when s16_4_update_loop => next_state <= s16_6_wait;
----	                            --next_state <= s1_idle;
----									 
----	  when s16_6_wait => case end_loop_reps is 
----			                      when '0' => next_state <= s1_idle;
----				  		             when others => next_state <= s25_done;
----							       end case;--next_state <= s1_idle;
----	  
----	  when s16_5_update_address => next_state <= s16_2_loop_read_first; 
--	  
--	  ------------------------------------------------------------------------------------------
--	   when s17_rd_glitch => case terminal_count_clock is 
--			                      when '1' =>  next_state <= s17_1_rd_glitch;        
--				  		             when others => next_state <= s17_rd_glitch;
--							       end case;
--									 
--	                       
--	  when s17_1_rd_glitch => case rd is
--	                             when '0'    =>  next_state <= s25_done;
--										  when others => next_state <= s17_1_rd_glitch;
--										end case;
--										
--	  when s17_2_loop_read_first => case terminal_count_clock is 
--			                      when '1' =>  next_state <= s17_3_enable_read_reg;        
--				  		             when others => next_state <= s17_2_loop_read_first;
--							       end case;
--									 
--	  when s17_3_enable_read_reg => case rd is
--	                                  when '0'    =>  next_state <= s17_4_update_loop;
--										       when others => next_state <= s17_3_enable_read_reg;
--										     end case;							 
--											  
--	  when s17_4_update_loop => next_state <= s17_6_wait;
--	                            --next_state <= s1_idle;
--									 
--	  when s17_6_wait => case end_loop_reps is 
--			                      when '0' => next_state <= s1_idle;
--				  		             when others => next_state <= s25_done;
--							       end case;--next_state <= s1_idle;
--	  
--	  when s17_5_update_address => next_state <= s17_2_loop_read_first; 
--	  ------------------------------------------------------------------------------------------
--	  
----     when s17_rd_glitch => case rd is
----	                             when '0' => next_state <= s25_done;
----										  when others => next_state <= s17_rd_glitch;
----										end case;
--
--	  when s18_divider_check => case error_flag_divider_zero is
--	                                     when '0' => next_state <= s19_loop_active;
--													 when others => next_state <= s26_error;
--												  end case;
--	  
--	  when s19_loop_active => case end_loop_reps is 
--			                      when '0' => next_state <= s20_trigger_active;
--				  		             when others => next_state <= s26_error;
--							       end case;
--     when s20_trigger_active => next_state <= s21_trigger_value;
--	   
--	  when s21_trigger_value => case trigger_out is 
--			                          when '1' => case terminal_count_clock is 
--			                                         when '1' => next_state <= s22_glitch_manager;
--				  		                                when others => next_state <= s29_wait_clock_sample;
--							                          end case;
--				  		                 when others => next_state <= s26_error;
--							           end case; 	
-----------------------------------------------------------------------------------------------										  
--										  
----	  when s22_glitch_manager => case terminal_count_clock is 
----			                          when '1' => case working_mode_to_fsm is
----											               when '1' =>  next_state <= s27_addr_loop_upgrade;
----																when others => next_state <= s24_sample_writing;
----															  end case;
----				  		                 when others => next_state <= s22_glitch_manager;
----							           end case;
----										  
----	  when s23_wait_clock_sample => case terminal_count_clock is 
----			                          when '1' => case working_mode_to_fsm is
----											               when '1' =>  next_state <= s27_addr_loop_upgrade;
----																when others => next_state <= s24_sample_writing;
----															  end case;
----				  		                 when others => next_state <= s23_wait_clock_sample;
----							           end case;
----	 
----	  when s24_sample_writing => case working_mode_to_fsm is 
----			                          when '0' => next_state <= s25_done;
----				  		                 when others => case end_loop_reps is 
----			                                            when '0' => next_state <= s1_idle;
----				  		                                   when others => next_state <= s25_done;
----							                             end case;
----							             end case;
----											 
----
----	  when s25_done => next_state <= s1_idle;
----	 
----	  when s26_error => next_state <= s1_idle;
----	  
----	  WHEN s27_addr_loop_upgrade => case end_loop_reps is 
----			                             when '0' => next_state <= s24_sample_writing;
----				  		                    when others => next_state <= s26_error;
----							              end case;	
--											 
--   when s22_glitch_manager => case terminal_count_clock is 
--			                          when '1' => case working_mode_to_fsm is 
--			                                         when '0' => next_state <= s24_sample_writing;
--				  		                                when others => case flag_one is
--																                   when '0' => next_state <= s27_addr_loop_upgrade;
--																						 when others => next_state <= s24_sample_writing;
--																					  end case;
--															  end case;
--				  		                 when others => next_state <= s22_glitch_manager;
--							           end case; 
--	  when s23_wait_clock_sample => case terminal_count_clock is 
--			                          when '1' => next_state <= s24_sample_writing;
--				  		                 when others => next_state <= s23_wait_clock_sample;
--							           end case;
--	 
--	  when s24_sample_writing =>  case working_mode_to_fsm is
--	                                 when '1' => case flag_one is
--												               when '1' => next_state <= s27_1_addr_loop_first;
--												               when others => next_state <= s30_reset_addr_loop;
--																end case;
--												when others => next_state <= s30_reset_addr_loop;
--											end case;--next_state <= s25_done;
--				  		                 
--											 
--
--	  when s25_done => next_state <= s1_idle;
--	 
--	  when s26_error => next_state <= s1_idle;
--	  
--	  WHEN s27_addr_loop_upgrade => case end_loop_reps is 
--			                                            when '0' => next_state <= s1_idle;
--				  		                                   when others => next_state <= s30_reset_addr_loop;
--							                             end case;
--																  
--	  when s27_1_addr_loop_first => next_state <= s1_idle;
--	  
--	  
--	  when s29_wait_clock_sample  => case terminal_count_clock is 
--			                             when '1' => next_state <= s22_glitch_manager;
--				  		                    when others => next_state <= s29_wait_clock_sample;
--							               end case;
--												
--	  when s30_reset_addr_loop => next_state <= s31_enable_addr_manager;
--	  
--	  when s31_enable_addr_manager => next_state <= s25_done;
--	  
--end case;
--end process State_transitions;
--
--Control_State : process(present_state)
--	begin
--
--		case present_state is
--			when s0_reset => 	sel_data_read                 <= "0000";							
--	                        en_reg_divider_clock          <= '0';
--	                        en_reg_clk_sel                <= '0';
--	                        en_reg_addr_memory            <= '0';
--	                        en_reg_mask_trigger           <= '0';
--	                        en_reg_mask_trigger_condition <= '0';
--	                        en_reg_loop_max_register      <= '0';
--	                        en_reg_working_mode           <= '0';
--                           en_reg_data_read              <= '0';
--                           rd_from_fsm                   <= '0';
--	                        wr_from_fsm                   <= '0';
--	                        enable_loop_counter           <= '0';
--	                        enable_trigger                <= '0';
--	                        reset_loop                    <= '1';
--	                        reset_addr_management         <= '1';
--	                        sel_addr                      <= '0';
--	                        en_addr_management            <= '0';
--                           reset_from_cu                 <= '1';
--                           done                          <= '0';
--	                        error                         <= '0';
--									reset_glitch                  <= '1';
--
--						  
--			when s1_idle => sel_data_read                 <= "0000";							
--	                      en_reg_divider_clock          <= '0';
--	                      en_reg_clk_sel                <= '0';
--	                      en_reg_addr_memory            <= '0';
--	                      en_reg_mask_trigger           <= '0';
--	                      en_reg_mask_trigger_condition <= '0';
--	                      en_reg_loop_max_register      <= '0';
--	                      en_reg_working_mode           <= '0';
--                         en_reg_data_read              <= '0';
--                         rd_from_fsm                   <= '0';
--	                      wr_from_fsm                   <= '0';
--	                      enable_loop_counter           <= '0';
--	                      enable_trigger                <= '0';
--	                      reset_loop                    <= '0';
--	                      reset_addr_management         <= '0';
--	                      sel_addr                      <= '0';
--	                      en_addr_management            <= '0';
--                         reset_from_cu                 <= '0';
--                         --done                          <= '0';
--	                      error                         <= '0';
--								 reset_glitch                  <= '1';
--
--							
--     when s2_wr_clock_divider_reg => sel_data_read                 <= "0000";							
--	                                  en_reg_divider_clock          <= '1';
--	                                  en_reg_clk_sel                <= '0';
--	                                  en_reg_addr_memory            <= '0';
--	                                  en_reg_mask_trigger           <= '0';
--	                                  en_reg_mask_trigger_condition <= '0';
--	                                  en_reg_loop_max_register      <= '0';
--	                                  en_reg_working_mode           <= '0';
--                                     en_reg_data_read              <= '0';
--                                     rd_from_fsm                   <= '0';
--	                                  wr_from_fsm                   <= '0';
--	                                  enable_loop_counter           <= '0';
--	                                  enable_trigger                <= '0';
--	                                  reset_loop                    <= '0';
--	                                  reset_addr_management         <= '0';
--	                                  sel_addr                      <= '0';
--	                                  en_addr_management            <= '0';
--                                     reset_from_cu                 <= '0';
--                                     done                          <= '0';
--	                                  error                         <= '0';
--												 reset_glitch                  <= '0';
--
--									
--													 
--     when s3_rd_clock_divider_reg => sel_data_read                 <= "0001";							
--	                                  en_reg_divider_clock          <= '0';
--	                                  en_reg_clk_sel                <= '0';
--	                                  en_reg_addr_memory            <= '0';
--	                                  en_reg_mask_trigger           <= '0';
--	                                  en_reg_mask_trigger_condition <= '0';
--	                                  en_reg_loop_max_register      <= '0';
--	                                  en_reg_working_mode           <= '0';
--                                     en_reg_data_read              <= '1';
--                                     rd_from_fsm                   <= '0';
--	                                  wr_from_fsm                   <= '0';
--	                                  enable_loop_counter           <= '0';
--	                                  enable_trigger                <= '0';
--	                                  reset_loop                    <= '0';
--	                                  reset_addr_management         <= '0';
--	                                  sel_addr                      <= '0';
--	                                  en_addr_management            <= '0';
--                                     reset_from_cu                 <= '0';
--                                     done                          <= '0';
--	                                  error                         <= '0';
--									          reset_glitch                  <= '0';
--												 
--     when s4_wr_clock_selection_reg => sel_data_read                 <= "0000";
--	                                    en_reg_divider_clock          <= '0';
--	                                    en_reg_clk_sel                <= '1';
--	                                    en_reg_addr_memory            <= '0';
--	                                    en_reg_mask_trigger           <= '0';
--	                                    en_reg_mask_trigger_condition <= '0';
--	                                    en_reg_loop_max_register      <= '0';
--	                                    en_reg_working_mode           <= '0';
--                                       en_reg_data_read              <= '0';
--                                       rd_from_fsm                   <= '0';
--	                                    wr_from_fsm                   <= '0';
--	                                    enable_loop_counter           <= '0';
--	                                    enable_trigger                <= '0';
--	                                    reset_loop                    <= '0';
--	                                    reset_addr_management         <= '0';
--	                                    sel_addr                      <= '0';
--	                                    en_addr_management            <= '0';
--                                       reset_from_cu                 <= '0';
--                                       done                          <= '0';
--	                                    error                         <= '0'; 	
--	                                    reset_glitch                  <= '0';
--													
--     when s5_rd_clock_selection_reg => sel_data_read                 <= "0010";
--	                                    en_reg_divider_clock          <= '0';
--	                                    en_reg_clk_sel                <= '0';
--	                                    en_reg_addr_memory            <= '0';
--	                                    en_reg_mask_trigger           <= '0';
--	                                    en_reg_mask_trigger_condition <= '0';
--	                                    en_reg_loop_max_register      <= '0';
--	                                    en_reg_working_mode           <= '0';
--                                       en_reg_data_read              <= '1';
--                                       rd_from_fsm                   <= '0';
--	                                    wr_from_fsm                   <= '0';
--	                                    enable_loop_counter           <= '0';
--	                                    enable_trigger                <= '0';
--	                                    reset_loop                    <= '0';
--	                                    reset_addr_management         <= '0';
--	                                    sel_addr                      <= '0';
--	                                    en_addr_management            <= '0';
--                                       reset_from_cu                 <= '0';
--                                       done                          <= '0';
--	                                    error                         <= '0'; 
--                                       reset_glitch                  <= '0';
--													
--	  when s6_wr_addr_reg => sel_data_read                 <= "0000";
--	                         en_reg_divider_clock          <= '0';
--	                         en_reg_clk_sel                <= '0';
--	                         en_reg_addr_memory            <= '1';
--	                         en_reg_mask_trigger           <= '0';
--	                         en_reg_mask_trigger_condition <= '0';
--	                         en_reg_loop_max_register      <= '0';
--	                         en_reg_working_mode           <= '0';
--                            en_reg_data_read              <= '0';
--                            rd_from_fsm                   <= '0';
--	                         wr_from_fsm                   <= '0';
--	                         enable_loop_counter           <= '0';
--	                         enable_trigger                <= '0';
--	                         reset_loop                    <= '0';
--	                         reset_addr_management         <= '0';
--	                         sel_addr                      <= '0';
--	                         en_addr_management            <= '0';
--                            reset_from_cu                 <= '0';
--                            done                          <= '0';
--	                         error                         <= '0'; 
--	                         reset_glitch                  <= '0';
--									 
--     when s6_1_enable_addr_manager => sel_data_read                 <= "0000";
--	                                  en_reg_divider_clock          <= '0';
--	                                  en_reg_clk_sel                <= '0';
--	                                  en_reg_addr_memory            <= '0';
--	                                  en_reg_mask_trigger           <= '0';
--	                                  en_reg_mask_trigger_condition <= '0';
--	                                  en_reg_loop_max_register      <= '0';
--	                                  en_reg_working_mode           <= '0';
--                                     en_reg_data_read              <= '0';
--                                     rd_from_fsm                   <= '0';
--	                                  wr_from_fsm                   <= '0';
--	                                  enable_loop_counter           <= '0';
--	                                  enable_trigger                <= '0';
--	                                  reset_loop                    <= '0';
--	                                  reset_addr_management         <= '0';
--	                                  sel_addr                      <= '0';
--	                                  en_addr_management            <= '1';
--                                     reset_from_cu                 <= '0';
--                                     done                          <= '0';
--	                                  error                         <= '0'; 
--	                                  reset_glitch                  <= '0';									 
--
--									 
--     when s7_rd_addr_reg => sel_data_read                <= "0011";
--	                         en_reg_divider_clock          <= '0';
--	                         en_reg_clk_sel                <= '0';
--	                         en_reg_addr_memory            <= '0';
--	                         en_reg_mask_trigger           <= '0';
--	                         en_reg_mask_trigger_condition <= '0';
--	                         en_reg_loop_max_register      <= '0';
--	                         en_reg_working_mode           <= '0';
--                            en_reg_data_read              <= '1';
--                            rd_from_fsm                   <= '0';
--	                         wr_from_fsm                   <= '0';
--	                         enable_loop_counter           <= '0';
--	                         enable_trigger                <= '0';
--	                         reset_loop                    <= '0';
--	                         reset_addr_management         <= '0';
--	                         sel_addr                      <= '0';
--	                         en_addr_management            <= '0';
--                            reset_from_cu                 <= '0';
--                            done                          <= '0';
--	                         error                         <= '0'; 
--									 reset_glitch                  <= '0';
--									 
--	  when s8_wr_trigger_mask_reg => sel_data_read                 <= "0000";
--	                                 en_reg_divider_clock          <= '0';
--	                                 en_reg_clk_sel                <= '0';
--	                                 en_reg_addr_memory            <= '0';
--	                                 en_reg_mask_trigger           <= '1';
--	                                 en_reg_mask_trigger_condition <= '0';
--	                                 en_reg_loop_max_register      <= '0';
--	                                 en_reg_working_mode           <= '0';
--                                    en_reg_data_read              <= '0';
--                                    rd_from_fsm                   <= '0';
--	                                 wr_from_fsm                   <= '0';
--	                                 enable_loop_counter           <= '0';
--	                                 enable_trigger                <= '0';
--	                                 reset_loop                    <= '0';
--	                                 reset_addr_management         <= '0';
--	                                 sel_addr                      <= '0';
--	                                 en_addr_management            <= '0';
--                                    reset_from_cu                 <= '0';
--                                    done                          <= '0';
--	                                 error                         <= '0'; 
--                                    reset_glitch                  <= '0';
--												
--     when s9_rd_trigger_mask_reg => sel_data_read                 <= "0101";
--	                                 en_reg_divider_clock          <= '0';
--	                                 en_reg_clk_sel                <= '0';
--	                                 en_reg_addr_memory            <= '0';
--	                                 en_reg_mask_trigger           <= '0';
--	                                 en_reg_mask_trigger_condition <= '0';
--	                                 en_reg_loop_max_register      <= '0';
--	                                 en_reg_working_mode           <= '0';
--                                    en_reg_data_read              <= '1';
--                                    rd_from_fsm                   <= '0';
--	                                 wr_from_fsm                   <= '0';
--	                                 enable_loop_counter           <= '0';
--	                                 enable_trigger                <= '0';
--	                                 reset_loop                    <= '0';
--	                                 reset_addr_management         <= '0';
--	                                 sel_addr                      <= '0';
--	                                 en_addr_management            <= '0';
--                                    reset_from_cu                 <= '0';
--                                    done                          <= '0';
--	                                 error                         <= '0'; 
--	                                 reset_glitch                  <= '0';
--												
--     when s10_wr_trigger_condition_reg => sel_data_read                 <= "0000";
--	                                       en_reg_divider_clock          <= '0';
--	                                       en_reg_clk_sel                <= '0';
--	                                       en_reg_addr_memory            <= '0';
--	                                       en_reg_mask_trigger           <= '0';
--	                                       en_reg_mask_trigger_condition <= '1';
--	                                       en_reg_loop_max_register      <= '0';
--	                                       en_reg_working_mode           <= '0';
--                                          en_reg_data_read              <= '0';
--                                          rd_from_fsm                   <= '0';
--	                                       wr_from_fsm                   <= '0';
--	                                       enable_loop_counter           <= '0';
--	                                       enable_trigger                <= '0';
--	                                       reset_loop                    <= '0';
--	                                       reset_addr_management         <= '0';
--	                                       sel_addr                      <= '0';
--	                                       en_addr_management            <= '0';
--                                          reset_from_cu                 <= '0';
--                                          done                          <= '0';
--	                                       error                         <= '0'; 
--														reset_glitch                  <= '0';
--	
--     when s11_rd_trigger_condition_reg => sel_data_read                 <= "0110";
--	                                       en_reg_divider_clock          <= '0';
--	                                       en_reg_clk_sel                <= '0';
--	                                       en_reg_addr_memory            <= '0';
--	                                       en_reg_mask_trigger           <= '0';
--	                                       en_reg_mask_trigger_condition <= '0';
--	                                       en_reg_loop_max_register      <= '0';
--	                                       en_reg_working_mode           <= '0';
--                                          en_reg_data_read              <= '1';
--                                          rd_from_fsm                   <= '0';
--	                                       wr_from_fsm                   <= '0';
--	                                       enable_loop_counter           <= '0';
--	                                       enable_trigger                <= '0';
--	                                       reset_loop                    <= '0';
--	                                       reset_addr_management         <= '0';
--	                                       sel_addr                      <= '0';
--	                                       en_addr_management            <= '0';
--                                          reset_from_cu                 <= '0';
--                                          done                          <= '0';
--	                                       error                         <= '0'; 
--														reset_glitch                  <= '0';
--	
--	  when s12_wr_working_mode_reg => sel_data_read                 <= "0000";
--	                                  en_reg_divider_clock          <= '0';
--	                                  en_reg_clk_sel                <= '0';
--	                                  en_reg_addr_memory            <= '0';
--	                                  en_reg_mask_trigger           <= '0';
--	                                  en_reg_mask_trigger_condition <= '0';
--	                                  en_reg_loop_max_register      <= '0';
--	                                  en_reg_working_mode           <= '1';
--                                     en_reg_data_read              <= '0';
--                                     rd_from_fsm                   <= '0';
--	                                  wr_from_fsm                   <= '0';
--	                                  enable_loop_counter           <= '0';
--	                                  enable_trigger                <= '0';
--	                                  reset_loop                    <= '0';
--	                                  reset_addr_management         <= '0';
--	                                  sel_addr                      <= '0';
--	                                  en_addr_management            <= '0';
--                                     reset_from_cu                 <= '0';
--                                     done                          <= '0';
--	                                  error                         <= '0'; 
--												 reset_glitch                  <= '0';
--	
--	  when s13_rd_working_mode_reg => sel_data_read                 <= "1000";
--	                                  en_reg_divider_clock          <= '0';
--	                                  en_reg_clk_sel                <= '0';
--	                                  en_reg_addr_memory            <= '0';
--	                                  en_reg_mask_trigger           <= '0';
--	                                  en_reg_mask_trigger_condition <= '0';
--	                                  en_reg_loop_max_register      <= '0';
--	                                  en_reg_working_mode           <= '0';
--                                     en_reg_data_read              <= '1';
--                                     rd_from_fsm                   <= '0';
--	                                  wr_from_fsm                   <= '0';
--	                                  enable_loop_counter           <= '0';
--	                                  enable_trigger                <= '0';
--	                                  reset_loop                    <= '0';
--	                                  reset_addr_management         <= '0';
--	                                  sel_addr                      <= '0';
--	                                  en_addr_management            <= '0';
--                                     reset_from_cu                 <= '0';
--                                     done                          <= '0';
--	                                  error                         <= '0'; 
--												 reset_glitch                  <= '0';
--	
--     when s14_wr_max_loop_reg => sel_data_read                 <= "0000";
--	                              en_reg_divider_clock          <= '0';
--	                              en_reg_clk_sel                <= '0';
--	                              en_reg_addr_memory            <= '0';
--	                              en_reg_mask_trigger           <= '0';
--	                              en_reg_mask_trigger_condition <= '0';
--	                              en_reg_loop_max_register      <= '1';
--	                              en_reg_working_mode           <= '0';
--                                 en_reg_data_read              <= '0';
--                                 rd_from_fsm                   <= '0';
--	                              wr_from_fsm                   <= '0';
--	                              enable_loop_counter           <= '0';
--	                              enable_trigger                <= '0';
--	                              reset_loop                    <= '0';
--	                              reset_addr_management         <= '0';
--	                              sel_addr                      <= '0';
--	                              en_addr_management            <= '0';
--                                 reset_from_cu                 <= '0';
--                                 done                          <= '0';
--	                              error                         <= '0'; 
--											reset_glitch                  <= '0';
--	
--	  when s15_rd_max_loop_reg => sel_data_read                 <= "1010";
--	                              en_reg_divider_clock          <= '0';
--	                              en_reg_clk_sel                <= '0';
--	                              en_reg_addr_memory            <= '0';
--	                              en_reg_mask_trigger           <= '0';
--	                              en_reg_mask_trigger_condition <= '0';
--	                              en_reg_loop_max_register      <= '0';
--	                              en_reg_working_mode           <= '0';
--                                 en_reg_data_read              <= '1';
--                                 rd_from_fsm                   <= '0';
--	                              wr_from_fsm                   <= '0';
--	                              enable_loop_counter           <= '0';
--	                              enable_trigger                <= '0';
--	                              reset_loop                    <= '0';
--	                              reset_addr_management         <= '0';
--	                              sel_addr                      <= '0';
--	                              en_addr_management            <= '0';
--                                 reset_from_cu                 <= '0';
--                                 done                          <= '0';
--	                              error                         <= '0';
--										   reset_glitch                  <= '0';
--										
--									
--								
--         when s16_1_Enable_Loop => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '1';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--			when s16_2_Disable_loop => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0'; 
--										  
--			when s16_3_rd_sample => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '1';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0'; 
--										  
--			when s16_4_addr_loop_first => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '1';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0'; 
--										  
--			when s16_5_addr_loop_upgrade => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '1';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '1';
--	                             en_addr_management            <= '1';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0'; 
--										  
--			when s16_6_reset_addr_loop => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '1';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '1';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0'; 
--										  
--			when s16_7_enable_addr_manager => sel_data_read                 <= "1011";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '1';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '1';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0'; 
--										  
--
----			when s16_rd_samples => sel_data_read                 <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '0';
----                                rd_from_fsm                   <= '1';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '0';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                             sel_addr                      <= '0';
----	                             en_addr_management            <= '0';
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
----										  
----			when s16_1_rd_samples => sel_data_read                 <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '1';
----                                rd_from_fsm                   <= '0';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '0';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                             sel_addr                      <= '0';
----	                             en_addr_management            <= '0';
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
----										  
----										  
----    when s16_2_loop_read_first => sel_data_read                 <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '0';
----                                rd_from_fsm                   <= '1';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '0';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                             --sel_addr                      <= '0';
----	                             en_addr_management            <= '0';
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
----										  
----	 when s16_3_enable_read_reg => sel_data_read                 <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '1';
----                                rd_from_fsm                   <= '0';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '0';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                             --sel_addr                      <= '0';
----	                             en_addr_management            <= '0';
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
----										  
----	   when s16_4_update_loop => sel_data_read                 <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '0';
----                                rd_from_fsm                   <= '0';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '1';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                            -- sel_addr                      <= '0';
----	                             en_addr_management            <= '1';
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
----										  
----	 	   when s16_6_wait => sel_data_read              <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '0';
----                                rd_from_fsm                   <= '0';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '0';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                            -- sel_addr                      <= '0';
----	                             en_addr_management            <= '0';
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
----										  
----	 when s16_5_update_address => sel_data_read                 <= "1011";
----	                             en_reg_divider_clock          <= '0';
----	                             en_reg_clk_sel                <= '0';
----	                             en_reg_addr_memory            <= '0';
----	                             en_reg_mask_trigger           <= '0';
----	                             en_reg_mask_trigger_condition <= '0';
----	                             en_reg_loop_max_register      <= '0';
----	                             en_reg_working_mode           <= '0';
----                                en_reg_data_read              <= '0';
----                                rd_from_fsm                   <= '0';
----	                             wr_from_fsm                   <= '0';
----	                             enable_loop_counter           <= '0';
----	                             enable_trigger                <= '0';
----	                             reset_loop                    <= '0';
----	                             reset_addr_management         <= '0';
----	                             sel_addr                      <= '1';
----	                             en_addr_management            <= '0';--------------
----                                reset_from_cu                 <= '0';
----                                done                          <= '0';
----	                             error                         <= '0'; 
----										  reset_glitch                  <= '0';
--	
------			when s17_rd_glitch =>  sel_data_read                 <= "1100";
------	                             en_reg_divider_clock          <= '0';
------	                             en_reg_clk_sel                <= '0';
------	                             en_reg_addr_memory            <= '0';
------	                             en_reg_mask_trigger           <= '0';
------	                             en_reg_mask_trigger_condition <= '0';
------	                             en_reg_loop_max_register      <= '0';
------	                             en_reg_working_mode           <= '0';
------                                en_reg_data_read              <= '1';
------                                rd_from_fsm                   <= '0';
------	                             wr_from_fsm                   <= '0';
------	                             enable_loop_counter           <= '0';
------	                             enable_trigger                <= '0';
------	                             reset_loop                    <= '0';
------	                             reset_addr_management         <= '0';
------	                             sel_addr                      <= '0';
------	                             en_addr_management            <= '0';
------                                reset_from_cu                 <= '0';
------                                done                          <= '0';
------	                             error                         <= '0';
------					                 reset_glitch                  <= '0';
----					
--------------------------------------------------------------------------------------
--          when s17_rd_glitch => sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '1';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--			when s17_1_rd_glitch => sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '1';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--										  
--    when s17_2_loop_read_first => sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '1';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             --sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--	 when s17_3_enable_read_reg => sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '1';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             --sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--	   when s17_4_update_loop => sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '1';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                            -- sel_addr                      <= '0';
--	                             en_addr_management            <= '1';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--	 	   when s17_6_wait => sel_data_read              <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                            -- sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
--										  
--	 when s17_5_update_address => sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '1';
--	                             en_addr_management            <= '0';--------------
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0'; 
--										  reset_glitch                  <= '0';
------------------------------------------------------------------------------------					
--	  
--	  when s18_divider_check => sel_data_read                 <= "0000";
--	                            en_reg_divider_clock          <= '0';
--	                            en_reg_clk_sel                <= '0';
--	                            en_reg_addr_memory            <= '0';
--	                            en_reg_mask_trigger           <= '0';
--	                            en_reg_mask_trigger_condition <= '0';
--	                            en_reg_loop_max_register      <= '0';
--	                            en_reg_working_mode           <= '0';
--                               en_reg_data_read              <= '0';
--                               rd_from_fsm                   <= '0';
--	                            wr_from_fsm                   <= '0';
--	                            enable_loop_counter           <= '0';
--	                            enable_trigger                <= '0';
--	                            reset_loop                    <= '0';
--	                            reset_addr_management         <= '0';   --PERCHE RESETTO? SBAGLIATO
--	                            sel_addr                      <= '0';
--	                            en_addr_management            <= '0';
--                               reset_from_cu                 <= '0';
--                               done                          <= '0';
--	                            error                         <= '0'; 
--										 reset_glitch                  <= '0';
--
--	  when s19_loop_active => sel_data_read                 <= "0000";
--	                          en_reg_divider_clock          <= '0';
--	                          en_reg_clk_sel                <= '0';
--	                          en_reg_addr_memory            <= '0';
--	                          en_reg_mask_trigger           <= '0';
--	                          en_reg_mask_trigger_condition <= '0';
--	                          en_reg_loop_max_register      <= '0';
--	                          en_reg_working_mode           <= '0';
--                             en_reg_data_read              <= '0';
--                             rd_from_fsm                   <= '0';
--	                          wr_from_fsm                   <= '0';
--	                          enable_loop_counter           <= '1';
--	                          enable_trigger                <= '0';
--	                          reset_loop                    <= '0';
--	                          reset_addr_management         <= '0';
--	                          sel_addr                      <= '0';
--	                          en_addr_management            <= '0';
--                             reset_from_cu                 <= '0';
--                             done                          <= '0';
--	                          error                         <= '0'; 
--									  reset_glitch                  <= '0'; 
--									
--	  when s20_trigger_active => sel_data_read                 <= "0000";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '0';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '1';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0';
--										  reset_glitch                  <= '0'; 
--										  
--	  when s21_trigger_value => sel_data_read                 <= "0000";
--	                            en_reg_divider_clock          <= '0';
--	                            en_reg_clk_sel                <= '0';
--	                            en_reg_addr_memory            <= '0';
--	                            en_reg_mask_trigger           <= '0';
--	                            en_reg_mask_trigger_condition <= '0';
--	                            en_reg_loop_max_register      <= '0';
--	                            en_reg_working_mode           <= '0';
--                               en_reg_data_read              <= '0';
--                               rd_from_fsm                   <= '0';
--	                            wr_from_fsm                   <= '0';
--	                            enable_loop_counter           <= '0';
--	                            enable_trigger                <= '0';
--	                            reset_loop                    <= '0';
--	                            reset_addr_management         <= '0';
--	                            sel_addr                      <= '0';
--	                            en_addr_management            <= '0';
--                               reset_from_cu                 <= '0';
--                               done                          <= '0';
--	                            error                         <= '0';
--										 reset_glitch                  <= '1'; 
--										 
--	  	   when s22_glitch_manager => sel_data_read                 <= "0000";
--	                              en_reg_divider_clock          <= '0';
--	                              en_reg_clk_sel                <= '0';
--	                              en_reg_addr_memory            <= '0';
--	                              en_reg_mask_trigger           <= '0';
--	                              en_reg_mask_trigger_condition <= '0';
--	                              en_reg_loop_max_register      <= '0';
--	                              en_reg_working_mode           <= '0';
--                                 en_reg_data_read              <= '0';
--                                 rd_from_fsm                   <= '0';
--	                              wr_from_fsm                   <= '0';
--	                              enable_loop_counter           <= '0';
--	                              enable_trigger                <= '0';
--	                              reset_loop                    <= '0';
--	                              reset_addr_management         <= '0';
--	                              sel_addr                      <= '0';
--	                              en_addr_management            <= '0';
--                                 reset_from_cu                 <= '0';
--                                 done                          <= '0';
--	                              error                         <= '0';
--										   reset_glitch                  <= '0';	
--	  
--	  when s23_wait_clock_sample => sel_data_read                 <= "0000";
--	                            en_reg_divider_clock          <= '0';
--	                            en_reg_clk_sel                <= '0';
--	                            en_reg_addr_memory            <= '0';
--	                            en_reg_mask_trigger           <= '0';
--	                            en_reg_mask_trigger_condition <= '0';
--	                            en_reg_loop_max_register      <= '0';
--	                            en_reg_working_mode           <= '0';
--                               en_reg_data_read              <= '0';
--                               rd_from_fsm                   <= '0';
--	                            wr_from_fsm                   <= '0';
--	                            enable_loop_counter           <= '0';
--	                            enable_trigger                <= '0';
--	                            reset_loop                    <= '0';
--	                            reset_addr_management         <= '0';
--	                            sel_addr                      <= '0';
--	                            en_addr_management            <= '0';
--                               reset_from_cu                 <= '0';
--                               done                          <= '0';
--	                            error                         <= '0';
--										 reset_glitch                  <= '0';
--	
--	   when s24_sample_writing => sel_data_read                 <= "0000";
--	                              en_reg_divider_clock          <= '0';
--	                              en_reg_clk_sel                <= '0';
--	                              en_reg_addr_memory            <= '0';
--	                              en_reg_mask_trigger           <= '0';
--	                              en_reg_mask_trigger_condition <= '0';
--	                              en_reg_loop_max_register      <= '0';
--	                              en_reg_working_mode           <= '0';
--                                 en_reg_data_read              <= '0';
--                                 rd_from_fsm                   <= '0';
--                              	wr_from_fsm                   <= '1';
--	                              enable_loop_counter           <= '0';
--	                              enable_trigger                <= '0';
--	                              reset_loop                    <= '0';
--	                              reset_addr_management         <= '0';
--	                              sel_addr                      <= '0';
--	                              en_addr_management            <= '0';
--                                 reset_from_cu                 <= '0';
--                                 done                          <= '0';
--	                              error                         <= '0';
--										   reset_glitch                  <= '0';	
--	
--	   when s25_done => 	sel_data_read                 <= "0000";
--	                     en_reg_divider_clock          <= '0';
--	                     en_reg_clk_sel                <= '0';
--	                     en_reg_addr_memory            <= '0';
--	                     en_reg_mask_trigger           <= '0';
--	                     en_reg_mask_trigger_condition <= '0';
--	                     en_reg_loop_max_register      <= '0';
--	                     en_reg_working_mode           <= '0';
--                        en_reg_data_read              <= '0';
--                        rd_from_fsm                   <= '0';
--	                     wr_from_fsm                   <= '0';
--	                     enable_loop_counter           <= '0';
--	                     enable_trigger                <= '0';
--	                     reset_loop                    <= '1';
--	                     reset_addr_management         <= '0';------------------------- da verificare
--	                     sel_addr                      <= '0';
--	                     en_addr_management            <= '0';
--                        reset_from_cu                 <= '0';
--                        done                          <= '1';
--	                     error                         <= '0';
--							   reset_glitch                  <= '0';	
--								
--	  when s26_error => sel_data_read                 <= "0000";
--	                    en_reg_divider_clock          <= '0';
--	                    en_reg_clk_sel                <= '0';
--	                    en_reg_addr_memory            <= '0';
--	                    en_reg_mask_trigger           <= '0';
--	                    en_reg_mask_trigger_condition <= '0';
--	                    en_reg_loop_max_register      <= '0';
--	                    en_reg_working_mode           <= '0';
--                       en_reg_data_read              <= '0';
--                       rd_from_fsm                   <= '0';
--	                    wr_from_fsm                   <= '0';
--	                    enable_loop_counter           <= '0';
--	                    enable_trigger                <= '0';
--	                    reset_loop                    <= '0';
--	                    reset_addr_management         <= '0';
--	                    sel_addr                      <= '0';
--	                    en_addr_management            <= '0';
--                       reset_from_cu                 <= '0';
--                       done                          <= '0';
--	                    error                         <= '1';
--							  reset_glitch                  <= '0'; 
--			 
--	  WHEN s27_addr_loop_upgrade => sel_data_read                 <= "0000";
--	                                en_reg_divider_clock          <= '0';
--	                                en_reg_clk_sel                <= '0';
--	                                en_reg_addr_memory            <= '0';
--	                                en_reg_mask_trigger           <= '0';
--	                                en_reg_mask_trigger_condition <= '0';
--	                                en_reg_loop_max_register      <= '0';
--	                                en_reg_working_mode           <= '0';
--                                   en_reg_data_read              <= '0';
--                                   rd_from_fsm                   <= '0';
--	                                wr_from_fsm                   <= '1';
--	                                enable_loop_counter           <= '0';
--	                                enable_trigger                <= '0';
--	                                reset_loop                    <= '0';
--	                                reset_addr_management         <= '0';
--	                                sel_addr                      <= '1';
--	                                en_addr_management            <= '1';
--                                   reset_from_cu                 <= '0';
--                                   done                          <= '0';
--	                                error                         <= '0';
--											  reset_glitch                  <= '0'; 
--											 
--	  WHEN s27_1_addr_loop_first => sel_data_read                 <= "0000";
--	                                en_reg_divider_clock          <= '0';
--	                                en_reg_clk_sel                <= '0';
--	                                en_reg_addr_memory            <= '0';
--	                                en_reg_mask_trigger           <= '0';
--	                                en_reg_mask_trigger_condition <= '0';
--	                                en_reg_loop_max_register      <= '0';
--	                                en_reg_working_mode           <= '0';
--                                   en_reg_data_read              <= '0';
--                                   rd_from_fsm                   <= '0';
--	                                wr_from_fsm                   <= '0';
--	                                enable_loop_counter           <= '0';
--	                                enable_trigger                <= '0';
--	                                reset_loop                    <= '0';
--	                                reset_addr_management         <= '0';
--	                                sel_addr                      <= '1';
--	                                en_addr_management            <= '0';
--                                   reset_from_cu                 <= '0';
--                                   done                          <= '0';
--	                                error                         <= '0';
--											  reset_glitch                  <= '0';  
--	  
--	  
--														
--		when s29_wait_clock_sample => sel_data_read            <= "0000";
--	                            en_reg_divider_clock          <= '0';
--	                            en_reg_clk_sel                <= '0';
--	                            en_reg_addr_memory            <= '0';
--	                            en_reg_mask_trigger           <= '0';
--	                            en_reg_mask_trigger_condition <= '0';
--	                            en_reg_loop_max_register      <= '0';
--	                            en_reg_working_mode           <= '0';
--                               en_reg_data_read              <= '0';
--                               rd_from_fsm                   <= '0';
--	                            wr_from_fsm                   <= '0';
--	                            enable_loop_counter           <= '0';
--	                            enable_trigger                <= '0';
--	                            reset_loop                    <= '0';
--	                            reset_addr_management         <= '0';
--	                            sel_addr                      <= '0';
--	                            en_addr_management            <= '0';
--                               reset_from_cu                 <= '0';
--                               done                          <= '0';
--	                            error                         <= '0';
--										 reset_glitch                  <= '0'; 
--										 
--		when s30_reset_addr_loop => sel_data_read                 <= "0000";
--	                            en_reg_divider_clock          <= '0';
--	                            en_reg_clk_sel                <= '0';
--	                            en_reg_addr_memory            <= '0';
--	                            en_reg_mask_trigger           <= '0';
--	                            en_reg_mask_trigger_condition <= '0';
--	                            en_reg_loop_max_register      <= '0';
--	                            en_reg_working_mode           <= '0';
--                               en_reg_data_read              <= '0';
--                               rd_from_fsm                   <= '0';
--	                            wr_from_fsm                   <= '0';
--	                            enable_loop_counter           <= '0';
--	                            enable_trigger                <= '0';
--	                            reset_loop                    <= '0';
--	                            reset_addr_management         <= '1';
--	                            sel_addr                      <= '0';
--	                            en_addr_management            <= '0';
--                               reset_from_cu                 <= '0';
--                               done                          <= '0';
--	                            error                         <= '0';
--										 reset_glitch                  <= '0'; 
--										 
--		 when s31_enable_addr_manager => sel_data_read               <= "0000";
--	                                  en_reg_divider_clock          <= '0';
--	                                  en_reg_clk_sel                <= '0';
--	                                  en_reg_addr_memory            <= '0';
--	                                  en_reg_mask_trigger           <= '0';
--	                                  en_reg_mask_trigger_condition <= '0';
--	                                  en_reg_loop_max_register      <= '0';
--	                                  en_reg_working_mode           <= '0';
--                                     en_reg_data_read              <= '0';
--                                     rd_from_fsm                   <= '0';
--	                                  wr_from_fsm                   <= '0';
--	                                  enable_loop_counter           <= '0';
--	                                  enable_trigger                <= '0';
--	                                  reset_loop                    <= '0';
--	                                  reset_addr_management         <= '0';
--	                                  sel_addr                      <= '0';
--	                                  en_addr_management            <= '1';
--                                     reset_from_cu                 <= '0';
--                                     done                          <= '0';
--	                                  error                         <= '0'; 
--	                                  reset_glitch                  <= '0';		
--												 
--	
--	
--		end case;
--	end process;
--	
--end Structure;

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CU_Logic_Analyzer is
port(

   clock                         : in  std_logic;
	reset                         : in  std_logic;
	error_flag_divider_zero       : in  std_logic;
	terminal_count_clock          : in  std_logic;
	working_mode_to_fsm           : in  std_logic;
	trigger_out                   : in  std_logic;
	end_loop_reps                 : in  std_logic;
   rd                            : in  std_logic;
	wr                            : in  std_logic;
	flag_one                      : in  std_logic;
	counter_loop                  : in  std_logic;
	out_error_state               : in  std_logic;--------
	setting                       : in  std_logic_vector(3 downto 0);	
   reset_from_cu                 : out std_logic;	
	en_reg_divider_clock          : out std_logic;
	en_reg_clk_sel                : out std_logic;
	en_reg_addr_memory            : out std_logic;
	en_reg_mask_trigger           : out std_logic;
	en_reg_mask_trigger_condition : out std_logic;
	en_reg_loop_max_register      : out std_logic;
	en_reg_working_mode           : out std_logic;
   en_reg_data_read              : out std_logic;
   rd_from_fsm                   : out std_logic;
	wr_from_fsm                   : out std_logic;
	enable_loop_counter           : out std_logic;
	enable_trigger                : out std_logic;
	reset_loop                    : out std_logic;
	reset_addr_management         : out std_logic;
	sel_addr                      : out std_logic;
	en_addr_management            : out std_logic;
	done                          : out std_logic;
	error                         : out std_logic;
	reset_glitch                  : out std_logic;
	sel_data_read                 : out std_logic_vector(3 downto 0)

);

end CU_Logic_Analyzer;
		  
architecture Structure of CU_Logic_Analyzer is

type State_type is (s0_reset, s1_idle, s2_wr_clock_divider_reg, s3_rd_clock_divider_reg, s4_wr_clock_selection_reg,
                    s5_rd_clock_selection_reg, s6_wr_addr_reg, s6_1_enable_addr_manager, s7_rd_addr_reg, s8_wr_trigger_mask_reg, s9_rd_trigger_mask_reg,
						  s10_wr_trigger_condition_reg, s11_rd_trigger_condition_reg, s12_wr_working_mode_reg,
						  s13_rd_working_mode_reg, s14_wr_max_loop_reg, s15_rd_max_loop_reg, s16_rd_samples, s16_1_rd_samples,
						  s16_2_loop_read_first, s16_3_enable_read_reg, s16_4_update_loop, s16_5_update_address, s16_6_wait, s16_7_reset_address_manager, 
						  s17_rd_glitch, s17_1_rd_glitch, s17_2_loop_read_first, s17_3_enable_read_reg, s17_4_update_loop, s17_5_update_address, s17_6_wait, s18_divider_check, s19_loop_active, s20_trigger_active, s21_trigger_value, s22_glitch_manager, 
						  s23_wait_clock_sample, s24_sample_writing, s25_done, s26_error, s27_addr_loop_upgrade, s27_1_addr_loop_first, 
						  s29_wait_clock_sample, s30_reset_addr_loop, s31_enable_addr_manager);
						  
signal present_state : State_type;
signal next_state : State_type ;

begin

State_registers : process(clock)
begin
   if (clock='1' and clock'event) then
	     if (Reset='1') then
	       present_state <= s0_reset;
		  else
			 present_state <= next_state;
		  end if;
	end if;
end process State_registers;

State_transitions : process (	clock, reset, error_flag_divider_zero, terminal_count_clock, flag_one, counter_loop,
                              working_mode_to_fsm, trigger_out, end_loop_reps, rd, wr, setting, out_error_state,present_state)
begin  

next_state <= s0_reset;

case present_state is
     when s0_reset => next_state <= s1_idle;
					 
	  when s1_idle =>  case wr is
			                when '1' => case setting is 
			                              when "0000" => next_state <= s1_idle;
								 				   when "0001" => next_state <= s2_wr_clock_divider_reg;
						                     when "0010" => next_state <= s4_wr_clock_selection_reg;
		 			                        when "0011" => next_state <= s6_wr_addr_reg;
		 			            	         when "0101" => next_state <= s8_wr_trigger_mask_reg;
           			            	      when "0110" => next_state <= s10_wr_trigger_condition_reg;
								         		when "1000" => next_state <= s12_wr_working_mode_reg;
								         		when "1010" => next_state <= s14_wr_max_loop_reg;
													when "1011" => next_state <= s18_divider_check;
								      			when others => next_state <= s1_idle;
												 end case;	
								 when others => case rd is 
											         when '1' => case setting is 
								                                when "0000" => next_state <= s1_idle;
								 				                    when "0001" => next_state <= s3_rd_clock_divider_reg;
								 				                    when "0010" => next_state <= s5_rd_clock_selection_reg;
								 			                       when "0011" => next_state <= s7_rd_addr_reg;
								 			                       when "0101" => next_state <= s9_rd_trigger_mask_reg;
            			            	 		              when "0110" => next_state <= s11_rd_trigger_condition_reg;
												           	        when "1000" => next_state <= s13_rd_working_mode_reg;
												                    when "1010" => next_state <= s15_rd_max_loop_reg;
																		  when "1011" => case working_mode_to_fsm is
																		                   when '0' => next_state <= s16_rd_samples;
																					          when others => case counter_loop is
																								                  when '0' => next_state <= s16_2_loop_read_first;
																														when others => next_state <= s16_5_update_address;
																													 end case;
																					        end case;			 
																		  when "1100" => case working_mode_to_fsm is
																		                   when '0' => next_state <= s17_rd_glitch;
																					          when others => case counter_loop is
																								                  when '0' => next_state <= s17_2_loop_read_first;
																														when others => next_state <= s17_5_update_address;
																													 end case;
																					        end case;			 
											           	  	        when others => next_state <= s1_idle;
																		end case;
														when others =>	next_state <= s1_idle;		
													 end case;
					          end case;
							
     when s2_wr_clock_divider_reg => next_state <= s1_idle;
													 
     when s3_rd_clock_divider_reg => next_state <= s25_done;
	  
     when s4_wr_clock_selection_reg => next_state <= s1_idle;
	  
     when s5_rd_clock_selection_reg => next_state <= s25_done;
	  
	  when s6_wr_addr_reg => next_state <= s6_1_enable_addr_manager;
	  
	  when s6_1_enable_addr_manager => next_state <= s1_idle;
													 
     when s7_rd_addr_reg => next_state <= s25_done;
	  
	  when s8_wr_trigger_mask_reg => next_state <= s1_idle;
													 
     when s9_rd_trigger_mask_reg => next_state <= s25_done;
	  
     when s10_wr_trigger_condition_reg => next_state <= s1_idle;
	  
     when s11_rd_trigger_condition_reg => next_state <= s25_done;
	  
	  when s12_wr_working_mode_reg => next_state <= s1_idle;
													 
     when s13_rd_working_mode_reg => next_state <= s25_done;
	  
	  when s14_wr_max_loop_reg => next_state <= s1_idle;
	  
     when s15_rd_max_loop_reg => next_state <= s25_done;
	  
	  when s16_rd_samples => case terminal_count_clock is 
			                      when '1' =>  next_state <= s16_1_rd_samples;        
				  		             when others => next_state <= s16_rd_samples;
							       end case;
									 
	                       
	  when s16_1_rd_samples => case rd is
	                             when '0'    =>  next_state <= s25_done;
										  when others => next_state <= s16_1_rd_samples;
										end case;
										
	  when s16_2_loop_read_first => case terminal_count_clock is 
			                      when '1' =>  next_state <= s16_3_enable_read_reg;        
				  		             when others => next_state <= s16_2_loop_read_first;
							       end case;
									 
	  when s16_3_enable_read_reg => case rd is
	                                  when '0'    =>  next_state <= s16_4_update_loop;
										       when others => next_state <= s16_3_enable_read_reg;
										     end case;							 
											  
	  when s16_4_update_loop => next_state <= s16_6_wait;
	                            --next_state <= s1_idle;
									 
	  when s16_6_wait => case end_loop_reps is 
			                      when '0' => next_state <= s1_idle;
				  		             when others => next_state <= s16_7_reset_address_manager;
							       end case;--next_state <= s1_idle;
									 
	  when s16_7_reset_address_manager => next_state <= s25_done;
	  
	  when s16_5_update_address => next_state <= s16_2_loop_read_first; 
	  
	  ------------------------------------------------------------------------------------------
	   when s17_rd_glitch => case terminal_count_clock is 
			                      when '1' =>  next_state <= s17_1_rd_glitch;        
				  		             when others => next_state <= s17_rd_glitch;
							       end case;
									 
	                       
	  when s17_1_rd_glitch => case rd is
	                             when '0'    =>  next_state <= s25_done;
										  when others => next_state <= s17_1_rd_glitch;
										end case;
										
	  when s17_2_loop_read_first => case terminal_count_clock is 
			                      when '1' =>  next_state <= s17_3_enable_read_reg;        
				  		             when others => next_state <= s17_2_loop_read_first;
							       end case;
									 
	  when s17_3_enable_read_reg => case rd is
	                                  when '0'    =>  next_state <= s17_4_update_loop;
										       when others => next_state <= s17_3_enable_read_reg;
										     end case;							 
											  
	  when s17_4_update_loop => next_state <= s17_6_wait;
	                            --next_state <= s1_idle;
									 
	  when s17_6_wait => case end_loop_reps is 
			                      when '0' => next_state <= s1_idle;
				  		             when others => next_state <= s16_7_reset_address_manager;
							       end case;--next_state <= s1_idle;
	  
	  when s17_5_update_address => next_state <= s17_2_loop_read_first; 
	  ------------------------------------------------------------------------------------------
	  
--     when s17_rd_glitch => case rd is
--	                             when '0' => next_state <= s25_done;
--										  when others => next_state <= s17_rd_glitch;
--										end case;

	  when s18_divider_check => case error_flag_divider_zero is
	                                     when '0' => next_state <= s19_loop_active;
													 when others => next_state <= s26_error;
												  end case;
	  
	  when s19_loop_active => case end_loop_reps is 
			                      when '0' => next_state <= s20_trigger_active;
				  		             when others => next_state <= s26_error;
							       end case;
     when s20_trigger_active => next_state <= s21_trigger_value;
	   
	  when s21_trigger_value => case trigger_out is 
			                          when '1' => case terminal_count_clock is 
			                                         when '1' => next_state <= s22_glitch_manager;
				  		                                when others => next_state <= s29_wait_clock_sample;
							                          end case;
				  		                 when others => next_state <= s26_error;
							           end case; 	
---------------------------------------------------------------------------------------------										  
										  
--	  when s22_glitch_manager => case terminal_count_clock is 
--			                          when '1' => case working_mode_to_fsm is
--											               when '1' =>  next_state <= s27_addr_loop_upgrade;
--																when others => next_state <= s24_sample_writing;
--															  end case;
--				  		                 when others => next_state <= s22_glitch_manager;
--							           end case;
--										  
--	  when s23_wait_clock_sample => case terminal_count_clock is 
--			                          when '1' => case working_mode_to_fsm is
--											               when '1' =>  next_state <= s27_addr_loop_upgrade;
--																when others => next_state <= s24_sample_writing;
--															  end case;
--				  		                 when others => next_state <= s23_wait_clock_sample;
--							           end case;
--	 
--	  when s24_sample_writing => case working_mode_to_fsm is 
--			                          when '0' => next_state <= s25_done;
--				  		                 when others => case end_loop_reps is 
--			                                            when '0' => next_state <= s1_idle;
--				  		                                   when others => next_state <= s25_done;
--							                             end case;
--							             end case;
--											 
--
--	  when s25_done => next_state <= s1_idle;
--	 
--	  when s26_error => next_state <= s1_idle;
--	  
--	  WHEN s27_addr_loop_upgrade => case end_loop_reps is 
--			                             when '0' => next_state <= s24_sample_writing;
--				  		                    when others => next_state <= s26_error;
--							              end case;	
											 
   when s22_glitch_manager => case terminal_count_clock is 
			                          when '1' => case working_mode_to_fsm is 
			                                         when '0' => next_state <= s24_sample_writing;
				  		                                when others => case flag_one is
																                   when '0' => next_state <= s27_addr_loop_upgrade;
																						 when others => next_state <= s24_sample_writing;
																					  end case;
															  end case;
				  		                 when others => next_state <= s22_glitch_manager;
							           end case; 
	  when s23_wait_clock_sample => case terminal_count_clock is 
			                          when '1' => next_state <= s24_sample_writing;
				  		                 when others => next_state <= s23_wait_clock_sample;
							           end case;
	 
	  when s24_sample_writing =>  case working_mode_to_fsm is
	                                 when '1' => case flag_one is
												               when '1' => next_state <= s27_1_addr_loop_first;
												               when others => next_state <= s30_reset_addr_loop;
																end case;
												when others => next_state <= s30_reset_addr_loop;
											end case;--next_state <= s25_done;
				  		                 
											 

	  when s25_done => next_state <= s1_idle;
	 
	  when s26_error => case out_error_state is
	                       when '1' => next_state <= s1_idle;
								  when others => next_state <= s26_error;
							  end case;
	  
	  WHEN s27_addr_loop_upgrade => case end_loop_reps is 
			                                            when '0' => next_state <= s1_idle;
				  		                                   when others => next_state <= s30_reset_addr_loop;
							                             end case;
																  
	  when s27_1_addr_loop_first => next_state <= s1_idle;
	  
	  
	  when s29_wait_clock_sample  => case terminal_count_clock is 
			                             when '1' => next_state <= s22_glitch_manager;
				  		                    when others => next_state <= s29_wait_clock_sample;
							               end case;
												
	  when s30_reset_addr_loop => next_state <= s31_enable_addr_manager;
	  
	  when s31_enable_addr_manager => next_state <= s25_done;
	  
end case;
end process State_transitions;

Control_State : process(present_state)
	begin

		case present_state is
			when s0_reset => 	sel_data_read                 <= "0000";							
	                        en_reg_divider_clock          <= '0';
	                        en_reg_clk_sel                <= '0';
	                        en_reg_addr_memory            <= '0';
	                        en_reg_mask_trigger           <= '0';
	                        en_reg_mask_trigger_condition <= '0';
	                        en_reg_loop_max_register      <= '0';
	                        en_reg_working_mode           <= '0';
                           en_reg_data_read              <= '0';
                           rd_from_fsm                   <= '0';
	                        wr_from_fsm                   <= '0';
	                        enable_loop_counter           <= '0';
	                        enable_trigger                <= '0';
	                        reset_loop                    <= '1';
	                        reset_addr_management         <= '1';
	                        sel_addr                      <= '0';
	                        en_addr_management            <= '0';
                           reset_from_cu                 <= '1';
                           done                          <= '0';
	                        error                         <= '0';
									reset_glitch                  <= '1';

						  
			when s1_idle => sel_data_read                 <= "0000";							
	                      en_reg_divider_clock          <= '0';
	                      en_reg_clk_sel                <= '0';
	                      en_reg_addr_memory            <= '0';
	                      en_reg_mask_trigger           <= '0';
	                      en_reg_mask_trigger_condition <= '0';
	                      en_reg_loop_max_register      <= '0';
	                      en_reg_working_mode           <= '0';
                         en_reg_data_read              <= '0';
                         rd_from_fsm                   <= '0';
	                      wr_from_fsm                   <= '0';
	                      enable_loop_counter           <= '0';
	                      enable_trigger                <= '0';
	                      reset_loop                    <= '0';
	                      reset_addr_management         <= '0';
	                      sel_addr                      <= '0';
	                      en_addr_management            <= '0';
                         reset_from_cu                 <= '0';
                         --done                          <= '0';
	                      error                         <= '0';
								 reset_glitch                  <= '1';

							
     when s2_wr_clock_divider_reg => sel_data_read                 <= "0000";							
	                                  en_reg_divider_clock          <= '1';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '0';
                                     en_reg_data_read              <= '0';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '0';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '0';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0';
												 reset_glitch                  <= '0';

									
													 
     when s3_rd_clock_divider_reg => sel_data_read                 <= "0001";							
	                                  en_reg_divider_clock          <= '0';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '0';
                                     en_reg_data_read              <= '1';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '0';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '0';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0';
									          reset_glitch                  <= '0';
												 
     when s4_wr_clock_selection_reg => sel_data_read                 <= "0000";
	                                    en_reg_divider_clock          <= '0';
	                                    en_reg_clk_sel                <= '1';
	                                    en_reg_addr_memory            <= '0';
	                                    en_reg_mask_trigger           <= '0';
	                                    en_reg_mask_trigger_condition <= '0';
	                                    en_reg_loop_max_register      <= '0';
	                                    en_reg_working_mode           <= '0';
                                       en_reg_data_read              <= '0';
                                       rd_from_fsm                   <= '0';
	                                    wr_from_fsm                   <= '0';
	                                    enable_loop_counter           <= '0';
	                                    enable_trigger                <= '0';
	                                    reset_loop                    <= '0';
	                                    reset_addr_management         <= '0';
	                                    sel_addr                      <= '0';
	                                    en_addr_management            <= '0';
                                       reset_from_cu                 <= '0';
                                       done                          <= '0';
	                                    error                         <= '0'; 	
	                                    reset_glitch                  <= '0';
													
     when s5_rd_clock_selection_reg => sel_data_read                 <= "0010";
	                                    en_reg_divider_clock          <= '0';
	                                    en_reg_clk_sel                <= '0';
	                                    en_reg_addr_memory            <= '0';
	                                    en_reg_mask_trigger           <= '0';
	                                    en_reg_mask_trigger_condition <= '0';
	                                    en_reg_loop_max_register      <= '0';
	                                    en_reg_working_mode           <= '0';
                                       en_reg_data_read              <= '1';
                                       rd_from_fsm                   <= '0';
	                                    wr_from_fsm                   <= '0';
	                                    enable_loop_counter           <= '0';
	                                    enable_trigger                <= '0';
	                                    reset_loop                    <= '0';
	                                    reset_addr_management         <= '0';
	                                    sel_addr                      <= '0';
	                                    en_addr_management            <= '0';
                                       reset_from_cu                 <= '0';
                                       done                          <= '0';
	                                    error                         <= '0'; 
                                       reset_glitch                  <= '0';
													
	  when s6_wr_addr_reg => sel_data_read                 <= "0000";
	                         en_reg_divider_clock          <= '0';
	                         en_reg_clk_sel                <= '0';
	                         en_reg_addr_memory            <= '1';
	                         en_reg_mask_trigger           <= '0';
	                         en_reg_mask_trigger_condition <= '0';
	                         en_reg_loop_max_register      <= '0';
	                         en_reg_working_mode           <= '0';
                            en_reg_data_read              <= '0';
                            rd_from_fsm                   <= '0';
	                         wr_from_fsm                   <= '0';
	                         enable_loop_counter           <= '0';
	                         enable_trigger                <= '0';
	                         reset_loop                    <= '0';
	                         reset_addr_management         <= '0';
	                         sel_addr                      <= '0';
	                         en_addr_management            <= '0';
                            reset_from_cu                 <= '0';
                            done                          <= '0';
	                         error                         <= '0'; 
	                         reset_glitch                  <= '0';
									 
     when s6_1_enable_addr_manager => sel_data_read                 <= "0000";
	                                  en_reg_divider_clock          <= '0';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '0';
                                     en_reg_data_read              <= '0';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '0';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '1';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0'; 
	                                  reset_glitch                  <= '0';									 

									 
     when s7_rd_addr_reg => sel_data_read                <= "0011";
	                         en_reg_divider_clock          <= '0';
	                         en_reg_clk_sel                <= '0';
	                         en_reg_addr_memory            <= '0';
	                         en_reg_mask_trigger           <= '0';
	                         en_reg_mask_trigger_condition <= '0';
	                         en_reg_loop_max_register      <= '0';
	                         en_reg_working_mode           <= '0';
                            en_reg_data_read              <= '1';
                            rd_from_fsm                   <= '0';
	                         wr_from_fsm                   <= '0';
	                         enable_loop_counter           <= '0';
	                         enable_trigger                <= '0';
	                         reset_loop                    <= '0';
	                         reset_addr_management         <= '0';
	                         sel_addr                      <= '0';
	                         en_addr_management            <= '0';
                            reset_from_cu                 <= '0';
                            done                          <= '0';
	                         error                         <= '0'; 
									 reset_glitch                  <= '0';
									 
	  when s8_wr_trigger_mask_reg => sel_data_read                 <= "0000";
	                                 en_reg_divider_clock          <= '0';
	                                 en_reg_clk_sel                <= '0';
	                                 en_reg_addr_memory            <= '0';
	                                 en_reg_mask_trigger           <= '1';
	                                 en_reg_mask_trigger_condition <= '0';
	                                 en_reg_loop_max_register      <= '0';
	                                 en_reg_working_mode           <= '0';
                                    en_reg_data_read              <= '0';
                                    rd_from_fsm                   <= '0';
	                                 wr_from_fsm                   <= '0';
	                                 enable_loop_counter           <= '0';
	                                 enable_trigger                <= '0';
	                                 reset_loop                    <= '0';
	                                 reset_addr_management         <= '0';
	                                 sel_addr                      <= '0';
	                                 en_addr_management            <= '0';
                                    reset_from_cu                 <= '0';
                                    done                          <= '0';
	                                 error                         <= '0'; 
                                    reset_glitch                  <= '0';
												
     when s9_rd_trigger_mask_reg => sel_data_read                 <= "0101";
	                                 en_reg_divider_clock          <= '0';
	                                 en_reg_clk_sel                <= '0';
	                                 en_reg_addr_memory            <= '0';
	                                 en_reg_mask_trigger           <= '0';
	                                 en_reg_mask_trigger_condition <= '0';
	                                 en_reg_loop_max_register      <= '0';
	                                 en_reg_working_mode           <= '0';
                                    en_reg_data_read              <= '1';
                                    rd_from_fsm                   <= '0';
	                                 wr_from_fsm                   <= '0';
	                                 enable_loop_counter           <= '0';
	                                 enable_trigger                <= '0';
	                                 reset_loop                    <= '0';
	                                 reset_addr_management         <= '0';
	                                 sel_addr                      <= '0';
	                                 en_addr_management            <= '0';
                                    reset_from_cu                 <= '0';
                                    done                          <= '0';
	                                 error                         <= '0'; 
	                                 reset_glitch                  <= '0';
												
     when s10_wr_trigger_condition_reg => sel_data_read                 <= "0000";
	                                       en_reg_divider_clock          <= '0';
	                                       en_reg_clk_sel                <= '0';
	                                       en_reg_addr_memory            <= '0';
	                                       en_reg_mask_trigger           <= '0';
	                                       en_reg_mask_trigger_condition <= '1';
	                                       en_reg_loop_max_register      <= '0';
	                                       en_reg_working_mode           <= '0';
                                          en_reg_data_read              <= '0';
                                          rd_from_fsm                   <= '0';
	                                       wr_from_fsm                   <= '0';
	                                       enable_loop_counter           <= '0';
	                                       enable_trigger                <= '0';
	                                       reset_loop                    <= '0';
	                                       reset_addr_management         <= '0';
	                                       sel_addr                      <= '0';
	                                       en_addr_management            <= '0';
                                          reset_from_cu                 <= '0';
                                          done                          <= '0';
	                                       error                         <= '0'; 
														reset_glitch                  <= '0';
	
     when s11_rd_trigger_condition_reg => sel_data_read                 <= "0110";
	                                       en_reg_divider_clock          <= '0';
	                                       en_reg_clk_sel                <= '0';
	                                       en_reg_addr_memory            <= '0';
	                                       en_reg_mask_trigger           <= '0';
	                                       en_reg_mask_trigger_condition <= '0';
	                                       en_reg_loop_max_register      <= '0';
	                                       en_reg_working_mode           <= '0';
                                          en_reg_data_read              <= '1';
                                          rd_from_fsm                   <= '0';
	                                       wr_from_fsm                   <= '0';
	                                       enable_loop_counter           <= '0';
	                                       enable_trigger                <= '0';
	                                       reset_loop                    <= '0';
	                                       reset_addr_management         <= '0';
	                                       sel_addr                      <= '0';
	                                       en_addr_management            <= '0';
                                          reset_from_cu                 <= '0';
                                          done                          <= '0';
	                                       error                         <= '0'; 
														reset_glitch                  <= '0';
	
	  when s12_wr_working_mode_reg => sel_data_read                 <= "0000";
	                                  en_reg_divider_clock          <= '0';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '1';
                                     en_reg_data_read              <= '0';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '0';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '0';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0'; 
												 reset_glitch                  <= '0';
	
	  when s13_rd_working_mode_reg => sel_data_read                 <= "1000";
	                                  en_reg_divider_clock          <= '0';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '0';
                                     en_reg_data_read              <= '1';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '0';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '0';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0'; 
												 reset_glitch                  <= '0';
	
     when s14_wr_max_loop_reg => sel_data_read                 <= "0000";
	                              en_reg_divider_clock          <= '0';
	                              en_reg_clk_sel                <= '0';
	                              en_reg_addr_memory            <= '0';
	                              en_reg_mask_trigger           <= '0';
	                              en_reg_mask_trigger_condition <= '0';
	                              en_reg_loop_max_register      <= '1';
	                              en_reg_working_mode           <= '0';
                                 en_reg_data_read              <= '0';
                                 rd_from_fsm                   <= '0';
	                              wr_from_fsm                   <= '0';
	                              enable_loop_counter           <= '0';
	                              enable_trigger                <= '0';
	                              reset_loop                    <= '0';
	                              reset_addr_management         <= '0';
	                              sel_addr                      <= '0';
	                              en_addr_management            <= '0';
                                 reset_from_cu                 <= '0';
                                 done                          <= '0';
	                              error                         <= '0'; 
											reset_glitch                  <= '0';
	
	  when s15_rd_max_loop_reg => sel_data_read                 <= "1010";
	                              en_reg_divider_clock          <= '0';
	                              en_reg_clk_sel                <= '0';
	                              en_reg_addr_memory            <= '0';
	                              en_reg_mask_trigger           <= '0';
	                              en_reg_mask_trigger_condition <= '0';
	                              en_reg_loop_max_register      <= '0';
	                              en_reg_working_mode           <= '0';
                                 en_reg_data_read              <= '1';
                                 rd_from_fsm                   <= '0';
	                              wr_from_fsm                   <= '0';
	                              enable_loop_counter           <= '0';
	                              enable_trigger                <= '0';
	                              reset_loop                    <= '0';
	                              reset_addr_management         <= '0';
	                              sel_addr                      <= '0';
	                              en_addr_management            <= '0';
                                 reset_from_cu                 <= '0';
                                 done                          <= '0';
	                              error                         <= '0';
										   reset_glitch                  <= '0';	

			when s16_rd_samples => sel_data_read                 <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '1';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
			when s16_1_rd_samples => sel_data_read                 <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '1';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
										  
    when s16_2_loop_read_first => sel_data_read                 <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '1';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             --sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	 when s16_3_enable_read_reg => sel_data_read                 <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '1';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             --sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	   when s16_4_update_loop => sel_data_read                 <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '1';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                            -- sel_addr                      <= '0';
	                             en_addr_management            <= '1';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	 	   when s16_6_wait => sel_data_read              <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                            -- sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	 when s16_7_reset_address_manager => en_reg_divider_clock          <= '0';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '0';
                                     en_reg_data_read              <= '0';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '1';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '1';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0'; 
	                                  reset_glitch                  <= '0';		
										  
	 when s16_5_update_address => sel_data_read                 <= "1011";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '1';
	                             en_addr_management            <= '0';--------------
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
	
--			when s17_rd_glitch =>  sel_data_read                 <= "1100";
--	                             en_reg_divider_clock          <= '0';
--	                             en_reg_clk_sel                <= '0';
--	                             en_reg_addr_memory            <= '0';
--	                             en_reg_mask_trigger           <= '0';
--	                             en_reg_mask_trigger_condition <= '0';
--	                             en_reg_loop_max_register      <= '0';
--	                             en_reg_working_mode           <= '0';
--                                en_reg_data_read              <= '1';
--                                rd_from_fsm                   <= '0';
--	                             wr_from_fsm                   <= '0';
--	                             enable_loop_counter           <= '0';
--	                             enable_trigger                <= '0';
--	                             reset_loop                    <= '0';
--	                             reset_addr_management         <= '0';
--	                             sel_addr                      <= '0';
--	                             en_addr_management            <= '0';
--                                reset_from_cu                 <= '0';
--                                done                          <= '0';
--	                             error                         <= '0';
--					                 reset_glitch                  <= '0';
					
----------------------------------------------------------------------------------
          when s17_rd_glitch => sel_data_read                 <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '1';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
			when s17_1_rd_glitch => sel_data_read                 <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '1';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
										  
    when s17_2_loop_read_first => sel_data_read                 <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '1';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             --sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	 when s17_3_enable_read_reg => sel_data_read                 <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '1';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             --sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	   when s17_4_update_loop => sel_data_read                 <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '1';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                            -- sel_addr                      <= '0';
	                             en_addr_management            <= '1';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	 	   when s17_6_wait => sel_data_read              <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                            -- sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
										  
	 when s17_5_update_address => sel_data_read                 <= "1100";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '0';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '1';
	                             en_addr_management            <= '0';--------------
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0'; 
										  reset_glitch                  <= '0';
----------------------------------------------------------------------------------					
	  
	  when s18_divider_check => sel_data_read                 <= "0000";
	                            en_reg_divider_clock          <= '0';
	                            en_reg_clk_sel                <= '0';
	                            en_reg_addr_memory            <= '0';
	                            en_reg_mask_trigger           <= '0';
	                            en_reg_mask_trigger_condition <= '0';
	                            en_reg_loop_max_register      <= '0';
	                            en_reg_working_mode           <= '0';
                               en_reg_data_read              <= '0';
                               rd_from_fsm                   <= '0';
	                            wr_from_fsm                   <= '0';
	                            enable_loop_counter           <= '0';
	                            enable_trigger                <= '0';
	                            reset_loop                    <= '0';
	                            reset_addr_management         <= '0';   --PERCHE RESETTO? SBAGLIATO
	                            sel_addr                      <= '0';
	                            en_addr_management            <= '0';
                               reset_from_cu                 <= '0';
                               done                          <= '0';
	                            error                         <= '0'; 
										 reset_glitch                  <= '0';

	  when s19_loop_active => sel_data_read                 <= "0000";
	                          en_reg_divider_clock          <= '0';
	                          en_reg_clk_sel                <= '0';
	                          en_reg_addr_memory            <= '0';
	                          en_reg_mask_trigger           <= '0';
	                          en_reg_mask_trigger_condition <= '0';
	                          en_reg_loop_max_register      <= '0';
	                          en_reg_working_mode           <= '0';
                             en_reg_data_read              <= '0';
                             rd_from_fsm                   <= '0';
	                          wr_from_fsm                   <= '0';
	                          enable_loop_counter           <= '1';
	                          enable_trigger                <= '0';
	                          reset_loop                    <= '0';
	                          reset_addr_management         <= '0';
	                          sel_addr                      <= '0';
	                          en_addr_management            <= '0';
                             reset_from_cu                 <= '0';
                             done                          <= '0';
	                          error                         <= '0'; 
									  reset_glitch                  <= '0'; 
									
	  when s20_trigger_active => sel_data_read                 <= "0000";
	                             en_reg_divider_clock          <= '0';
	                             en_reg_clk_sel                <= '0';
	                             en_reg_addr_memory            <= '0';
	                             en_reg_mask_trigger           <= '0';
	                             en_reg_mask_trigger_condition <= '0';
	                             en_reg_loop_max_register      <= '0';
	                             en_reg_working_mode           <= '0';
                                en_reg_data_read              <= '0';
                                rd_from_fsm                   <= '0';
	                             wr_from_fsm                   <= '0';
	                             enable_loop_counter           <= '0';
	                             enable_trigger                <= '1';
	                             reset_loop                    <= '0';
	                             reset_addr_management         <= '0';
	                             sel_addr                      <= '0';
	                             en_addr_management            <= '0';
                                reset_from_cu                 <= '0';
                                done                          <= '0';
	                             error                         <= '0';
										  reset_glitch                  <= '0'; 
										  
	  when s21_trigger_value => sel_data_read                 <= "0000";
	                            en_reg_divider_clock          <= '0';
	                            en_reg_clk_sel                <= '0';
	                            en_reg_addr_memory            <= '0';
	                            en_reg_mask_trigger           <= '0';
	                            en_reg_mask_trigger_condition <= '0';
	                            en_reg_loop_max_register      <= '0';
	                            en_reg_working_mode           <= '0';
                               en_reg_data_read              <= '0';
                               rd_from_fsm                   <= '0';
	                            wr_from_fsm                   <= '0';
	                            enable_loop_counter           <= '0';
	                            enable_trigger                <= '0';
	                            reset_loop                    <= '0';
	                            reset_addr_management         <= '0';
	                            sel_addr                      <= '0';
	                            en_addr_management            <= '0';
                               reset_from_cu                 <= '0';
                               done                          <= '0';
	                            error                         <= '0';
										 reset_glitch                  <= '1'; 
										 
	  	   when s22_glitch_manager => sel_data_read                 <= "0000";
	                              en_reg_divider_clock          <= '0';
	                              en_reg_clk_sel                <= '0';
	                              en_reg_addr_memory            <= '0';
	                              en_reg_mask_trigger           <= '0';
	                              en_reg_mask_trigger_condition <= '0';
	                              en_reg_loop_max_register      <= '0';
	                              en_reg_working_mode           <= '0';
                                 en_reg_data_read              <= '0';
                                 rd_from_fsm                   <= '0';
	                              wr_from_fsm                   <= '0';
	                              enable_loop_counter           <= '0';
	                              enable_trigger                <= '0';
	                              reset_loop                    <= '0';
	                              reset_addr_management         <= '0';
	                              sel_addr                      <= '0';
	                              en_addr_management            <= '0';
                                 reset_from_cu                 <= '0';
                                 done                          <= '0';
	                              error                         <= '0';
										   reset_glitch                  <= '0';	
	  
	  when s23_wait_clock_sample => sel_data_read                 <= "0000";
	                            en_reg_divider_clock          <= '0';
	                            en_reg_clk_sel                <= '0';
	                            en_reg_addr_memory            <= '0';
	                            en_reg_mask_trigger           <= '0';
	                            en_reg_mask_trigger_condition <= '0';
	                            en_reg_loop_max_register      <= '0';
	                            en_reg_working_mode           <= '0';
                               en_reg_data_read              <= '0';
                               rd_from_fsm                   <= '0';
	                            wr_from_fsm                   <= '0';
	                            enable_loop_counter           <= '0';
	                            enable_trigger                <= '0';
	                            reset_loop                    <= '0';
	                            reset_addr_management         <= '0';
	                            sel_addr                      <= '0';
	                            en_addr_management            <= '0';
                               reset_from_cu                 <= '0';
                               done                          <= '0';
	                            error                         <= '0';
										 reset_glitch                  <= '0';
	
	   when s24_sample_writing => sel_data_read                 <= "0000";
	                              en_reg_divider_clock          <= '0';
	                              en_reg_clk_sel                <= '0';
	                              en_reg_addr_memory            <= '0';
	                              en_reg_mask_trigger           <= '0';
	                              en_reg_mask_trigger_condition <= '0';
	                              en_reg_loop_max_register      <= '0';
	                              en_reg_working_mode           <= '0';
                                 en_reg_data_read              <= '0';
                                 rd_from_fsm                   <= '0';
                              	wr_from_fsm                   <= '1';
	                              enable_loop_counter           <= '0';
	                              enable_trigger                <= '0';
	                              reset_loop                    <= '0';
	                              reset_addr_management         <= '0';
	                              sel_addr                      <= '0';
	                              en_addr_management            <= '0';
                                 reset_from_cu                 <= '0';
                                 done                          <= '0';
	                              error                         <= '0';
										   reset_glitch                  <= '0';	
	
	   when s25_done => 	sel_data_read                 <= "0000";
	                     en_reg_divider_clock          <= '0';
	                     en_reg_clk_sel                <= '0';
	                     en_reg_addr_memory            <= '0';
	                     en_reg_mask_trigger           <= '0';
	                     en_reg_mask_trigger_condition <= '0';
	                     en_reg_loop_max_register      <= '0';
	                     en_reg_working_mode           <= '0';
                        en_reg_data_read              <= '0';
                        rd_from_fsm                   <= '0';
	                     wr_from_fsm                   <= '0';
	                     enable_loop_counter           <= '0';
	                     enable_trigger                <= '0';
	                     reset_loop                    <= '1';
	                     reset_addr_management         <= '0';------------------------- da verificare
	                     sel_addr                      <= '0';
	                     en_addr_management            <= '0';
                        reset_from_cu                 <= '0';
                        done                          <= '1';
	                     error                         <= '0';
							   reset_glitch                  <= '0';	
								
	  when s26_error => sel_data_read                 <= "0000";
	                    en_reg_divider_clock          <= '0';
	                    en_reg_clk_sel                <= '0';
	                    en_reg_addr_memory            <= '0';
	                    en_reg_mask_trigger           <= '0';
	                    en_reg_mask_trigger_condition <= '0';
	                    en_reg_loop_max_register      <= '0';
	                    en_reg_working_mode           <= '0';
                       en_reg_data_read              <= '0';
                       rd_from_fsm                   <= '0';
	                    wr_from_fsm                   <= '0';
	                    enable_loop_counter           <= '0';
	                    enable_trigger                <= '0';
	                    reset_loop                    <= '0';
	                    reset_addr_management         <= '0';
	                    sel_addr                      <= '0';
	                    en_addr_management            <= '0';
                       reset_from_cu                 <= '0';
                       done                          <= '0';
	                    error                         <= '1';
							  reset_glitch                  <= '0'; 
			 
	  WHEN s27_addr_loop_upgrade => sel_data_read                 <= "0000";
	                                en_reg_divider_clock          <= '0';
	                                en_reg_clk_sel                <= '0';
	                                en_reg_addr_memory            <= '0';
	                                en_reg_mask_trigger           <= '0';
	                                en_reg_mask_trigger_condition <= '0';
	                                en_reg_loop_max_register      <= '0';
	                                en_reg_working_mode           <= '0';
                                   en_reg_data_read              <= '0';
                                   rd_from_fsm                   <= '0';
	                                wr_from_fsm                   <= '1';
	                                enable_loop_counter           <= '0';
	                                enable_trigger                <= '0';
	                                reset_loop                    <= '0';
	                                reset_addr_management         <= '0';
	                                sel_addr                      <= '1';
	                                en_addr_management            <= '1';
                                   reset_from_cu                 <= '0';
                                   done                          <= '0';
	                                error                         <= '0';
											  reset_glitch                  <= '0'; 
											 
	  WHEN s27_1_addr_loop_first => sel_data_read                 <= "0000";
	                                en_reg_divider_clock          <= '0';
	                                en_reg_clk_sel                <= '0';
	                                en_reg_addr_memory            <= '0';
	                                en_reg_mask_trigger           <= '0';
	                                en_reg_mask_trigger_condition <= '0';
	                                en_reg_loop_max_register      <= '0';
	                                en_reg_working_mode           <= '0';
                                   en_reg_data_read              <= '0';
                                   rd_from_fsm                   <= '0';
	                                wr_from_fsm                   <= '0';
	                                enable_loop_counter           <= '0';
	                                enable_trigger                <= '0';
	                                reset_loop                    <= '0';
	                                reset_addr_management         <= '0';
	                                sel_addr                      <= '1';
	                                en_addr_management            <= '0';
                                   reset_from_cu                 <= '0';
                                   done                          <= '0';
	                                error                         <= '0';
											  reset_glitch                  <= '0';  
	  
	  
														
		when s29_wait_clock_sample => sel_data_read            <= "0000";
	                            en_reg_divider_clock          <= '0';
	                            en_reg_clk_sel                <= '0';
	                            en_reg_addr_memory            <= '0';
	                            en_reg_mask_trigger           <= '0';
	                            en_reg_mask_trigger_condition <= '0';
	                            en_reg_loop_max_register      <= '0';
	                            en_reg_working_mode           <= '0';
                               en_reg_data_read              <= '0';
                               rd_from_fsm                   <= '0';
	                            wr_from_fsm                   <= '0';
	                            enable_loop_counter           <= '0';
	                            enable_trigger                <= '0';
	                            reset_loop                    <= '0';
	                            reset_addr_management         <= '0';
	                            sel_addr                      <= '0';
	                            en_addr_management            <= '0';
                               reset_from_cu                 <= '0';
                               done                          <= '0';
	                            error                         <= '0';
										 reset_glitch                  <= '0'; 
										 
		when s30_reset_addr_loop => sel_data_read                 <= "0000";
	                            en_reg_divider_clock          <= '0';
	                            en_reg_clk_sel                <= '0';
	                            en_reg_addr_memory            <= '0';
	                            en_reg_mask_trigger           <= '0';
	                            en_reg_mask_trigger_condition <= '0';
	                            en_reg_loop_max_register      <= '0';
	                            en_reg_working_mode           <= '0';
                               en_reg_data_read              <= '0';
                               rd_from_fsm                   <= '0';
	                            wr_from_fsm                   <= '0';
	                            enable_loop_counter           <= '0';
	                            enable_trigger                <= '0';
	                            reset_loop                    <= '0';
	                            reset_addr_management         <= '1';
	                            sel_addr                      <= '0';
	                            en_addr_management            <= '0';
                               reset_from_cu                 <= '0';
                               done                          <= '0';
	                            error                         <= '0';
										 reset_glitch                  <= '0'; 
										 
		 when s31_enable_addr_manager => sel_data_read               <= "0000";
	                                  en_reg_divider_clock          <= '0';
	                                  en_reg_clk_sel                <= '0';
	                                  en_reg_addr_memory            <= '0';
	                                  en_reg_mask_trigger           <= '0';
	                                  en_reg_mask_trigger_condition <= '0';
	                                  en_reg_loop_max_register      <= '0';
	                                  en_reg_working_mode           <= '0';
                                     en_reg_data_read              <= '0';
                                     rd_from_fsm                   <= '0';
	                                  wr_from_fsm                   <= '0';
	                                  enable_loop_counter           <= '0';
	                                  enable_trigger                <= '0';
	                                  reset_loop                    <= '0';
	                                  reset_addr_management         <= '0';
	                                  sel_addr                      <= '0';
	                                  en_addr_management            <= '1';
                                     reset_from_cu                 <= '0';
                                     done                          <= '0';
	                                  error                         <= '0'; 
	                                  reset_glitch                  <= '0';		
												 
		     
												 
	
	
		end case;
	end process;
	
end Structure;