library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity CU_Glitch_Detector is
port(
   clock                         : in  std_logic;
	reset                         : in  std_logic;
	edge                          : in  std_logic;
	LA_Clock                      : in  std_logic;
	glitch                        : out std_logic);

end CU_Glitch_Detector;
		  
architecture Structure of CU_Glitch_Detector is

type State_type is (s0_idle, s1_zero, s2_one, s3_glitch, s4_wait);
						  
signal present_state : State_type;
signal next_state : State_type ;

begin

State_registers : process(clock)
begin
   if (clock='1' and clock'event) then
	     if (Reset='1') then
	       present_state <= s0_idle;
		  else
			 present_state <= next_state;
		  end if;
	end if;
end process State_registers;

State_transitions : process (	clock, reset, edge, LA_Clock, present_state)
begin  

next_state <= s0_idle;

case present_state is
     when s0_idle => case LA_Clock is
	                     when '1' => case edge is 
			                              when '0' => next_state <= s1_zero;
								               when '1' => next_state <= s1_zero;
								               when others => next_state <= s0_idle;
							               end case;
								when others => next_state <= s0_idle;
							end case;
									
					 
	  when s1_zero => case LA_Clock is
	                     when '1' => case edge is 
								               when '1' => next_state <= s2_one;
													when others => next_state <= s1_zero;
							               end case;
								when others => next_state <= s0_idle;
							end case;
	  
     when s2_one => case LA_Clock is
	                     when '1' => case edge is 
								               when '1' => next_state <= s3_glitch;
													when others => next_state <= s2_one;
							               end case;
								when others => next_state <= s0_idle;
							end case;

	  
	  when s3_glitch => case LA_Clock is
	                     when '1' => next_state <= s3_glitch;
								when others => next_state <= s4_wait;
							end case;
							
	  when s4_wait => case LA_Clock is
	                     when '0' => next_state <= s4_wait;
								when others => next_state <= s0_idle;
							end case;
							
	  
end case;
end process State_transitions;

Control_State : process(present_state)
	begin

		case present_state is
			when s0_idle => glitch  <= '0';
			
			when s1_zero => glitch  <= '0';
			
			when s2_one => glitch  <= '0';
			
			when s3_glitch => glitch  <= '1';
			
			when s4_wait => glitch  <= '1';

		end case;
	end process;
	
end Structure;