library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity ADDR_Manager is
port(
   clock         : in std_logic;
	reset         : in std_logic;
	enable_adder  : in std_logic;
	address_in    : in std_logic_vector(31 downto 0);
	address_out   : out std_logic_vector(31 downto 0) := "00000000000000000000000000000000"
	);
end ADDR_Manager;
	
architecture behaviour of ADDR_Manager is

begin

process(clock)
begin

if (clock'event and clock = '1') then
   if (reset = '1') then
	   address_out <= "00000000000000000000000000000000";
	end if;
	
	if (enable_adder='1') then
		address_out <= address_in + "00000000000000000000000000000001";		
   end if;
end if;
end process;
end architecture;

