library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
library lpm;
use lpm.lpm_components.all;
library altera_mf;
use altera_mf.altera_mf_components.all;

entity user is
	port
	(
		-- Main clock inputs
		mainClk	: in std_logic;
		slowClk	: in std_logic;
		-- Main reset input
		reset		: in std_logic;
		-- MCU interface (UART, I2C)
		mcuUartTx	: in std_logic;
		mcuUartRx	: out std_logic;
		mcuI2cScl	: in std_logic;
		mcuI2cSda	: inout std_logic;
		-- Logic state analyzer/stimulator
		lsasBus	: inout std_logic_vector( 31 downto 0 );
		-- Dip switches
		switches	: in std_logic_vector( 7 downto 0 );
		-- LEDs
		leds		: out std_logic_vector( 3 downto 0 )
	);
end user;

architecture behavioural of user is

	signal clk: std_logic;
	signal pllLock: std_logic;

	signal lsasBusIn: std_logic_vector( 31 downto 0 );
	signal lsasBusOut: std_logic_vector( 31 downto 0 );
	signal lsasBusEn: std_logic_vector( 31 downto 0 ) := ( others => '0' );

	signal mcuI2cDIn: std_logic;
	signal mcuI2CDOut: std_logic;
	signal mcuI2cEn: std_logic := '0';	
	
	signal pattern_out_extra : std_logic_vector(3 downto 0);
   signal mask_output_enable_out_extra : std_logic_vector(3 downto 0);
	signal reset_inv: std_logic;
	signal rst: std_logic;
--	component myAltPll
--		PORT
--		(
--			areset		: IN STD_LOGIC  := '0';
--			inclk0		: IN STD_LOGIC  := '0';
--			c0		: OUT STD_LOGIC ;
--			locked		: OUT STD_LOGIC 
--		);
--	end component;
	
	component Logic_Analyzer_System
	port (
		clock_sink_clk            : in  std_logic                     := '0';             --    clock_sink.clk
		reset_sink_reset          : in  std_logic                     := '0';             --    reset_sink.reset
		mosi                      : in  std_logic                     := '0';             --   conduit_end.mosi
		ss                        : in  std_logic                     := '0';             --              .ss
		sclk                      : in  std_logic                     := '0';		--              .sclk
		external_clock            : in std_logic;
		miso                      : out std_logic; 		--              .miso
		done                      : out std_logic;
		out_error_state           : in std_logic;
	   error                     : out std_logic;
		en_miso                   : out std_logic
	);
	end component;
	
begin

--**********************************************************************************
--* Main clock PLL
--**********************************************************************************

--	myAltPll_inst : myAltPll PORT MAP (
--		areset	 => reset,
--		inclk0	 => mainClk,
--		c0	 => clk,
--		locked	 => pllLock
--	);


--**********************************************************************************
--* LEDs
--**********************************************************************************

--	leds <= switches( 3 downto 0 );
	
--**********************************************************************************
--* Logic state analyzer/stimulator dummy process definition
--* Just a simple up counter
--* 		lsasBus	: inout std_logic_vector( 31 downto 0 )
--**********************************************************************************

	lsasBusIn <= lsasBus;

	lsasBus_tristate:
	process( lsasBusEn, lsasBusOut ) is
	begin
		for index in 0 to 31 loop
			if lsasBusEn( index ) = '1'  then
				lsasBus( index ) <= lsasBusOut ( index );
			else
				lsasBus( index ) <= 'Z';
			end if;
		end loop;
	end process;
	
	Logic_Analyzer_Sys : Logic_Analyzer_System
	port map(
		clock_sink_clk     => mainClk,
		reset_sink_reset   => rst,
		mosi               => lsasBusIn(15),
		sclk               => lsasBusIn(13),
	   ss                 => lsasBusIn(12),    
		miso               => lsasBusOut(14),
	   en_miso            => lsasBusEn(14),
		external_clock     => '0',
		out_error_state    => switches(7),
		done               => leds(0),   --Da sistemare
	   error              => leds(1)   --Da sistemare
	);
reset_inv <= NOT reset;
rst <= reset_inv OR switches(0);	--(SWITCH 8 SU SCHEDA)
	
end behavioural;
