import os
import pickle

from core.patch import Patch
from core.events import GlobalEvent, CommandEvent
from core.property import Pos_x, Pos_y, Shape_x, Shape_y

# future update: a method to extract patches with properties from images instead of convert_properties 

def convert_properties(elem_props):

    properties = {
        Pos_x: elem_props['pos_x'],
        Pos_y: elem_props['pos_y'],
        Shape_x: elem_props['pos_x'] - elem_props['hitbox_tl_x'],
        Shape_y: elem_props['pos_y'] - elem_props['hitbox_tl_y'],
    }

    return properties
    
def load_patches_per_frame(log_file_name= None, descriptions_to_exclude= ['environment']):

    if log_file_name is None: # use last saved
        log_files_name = os.listdir('logs/arkanoid_logs')
        if not log_files_name: raise Exception('no saved logs')
        log_file_name = sorted(log_files_name, reverse= True)[0]

    log_file_path = f'logs/arkanoid_logs/{log_file_name}'
    with open(log_file_path, 'rb') as log_file:
        log = pickle.load(log_file)
    print(f'{log_file_path} loaded')

    patches_per_frame = []
    global_events_per_frame = []
    for frame in log:

        patches = []
        for description, elem_props in frame['elements'].items():
            if description in descriptions_to_exclude or elem_props['existence'] == False: continue
            
            patches.append(Patch(description, convert_properties(elem_props)))

        patches_per_frame.append(patches)

        global_events = [CommandEvent(com) for com in frame['commands']]
        global_events.extend([GlobalEvent(ev['description']) for ev in frame['events']])

        global_events_per_frame.append(global_events)

    return patches_per_frame, global_events_per_frame


def write_results(population):

    scores = []
    for ind_id, ind in enumerate(population):
        scores.append((ind_id, ind, ind.score))
    
    population = [(ind_id, ind, score) for ind_id, ind, score in sorted(scores, key= lambda x: x[2])]#[:1]

    out_string = ''
    for ind_id, ind, score in population:
        out_string += f'\n--------------\nind_{ind_id}:\n--------------'
        for obj_id in ind.object_dict.keys():
                out_string += f'\n\nobj_{obj_id}'
                if obj_id in ind.rules.keys():
                    out_string += f'\n\nrules: {ind.rules[obj_id]}\n'
                else:
                    out_string += '\n\nno rules\n'
                for frame_id, frame_dict in ind.object_info[obj_id].items():
                    if frame_dict['present']:
                        out_string += f'\nframe {frame_id} - patch: {frame_dict["patch"]}\n- unexplained: {frame_dict["unexplained"]}\n- explained: {frame_dict["explained_unexplained"]}\n- events: {frame_dict["events"]}\n- global events: {frame_dict["global_events"]}'
                    else:
                        out_string += f'\nframe {frame_id} - patch not present\n- unexplained: {frame_dict["unexplained"]}\n- explained: {frame_dict["explained_unexplained"]}\n- events: {frame_dict["events"]}\n- global events: {frame_dict["global_events"]}'
        out_string += print_classes(ind.object_classes, ind.obj_class_assignment)
        out_string += f'\nscore: {score}'
    with open('log.txt', 'w') as f:
        f.write(out_string)
    print(f'n° individuals: {len(population)}')
    print(f'best score: {population[0][2]}')

def print_classes(object_classes, obj_class_assignment= None):

    if obj_class_assignment is not None:
        class_obj_assignment = {}
        for obj_id, class_id in obj_class_assignment.items():
            if class_id in class_obj_assignment.keys(): class_obj_assignment[class_id].append(obj_id)
            else: class_obj_assignment[class_id] = [obj_id]

    ss = '\n\n===============================================\n\n--- Created Classes ---\n'

    for class_id, obj_class in object_classes.items():
        ss += "---------------------------------------\n"
        ss += f'Class {class_id}:\n\n'
        ss += 'Property Variance:\n\n'
        for prop_class, variance in sorted(obj_class.property_variance_dict.items(), key= lambda x: x[0].__name__):
            ss += f'\t{prop_class.__name__}: {"variable" if variance else "constant"}\n'
        ss += '\nRules:'
        if obj_class.rules:
            for rule in obj_class.rules:
                ss += f'\t{rule}'
        else: ss += '\tNo Rules'
        ss += f'\n\nsame_shape: {obj_class.same_shape}\n'

        if obj_class_assignment is not None: ss += f'\n\nAssigned Objects: {class_obj_assignment[class_id]}\n'

    return ss