import pygame
import random
import imageio
import sys

from core.patch import Patch
from core.property import Pos_x, Pos_y, Shape_x, Shape_y


debug_patches_per_frame_0 = [
        [ # frame 0
            Patch('ball_a', {
                Pos_x: 4,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_b', {
                Pos_x: 4,
                Pos_y: 1,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('wall_a', {
                Pos_x: 6,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
            Patch('wall_b', {
                Pos_x: 1,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
        ],
        [ # frame 1
            Patch('ball_a', {
                Pos_x: 3,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_b', {
                Pos_x: 5,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('wall_a', {
                Pos_x: 6,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
            Patch('wall_b', {
                Pos_x: 1,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
        ],
        [ # frame 2
            Patch('ball_a', {
                Pos_x: 2,
                Pos_y: 1,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_b', {
                Pos_x: 4,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('wall_a', {
                Pos_x: 6,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
            Patch('wall_b', {
                Pos_x: 1,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
        ],
        [ # frame 3
            Patch('ball_a', {
                Pos_x: 3,
                Pos_y: 0,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_b', {
                Pos_x: 3,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('wall_a', {
                Pos_x: 6,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 3,
            }),
        ],
    ]


debug_patches_per_frame_1 = [
        [ # frame 0
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 2,
                Pos_y: 10,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 10,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 1
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 3,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 10,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 2
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 4,
                Pos_y: 8,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 9,
                Pos_y: 8,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 3
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 5,
                Pos_y: 7,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 8,
                Pos_y: 7,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 4
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 6,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 7,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 5
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 5,
                Pos_y: 5,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 8,
                Pos_y: 5,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 6
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_1', {
                Pos_x: 12,
                Pos_y: 3,
                Shape_x: 2,
                Shape_y: 1,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 4,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 9,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 7
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 3,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 8,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 8
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 2,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 7,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 9
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 1,
                Pos_y: 1,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 6,
                Pos_y: 1,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 10
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 2,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 5,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 11
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 3,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 4,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 12
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 2,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 5,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 13
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 1,
                Pos_y: 5,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 6,
                Pos_y: 5,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 14
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 2,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 7,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 15
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 3,
                Pos_y: 7,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 8,
                Pos_y: 7,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 16
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 4,
                Pos_y: 8,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 9,
                Pos_y: 8,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 17
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 5,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 10,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 18
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 6,
                Pos_y: 10,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 11,
                Pos_y: 10,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 19
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 7,
                Pos_y: 11,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 12,
                Pos_y: 11,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 20
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 8,
                Pos_y: 10,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 13,
                Pos_y: 10,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 21
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 9,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 14,
                Pos_y: 9,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 22
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_5', {
                Pos_x: 16,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 10,
                Pos_y: 8,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 15,
                Pos_y: 8,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 23
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 11,
                Pos_y: 7,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 14,
                Pos_y: 7,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 24
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 12,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 13,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 25
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 11,
                Pos_y: 5,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 14,
                Pos_y: 5,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 26
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 10,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 15,
                Pos_y: 4,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 27
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 9,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 16,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 28
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 8,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 17,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 29
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 7,
                Pos_y: 1,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 16,
                Pos_y: 1,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 30
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 6,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 15,
                Pos_y: 2,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
        [ # frame 31
            Patch('wall_1', {
                Pos_x: 0,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_2', {
                Pos_x: 22,
                Pos_y: 6,
                Shape_x: 0,
                Shape_y: 5,
            }),
            Patch('wall_3', {
                Pos_x: 11,
                Pos_y: 0,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('wall_4', {
                Pos_x: 11,
                Pos_y: 12,
                Shape_x: 10,
                Shape_y: 0,
            }),
            Patch('brick_2', {
                Pos_x: 19,
                Pos_y: 3,
                Shape_x: 1,
                Shape_y: 1,
            }),
            Patch('ball_1', {
                Pos_x: 5,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
            Patch('ball_2', {
                Pos_x: 14,
                Pos_y: 3,
                Shape_x: 0,
                Shape_y: 0,
            }),
        ],
    ]


debug_patches_per_frame = debug_patches_per_frame_1

def debug_to_video():

    pygame.init()

    max_x = 0
    max_y = 0
    for frame in debug_patches_per_frame:
        for p in frame:
            if p.properties[Pos_x] + p.properties[Shape_x] > max_x: max_x = p.properties[Pos_x] + p.properties[Shape_x]
            if p.properties[Pos_y] + p.properties[Shape_y] > max_y: max_y = p.properties[Pos_y] + p.properties[Shape_y]

    scale_x = 720 // max_x
    scale_y = 360 // max_y

    screen_width = (((max_x + 1) * scale_x) // 16) * 16
    screen_height = ((((max_y + 1) * scale_y)) // 16) * 16

    screen = pygame.display.set_mode((screen_width, screen_height))
    pygame.display.set_caption("Video from Debug Patches")

    patch_colors = {}
    def get_color(name):
        if name not in patch_colors:
            patch_colors[name] = (random.randint(50,255), random.randint(50,255), random.randint(50,255))
        return patch_colors[name]

    frame_images = []

    clock = pygame.time.Clock()
    fps = 1

    for frame in debug_patches_per_frame:
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                pygame.quit()
                sys.exit()

        screen.fill((255, 255, 255))
        
        for patch in frame:
            props = patch.properties
            pos_x = props[Pos_x]
            pos_y = props[Pos_y]
            shape_x = props[Shape_x]
            shape_y = props[Shape_y]
            color = get_color(patch.description)
            
            left = int((pos_x - shape_x) * scale_x)
            top = int((pos_y - shape_y) * scale_y)
            rect_width = int(2 * (shape_x + 0.5) * scale_x)
            rect_height = int(2 * (shape_y + 0.5) * scale_y)
            
            if rect_width == 0 and rect_height == 0:
                center = (int(pos_x * scale_x), int(pos_y * scale_y))
                pygame.draw.circle(screen, color, center, 5)
            elif rect_width == 0:
                start_pos = (int(pos_x * scale_x), int((pos_y - shape_y) * scale_y))
                end_pos   = (int(pos_x * scale_x), int((pos_y + shape_y) * scale_y))
                pygame.draw.line(screen, color, start_pos, end_pos, 3)
            elif rect_height == 0:
                start_pos = (int((pos_x - shape_x) * scale_x), int(pos_y * scale_y))
                end_pos   = (int((pos_x + shape_x) * scale_x), int(pos_y * scale_y))
                pygame.draw.line(screen, color, start_pos, end_pos, 3)
            else:
                pygame.draw.rect(screen, color, (left, top, rect_width, rect_height))
        
        pygame.display.flip()
        
        image = pygame.surfarray.array3d(screen).swapaxes(0,1)
        frame_images.append(image)
        
        clock.tick(fps)

    output_filename = "debug_patches_video.mp4"
    imageio.mimsave(output_filename, frame_images, fps=fps)
    print(f"Video saved as {output_filename}")

    running = True
    while running:
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                running = False

    pygame.quit()