import time

from heuristic import heuristic_initialization
from utils import load_patches_per_frame, write_results

def main():

    arkanoid_simple_804 = "arkanoid_log_2025_03_24_21_49_55.pkl"
    arkanoid_complete_lose_498 = "arkanoid_log_2025_03_24_21_54_03.pkl"
    arkanoid_complete_speed_21_lose_259 = "arkanoid_log_2025_03_25_09_47_11.pkl"
    arkanoid_complete_win_1501 = "arkanoid_log_2025_03_25_15_27_44.pkl"
    arkanoid_complete_lose_250 = "arkanoid_log_2025_03_25_16_53_26.pkl"
    arkanoid_complete_big_ball_190 = "arkanoid_log_2025_03_25_18_13_54.pkl"

    pong_681 = '../pong_logs/pong_log_2025_03_30_19_15_41.pkl'

    starting_time = time.time()

    patches_per_frame, global_events_per_frame = load_patches_per_frame(arkanoid_complete_big_ball_190)
    
    #patches_per_frame, global_events_per_frame = load_patches_per_frame(None) # last log

    #### ------------------------------- ####

    starting_from = 0
    stop_at = -1#150
    population = heuristic_initialization(patches_per_frame[starting_from:stop_at], global_events_per_frame[starting_from:stop_at])
    
    print('\n\n=====================================\nheuristic_initialization end\n=====================================\n')

    write_results(population)

    elapsed = time.time() - starting_time
    print(f"Elapsed time: {int(elapsed // 60)} min {int(elapsed % 60)} sec")

    return

if __name__ == "__main__":
    main()
