

class ObjectClass:

    def __init__(self, property_variance_dict, rules, same_shape):

        self.property_variance_dict = {prop_class: variance for prop_class, variance in property_variance_dict.items()}

        self.rules = rules[:]

        self.same_shape = same_shape

    def test(self, obj):

        score = 0

        for prop_class in obj.properties[obj.frames_id[-1]].keys():
            variance = False
            for i_fid in range(len(obj.frames_id) - 1):
                if obj.properties[obj.frames_id[i_fid]][prop_class] != obj.properties[obj.frames_id[i_fid + 1]][prop_class]:
                    variance = True
                    break
            if prop_class in self.property_variance_dict.keys():
                if self.property_variance_dict[prop_class] != variance:
                    if variance:
                        return False, -100
                    else:
                        score -= 1
                elif variance:
                    score += 1
            else:
                return False, -100

        for cf in obj.frames_id:
            for rule in self.rules:
                triggered, effects, cause_offset = rule.trigger(obj, cf)
                if triggered:
                    ef = cf + cause_offset
                    if ef in obj.unexplained.keys():
                        if all(any(effect.test(unexpl) for unexpl in obj.unexplained[ef]) for effect in effects):
                            score += 10
                        else:
                            return False, -100
                    else:
                        return False, -100
        
        return True, score