# Arkanoid Atom

Arkanoid_Atom analyzes the behavior of graphical elements in a simple Arkanoid game using logic-based methods. It avoids deep learning, relying on interpretable and rule-based mechanisms. This project provides insights into object interactions, properties, and changes over time.

## Table of Contents

- [Features](#features)
- [Installation](#installation)
- [Usage](#usage)
- [License](#license)
- [Glossary](#glossary)

## Features

- Logic-based detection of object appearance, disappearance, and changes.
- Generalization through object classes
- Modular design for extensibility and experimentation.

## Installation

### Steps

1. Clone the repository:

   ```bash
   git clone https://github.com/BlankTo/arkanoid_atom.git
   ```

2. Navigate to the project directory:

   ```bash
   cd arkanoid_atom
   ```

3. Install the required dependencies:

   ```bash
   pip install -r requirements.txt
   ```

4. Run the game and analysis:

   ```bash
   python arkanoid.py  # Play the game and generate logs
   python main.py      # Analyze the generated logs (check in the file to load the correct log (or the last one with None))
   ```

### Commands in Gameplay

- **Left Arrow Key**: Move the paddle to the left.
- **Right Arrow Key**: Move the paddle to the right.
- **q**: Exit the game (logs are still recorded).

## License

This project is licensed under the MIT License. See the `LICENSE` file for more details.

---
