import pwd
import subprocess
import sys
import os 

def install_packages(requirements_file):
    try:
        subprocess.check_call(['sudo', sys.executable, '-m', 'pip', 'install', '-r', requirements_file])
    except subprocess.CalledProcessError as e:
        print(f"An error occurred while installing packages: {e}")
        sys.exit(1)

def move_script_to_bin(script_name):
    current_dir = os.path.dirname(os.path.abspath(__file__))

    script_full_name = 'update/' + script_name

    src = os.path.join(current_dir, script_full_name)
    dest = os.path.join('/usr/local/bin', script_name)

    try:
        subprocess.check_call(['sudo', 'mv', src, dest])
        print(f"Script {script_name} moved to {dest}.")
    except FileNotFoundError as e:
        print(f"File {script_name} not found at {src}: {e}")
        sys.exit(1)
    except Exception as e:
        print(f"An error occurred while moving the script: {e}")
        sys.exit(1)

def run_script(script_name):
    try:
        subprocess.check_call([sys.executable, script_name])
    except subprocess.CalledProcessError as e:
        print(f"An error occurred while running the script: {e}")
        sys.exit(1)

def install_crontab_if_needed():
    try:
        # Check if crontab is installed
        subprocess.check_call(['which', 'crontab'])
    except subprocess.CalledProcessError:
        print("crontab not found. Attempting to install...")
        try:
            subprocess.check_call(['sudo', 'apt-get', 'install', '-y', 'cron'])
        except subprocess.CalledProcessError as e:
            print(f"An error occurred while installing crontab: {e}")
            sys.exit(1)

def add_cron_job(script_path, user, interval='* * * * *'):
    current_user = user

    cron_command = f"{interval} {sys.executable} {script_path}"

    print(f"Command: {cron_command}")
    
    try:
        # Check if the cron job is already present
        cron_jobs = subprocess.check_output(['crontab', '-u', current_user, '-l'], stderr=subprocess.STDOUT).decode()
        if cron_command in cron_jobs:
            print(f"Cron job is already present for {current_user}.")
            return
    except subprocess.CalledProcessError:
        # If crontab is empty or not set, this command will fail
        print(f"No existing crontab for user {current_user}, creating a new one.")

    # Add the cron job to the crontab
    try:
        subprocess.run(f'(sudo crontab -u {current_user} -l; echo "{cron_command}") | sudo crontab -u {current_user} -', shell=True, check=True)
        print(f"Cron job added successfully for {current_user}.")   
    except subprocess.CalledProcessError as e:
        print(f"An error occurred while adding the cron job for {current_user}: {e}")
        sys.exit(1)

def start_crontab():
    subprocess.run(f'sudo service cron start', shell=True, check=True)

def get_users():
    # Get a list of users with UID >= 1000 (normal users)
    users = []
    for user in pwd.getpwall():
        if user.pw_uid >= 1000 and user.pw_name != 'nobody':  # Exclude system users
            users.append(user.pw_name)
    return users

if __name__ == "__main__":
    dir = '/dbUpdate/'
    script_name = 'update.py'

    current_dir = os.path.dirname(os.path.abspath(__file__))  # Get the directory where this script is located

    requirements_file = os.path.join(current_dir, 'requirements.txt')
    script_to_run = os.path.join('/usr/local/bin', script_name)

    # Check if requirements.txt exists
    if not os.path.exists(requirements_file):
        print(f"{requirements_file} not found.")
        sys.exit(1)

    # Install packages
    install_packages(requirements_file)

    # Check and install crontab if necessary
    install_crontab_if_needed()

    # Move the script to another folder so it can keep running in background
    move_script_to_bin(script_name)

    # # Add the cron job for every minute (can change interval for every 5 or 10 mins)
    # # * * * * * ->    1 minute
    # # */5 * * * * ->    5 minutes
    # # */10 * * * * ->   10 minutes
    # add_cron_job(script_to_run, interval='* * * * *')  # Run every minute

    # Get the list of users and add the cron job for each
    users = get_users()
    for user in users:
        add_cron_job(script_to_run, user, interval='*/2 * * * *') 

    # Start crontab
    start_crontab()
