import imaplib
import email
import os
import time

# Configuration
IMAP_SERVER = 'email_server'  
EMAIL_ACCOUNT = 'sarahwilliams@e-corp.com'  
EMAIL_PASSWORD = 'sarahwilliams'           
SUBJECT = "Important Security Update: Action Required"  
SAVE_DIR = os.path.expanduser("/home/sarahwilliams/downloads")   

MAX_RETRIES = 5  # Maximum number of retries for login attempts
RETRY_DELAY = 10  # Delay between retries in seconds

os.makedirs(SAVE_DIR, exist_ok=True)

def save_attachment(part):
    filename = part.get_filename()
    if filename:
        file_path = os.path.join(SAVE_DIR, filename)
        with open(file_path, 'wb') as f:
            f.write(part.get_payload(decode=True))
        print(f"Saved attachment: {file_path}")

def attempt_login():
    for attempt in range(1, MAX_RETRIES + 1):
        try:
            # Connect to the IMAP server
            mail = imaplib.IMAP4_SSL(IMAP_SERVER)
            mail.login(EMAIL_ACCOUNT, EMAIL_PASSWORD)
            print("Login successful.")
            return mail
        except imaplib.IMAP4.error as e:
            print(f"Login attempt {attempt} failed: {e}")
            if attempt < MAX_RETRIES:
                print(f"Retrying in {RETRY_DELAY} seconds...")
                time.sleep(RETRY_DELAY)
            else:
                print("Max retries reached. Exiting.")
                return None

def main():
    # Connect to the IMAP server
    mail = imaplib.IMAP4_SSL(IMAP_SERVER)
    mail.login(EMAIL_ACCOUNT, EMAIL_PASSWORD)

    # Select the mailbox to search
    mail.select("inbox")

    # Search for emails by subject
    result, data = mail.search(None, f'SUBJECT "{SUBJECT}"')

    if result == "OK":
        for num in data[0].split():
            # Fetch the email by ID
            result, msg_data = mail.fetch(num, '(RFC822)')
            msg = email.message_from_bytes(msg_data[0][1])

            # Iterate through email parts to find attachments
            for part in msg.walk():
                if part.get_content_maintype() == 'multipart':
                    continue
                if part.get('Content-Disposition') is None:
                    continue
                save_attachment(part)
    else:
        print("No emails found.")

    mail.logout()

if __name__ == "__main__":
    main()