%ERRORE DELTA POLYFIT
clc
clear
close all

% Dati di esempio
x = [1 2 3 4 5];
y = [2.2 2.8 3.6 4.5 5.1];

% Fit polinomiale di grado 2
[p, S] = polyfit(x, y, 2);

% Valutazione del polinomio con errore di stima
[x_fit, delta] = polyval(p, x, S);

% Grafico con intervallo di errore
figure;
plot(x, y, 'ro', 'MarkerFaceColor', 'r'); % Punti originali
hold on;
plot(x, x_fit, 'b-', 'LineWidth', 2); % Fit polinomiale
plot(x, x_fit + delta, 'k--'); % Limite superiore
plot(x, x_fit - delta, 'k--'); % Limite inferiore
hold off;
legend('Dati', 'Fit', 'Errore superiore', 'Errore inferiore');
title('Polyval con errore di stima');
grid on;