%TOP
clc
clear
close all

% /solve/monitors/residual/reset? yes

% Controllo della matrice delle coordinate

P=readmatrix('parabolic_s1.txt');
P=P*100;
P=sortrows(P);
z=length(P(:,1));

P=unique(P,'rows');

% figure
% plot(P(:,1),P(:,2),'k o','MarkerSize',1)
% axis equal

L=P(end,1)*10^-2; %lunghezza divergente

ri=P(1,2);
rt=1;
re=P(end,2);
                       % ---- TUTTO IN cm ed cm^2 ---- %
Ai=pi*ri^2;
At=pi*rt^2;
Ae=pi*re^2;

% Applico legge delle aree: ipotesi flusso 1D isentropico !

gamma=1.4; %aria
delta=(gamma-1)*0.5;
R=287; %cost. gas aria [J/(kg*K)]

c1=(gamma+1)/(2*(gamma-1));
c2=gamma/(gamma-1);

Gamma=sqrt(gamma)*(2/(gamma+1))^c1;

Mt=1; % Gola sonica

f1=@(M) Ai/At - (1./M)*((1+delta*M.^2)./(1+delta)).^c1; 
f2=@(M) Ae/At - (1./M)*((1+delta*M.^2)./(1+delta)).^c1;

%Mach isentropici di VolvoS1

Mi_is=fzero(f1,0.1);
Me_is=fzero(f2,4);

pa=101325; % pressione ambiente 
%p0=101325*(1+delta*Me_is^2)^c2 % pressione totale (adattamento)
p0=10*pa; %NPR=10; metto per normalizzare bene
% pi=p0/(1+delta*Mi_is^2)^c2;
% pe=p0/(1+delta*Me_is^2)^c2;
T0=300; % temperatura totale [K]

% per pressure-inlet delle mie simulazioni
p0_cfd=input('npr cfd = ')*pa
pi_cfd=p0_cfd/(1+delta*Mi_is^2)^c2
pe_cfd=p0_cfd/(1+delta*Me_is^2)^c2 % se uscita isentropica, aka full flowing

m_dot_1D=Gamma*(p0_cfd/sqrt(R*T0))*At*10^-4
%m_dot_CFD=0.727675; %[kg/s] dalla sim. inviscida 120x80 per p0=10*npr full flowing

% Simulazione solo ugello, npr=10
pw_EUL=readmatrix("pw_wall_inv.txt");  % 120x80 Valentyn
pax_EUL=readmatrix("pw_axis_inv.txt"); % 120x80 Valentyn
pw_NS=readmatrix("pw_wall_visc.txt");  % 120x100 mia
pax_NS=readmatrix("pw_axis_visc.txt"); % 120x100 mia

% Normalizzo subito, per usarli nei prossimi grafici
pw_EUL=[pw_EUL(:,1)./L,pw_EUL(:,2)./p0];
pax_EUL=[pax_EUL(:,1)./L,pax_EUL(:,2)./p0];
pw_NS=[pw_NS(:,1)./L,pw_NS(:,2)./p0];
pax_NS=[pax_NS(:,1)./L,pax_NS(:,2)./p0];
%% 


%2/3 divergente: x=6.95164686904948	y=3.97495962134331
%Full flowing NPR=50
pax_50=readmatrix("pax_npr50.txt");
pw_50=readmatrix("pw_npr50.txt");
p0_50=101325*50;

% figure
% plot(pw_EUL(:,1),pw_EUL(:,2),'b--','LineWidth',1.)
% hold on
% plot(pax_EUL(:,1),pax_EUL(:,2),'g--','LineWidth',1.)
% plot(pw_NS(:,1),pw_NS(:,2),'b-','LineWidth',1.)
% plot(pax_NS(:,1),pax_NS(:,2),'g-','LineWidth',1.)
% legend('p_{wall} EUL','p_{axis} EUL','p_{wall} NS','p_{axis} NS')

% figure
% plot(pax_50(:,1)./L,pax_50(:,2)/p0_50,'g-','LineWidth',1.0)
% hold on
% plot(pw_50(:,1)./L,pw_50(:,2)/p0_50,'b-','LineWidth',1.0)
% legend('p_{axis}','p_{wall}')
% grid on
% xlabel("x / L")
% xlim([-0.4,1.05])
% ylim([-0.02,1.05])
% ylabel("p(x) / p_c")
% title("Profili di pressione"," Condizione full-flowing")

Mt_50=readmatrix("Mach_golaTOP.txt");
Me_50=readmatrix("Mach_exitTOP.txt");
M23_50=readmatrix("Mach_dueterziTOP.txt");

Mt_50=sortrows(Mt_50,2);
Me_50=sortrows(Me_50,2);
M23_50=sortrows(M23_50,2);

Mt_50(end-1,1)=0;
Me_50(end-1,1)=0;
M23_50(end-1,1)=0;

% figure
% plot(Mt_50(:,1),Mt_50(:,2)./0.01,'r-','LineWidth',1.0)
% hold on
% plot(Me_50(:,1),Me_50(:,2)./0.01,'g-','LineWidth',1.0)
% plot(M23_50(:,1),M23_50(:,2)./0.01,'b-','LineWidth',1.0)
% title("Profili di Mach lungo sezioni ugello","Condizione full-flowing")
% legend('$x=x_t$','$x=x_e$','$x=\frac{2}{3}L$','Interpreter','latex')
% grid on
% xlabel('M')
% ylabel('r / r_t')
% ylim([0,4.6])

ut_50=readmatrix("ut_50.txt");
ue_50=readmatrix("ue_50.txt");
u23_50=readmatrix("u23_50.txt");

ut_50=sortrows(ut_50,2);
ue_50=sortrows(ue_50,2);
u23_50=sortrows(u23_50,2);

ut_50(end-1,1)=0;
ue_50(end-1,1)=0;
u23_50(end-1,1)=0;

% figure
% plot(ut_50(:,1),ut_50(:,2)./0.01,'r-','LineWidth',1.0)
% hold on
% plot(ue_50(:,1),ue_50(:,2)./0.01,'g-','LineWidth',1.0)
% plot(u23_50(:,1),u23_50(:,2)./0.01,'b-','LineWidth',1.0)
% title("Profili di velocità assiale lungo sezioni ugello","Condizione full-flowing")
% legend('$x=x_t$','$x=x_e$','$x=\frac{2}{3}L$','Interpreter','latex')
% grid on
% xlabel('u [m/s]')
% ylabel('r / r_t')
% ylim([0,4.6])

% TEST CASE OSTLUND, NPR=14 (FSS) ed NPR=16 (RSS)

% ascissa è distanza da gola normalizzata con lunghezza del divergente
% ordinate sono pw/p0

close all

L=0.10435; %[m] lunghezza divergente

pa=101325;
p0_10=10*pa;
p0_12=12*pa;
p0_14=14*pa;
p0_16=16*pa;
p0_18=18*pa;
p0_20=20*pa;

p0_v=[p0_10,p0_12,p0_14,p0_16,p0_18,p0_20];

%pa=100000; % [Pa] ossia 1 bar, è la pressione amb. del test case!

T14=[0.40042673620886393, 0.06281075434515254
0.45086606706278076, 0.06407407133014269
0.5517032405280863, 0.06425543421890975
0.6514790064553732, 0.06443694527997154
0.750732711997511, 0.06510712856910014
0.8011512987301636, 0.06519781001348368
0.9009443514251709, 0.06635651735838433
0.9513577521275076, 0.06615403991761618
1.001223162293115, 0.0649744402791566]; %NPR=14 ffs dati sperimentali

T16=[0.40070070070070063, 0.015222536822536822
0.4497497497497496, 0.013839897039897034
0.49979979979979966, 0.012685599885599835
0.5498498498498499, 0.01221701701701699
0.6499499499499499, 0.04533699413699415
0.7510510510510511, 0.09079959959959957
0.8001001001001, 0.059245531245531224
0.8501501501501498, 0.045976948376948386
0.9002002002001999, 0.05670836550836551
0.951251251251251, 0.07246812526812525
1.0003003003003001, 0.061485485485485464]; %NPR=16 rss dati sperimentali

% Intro simulazioni 

% Lettura pressioni di parete: mesh 5,6,7 poi mesh 6-SA e poi mesh 6-HSN

pw5_data=leggi_pw('C:\Users\ricca\Documents\MATLAB\Lavori_tesi\TOP_TESI\pw5');
pw6_data=leggi_pw('C:\Users\ricca\Documents\MATLAB\Lavori_tesi\TOP_TESI\pw6');
pw6SA_data=leggi_pw('C:\Users\ricca\Documents\MATLAB\Lavori_tesi\TOP_TESI\pw6_SA');
pw6hsn_data=leggi_pw('C:\Users\ricca\Documents\MATLAB\Lavori_tesi\TOP_TESI\pw_hsn');
pw7_data=leggi_pw('C:\Users\ricca\Documents\MATLAB\Lavori_tesi\TOP_TESI\pw7');

% Mesh 5
pw5_10=pw5_data{1};
pw5_12=pw5_data{2};
pw5_14=pw5_data{3};
pw5_16=pw5_data{4};
pw5_18=pw5_data{5};
pw5_20=pw5_data{6};

% Mesh 6
pw6_10=pw6_data{1};
pw6_12=pw6_data{2};
pw6_14=pw6_data{3};
pw6_16=pw6_data{4};
pw6_18=pw6_data{5};
pw6_20=pw6_data{6};

% Mesh 6 SA
pw6_10SA=pw6SA_data{1};
pw6_12SA=pw6SA_data{2};
pw6_14SA=pw6SA_data{3};
pw6_16SA=pw6SA_data{4};
pw6_18SA=pw6SA_data{5};
pw6_20SA=pw6SA_data{6};

% Mesh 6 HSN
pw6_10_hsn=pw6hsn_data{1};
pw6_12_hsn=pw6hsn_data{2};
pw6_14_hsn=pw6hsn_data{3};
pw6_16_hsn=pw6hsn_data{4};
pw6_18_hsn=pw6hsn_data{5};
pw6_20_hsn=pw6hsn_data{6};

% Mesh 7
pw7_10=pw7_data{1};
pw7_12=pw7_data{2};
pw7_14=pw7_data{3};
pw7_16=pw7_data{4};
pw7_18=pw7_data{5};
pw7_20=pw7_data{6};

% Si usano solo mesh 5, mesh 6, mesh 7
% Modelli e schemi: 
% 1) k-omega SST, tabulated + low Re corrections + ROE FDS 2°ordine 
% 2) Spalart-Allmaras, vorticity based + AUSM 2°ordine + HSN 
% I casi test li faccio con k-omega SST (mesh 5,6,7) e SA (solo mesh 6) 

% Notazione p_wall: pw(i)_(j)_(modello) 
% i--> 5,6,7 tipo di mesh
% j--> numero NPR
% modello--> SST o SA riferiti risp. a k-omega SST o Spalart-All.

% Pressioni 1°caso, NPR=14 (FSS)
pw6_14c=readmatrix("pw6_14c.txt"); % mesh 6, compressibility
pw6_14c_hsn=readmatrix("pw6_14c_hsn.txt"); % mesh 6, hsn + compressibility

% Pressioni 2°caso, NPR=16 (RSS)
pw6_16_RSS=readmatrix("pw6_16_RSS.txt"); % mesh 6, HSN 
pw6_16SA_RSS=readmatrix("pw6_16SA_RSS.txt"); % mesh 6, SA

% Normalizzazioni
pw6_14_hsn=[pw6_14_hsn(:,1)./L,pw6_14_hsn(:,2)./p0_14];
pw6_14c=[pw6_14c(:,1)./L,pw6_14c(:,2)./p0_14];
pw6_14c_hsn=[pw6_14c_hsn(:,1)./L,pw6_14c_hsn(:,2)./p0_14];

pw6_16SA_RSS=[pw6_16SA_RSS(:,1)./L,pw6_16SA_RSS(:,2)./p0_16];
pw6_16_RSS=[pw6_16_RSS(:,1)./L,pw6_16_RSS(:,2)./p0_16];

% Prima testo mesh 5,6,7 con stesso set up
% Poi testo mesh 6, variando un po' le cose
%Questo solo per il primo caso test

% CASO TEST 1: NPR=14 FSS
figure 
plot(T14(:,1),T14(:,2),'k *','MarkerSize',9)
hold on
plot(pw_EUL(:,1),pw_EUL(:,2),'k--','LineWidth',0.5)
%plot(pw5_14(:,1)./L,pw5_14(:,2)/p0_14,'r-','LineWidth',1)
plot(pw6_14(:,1)./L,pw6_14(:,2)./p0_14,'b-','LineWidth',1)
plot(pw6_14_hsn(:,1),pw6_14_hsn(:,2),'b-.','LineWidth',1.1)
plot(pw6_14SA(:,1)./L,pw6_14SA(:,2)./p0_14,'m-','LineWidth',1.1)
plot(pw6_14c(:,1),pw6_14c(:,2),'r-','LineWidth',1.1)
plot(pw6_14c_hsn(:,1),pw6_14c_hsn(:,2),'r-.','LineWidth',1.1)

%plot(pw7_14(:,1)./L,pw7_14(:,2)./p0_14,'g-','LineWidth',1)


%legend('Exp. data','','Mesh 1, k-\omega SST','Mesh 2, k-\omega SST'...
    %,'Mesh 3, k-\omega SST')
legend('Exp. data','','k-\omega SST default','k-\omega SST + HSN','Spalart-Allmaras'...
    ,'k-\omega SST + compressibility','K-\omega SST + compressibility + HSN')
grid minor
%title('\fontname{Times New Roman}Ugello VOLVOS1, NPR = 14')
title('\fontname{Times New Roman}Ugello VOLVOS1, NPR = 14','\fontname{Times New Roman} Mesh 2, modello k-\omega SST')
xlabel('x / L')
ylabel('p_w / p^o')
xlim([0.1,1.05])
ylim([0,0.1])

%Una volta finito primo caso test, so che mesh usare e con quale set up

% CASO TEST 2: NPR=16 RSS (lo faccio a tempo perso)
% Nel secondo caso test, mi limito a verificare ordini di grandezza
figure 
plot(T16(:,1),T16(:,2),'k *','MarkerSize',9)
hold on
plot(pw_EUL(:,1),pw_EUL(:,2),'k--','LineWidth',0.5)
%plot(pw5_16(:,1)./L,pw5_16(:,2)./p0_16,'r-','LineWidth',1)
%plot(pw6_16(:,1)./L,pw6_16(:,2)./p0_16,'b-','LineWidth',1)
%plot(pw7_16(:,1)./L,pw7_16(:,2)./p0_16,'g-','LineWidth',1)
plot(pw6_16_RSS(:,1),pw6_16_RSS(:,2),'b-','LineWidth',1.)
plot(pw6_16SA_RSS(:,1),pw6_16SA_RSS(:,2),'m-','LineWidth',1.)
legend('Exp. data','','Mesh 2, k-\omega SST','Mesh 2, Spalart-Allmaras')
%legend('Exp. data','','Mesh 1, k-\omega SST','Mesh 2, k-\omega SST',...
%    'Mesh 3, k-\omega SST')
title('\fontname{Times New Roman}Ugello VOLVOS1',' NPR=16')
grid minor
xlabel('x / L')
ylabel('p_w / p_0')
xlim([0.1,1.05])
ylim([0,0.1])

%% Andamenti p_wall e posizione punto di separazione

%confronti pressione

% L=0.10435; %[m] lunghezza divergente 
% pa=101325;

pw_EUL=readmatrix("pw_wall_inv.txt");  % 120x80 Valentyn

% Grafico x_sep - NPR per le tre mesh SST + mesh 6 SA 

X5=[pw5_10(:,1)];
X6=[pw6_10(:,1)];
X6_SA=[pw6_10SA(:,1)];
X7=[pw7_10(:,1)];
 
Pw5=[pw5_10(:,2),pw5_12(:,2),pw5_14(:,2),pw5_16(:,2),pw5_18(:,2),...
    pw5_20(:,2)];
Pw6=[pw6_10(:,2),pw6_12(:,2),pw6_14(:,2),pw6_16(:,2),pw6_18(:,2),...
    pw6_20(:,2)];
Pw6_SA=[pw6_10SA(:,2),pw6_12SA(:,2),pw6_14SA(:,2),pw6_16SA(:,2),pw6_18SA(:,2),...
     pw6_20SA(:,2)];
Pw7=[pw7_10(:,2),pw7_12(:,2),pw7_14(:,2),pw7_16(:,2),pw7_18(:,2),...
    pw7_20(:,2)];

[min5,ind5]=min(Pw5);
[min6,ind6]=min(Pw6);
[min6_SA,ind6_SA]=min(Pw6_SA);
[min7,ind7]=min(Pw7);

Xsep5=X5(ind5);
Xsep6=X6(ind6);
Xsep6_SA=X6_SA(ind6_SA);
Xsep7=X7(ind7);

figure 

plot(pw_EUL(:,1)./L,pw_EUL(:,2)./p0_10,'k--','LineWidth',1.0)
hold on

plot(pw6_10(:,1)./L,pw6_10(:,2)./p0_10,'b-','LineWidth',1.0)
plot(pw6_12(:,1)./L,pw6_12(:,2)./p0_12,'g-','LineWidth',1.0)
plot(pw6_14(:,1)./L,pw6_14(:,2)./p0_14,'r-','LineWidth',1.0)
plot(pw6_16(:,1)./L,pw6_16(:,2)./p0_16,'m-','LineWidth',1.0)
plot(pw6_18(:,1)./L,pw6_18(:,2)./p0_18,'-','Color',[0.9290 0.6940 0.1250],'LineWidth',1.0)
plot(pw6_20(:,1)./L,pw6_20(:,2)./p0_20,'-','Color',[0.4940 0.1840 0.5560],'LineWidth',1.0)
%plot(Xsep6./L,min6./p0_v,'k o','MarkerFaceColor','k','MarkerSize',4)

% plot(pw6_10SA(:,1)./L,pw6_10SA(:,2)./p0_10,'b--','LineWidth',1.0)
% plot(pw6_12SA(:,1)./L,pw6_12SA(:,2)./p0_12,'g--','LineWidth',1.0)
% plot(pw6_14SA(:,1)./L,pw6_14SA(:,2)./p0_14,'r--','LineWidth',1.0)
% plot(pw6_16SA(:,1)./L,pw6_16SA(:,2)./p0_16,'m--','LineWidth',1.0)
% plot(pw6_18SA(:,1)./L,pw6_18SA(:,2)./p0_18,'--','Color',[0.9290 0.6940 0.1250],'LineWidth',1.0)
% plot(pw6_20SA(:,1)./L,pw6_20SA(:,2)./p0_20,'--','Color',[0.4940 0.1840 0.5560],'LineWidth',1.0)
% plot(Xsep6_SA./L,min6_SA./p0_v,'k o','MarkerFaceColor','k','MarkerSize',4)

plot(pw5_10(:,1)./L,pw5_10(:,2)./p0_10,'b--','LineWidth',1.0)
plot(pw5_12(:,1)./L,pw5_12(:,2)./p0_12,'g--','LineWidth',1.0)
plot(pw5_14(:,1)./L,pw5_14(:,2)./p0_14,'r--','LineWidth',1.0)
plot(pw5_16(:,1)./L,pw5_16(:,2)./p0_16,'m--','LineWidth',1.0)
plot(pw5_18(:,1)./L,pw5_18(:,2)./p0_18,'--','Color',[0.9290 0.6940 0.1250],'LineWidth',1.0)
plot(pw5_20(:,1)./L,pw5_20(:,2)./p0_20,'--','Color',[0.4940 0.1840 0.5560],'LineWidth',1.0)
%plot(Xsep5./L,min5./p0_v,'k o','MarkerFaceColor','k','MarkerSize',4)

plot(pw7_10(:,1)./L,pw7_10(:,2)./p0_10,'b-.','LineWidth',1.0)
plot(pw7_12(:,1)./L,pw7_12(:,2)./p0_12,'g-.','LineWidth',1.0)
plot(pw7_14(:,1)./L,pw7_14(:,2)./p0_14,'r-.','LineWidth',1.0)
plot(pw7_16(:,1)./L,pw7_16(:,2)./p0_16,'m-.','LineWidth',1.0)
plot(pw7_18(:,1)./L,pw7_18(:,2)./p0_18,'-.','Color',[0.9290 0.6940 0.1250],'LineWidth',1.0)
plot(pw7_20(:,1)./L,pw7_20(:,2)./p0_20,'-.','Color',[0.4940 0.1840 0.5560],'LineWidth',1.0)
%plot(Xsep7./L,min7./p0_v,'k o','MarkerFaceColor','k','MarkerSize',4)

legend('','NPR=10','NPR=12','NPR=14','NPR=16','NPR=18','NPR=20')
grid minor
xlabel("x / L")
ylabel("p_w / p^o")
xlim([0,1])
ylim([0,0.2])
title("\fontname{Times New Roman} Pressioni di parete, NPR variabili", '\fontname{Times New Roman} Mesh 1,2 & 3, modello k-\omega SST')

% Posizione punto di separazione

NPR_v=[10 12 14 16 18 20];

figure

plot(Xsep5./L,NPR_v,'r s','MarkerFaceColor','r','MarkerSize',5)
hold on
plot(Xsep6./L,NPR_v,'b ^','MarkerFaceColor','b','MarkerSize',5)
plot(Xsep7./L,NPR_v,'g v','MarkerFaceColor','g','MarkerSize',5)
plot(Xsep6_SA./L,NPR_v,'m o','MarkerFaceColor','m','MarkerSize',5)
yline([10,12,14,16],'g--','LineWidth',1.1)
yline([18,20],'r--','LineWidth',1.1)
% xline(0.5*[Xsep7(2)+Xsep5(5)]./L)
% xline(0.5*[Xsep6_SA(4)+Xsep6_SA(5)]./L)

ylim([8,22])
xlim([0,0.8])


 legend('Mesh 1, k-\omega SST','Mesh 2, k-\omega SST','Mesh 3, k-\omega SST '...
     ,'Mesh 2, Spalart-Allmaras','FSS','','','','RSS')
title('\fontname{Times New Roman}Posizione del punto di separazione',' NPR \in [10,20]','FontSize',12)
xlabel('X_{sep} / L')
ylabel(' NPR ')
grid minor

%% Numero di Reynolds
%Re=rho*U*D/L
%Faccio stima 1D in sezione di gola come Martelli Texas

%npr=10
rho=7.1380128; %[kg/m^3]
U=324.7078; %[m/s]
D=0.02; %[m]
mu=1.580396*10^(-5); %[kg/m/s]
Re10=(rho*U*D)/mu

%npr=50
rho=35.6777; %[kg/m^3]
U=324.928; %[m/s]
mu=1.57993*10^(-5);
Re50=(rho*U*D)/mu




