%TOP
clc
clear
close all

% Controllo della matrice delle coordinate

P=readmatrix('parabolic_s1.txt');
P=P*100; % porto in cm
P=sortrows(P);
z=length(P(:,1));

P=unique(P,'rows');

% Grandezze di riferimento [cm]

L_tot=P(end,1)-P(1,1);
L=10.435; %[cm] lunghezza divergente
ri=P(1,2);
rt=1;
re=P(end,2)
                       % ---- TUTTO IN cm ed cm^2 ---- %
Ai=pi*ri^2;
At=pi*rt^2;
Ae=pi*re^2;


P=[P,zeros(1301,1)];
v=1:1301;
T=[ones(1301,1),v',P];

% Definizione dominio esterno

b= 7*re; % base dominio esterno
h=5*re; % altezza dominio esterno
s=0.1*rt; % estensione del segmento getto secondario, Ianna
%s=4.5491-4.4720; %Valentyn, mai usato

% Spigoli dominio esterno

xe=P(end,1);
ye=re;

xA=xe;       % vertice superiore, spigolo sez. uscita
yA=ye+s;

xB=xA-re;    % vado indietro, alla stessa altessa
yB=yA;

xC=xB;       % tiro su un segmento verticale
yC=yB+h;

xD=xe+b;     % tiro il segmento orizzontale superiore
yD=yC;

xE=xD;       % tiro il segmento verticale di destra, verso il basso
yE=0;

xF=P(1,1);   % mi ricongiungo all'inlet, lungo asse ugello
yF=0;

M=[xe ye;xA yA;xB yB;xA yA; xB yB; xC yC; xC yC; xD yD; xE yE; xD yD;...
    xF yF;xE yE; xF yF; P(1,1) P(1,2)];
M=[zeros(14,2),M,zeros(14,1)];
T=[T;M];
writematrix(T,'TOP_ugello_e_dominio.xls');

figure(1) % Geometria solo ugello

xline(0,'k--','LineWidth',0.01)
hold on
xline(T(1301,3),'k--','LineWidth',0.01)
xline(T(1,3),'k--','LineWidth',0.01)
plot(T(1:1301,3),T(1:1301,4),'k-','LineWidth',1)
plot([T(1,3),T(1,3)],[0,T(1,4)],'k-','LineWidth',1)
plot([T(1301,3),T(1301,3)],[0,T(1301,4)],'k-','LineWidth',1)
plot([T(1,3),T(1301,3)],[0,0],'k-.','LineWidth',1)
plot(T(1:1301,3),-T(1:1301,4),'k-','LineWidth',1)
plot([T(1,3),T(1,3)],-[0,T(1,4)],'k-','LineWidth',1)
plot([T(1301,3),T(1301,3)],-[0,T(1301,4)],'k-','LineWidth',1)
plot([0,T(201,3)+2],[1,1],'k--')
plot([0,T(201,3)+2],[-1,-1],'k--')
plot([T(1,3)-2,T(1,3)],[T(1,4),T(1,4)],'k--')
plot([T(1,3)-2,T(1,3)],-[T(1,4),T(1,4)],'k--')
plot([T(1301,3),T(1301,3)+2],[T(1301,4),T(1301,4)],'k--')
plot([T(1301,3),T(1301,3)+2],-[T(1301,4),T(1301,4)],'k--')

axis equal
title("\fontname{Times New Roman}Geometria ugello TOP",'FontSize',12)
%grid minor
xlim([T(1,3)-5,T(1301,3)+5])
xlabel('x [cm]')
ylabel('y [cm]')
ylim([-T(1301,4)-5,T(1301,4)+5])

figure(2) % Geometria dominio esterno

plot(T(1:1301,3),T(1:1301,4),'k-','LineWidth',1)
hold on
plot([xe,xA],[ye,yA],'k-','LineWidth',1)
plot([xB,xA],[yB,yA],'k-','LineWidth',1)
plot([xB,xC],[yB,yC],'k-','LineWidth',1)
plot([xC,xD],[yC,yD],'k-','LineWidth',1)
plot([xE,xD],[yE,yD],'k-','LineWidth',1)
plot([xF,xE],[yF,yE],'k-','LineWidth',1)
plot([xB,xA],[yB,yA],'k-','LineWidth',1)
plot([xF,P(1,1)],[yF,P(1,2)],'k-','LineWidth',1)
plot([T(1,3),T(1301,3)],[0,0],'k-','LineWidth',1)
plot([T(1301,3),T(1301,3)],[0,yC],'k--')
plot([xB,xB-4],[yB,yB],'k--')
plot([xC,xC-4],[yC,yC],'k--')
plot([xe,xD],[ye,ye],'k:')
plot([xe,xD],[yA,yA],'k:')
axis equal
%grid minor
xlim([T(1,3)-5,xD+5])
ylim([-5,30])

title('\fontname{Times New Roman} Dominio computazionale, ugello VOLVOS1','FontSize',12)
xlabel('x [cm]')
ylabel('y [cm]')

%% Dominio colorato per condizioni al contorno

figure(3) % Geometria solo ugello


plot(T(1:1301,3),T(1:1301,4),'k-','LineWidth',1)
hold on
plot([T(1,3),T(1,3)],[0,T(1,4)],'g-','LineWidth',1)
plot([T(1301,3),T(1301,3)],[0,T(1301,4)],'r-','LineWidth',1)
plot([T(1,3),T(1301,3)],[0,0],'b-','LineWidth',1)
axis equal
title("\fontname{Times New Roman}Geometria ugello TOP",'FontSize',12)
%xlim([T(1,3)-5,T(1301,3)+5])
xlabel('x [cm]')
ylabel('y [cm]')
%ylim([-T(1301,4)-5,T(1301,4)+5])

figure(4) % Geometria dominio esterno

plot(T(1:1301,3),T(1:1301,4),'k-','LineWidth',1)
hold on
plot([xe,xA],[ye,yA],'k-','LineWidth',1)
plot([xB,xA],[yB,yA],'k-','LineWidth',1)
plot([xB,xC],[yB,yC],'m-','LineWidth',1)
plot([xC,xD],[yC,yD],'m-','LineWidth',1)
plot([xE,xD],[yE,yD],'r-','LineWidth',1)
plot([xF,xE],[yF,yE],'b-','LineWidth',1)
plot([xB,xA],[yB,yA],'k-','LineWidth',1)
plot([xF,P(1,1)],[yF,P(1,2)],'g-','LineWidth',1)
plot([T(1,3),T(1301,3)],[0,0],'b-','LineWidth',1)
axis equal
xlim([T(1,3)-15,xD+15])
ylim([-5,30])

title('\fontname{Times New Roman} Dominio computazionale, ugello VOLVOS1','FontSize',12)
xlabel('x [cm]')
ylabel('y [cm]')













