%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                          Magistral Theis:                               %               
%                       Mission Profile for eVTOL                         %
%                        Prof. Davide Ferretto                            %
%                     Candidate Nadia Oteri 295925                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Input Data

tot_weight = 3089;              % kg
coeff_drag = 0.05;              % drag coeficien
wing_surf = 2.2 * 12;           % m^2
v_cruise = 77.16;               % m/s
v_stall = 33.33;                % m/s

% Altitude and  range max
alt_max = 1000 * 0.3048;        % from ft to m
range_tot = 28.97 * 1000;       % from km to m

% Gradient initial climb and climb
gradient_initial_climb = 0.125;
gradient_climb = 0.12;

% Mission Phases
phases = {'Take off', 'Initial climb', 'Climb', 'Cruise', 'Descent', 'Loiter', 'Approach', 'Landing'};

% V Phases
v_phases = [v_stall, v_stall + 5, v_stall + 10, v_cruise, v_stall + 10, v_stall, v_stall + 5, v_stall];


time_phases = zeros(1, length(phases));
altitude_phases = zeros(1, length(phases));
range_phases = zeros(1, length(phases));

% Vertical TO
altitude_takeoff = 15 * 0.3048;              % 15 ft in m
time_phases(1) = 1 * 60;                     % 1 min in s
altitude_phases(1) = altitude_takeoff;
range_phases(1) = 0;

% Initial Climb
altitude_initial_climb = 500 * 0.3048;    % 500 ft in m
distance_initial_climb = (altitude_initial_climb - altitude_takeoff) / gradient_initial_climb;
time_phases(2) = distance_initial_climb / v_phases(2);
altitude_phases(2) = altitude_initial_climb;
range_phases(2) = distance_initial_climb;

% Climb
altitude_climb = alt_max - altitude_initial_climb;
distance_climb = altitude_climb / gradient_climb;
time_phases(3) = distance_climb / v_phases(3);
altitude_phases(3) = alt_max;
range_phases(3) = distance_climb;

range_cruise = range_tot - sum(range_phases) - (distance_initial_climb + distance_climb + range_phases(5) + range_phases(7));
time_phases(4) = range_cruise / v_cruise;
altitude_phases(4) = alt_max;
range_phases(4) = range_cruise;

% Descent
altitude_descent = alt_max - 500 * 0.3048;
distance_descent = altitude_descent / gradient_climb;
time_phases(5) = distance_descent / v_phases(5);
altitude_phases(5) = 500 * 0.3048;
range_phases(5) = distance_descent;

% Loiter
range_loiter = 0.2 * 1000;              % 200 m
time_phases(6) = 2 * 60;                 % 2 min into s
altitude_phases(6) = 500 * 0.3048;
range_phases(6) = range_loiter;

% Approach
altitude_approach = 15 * 0.3048;     
distance_approach = (500 * 0.3048 - altitude_approach) / gradient_climb;
time_phases(7) = distance_approach / v_phases(7);
altitude_phases(7) = altitude_approach;
range_phases(7) = distance_approach;

% Landing
time_phases(8) = 1 * 60;                
altitude_phases(8) = 0;
range_phases(8) = 0;

% Print Value
fprintf('Phases\t\t\tVelocity (m/s)\tDistance (m)\tTime (s)\n');
fprintf('-----------------------------------------------\n');
for i = 1:length(phases)
    fprintf('%s\t\t%.2f\t\t%.2f\t\t%.2f\n', phases{i}, v_phases(i), range_phases(i), time_phases(i));
end

% Profile altitude-time
figure;
plot(cumsum(time_phases) / 60, altitude_phases, '-o', 'LineWidth', 2); 
xlabel('Time (min)');
ylabel('Altitudine (m)');
title('Profile Altitudine-Time');
% text(sum(time_phases(1:1)) / 60 + 1, 15 * 0.3048 + 8, 'Take off', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(time_phases(1:2)) / 60 + 1, 150, 'Initial climb', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(time_phases(1:3)) / 60 - 1, 400, 'Climb', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text((sum(time_phases(1:3)) + sum(time_phases(1:4))) / 120, alt_max * 0.3048 + 450, 'Cruise', 'HorizontalAlignment', 'center', 'VerticalAlignment', 'middle');
% text(sum(time_phases(1:5)) / 60 - 1, 400, 'Descent', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(time_phases(1:6)) / 60 - 4, altitude_phases(6) + 20, 'Loiter', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(time_phases(1:7)) / 60 - 6, 90, 'Approach', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(time_phases(1:8)) / 60 - 6, 15 * 0.3048 + 8, 'Landing', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');

% Profile altitude-range
figure;
hold on;
plot(cumsum(range_phases) / 1000, altitude_phases, '-o', 'LineWidth', 2);

%range_cumulative = cumsum(range_fasi);
%range_cumulative_loiter = [range_cumulative(1:5), range_cumulative(5) + range_loiter/2, range_cumulative(5) + range_loiter];
%altitude_loiter = [altitudine_fasi(5), altitudine_fasi(5), altitudine_fasi(6), altitudine_fasi(6), altitudine_fasi(5)];
%hold on;
%plot(range_cumulative_loiter / 1000, altitude_loiter, '--', 'LineWidth', 2); 

xlabel('Range (km)');
ylabel('Altitude (m)');
title('Profile Altitudine-Range');
% text(sum(range_phases(1:1)) / 1000 + 2, 15 * 0.3048 + 8, 'Take off', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(range_phases(1:2)) / 1000 + 2, 150, 'Initial climb', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(range_phases(1:3)) / 1000 - 1, 400, 'Climb', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text((sum(range_phases(1:3)) + sum(range_phases(1:4))) / 2000, alt_max * 0.3048 + 450, 'Cruise', 'HorizontalAlignment', 'center', 'VerticalAlignment', 'middle');
% text(sum(range_phases(1:5)) / 1000 - 2, 400, 'Descent', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(range_phases(1:6)) / 1000 - 1, altitude_phases(6) + 20, 'Loiter', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(range_phases(1:7)) / 1000 - 18, 90, 'Approach', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
% text(sum(range_phases(1:8)) / 1000 - 15, 15 * 0.3048 + 8, 'Landing', 'HorizontalAlignment', 'left', 'VerticalAlignment', 'middle');
