%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                          Magistral Theis:                               %               
%              Operating cost estimation methodology for eVTOL            %
%                        Prof. Davide Ferretto                            %
%                     Candidate Nadia Oteri 295925                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear all
close all
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Data: 6 percentage values for each column
data = [25.63, 35.08, 12.90, 2.77, 0.54, 23.08; % Column 1 data
        24.83, 40.18, 9.92, 1.96, 0.54, 23.08;  % Column 2 data
        26.62, 26.18, 18.82, 4.76, 0.54, 23.08]; % Column 3 data

% Calculate the sum for each column
columnSums = sum(data, 2);

% Create a stacked bar chart to show contributions
figure;
barHandle = bar(data, 'stacked');

% Define custom shades of blue for each data group
blueShades = [0.7 0.9 1.0;  % Very light blue
              0.6 0.8 0.9;  % Light blue
              0.5 0.7 0.9;  % Medium light blue
              0.4 0.6 0.8;  % Medium blue
              0.3 0.5 0.7;  % Darker medium blue
              0.2 0.4 0.6]; % Dark blue

% Apply the blue shades to each bar group explicitly
for k = 1:length(barHandle)
    barHandle(k).FaceColor = 'flat';
    barHandle(k).CData(:,:) = repmat(blueShades(k, :), size(data, 1), 1);
end

% Add titles and labels
title('Summed Percentages with Costs Contributions');
xlabel('Mission Scenario');
ylabel('Sum of Percentages');
xticks(1:3); 
xticklabels({'Brussel-Liege', 'Ibiza-Palma', 'Heathrow-London'});
grid on;

% Add a legend for the data
legend({'DOCflt', 'DOCmaint', 'DOCdepr', 'DOClnr', 'DOCfin', 'IOC'}, ...
       'Location', 'bestoutside');