clear
clc

%% GESTIONE DATI
TIC = importdata('Geom_TIC.txt');  
x = TIC(:,1);    
y = TIC(:,2);    

%gestisco i dati in modo da avere anche
% numero linea
% numero punto
n_linea = ones(length(x),1);
n_punto = linspace(1,length(x),length(x));
z = zeros(length(x),1);

%scrivo file

fileID = fopen('TIC.dat','w');

for i = 1:length(x)
    fprintf(fileID,'%d %d %f %f %d\n',n_linea(i),n_punto(i),x(i),y(i),z(i));
end

fclose(fileID);

%% Aggiungo il contenuto del file "Dominio"

dominioID = fopen("Dominio.txt",'r');
fileID = fopen('TIC.dat','a');

% copio il contenuto del file dominio
while ~feof(dominioID)
    line = fgets(dominioID);
    fprintf(fileID, '%s', line);
end

fclose(dominioID);
fclose(fileID);

%% PLOT 

figure(1)
hold on
plot(x,y,'LineWidth',1)
plot([x(1) x(1)],[y(1) 0],'r')
plot(x(1),0,'r*')

plot([x(1) x(end)+40],[0 0],'r')
plot(x(end)+40,0,'bo')

plot([x(end)+40 x(end)+40],[0 40],'r')
plot(x(end)+40,40,'ro')

plot([x(end) x(end)-3],[y(end)+0.1 y(end)+0.1],'r')
plot(x(end)-3,y(end)+0.1,'go')

plot([x(end)-3 x(end)-3],[y(end)+0.1 40],'r')
plot(x(end)-3,40-0.1,'go')

plot([x(end) x(end)],[y(end)+0.1 y(end)],'r')

plot([x(end)-3 x(end)+40],[40 40],'r')

xlim([-10 60])
ylim([-5 60])
