%% POST PROCESSING
clear 
clc

%% P_WALL
data = importdata('p_wall_test.txt');
x_test = data(:,1);
y_test = data(:,2);

data1 = importdata("P_wall_1");
[x_data1,index] = sort(data1.data(:,1));
y_data1 = data1.data(:,2);
y_data1 = y_data1(index);
P_0 = 2.5e+06;  %[Pa]
R = 0.01;    %[cm]

data2 = importdata('P_wall_2');
[x_data2,index] = sort(data2.data(:,1));
y_data2 = data2.data(:,2);
y_data2 = y_data2(index);

data3 = importdata('P_wall_3');
[x_data3,index] = sort(data3.data(:,1));
y_data3 = data3.data(:,2);
y_data3 = y_data3(index);
P_wall_3 = [x_data3 y_data3];

data4 = importdata('P_wall_4');
[x_data4,index] = sort(data4.data(:,1));
y_data4 = data4.data(:,2);
y_data4 = y_data4(index);
P_wall_4 = [x_data4 y_data4];




figure(1)
hold on
plot(x_test,y_test,'s','MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor','[0.6 0.6 0.6]')
plot(x_data1(80:end)/R,y_data1(80:end)./P_0,'-','MarkerSize',3,'MarkerEdgeColor','r','MarkerFaceColor','r','Linewidth',1.5,'Color','g');
plot(x_data2(70:end)/R,y_data2(70:end)./P_0,'-','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','b','Linewidth',1.5,'Color','r');
plot(x_data3(80:end)/R,y_data3(80:end)./P_0,'-','MarkerSize',3,'MarkerEdgeColor','m','MarkerFaceColor','m','Linewidth',1.5,'Color','[0.3010 0.7450 0.9330]');
plot(x_data4(20:end)/R,y_data4(20:end)./P_0,'-','MarkerSize',3,'MarkerEdgeColor','g','MarkerFaceColor','g','Linewidth',1.5,'Color','b');



grid on
grid minor
title('$\textbf{Andamento a parete TIC}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{\frac{P_{wall}}{P_0}}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{Experimental data}$','$\textbf{Mesh 1, 59600 celle}$','$\textbf{Mesh 2, 35800 celle}$','$\textbf{Mesh 3, 86400 celle}$','$\textbf{Mesh 4, 68800 celle}$','Interpreter','latex','Location','northwest','FontSize',10)
xlim([2,8.75])
ylim([0,0.06])
