%% POST PROCESSING

clear 
clc 


%% DATI DA GRAFICO

data_45_7 = importdata("Data_45_7.txt");
data_50_5 = importdata('Data_50_5.txt');
data_47_4 = importdata('Data_47_4.txt');
%% DATI DA SIMULAZIONE

% il grafico precedente tiene conto dei valori di P_wall/P_0 in X/R_th per
% bassi e alti NPR. 
% prove eseguite per ora NPR:

% importo file txt dei test data



% importo dati analisi
R = 0.01;    %[cm]
P_a = 101325;

%%
% NPR = 30;
data1 = importdata("P_wall_70");
[x_data1,index] = sort(data1.data(:,1));
y_data1 = data1.data(:,2);
y_data1 = y_data1(index);


% NPR = 35 ;
data2 = importdata("P_wall_68_down");
[x_data2,index] = sort(data2.data(:,1));
y_data2 = data2.data(:,2);
y_data2 = y_data2(index);

% NPR = 40;
data3 = importdata("P_wall_66_down");
[x_data3,index] = sort(data3.data(:,1));
y_data3 = data3.data(:,2);
y_data3 = y_data3(index);

% NPR = 45.7
data4 = importdata("P_wall_64_down");
[x_data4,index] = sort(data4.data(:,1));
y_data4 = data4.data(:,2);
y_data4 = y_data4(index);

% NPR = 47.4
data5 = importdata("P_wall_62_down");
[x_data5,index] = sort(data5.data(:,1));
y_data5 = data5.data(:,2);
y_data5 = y_data5(index);

% NPR = 50.5
%data6 = importdata("P_wall_62");
%[x_data6,index] = sort(data6.data(:,1));
%y_data6 = data6.data(:,2);
%y_data6 = y_data6(index);



%% NORMALIZZATI SU P_0


P_30 = 3039750;
P_35 = 3546375;
P_40 = 4053000;
P_42 = 4255650;
P_44 = 4458300;
P_45_7 = 4630552.5;
P_46 = 4660950;
P_47_4 = 4802805;
P_48 = 4863600;
P_50 = 5066250;
P_50_5 = 5116912.5;
P_52 = 5268900;
P_54 = 5471550;
P_56 = 5674200;
P_58 = 5876850;
P_60 = 6079500;
P_62 = 6282150;
P_64 = 6484800;
P_66 = 6687450;
P_68 = 6890100;
P_70 = 7092750;


P = [P_30 P_35 P_40 P_45_7 P_47_4 P_50_5];

frac = P_a ./ P;

%%
figure(1)
hold on
plot(x_data1(3:end)./R,y_data1(3:end)./P_70,'-','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','b','Linewidth',1,'Color','b');
plot(x_data2(3:end)./R,y_data2(3:end)./P_68,'-','MarkerSize',3,'MarkerEdgeColor','m','MarkerFaceColor','m','Linewidth',1,'Color','m');
plot(x_data3(3:end)./R,y_data3(3:end)./P_66,'-','MarkerSize',3,'MarkerEdgeColor','c','MarkerFaceColor','c','Linewidth',1,'Color','[0.4940 0.1840 0.5560]');
plot(x_data4(3:end)./R,y_data4(3:end)./P_64,'-','MarkerSize',3,'MarkerEdgeColor','r','MarkerFaceColor','r','Linewidth',1,'Color','r');
plot(x_data5(3:end)./R,y_data5(3:end)./P_62,'-','MarkerSize',3,'MarkerEdgeColor','g','MarkerFaceColor','g','Linewidth',1,'Color','g');
%plot(x_data6(3:end)./R,y_data6(3:end)./P_62,'-','MarkerSize',3,'MarkerEdgeColor','y','MarkerFaceColor','y','Linewidth',1,'Color','[0.6350 0.0780 0.1840]');

%plot(x_data1(3:end)./R,y_data1(3:end)./P_30,'b-','Linewidth',1);
%plot(x_data2(3:end)./R,y_data2(3:end)./P_35,'m-','Linewidth',1);
%plot(x_data3(3:end)./R,y_data3(3:end)./P_40,'c-','Linewidth',1);
%plot(x_data4(3:end)./R,y_data4(3:end)./P_45_7,'r-','Linewidth',1);
%plot(x_data5(3:end)./R,y_data5(3:end)./P_47_4,'g-','Linewidth',1);
%plot(x_data6(3:end)./R,y_data6(3:end)./P_50_5,'y-','Linewidth',1);
plot([6.2 6.2],[0 1.5],'k--','LineWidth',0.5)
grid on
grid minor
title('$\textbf{Andamento a parete SST}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{\frac{P_{wall}}{P_0}}$','Interpreter','latex','Rotation',0,'FontSize',12)
%legend ('$\textbf{NPR = 62}$','$\textbf{NPR = 64}$','$\textbf{NPR = 66}$','$\textbf{NPR = 68}$','$\textbf{NPR = 70}$','$\textbf{NPR = 62}$','$\textbf{Inflection}$','Interpreter','latex','Location','northwest','FontSize',10)
legend ('$\textbf{NPR = 70}$','$\textbf{NPR = 68}$','$\textbf{NPR = 66}$','$\textbf{NPR = 64}$','$\textbf{NPR = 62}$','$\textbf{Inflection}$','Interpreter','latex','Location','northwest','FontSize',10)
xlim([3.11 14.3])
ylim([0 0.06])



%% CONFRONTO CON DATI SPERIMENTALI

% Mesh 73400 celle;
data1 = importdata("P_wall_45_7");
[x_data1,index] = sort(data1.data(:,1));
y_data1 = data1.data(:,2);
y_data1 = y_data1(index);


% Mesh 73400 celle;
data2 = importdata("P_wall_47_4");
[x_data2,index] = sort(data2.data(:,1));
y_data2 = data2.data(:,2);
y_data2 = y_data2(index);

% Mesh 73400 celle;
data3 = importdata("P_wall_50_5");
[x_data3,index] = sort(data3.data(:,1));
y_data3 = data3.data(:,2);
y_data3 = y_data3(index);

% Mesh M2 59680 celle;
data4 = importdata("P_wall_45_7_M2");
[x_data4,index] = sort(data4.data(:,1));
y_data4 = data4.data(:,2);
y_data4 = y_data4(index);

%  Mesh M2 59680 celle;
data5 = importdata("P_wall_47_4_M2");
[x_data5,index] = sort(data5.data(:,1));
y_data5 = data5.data(:,2);
y_data5 = y_data5(index);

%  Mesh M2 59680 celle;
%data6 = importdata("P_wall_50_5_M2");
%[x_data6,index] = sort(data6.data(:,1));
%y_data6 = data6.data(:,2);
%y_data6 = y_data6(index);

figure(2)
hold on
plot(data_45_7(:,1),data_45_7(:,2).*frac(4),'^','MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[1 0.5 0]);
plot(data_47_4(:,1),data_47_4(:,2).*frac(5),'s','MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[1 1 0]);
plot(data_50_5(:,1),data_50_5(:,2).*frac(6),'d','MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[0.6 0.6 0.6]);
%plot(x_data1(16:end)./R,y_data1(16:end)./P_45_7,'-^','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','b','Linewidth',0.5,'Color','b');
plot(x_data1(16:end)./R,y_data1(16:end)./P_45_7,'b','Linewidth',1);
plot(x_data2(16:end)./R,y_data2(16:end)./P_47_4,'b--','Linewidth',1);
plot(x_data3(16:end)./R,y_data3(16:end)./P_50_5,'b-.','Linewidth',1);
%plot(x_data4(16:end)./R,y_data4(16:end)./P_45_7,'r','Linewidth',1);
%plot(x_data5(16:end)./R,y_data5(16:end)./P_47_4,'r--','Linewidth',1);
%plot(x_data4(16:end)./R,y_data4(16:end)./P_45_7,'-x','MarkerSize',3,'MarkerEdgeColor','g','MarkerFaceColor','m','Linewidth',0.5,'Color','m');
plot([6.2 6.2],[0 1.5],'k--','LineWidth',0.5)



grid on
grid minor
title('$\textbf{Andamento a parete}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{\frac{P_{wall}}{P_0}}$','Interpreter','latex','Rotation',0,'FontSize',12)
%legend ('$\textbf{NPR = 52}$','$\textbf{NPR = 54}$','$\textbf{NPR = 56}$','$\textbf{NPR = 58}$','$\textbf{NPR = 60}$','$\textbf{NPR = 62}$','$\textbf{Inflection}$','Interpreter','latex','Location','northwest','FontSize',10)
%legend ('$\textbf{Experimental NPR = 45.7}$','$\textbf{Experimental NPR = 47.4}$','$\textbf{Experimental NPR = 50.5}$','$\textbf{NPR = 45.7 73400 celle}$','$\textbf{NPR = 47.4 73400 celle}$','$\textbf{NPR = 50.5 73400 celle}$','$\textbf{NPR = 45.7 59680 celle}$','$\textbf{NPR = 47.4 59680 celle}$','$\textbf{Inflection}$','Interpreter','latex','Location','northwest','FontSize',10)
legend ('$\textbf{Experimental NPR = 45.7}$','$\textbf{Experimental NPR = 47.4}$','$\textbf{Experimental NPR = 50.5}$','$\textbf{NPR = 45.7 - 73400 celle}$','$\textbf{NPR = 47.4 - 73400 celle}$','$\textbf{NPR = 50.5 - 73400 celle}$','$\textbf{Inflection}$','Interpreter','latex','Location','northwest','FontSize',10)
xlim([3.11 14.5])
ylim([0 0.06])

%%
clc 
clear

%% CONFRONTO 

R = 0.01;    %[cm]
P_30 = 3039750;
P_35 = 3546375;
P_40 = 4053000;
P_42 = 4255650;
P_44 = 4458300;
P_45_7 = 4630552.5;
P_46 = 4660950;
P_47_4 = 4802805;
P_48 = 4863600;
P_50 = 5066250;
P_50_5 = 5116912.5;
P_52 = 5268900;
P_54 = 5471550;
P_56 = 5674200;
P_58 = 5876850;
P_60 = 6079500;
P_62 = 6282150;
P_64 = 6484800;
P_66 = 6687450;
P_68 = 6890100;
P_70 = 7092750;
P_70_5 = 7143412.5;
P_71 = 7194075;
P_71_5 = 7244737.5;
P_72 = 7295400;
P_72_5 = 7346062.5;
P_73 = 7396725;
P_74 = 7498050;
P_76 = 7700700;

data2_2 = importdata("P_wall_64_M2");
[x_data2_2,index] = sort(data2_2.data(:,1));
y_data2_2 = data2_2.data(:,2);
y_data2_2 = y_data2_2(index);

data2_3 = importdata("P_wall_64_M2_down");
[x_data2_3,index] = sort(data2_3.data(:,1));
y_data2_3 = data2_3.data(:,2);
y_data2_3 = y_data2_3(index);

data2_4 = importdata("P_wall_64_M2_down_1");
[x_data2_4,index] = sort(data2_4.data(:,1));
y_data2_4 = data2_4.data(:,2);
y_data2_4 = y_data2_4(index);


data2_5 = importdata("P_wall_64_M2_down_2");
[x_data2_5,index] = sort(data2_5.data(:,1));
y_data2_5 = data2_5.data(:,2);
y_data2_5 = y_data2_5(index);



figure(2)
hold on
%plot(x_data2(16:end)./R,y_data2(16:end)./P_a,'-s','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','b','Linewidth',0.5,'Color','b');
plot(x_data2_2(20:end)./R,y_data2_2(20:end)./P_64,'-','MarkerSize',3,'MarkerEdgeColor','r','MarkerFaceColor','r','Linewidth',1,'Color','r');
plot(x_data2_3(20:end)./R,y_data2_3(20:end)./P_64,'-','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','b','Linewidth',1,'Color','b');
plot(x_data2_4(20:end)./R,y_data2_4(20:end)./P_64,'-','MarkerSize',3,'MarkerEdgeColor','g','MarkerFaceColor','g','Linewidth',1,'Color','g');
plot(x_data2_5(20:end)./R,y_data2_5(20:end)./P_64,'-','MarkerSize',3,'MarkerEdgeColor','k','MarkerFaceColor','k','Linewidth',0.5,'Color','k');

plot([6.2 6.2],[0 1.5],'k--','LineWidth',0.5)

grid on
grid minor
title('$\textbf{Andamento a parete SA}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{\frac{P_{wall}}{P_0}}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{1 tentativo}$','$\textbf{2 tentativo}$','$\textbf{3 tentativo}$','$\textbf{4 tentativo}$','Interpreter','latex','Location','northwest','FontSize',10)
%legend ('$\textbf{NPR = 48}$','$\textbf{NPR = 50}$','$\textbf{NPR = 52}$','$\textbf{NPR = 54}$','$\textbf{Inflection}$','Interpreter','latex','Location','northwest','FontSize',10)
xlim([3.11 15])
ylim([0 0.06])

%%
clear 
clc
%% GRAFICI ISTERESI S-A


NPR_SA = [50 52 54 56 58 60];
x_sep_SA_up = [6.88561 8.05925 10.2606 11.5712 12.3869 12.959];
x_sep_SA_down = [6.88561 8.12276 10.4877 11.7123 12.466 12.959];


figure(3)
hold on
plot(x_sep_SA_up,NPR_SA,'ro-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','r')
plot(x_sep_SA_down,NPR_SA,'bs-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','b')
plot(x_sep_SA_up(4),NPR_SA(4),'s','MarkerSize',10,'MarkerEdgeColor','r','MarkerFaceColor','none')
plot(x_sep_SA_down(3),NPR_SA(3),'d','MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor','none')
grid on
grid minor
title('$\textbf{Ciclo di isteresi con modello $\mathbf{S-A}$}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{NPR}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{up ramping}$','$\textbf{down ramping}$','$\mathbf{NPR_{tr} = 56}$','$\mathbf{NPR_{ritr} = 54}$','Interpreter','latex','Location','northwest','FontSize',10)
xticks(6:0.2:14)
ylim([min(NPR_SA)-0.5, max(NPR_SA)+0.5])
xlim([min([x_sep_SA_up x_sep_SA_down])-0.2, max([x_sep_SA_up x_sep_SA_down])+0.15])


%%
clear 
clc
%% GRAFICO ISTERESI SST

NPR_SST = [62 64 66 68 70];
x_sep_SST_up = [6.39553 6.58125 6.92324 12.2313 12.7911];
x_sep_SST_down = [6.39553 6.59667 11.2314 12.3087 12.7911];


figure(4)
hold on
plot(x_sep_SST_up,NPR_SST,'ro-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','r')
plot(x_sep_SST_down,NPR_SST,'bs-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','b')
plot(x_sep_SST_up(4),NPR_SST(4),'s','MarkerSize',10,'MarkerEdgeColor','r','MarkerFaceColor','none')
plot(x_sep_SST_down(3),NPR_SST(3),'d','MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor','none')
grid on
grid minor
title('$\textbf{Ciclo di isteresi con modello SST $\mathbf{k-\omega}$}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{NPR}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{up ramping}$','$\textbf{down ramping}$','$\mathbf{NPR_{tr} = 68}$','$\mathbf{NPR_{ritr} = 66}$','Interpreter','latex','Location','northwest','FontSize',10)
xticks(6:0.2:14)
ylim([min(NPR_SST)-0.5, max(NPR_SST)+0.5])
xlim([min([x_sep_SST_up x_sep_SST_down])-0.2, max([x_sep_SST_up x_sep_SST_down])+0.15])



%% 
clear 
clc
%% GRAFICO ISTERESI KE 

% 72-71.5-71-70.5-70-68-66


NPR_KE = [66 68 70 71 72 73];
x_sep_KE_up = [6.44993 6.53608 6.70922 6.86709 13.5759 13.6679];
x_sep_KE_down = [6.44993 13.0443 13.4849 13.5759 13.6219 13.6679];

figure(5)
hold on
plot(x_sep_KE_up,NPR_KE,'ro-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','r')
plot(x_sep_KE_down,NPR_KE,'bs-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','b')
plot(x_sep_KE_up(5),NPR_KE(5),'s','MarkerSize',10,'MarkerEdgeColor','r','MarkerFaceColor','none')
plot(x_sep_KE_down(2),NPR_KE(2),'d','MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor','none')
grid on
grid minor
title('$\textbf{Ciclo di isteresi con modello $\mathbf{k-\epsilon}$}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{NPR}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{up ramping}$','$\textbf{down ramping}$','$\mathbf{NPR_{tr} = 72}$','$\mathbf{NPR_{ritr} = 68}$','Interpreter','latex','Location','northwest','FontSize',10)
xticks(6:0.2:14)
ylim([min(NPR_KE)-0.5, max(NPR_KE)+0.5])
xlim([min([x_sep_KE_up x_sep_KE_down])-0.2, max([x_sep_KE_up x_sep_KE_down])+0.15])

%%
clear 
clc
%% Percentuali isteresi

NPR_tr_SA = 56;
NPR_ritr_SA = 54;
ister_SA= (NPR_tr_SA - NPR_ritr_SA)/NPR_tr_SA;
Range_SA = NPR_tr_SA - NPR_ritr_SA;

NPR_tr_SST = 68;
NPR_ritr_SST = 66;
ister_SST= (NPR_tr_SST - NPR_ritr_SST)/NPR_tr_SST;
Range_SST = NPR_tr_SST - NPR_ritr_SST;

NPR_tr_KE = 72;
NPR_ritr_KE = 68;
ister_KE= (NPR_tr_KE - NPR_ritr_KE)/NPR_tr_KE;
Range_KE = NPR_tr_KE - NPR_ritr_KE;
%%
clear 
clc

%% Plot con profilo

DB = importdata('db_geometry'); 
R = 0.01;
x_prof = DB(:,1);    
y_prof = DB(:,2); 

P_30 = 3039750;
P_35 = 3546375;
P_40 = 4053000;
P_42 = 4255650;
P_44 = 4458300;
P_45_7 = 4630552.5;
P_46 = 4660950;
P_47_4 = 4802805;
P_48 = 4863600;
P_50 = 5066250;
P_50_5 = 5116912.5;
P_52 = 5268900;
P_54 = 5471550;
P_56 = 5674200;
P_58 = 5876850;
P_60 = 6079500;
P_62 = 6282150;
P_64 = 6484800;
P_66 = 6687450;
P_68 = 6890100;
P_70 = 7092750;
P_70_5 = 7143412.5;
P_71 = 7194075;
P_71_5 = 7244737.5;
P_72 = 7295400;
P_72_5 = 7346062.5;
P_73 = 7396725;
P_74 = 7498050;
P_76 = 7700700;


%%

% prova 1
data1 = importdata("P_wall_52");
[x_data1,index] = sort(data1.data(:,1));
y_data1 = data1.data(:,2);
y_data1 = y_data1(index);


% prova 2
data2 = importdata("P_wall_54");
[x_data2,index] = sort(data2.data(:,1));
y_data2 = data2.data(:,2);
y_data2 = y_data2(index);

% prova 3
data3 = importdata("P_wall_56");
[x_data3,index] = sort(data3.data(:,1));
y_data3 = data3.data(:,2);
y_data3 = y_data3(index);

% prova 4
data4 = importdata("P_wall_58");
[x_data4,index] = sort(data4.data(:,1));
y_data4 = data4.data(:,2);
y_data4 = y_data4(index);

%  prova 5
data5 = importdata("P_wall_60");
[x_data5,index] = sort(data5.data(:,1));
y_data5 = data5.data(:,2);
y_data5 = y_data5(index);

%  prova 6
data6 = importdata("P_wall_62");
[x_data6,index] = sort(data6.data(:,1));
y_data6 = data6.data(:,2);
y_data6 = y_data6(index);


figure(6)
hold on
grid on
grid minor
yyaxis left
plot(x_data1(3:end)./R,y_data1(3:end)./P_52,'-','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','b','Linewidth',1,'Color','b');
plot(x_data2(3:end)./R,y_data2(3:end)./P_54,'-','MarkerSize',3,'MarkerEdgeColor','m','MarkerFaceColor','m','Linewidth',1,'Color','m');
plot(x_data3(3:end)./R,y_data3(3:end)./P_56,'-','MarkerSize',3,'MarkerEdgeColor','c','MarkerFaceColor','c','Linewidth',1,'Color','[0.4940 0.1840 0.5560]');
plot(x_data4(3:end)./R,y_data4(3:end)./P_58,'-','MarkerSize',3,'MarkerEdgeColor','r','MarkerFaceColor','r','Linewidth',1,'Color','r');
plot(x_data5(3:end)./R,y_data5(3:end)./P_60,'-','MarkerSize',3,'MarkerEdgeColor','g','MarkerFaceColor','g','Linewidth',1,'Color','g');
plot(x_data6(3:end)./R,y_data6(3:end)./P_62,'-','MarkerSize',3,'MarkerEdgeColor','y','MarkerFaceColor','y','Linewidth',1,'Color','[0.6350 0.0780 0.1840]');
plot([6.2 6.2],[0 1.5],'k--','LineWidth',0.5)
%title('$\textbf{Andamento a parete SST $\mathbf{k-\omega}$}$','Interpreter','latex','FontSize',15)
title('$\textbf{Andamento a parete - Mesh 59680 celle}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{\frac{P_{wall}}{P_0}}$','Interpreter','latex','Rotation',0,'FontSize',12)

ylim([0 0.06])

yyaxis right
plot(x_prof/R,y_prof,'k-','Linewidth',2)
%legend ('$\textbf{NPR = 62}$','$\textbf{NPR = 64}$','$\textbf{NPR = 66}$', ...
    %'$\textbf{NPR = 68}$','$\textbf{NPR = 70}$','$\textbf{NPR = 62}$','$\textbf{Inflection}$','$\textbf{Profilo}$','Interpreter','latex','Location','northwest','FontSize',10)
legend ('$\textbf{NPR = 70}$','$\textbf{NPR = 68}$','$\textbf{NPR = 66}$','$\textbf{NPR = 64}$','$\textbf{NPR = 62}$','$\textbf{Inflection}$','$\textbf{Profilo}$','Interpreter','latex','Location','northwest','FontSize',10)
%legend ('$\textbf{NPR = 70}$','$\textbf{NPR = 68}$','$\textbf{NPR = 66}$','$\textbf{NPR = 64}$','$\textbf{Inflection}$','$\textbf{Profilo}$','Interpreter','latex','Location','northwest','FontSize',10)
ylabel('$\mathbf{Y/R^*}$','Interpreter','latex','Rotation',0,'FontSize',12)

xlim([3.5 14.5])
ylim([0 0.06])


%% Confronto

data1 = importdata("P_wall_40");
[x_data1,index] = sort(data1.data(:,1));
y_data1 = data1.data(:,2);
y_data1 = y_data1(index);



% prova 2
data2 = importdata("P_wall_45_7");
[x_data2,index] = sort(data2.data(:,1));
y_data2 = data2.data(:,2);
y_data2 = y_data2(index);

figure(6)
hold on
grid on
grid minor
yyaxis left
plot(x_data1(3:end)./R,y_data1(3:end)./P_40,'-','MarkerSize',3,'MarkerEdgeColor','b','MarkerFaceColor','r','Linewidth',1,'Color','r');
plot(x_data2(3:end)./R,y_data2(3:end)./P_45_7,'-','MarkerSize',3,'MarkerEdgeColor','r','MarkerFaceColor','b','Linewidth',1,'Color','b');

plot([6.2 6.2],[0 1.5],'k--','LineWidth',0.5)
title('$\textbf{Confronto a NPR = 66}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{\frac{P_{wall}}{P_0}}$','Interpreter','latex','Rotation',0,'FontSize',12)

ylim([0 0.06])

yyaxis right
plot(x_prof/R,y_prof,'k-','Linewidth',2)
legend ('$\textbf{up - ramping}$','$\textbf{down - ramping}$','$\textbf{Inflection}$','$\textbf{Profilo}$','Interpreter','latex','Location','northwest','FontSize',10)

ylabel('$\mathbf{Y/R^*}$','Interpreter','latex','Rotation',0,'FontSize',12)

xlim([3.5 14.5])
ylim([0 0.06])

%%
clear 
clc
%% GRAFICO ISTERESI SST MESH NUOVA

NPR_SST = [62 64 66 68 70];
x_sep_SST2_up = [6.33372 6.53926 7.01486 12.2684 12.7692];
x_sep_SST2_down = [6.33372 6.53926 11.1148 12.2684 12.7692];


figure(7)
hold on
plot(x_sep_SST2_up,NPR_SST,'ro-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','r')
plot(x_sep_SST2_down,NPR_SST,'bs-','LineWidth',0.5,'MarkerSize',5,'MarkerFaceColor','b')
plot(x_sep_SST2_up(4),NPR_SST(4),'s','MarkerSize',10,'MarkerEdgeColor','r','MarkerFaceColor','none')
plot(x_sep_SST2_down(3),NPR_SST(3),'d','MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor','none')
grid on
grid minor
title('$\textbf{Ciclo di isteresi - Mesh 59680 celle} $','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{NPR}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{up ramping}$','$\textbf{down ramping}$','$\mathbf{NPR_{tr} = 68}$','$\mathbf{NPR_{ritr} = 66}$','Interpreter','latex','Location','northwest','FontSize',10)
xticks(6:0.2:14)
ylim([min(NPR_SST)-0.5, max(NPR_SST)+0.5])
xlim([min([x_sep_SST2_up x_sep_SST2_down])-0.2, max([x_sep_SST2_up x_sep_SST2_down])+0.15])





%%
clc
clear
%% CONFRONTO CICLI DI ISTERESI


NPR_SST = [62 64 66 68 70 68 66 64 62];

% mesh 1
x_sep_SST = [6.39553 6.58125 6.92324 12.2313 12.7911 12.3087 11.2314 6.59667 6.39553];


% mesh 2
x_sep_SST2 = [6.33372 6.53926 7.01486 12.2684 12.7692 12.2684 11.1148 6.53926 6.33372];

%
x_sep_SST2_up = [6.33372 6.53926 7.01486 12.2684 12.7692];
x_sep_SST2_down = [6.33372 6.53926 11.1148 12.2684 12.7692];

figure(8)
hold on
plot(x_sep_SST,NPR_SST,'ro-','LineWidth',0.8,'MarkerSize',2.5,'MarkerFaceColor','r')
plot(x_sep_SST2,NPR_SST,'bo-','LineWidth',0.8,'MarkerSize',2.5,'MarkerFaceColor','b')
grid on
grid minor
title('$\textbf{Ciclo di isteresi confronto tra le due mesh} $','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{X/R^*}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{NPR}$','Interpreter','latex','Rotation',0,'FontSize',12)
legend ('$\textbf{Mesh 73400 celle}$','$\textbf{Mesh 59680 celle}$','Interpreter','latex','Location','northwest','FontSize',10)
xticks(6:0.2:14)
ylim([min(NPR_SST)-0.5, max(NPR_SST)+0.5])
xlim([min([x_sep_SST2_up x_sep_SST2_down])-0.2, max([x_sep_SST2_up x_sep_SST2_down])+0.15])




%% FUNZIONE PORTATA CORRETTA

gamma = 1.4;
M = linspace(0,5,100);
a = gamma+1;
b = 2*(gamma-1);
c = gamma-1;
F_m = sqrt(gamma).*M.*(1./(1+0.5*c.*M.^2)).^(a/b);

figure(9)
plot(M,F_m,'b-','Linewidth',1)
grid on
grid minor
title('$\textbf{Funzione portata corretta $\mathbf{f(M_i)}$}$','Interpreter','latex','FontSize',15)
xlabel('$\mathbf{M_i}$','Interpreter','latex','FontSize',10)
ylabel('$\mathbf{f(M_i)}$','Interpreter','latex','Rotation',0,'FontSize',12)
ylim([0 0.8])