import os
from PreProcessing import Normalization, Primo_Terzo_Alignment, Patches
from ErrorCorrection import Secondo_alignment, Correzione_Errori, Cleaning
from natsort import natsorted
from Segmentation import segmentazione
from FileTiff import FileTif


current_dir = os.getcwd()
image_dir = os.path.join(current_dir, 'images') #Dataset originale
Preprocc_dir = os.path.join(current_dir, 'Pre-Procc') # cartella di uscita per le immagini normalizzate

#Normalizzazione immagine
Normalization(image_dir,Preprocc_dir)

#Primo alignment sulle immagini intere normalizzate
primo_alignment_dir = os.path.join(current_dir, 'All 1')
pivot_image_name = f"VID1495_A1_1_01d00h00m.tif"
Primo_Terzo_Alignment(Preprocc_dir,primo_alignment_dir,pivot_image_name,save_interval = 10)

#Divisione in patch
patch_dim_ver = 1300 #1300
patch_dim_hor = 950 #950
Patch_dir = os.path.join(current_dir, 'Patch')
Patches(primo_alignment_dir, patch_dim_ver, patch_dim_hor, Patch_dir)

#Eliminare le immagini outlier
GS_path = os.path.join(current_dir, 'gold_standard.xlsx')
for n in range(4,12):
    folders = [os.path.join(Patch_dir, f'{n}/{n}_{i}') for i in range(3, 12)]
    clean = Cleaning(folders, GS_path)

#Secondo alignment sui singoli patch per l'identificazione di errori
for i in range(4,12): #Bisogna elaborare una riga e colonna in più rispetto a quelle finali
    for n in range(3,10):  
        dataset_dir = os.path.join(Patch_dir, f'{i}/{i}_{n}')
        all2_dir = os.path.join(Patch_dir, f'ALL2/{i}/{i}_{n}')  # Cartella dove salvare le immagini allineate
        # Creare la cartella se non esiste
        if not os.path.isdir(all2_dir):
            os.makedirs(all2_dir)
        pivot_image_name = f"VID1495_A1_1_01d00h00m_{i}_{n}.tif"
        # Generare le patch per la cartella corrente
        Secondo_alignment(dataset_dir, all2_dir,pivot_image_name, cambio_riferimento=11)
        print(f'Patch per {i}_{n} completate')


# Correzione degli errori

for n in range(4,11):
    folders = [os.path.join(Patch_dir, f'{n}/{n}_{i}') for i in range(3,10)]
    folders_all = [os.path.join(Patch_dir, f'ALL2/{n}/{n}_{i}') for i in range(3,10)]
    folders_ver = [os.path.join(Patch_dir, f'{n+1}/{n+1}_{i}') for i in range(3, 10)]
    folders_ver_all = [os.path.join(Patch_dir, f'ALL2/{n+1}/{n+1}_{i}') for i in range(3, 10)]
    excel_output_path = os.path.join(Patch_dir, f'correzione_automatica_{n}.xlsx')
    modified_images_found = Correzione_Errori(folders, GS_path,excel_output_path,folders_ver,folders_all,folders_ver_all)

#Terzo Alignment
for n in range(4,11):
    for i in range(3,9): 
        folders = os.path.join(Patch_dir, f'{n}/{n}_{i}')
        folders_all3 = os.path.join(Patch_dir, f'ALL3/{n}/{n}_{i}')
        
        pivot_image_name = f"VID1495_A1_1_01d00h00m_{n}_{i}.tif"
        # Generare le patch per la cartella corrente
        Primo_Terzo_Alignment(folders,folders_all3,pivot_image_name,save_interval = 10)
        print(f'Patch per {n}_{i} completate')

#Segmentazione
for i in range(4,11):
    for n in range(3,9):     
        dataset_dir = os.path.join(Patch_dir, f'ALL3/{i}/{i}_{n}')
        output_image_dir = os.path.join(Patch_dir, f'Voronoi/{i}/{i}_{n}')
        os.makedirs(output_image_dir, exist_ok=True)
        list_images = natsorted([f for f in os.listdir(dataset_dir) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])
        output_feature= os.path.join(Patch_dir, f'Voronoi/{i}')
        segmentazione(list_images,output_image_dir,dataset_dir,i,n,output_feature,Feature=True)
        #Per non calcolare le feature impostare Feature = False


#Creare File TIF multiframe
step = 1  #cambiare il valore per cambiare la frequenza di acquisizone
for i in range(4, 11):
    for n in range(3, 9):  
        dataset_dir = os.path.join(Patch_dir, f'Voronoi/{i}/{i}_{n}')
        pivot_image_name = f"VID1495_A1_1_00d23h50m_{i}_{n}.tif"

        output_image_dir_1 = os.path.join(current_dir, f'Gruppi {step}/G1/{i}_{n}')
        output_image_dir_2 = os.path.join(current_dir, f'Gruppi {step}/G2/{i}_{n}')
        os.makedirs(output_image_dir_1, exist_ok=True)
        os.makedirs(output_image_dir_2, exist_ok=True)
        FileTif(dataset_dir,pivot_image_name,output_image_dir_1,output_image_dir_2,i,n,step)

#Fare il tracking con TrackMate e salvare il file .csv. Usare poi i codici 'Feature_Tracking.py' 
# e 'Statistica.py' per calcolare le feature e confrontare i gruppi