import pandas as pd
from scipy.stats import ttest_ind
import os
import seaborn as sns
import matplotlib.pyplot as plt
import scipy.stats as stats


# Percorsi dei due file Excel da confrontare
file1_path = os.path.join(os.getcwd(), 'Gruppi', 'G1', 'Statistica.xlsx')
file2_path = os.path.join(os.getcwd(), 'Gruppi', 'G2', 'Statistica.xlsx')
image_folder = os.path.join(os.getcwd(), 'Gruppi')
# Carica i dati
df1 = pd.read_excel(file1_path, sheet_name="Statistiche")
df2 = pd.read_excel(file2_path, sheet_name="Statistiche")
frame_intervals = {"G1": 10, "Gruppi 2": 20, "Gruppi 4": 40, "Gruppi 6":60, "Gruppi 9": 90}
# Nome della colonna della velocità (modifica se necessario)
speed_column = "Mean Track mean speed"

# Verifica se la colonna esiste in entrambi i file
if speed_column not in df1.columns or speed_column not in df2.columns:
    raise ValueError(f"La colonna '{speed_column}' non è presente in uno dei file!")

# Seleziona solo la velocità
speed1 = (df1[speed_column].dropna())/ frame_intervals["G1"]
speed2 = (df2[speed_column].dropna())/ frame_intervals["G1"]
# Test di Shapiro-Wilk
stat, p_value = stats.shapiro(speed1)

print(f"Statistic: {stat}, p-value: {p_value}")

if p_value < 0.05:
    print("I dati non seguono una distribuzione normale.")
else:
    print("I dati seguono una distribuzione normale.")

stat, p_value = stats.shapiro(speed2)

print(f"Statistic: {stat}, p-value: {p_value}")

# Se il p-value è inferiore a 0.05, i dati non sono normali
if p_value < 0.05:
    print("I dati non seguono una distribuzione normale.")
else:
    print("I dati seguono una distribuzione normale.")

# Esegui il t-test
stat, p_value = ttest_ind(speed1, speed2, nan_policy='omit')

# Stampa il risultato
print(f"T-test per la velocità media tra G1 e G2:")
print(f"Statistiche t: {stat:.5f}, P-value: {p_value:.20f}")

# Valutazione della significatività
if p_value < 0.001:
    significance = "(p < 0.001)"
elif p_value < 0.01:
    significance = "(p < 0.01)"
elif p_value < 0.05:
    significance = "(p < 0.05)"
else:
    significance = "non significativo"

print(f"Risultato: {significance}")

# Creiamo un DataFrame lungo per il confronto visivo
df_long = pd.DataFrame({
    "Velocità": list(speed1) + list(speed2),
    "Gruppo": ["G1"] * len(speed1) + ["G2"] * len(speed2)
})

# Boxplot per confrontare le distribuzioni


plt.figure(figsize=(8, 5))
sns.boxplot(x="Gruppo", y="Velocità", data=df_long)
plt.title("Comparison of Mean Speed Between Groups")
plt.xlabel("Group")
plt.ylabel("Mean Speed")

# Image save path
fig_path = os.path.join(image_folder, "Comparison.png")  

# Save before displaying the plot
plt.savefig(fig_path, dpi=300, bbox_inches='tight')
#plt.show()


# STUDIO FREQUENZA


# Percorso principale
#image_folder = os.path.join(os.getcwd())

# Definizione dei gruppi
gruppi = ['G1', 'Gruppi 2', 'Gruppi 4', 'Gruppi 6', 'Gruppi 9']
speed_column = "Mean Track mean speed"  # Nome della colonna della velocità

# Caricamento dati
dati = {}
for gruppo in gruppi:
    file_path = os.path.join(image_folder, gruppo, 'Statistica.xlsx')
    df = pd.read_excel(file_path, sheet_name="Statistiche")
    
    # Controlla se la colonna esiste
    if speed_column not in df.columns:
        raise ValueError(f"La colonna '{speed_column}' non è presente in {file_path}!")
    
    dati[gruppo] = (df[speed_column].dropna())/ frame_intervals[gruppo]

# Test di Shapiro-Wilk per la normalità
print("\n--- Test di normalità (Shapiro-Wilk) ---")
for gruppo, speed in dati.items():
    stat, p_value = stats.shapiro(speed)
    print(f"{gruppo}: stat={stat:.5f}, p-value={p_value:.5f}")
    if p_value < 0.05:
        print("i dati NON sono normali.")
    else:
        print(f"i dati seguono una distribuzione normale.")

# kruskal per il confronto tra più gruppi
stat, p_value = stats.kruskal(*dati.values())

print("\n--- Test kruskal ---")
print(f"Statistiche F: {stat:.5f}, P-value: {p_value:.10f}")

if p_value < 0.001:
    significance = "(p < 0.001) ***"
elif p_value < 0.01:
    significance = "(p < 0.01) **"
elif p_value < 0.05:
    significance = "(p < 0.05) *"
else:
    significance = "non significativo"

print(f"Risultato: {significance}")

mapping_nomi = {
    "G1": "10 min",
    "Gruppi 2": "20 min",
    "Gruppi 4": "40 min",
    "Gruppi 6": "60 min",
    "Gruppi 9": "90 min"
}

# Creazione DataFrame lungo per visualizzazione
df_long = pd.DataFrame({
    "Velocità": [v for gruppo in gruppi for v in dati[gruppo]],
    "Gruppo": [mapping_nomi[gruppo] for gruppo in gruppi for _ in range(len(dati[gruppo]))]
})

# Boxplot per confronto visivo
plt.figure(figsize=(10, 6))
sns.boxplot(x="Gruppo", y="Velocità", data=df_long, palette="Set2")
sns.swarmplot(x="Gruppo", y="Velocità", data=df_long, color=".25", alpha=0.6)

plt.title("Comparison of Mean Speed Between Groups")
plt.xlabel("Group")
plt.ylabel("Mean Speed")

# Salvataggio immagine
fig_path = os.path.join(image_folder, "Comparison_5Groups.png")
plt.savefig(fig_path, dpi=300, bbox_inches='tight')
#plt.show()
