import numpy as np
import os
import tifffile as tiff
from natsort import natsorted

# Imposta il passo per selezionare le immagini

def FileTif(dataset_dir,pivot_image_name,output_image_dir_1,output_image_dir_2,i,n,step):
        list_image = natsorted([f for f in sorted(os.listdir(dataset_dir)) if f.endswith('.tif')])
        #list_image = list(reversed(list_image))

        if pivot_image_name in list_image:
            pivot_index = list_image.index(pivot_image_name)
            list_before_pivot = list_image[:pivot_index]
            list_after_pivot = list_image[pivot_index:]
            list_before_pivot= list(reversed(list_before_pivot[::step]))
            list_after_pivot= list(reversed(list_after_pivot[::step]))
            print(list_before_pivot)

            # Seleziona solo alcune immagini con il passo specificato
            frames_1 = [np.asarray(tiff.imread(os.path.join(dataset_dir, file))) for file in list_before_pivot]
            frames_2 = [np.asarray(tiff.imread(os.path.join(dataset_dir, file))) for file in list_after_pivot]

            output_file_1 = f"{output_image_dir_1}/{i}_{n}.tiff"
            with tiff.TiffWriter(output_file_1) as tif:
                for frame in frames_1:
                    tif.write(frame)

            output_file_2 = f"{output_image_dir_2}/{i}_{n}.tiff"
            with tiff.TiffWriter(output_file_2) as tif:
                for frame in frames_2:
                    tif.write(frame)

        else:
            frames_1 = [np.asarray(tiff.imread(os.path.join(dataset_dir, file))) for file in list_image[::step]]
            output_file = f"{output_image_dir_1}/{i}_{n}.tiff"

            with tiff.TiffWriter(output_file) as tif:
                for frame in frames_1:
                    tif.write(frame)
