import numpy as np
import matplotlib.pyplot as plt
import os
from skimage.draw import polygon as skpolygon
from openpyxl import load_workbook, Workbook
from natsort import natsorted
import openpyxl
from openpyxl.drawing.image import Image as Image_b

def grafici_gruppi(image_names, valore, sheet_name, media, nome, result_dir, posizione, file_path, xlim, ylim1, ylim2,start_index):
        plt.figure(figsize=(10, 5))

        # Gruppo 1: Primo gruppo di immagini (fino a start_index)
        subset_image_names_1 = image_names[:start_index]  # Immagini prima dell'indice di riferimento
        subset_valore_1 = valore[:start_index]
        max_1 = max(subset_valore_1)
        min_1 = min(subset_valore_1)
        max_ind_1 = valore.index(max_1)
        min_ind_1 = valore.index(min_1)
        
        plt.plot(subset_image_names_1, subset_valore_1, color='blue', alpha=0.7, linewidth=1.5, label='Pre-drug (G1)')
        
        # Gruppo 2: Secondo gruppo di immagini
        subset_image_names_2 = image_names[start_index:]  # Immagini dopo l'indice di riferimento
        subset_valore_2 = valore[start_index:]
        max_2 = max(subset_valore_2)
        min_2 = min(subset_valore_2)
        max_ind_2 = valore.index(max_2)
        min_ind_2 = valore.index(min_2)
        
        plt.plot(subset_image_names_2, subset_valore_2, color='orange', alpha=0.7, linewidth=1.5, label='Post-drug (G2)')

        # Linea rossa per la media
        plt.axhline(y=media, color='red', linestyle='--', linewidth=2, label=f'Mean = {media:.2f}')
        
        # Titolo e etichette con font più grandi per migliorare la leggibilità
        plt.title(f'{nome} {sheet_name}', fontsize=14)
        plt.xlabel('Frame', fontsize=12)
        plt.ylabel(nome, fontsize=12)
        
        # Limiti degli assi X e Y con margini extra
        plt.xlim([0, xlim+2])
        plt.ylim([ylim1 - (ylim2 - ylim1) * 0.05, ylim2 + (ylim2 - ylim1) * 0.05])  # Aggiungi margine sopra e sotto

        # Aggiungi una griglia leggera
        plt.grid(True, linestyle='--', alpha=0.5)

        # Aggiungi un'annotazione dinamica per la media
        #plt.text(xlim * 0.05, media, f'Mean: {media:.2f}', fontsize=9, ha='left', va='bottom', color='red')

        # Annotazioni per i massimi e minimi di ciascun gruppo
        plt.annotate(f'Max G1: {max_1:.2f}', xy=(max_ind_1, max_1), 
                    xytext=(max_ind_1, max_1 + (ylim2 - ylim1) * 0.05),
                    arrowprops=dict(facecolor='green', shrink=0.05), fontsize=9,ha='left', color='green')
        plt.annotate(f'Min G1: {min_1:.2f}', xy=(min_ind_1, min_1), 
                    xytext=(min_ind_1, min_1 - (ylim2 - ylim1) * 0.05),
                    arrowprops=dict(facecolor='purple', shrink=0.05), fontsize=9,ha='left', color='purple')

        plt.annotate(f'Max G2: {max_2:.2f}', xy=(max_ind_2, max_2), 
                    xytext=(max_ind_2, max_2 + (ylim2 - ylim1) * 0.05),
                    arrowprops=dict(facecolor='green', shrink=0.05), fontsize=9,ha='right', color='green')
        plt.annotate(f'Min G2: {min_2:.2f}', xy=(min_ind_2, min_2), 
                    xytext=(min_ind_2, min_2 - (ylim2 - ylim1) * 0.05),
                    arrowprops=dict(facecolor='purple', shrink=0.05), fontsize=9,ha='right', color='purple')

        # Aggiungi la legenda
        plt.legend(loc='upper left', fontsize=10)

        # Salvataggio del grafico
        grafico_path = os.path.join(result_dir, f'{nome} {sheet_name}.png')
        
        plt.savefig(grafico_path, bbox_inches='tight')
        plt.close()

        # Caricamento e modifica del file Excel
        workbook = load_workbook(file_path)
        sheet_grafico = workbook[sheet_name]

        # Inserimento dell'immagine nel foglio
        img = Image_b(grafico_path)
        sheet_grafico.add_image(img, posizione)
        workbook.save(file_path)

def features(output,info,riga,colonna,list_images):
    file_path = os.path.join(output, 'Patch info.xlsx')
    list_images = natsorted(list_images)
    image_names = np.arange(0,len(list_images))
    mean_areas = []
    num_cell =[]
    n = 1
    if os.path.exists(file_path):
            workbook = openpyxl.load_workbook(file_path)
    else:
            workbook = Workbook()

    target_image_name = f"VID1495_A1_1_01d00h00m_{riga}_{colonna}.tif"
    # Verifica che target_image_name sia nella lista
    if target_image_name in list_images:
        start_index = list_images.index(target_image_name)
    else:
        print(f"Errore: {target_image_name} non trovato in list_images.")
        return  # Esce dalla funzione se l'indice non è valido

    # Controlla se l'indice è valido per la divisione
    if start_index <= 0 or start_index >= len(image_names):
        print("Errore: La divisione in gruppi non è valida.")
        return

    # Scrivi le informazioni per ogni immagine in un proprio foglio
    for row_data in info:
        image_name = row_data[0]
        
        start_index = list_images.index(target_image_name)
        num_cellule = row_data[1]
        mean_area = row_data[2]
        mean_per = row_data[3]
        #circolarita_media = row_data[4]
        eccentricita_media = row_data[4]
        orientamento_medio = row_data[5]
        #cell_areas = row_data[3]

        # Crea un nome di foglio valido, assicurati che non sia troppo lungo e rimuovi caratteri non validi
        sheet_name = f'{riga}_{colonna}'
        #print(sheet_name)

        # Controlla se il foglio già esiste, altrimenti crealo
        if sheet_name in workbook.sheetnames:
            sheet = workbook[sheet_name]
        else:
            sheet = workbook.create_sheet(title=sheet_name)
            # Scrivi l'intestazione se è un nuovo foglio
            header = ['Image Name', 'Num. cell','Area Media', 'Perimetro Medio', 'Eccentricità Media', 'Orientamneto Medio']
            sheet.append(header)
        
        
        mean_areas.append(mean_area)
        num_cell.append(num_cellule)
        n = n+1
        # Aggiungi i dati dell'immagine al foglio specifico
        sheet.append([image_name, num_cellule, mean_area, mean_per, eccentricita_media, orientamento_medio])
    workbook.save(file_path)

    max_area_value = max(mean_areas)
    min_area_value = min(mean_areas)
    #max_index = mean_areas.index(max_area_value)
    #min_index = mean_areas.index(min_area_value)
    mean_area_value = np.mean(mean_areas)
    xlim = len(list_images)
    ylim1 = min_area_value
    ylim2 = max_area_value
    
    #plt.fill_between(image_names, mean_areas, color='skyblue', alpha=0.4)
    #plt.grid(True)

    # Salva il grafico come immagine
    result_dir = os.path.join(output, 'Grafici ', sheet_name + '/')
    os.makedirs(result_dir, exist_ok=True)
    
    grafici_gruppi(image_names, mean_areas, sheet_name, mean_area_value, 'Mean Area', result_dir, 'I2', file_path, xlim, ylim1, ylim2,start_index)
    
    max_value = max(num_cell)
    min_value = min(num_cell)
    # max_index = num_cell.index(max_value)
    # min_index = num_cell.index(min_value)
    mean_value = np.mean(num_cell)
    xlim = len(list_images)
    ylim1 = min_value
    ylim2 = max_value
    grafici_gruppi(image_names, num_cell, sheet_name, mean_value, 'Number of cells', result_dir, 'I30', file_path, xlim, ylim1, ylim2,start_index)
    # Salva il file Excel
    print("File Excel aggiornato correttamente.")
