import numpy as np
import os
import cv2
import tifffile as tiff
from natsort import natsorted
import pandas as pd
from PIL import Image
from datetime import datetime
from natsort import natsorted
import matplotlib.pyplot as plt

def Secondo_alignment(dataset_dir, output_dir,pivot_image_name, cambio_riferimento=10):
    # Creare la cartella di output se non esiste
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)
    
    # Ottenere l'elenco delle immagini TIFF nella cartella
    list_image = natsorted([f for f in os.listdir(dataset_dir) if f.endswith('.tif')])
    output_path = os.path.join(output_dir, list_image[1])
    img = cv2.imread(os.path.join(dataset_dir, list_image[1]))
    cv2.imwrite(output_path, img)
    
    if len(list_image) < 2:
        print(f"Nella directory {dataset_dir} ci sono meno di due immagini. Procedura saltata.")
        return
    
    img_name_p = list_image[1]
    idx = 0
    
    # Ciclo per processare le immagini
    for img_name in list_image:
        # Cambiare riferimento ogni `cambio_riferimento` immagini o se inizia il secondo giorno
        
        if idx % cambio_riferimento == 0 or pivot_image_name == img_name_p:
            ref_name = img_name_p
            img_ref_color = cv2.imread(os.path.join(output_dir, ref_name))
            img_ref_gray = cv2.cvtColor(img_ref_color, cv2.COLOR_BGR2GRAY)
            print(f"Nuovo riferimento: {ref_name}")
            if pivot_image_name == img_name_p:
                ref_name = img_name_p
                img_ref_color = cv2.imread(os.path.join(dataset_dir, pivot_image_name))
                img_ref_gray = cv2.cvtColor(img_ref_color, cv2.COLOR_BGR2GRAY)
                cv2.imwrite(os.path.join(output_dir, pivot_image_name), img_ref_gray)
                cambio_riferimento = 5
                idx = cambio_riferimento  # Forzare il cambio al prossimo ciclo
        
        img_color = cv2.imread(os.path.join(dataset_dir, img_name))
        img_gray = cv2.cvtColor(img_color, cv2.COLOR_BGR2GRAY)
        height, width = img_ref_gray.shape

        # Rilevamento e descrizione con ORB
        orb_detector = cv2.ORB_create(5000)
        kp_ref, d_ref = orb_detector.detectAndCompute(img_ref_gray, None)
        kp, d = orb_detector.detectAndCompute(img_gray, None)

        # Verifica dei descrittori
        if d is None or d_ref is None:
            print(f"Descrittori non trovati per {img_name} o immagine di riferimento. Procedura saltata.")
            output_path = os.path.join(output_dir, img_name)
            cv2.imwrite(output_path, img_gray)
            idx = idx + 1
            img_name_p = img_name
            continue
        
        # Conversione dei tipi dei descrittori
        d = d.astype(np.uint8) if d.dtype != np.uint8 else d
        d_ref = d_ref.astype(np.uint8) if d_ref.dtype != np.uint8 else d_ref
        
        # Matcher di caratteristiche
        matcher = cv2.BFMatcher(cv2.NORM_HAMMING, crossCheck=True)
        matches = matcher.match(d, d_ref)
        matches = sorted(matches, key=lambda x: x.distance)[:int(len(matches) * 0.9)]

        if len(matches) < 100:
            print(f"Immagine {img_name} non allineata: meno di 100 corrispondenze trovate.")
            output_path = os.path.join(output_dir, img_name)
            cv2.imwrite(output_path, img_gray)
            idx = idx + 1
            img_name_p = img_name
            continue

        # Matrici per la stima dell'omografia
        p1 = np.array([kp[m.queryIdx].pt for m in matches], dtype=np.float32)
        p2 = np.array([kp_ref[m.trainIdx].pt for m in matches], dtype=np.float32)

        # Calcolo dell'omografia
        homography, _ = cv2.findHomography(p1, p2, cv2.RANSAC)

        # Trasformazione dell'immagine
        transformed_img = cv2.warpPerspective(img_color, homography, (width, height))
        
        # Salvataggio dell'immagine allineata
        output_path = os.path.join(output_dir, img_name)
        cv2.imwrite(output_path, transformed_img)
        img_name_p = img_name
        idx = idx + 1

    print(f"Allineamento completato per {dataset_dir}")

def GS_cleaning(file_path, image_name_to_find, n, num_sh,img1_path):
    # Carica il file Excel
    excel_data = pd.ExcelFile(file_path)
    print(image_name_to_find)
    # Seleziona il foglio specificato
    sheet_name = excel_data.sheet_names[num_sh-1]
    df = pd.read_excel(file_path, sheet_name=sheet_name)

    # Trova la riga dell'immagine specifica
    row_index = None
    for row in range(df.shape[0]):
        if df.iat[row, 0] == image_name_to_find:  # Assumendo che il nome dell'immagine sia nella prima colonna
            row_index = row
            break
    #print(f"La cella nella riga {row_index}, colonna {n} and {sheet_name}")
    # Controlla se la cella specificata (riga trovata e colonna n) contiene un valore
    cell_value = 'vuota'
    if row_index is not None:
        cell_value = df.iat[row_index, n]  # n-1 per l'indicizzazione 0 di Python
        
        if pd.notna(cell_value):
                    
            if cell_value == 'ERR':
                    if os.path.exists(img1_path):
                        # Add entry to modified images log
                        os.remove(img1_path)
                        return True  # Indicates that an image was processed
                    else:
                        print(f"Image not found: {img1_path}")
                        return False

def Cleaning(folders,GS_path):
    
    for idx in range(0,len(folders)-1):
            
            folder1= folders[idx]

            images1 = natsorted([f for f in os.listdir(folder1) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])

            base_name, ext = images1[0].split('.')
            parts = base_name.split('_')
            for i in range(0,len(images1)):
                print(images1[i])
                
                img1_path = os.path.join(folder1, images1[i])
                base_name, ext = images1[i].split('.')
                parts = base_name.split('_')
                name = base_name[:-4] + '.' + ext if base_name[-5] == 'm' else base_name[:-5] + '.' + ext
                
                #ref_name,c,img1_p = allinea_immagini(folder1_all,folder1, images1[i],n, int(parts[-1]),c,ref_name,img1_p, cambio_riferimento=10) 
     
                GS_cleaning(GS_path,name,int(parts[-1]), int(parts[-2]),img1_path)

def GS(file_path, image_name_to_find, n, num_sh,modified_images):
    
    if not os.path.exists(file_path):
        print(f"File not found. Creating an empty file at: {file_path}")
        pd.DataFrame().to_excel(file_path, index=False)
    #print(image_name_to_find)
    excel_data = pd.ExcelFile(file_path)
    # Seleziona il foglio specificato
    sheet_name = excel_data.sheet_names[num_sh-1]
    df = pd.read_excel(file_path, sheet_name=sheet_name)

    # Trova la riga dell'immagine specifica
    row_index = None
    for row in range(df.shape[0]):
        if df.iat[row, 0] == image_name_to_find:  # Assumendo che il nome dell'immagine sia nella prima colonna
            row_index = row
            break
    #print(f"La cella nella riga {row_index}, colonna {n} and {sheet_name}")
    # Controlla se la cella specificata (riga trovata e colonna n) contiene un valore
    cell_value = 'vuota'
    if row_index is not None:
        cell_value = df.iat[row_index, n]  # n-1 per l'indicizzazione 0 di Python
    modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''})

def fascia_righe(img1_path, window_height=10, threshold=0):
   #rivela la fascia nera per spostamenti verticali (MOVEV)
    # Caricamento immagine come array
    image = np.array(Image.open(img1_path))

    # Larghezza della finestra = larghezza immagine
    #window_width = image.shape[1]

    # Inizializzazione delle variabili
    black_band_start = None
    black_band_end = None
    inside_black_band = False

    # Scansione con finestra mobile riga per riga
    for start_row in range(0, image.shape[0] - window_height + 1, 1):
        # Selezione finestra
        window = image[start_row:start_row + window_height, :]
        mean_intensity = np.mean(window)
        
        # Rilevamento inizio fascia nera
        if mean_intensity <= threshold and not inside_black_band:
            black_band_start = start_row
            inside_black_band = True
        # Rilevamento fine fascia nera
        elif mean_intensity > threshold and inside_black_band:
            black_band_end = start_row
            break

    # Se non viene rilevata una fine, assume l'immagine termina con la fascia
    if inside_black_band and black_band_end is None:
        black_band_end = image.shape[0]

    # Ritorna i limiti della fascia nera, o None se non trovata
    if black_band_start is not None and black_band_end is not None:
        return black_band_start, black_band_end
    else:
        #print("Fascia nera non trovata.")
        return None, None

def fascia(img1_path):
    #rivela la fascia nera per spostamenti orizzontali (MOVE, COPY, MOVE_COPY,MISS)
    image = cv2.imread(img1_path)  # Carica l'immagine
    image = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY) # Converte in array numpy
    window_width = 40  # Larghezza della finestra
    #window_height = image.shape[0]  # Altezza della finestra = altezza immagine
    threshold = 0.1  # Soglia per determinare il nero (intensità media)

    # Analisi con finestra mobile
    black_band_start = None
    black_band_end = None
    inside_black_band = False
    black_pixels = np.sum(image == 0)
    height, width = image.shape
    total_pixels = height * width

    if black_pixels < 0.7 * total_pixels:
        for start_col in range(0, image.shape[1] - window_width + 1, 1):  # Scorre colonna per colonna
            window = image[:, start_col:start_col + window_width]
            mean_intensity = np.mean(window)
            
            if mean_intensity <= threshold and not inside_black_band:
                black_band_start = start_col
                inside_black_band = True
            elif mean_intensity > threshold and inside_black_band:
                black_band_end = start_col
                break

    if inside_black_band and black_band_end is None:
        black_band_end = image.shape[1]

    # Ritorna i limiti della fascia nera, o None se non trovata
    if black_band_start is not None and black_band_end is not None:
        return black_band_start, black_band_end
    else:
        #print("Fascia nera non trovata.")
        return None, None
    
def correzione(file_path, image_name_to_find, n, num_sh,img1_path,img2_path,modified_images,start,start_2,end):
    excel_data = pd.ExcelFile(file_path)
    #print(image_name_to_find)
    # Seleziona il foglio specificato
    sheet_name = excel_data.sheet_names[num_sh-1]
    df = pd.read_excel(file_path, sheet_name=sheet_name)

    # Trova la riga dell'immagine specifica
    row_index = None
    for row in range(df.shape[0]):
        if df.iat[row, 0] == image_name_to_find:  # Assumendo che il nome dell'immagine sia nella prima colonna
            row_index = row
            break
    #print(f"La cella nella riga {row_index}, colonna {n} and {sheet_name}")
    # Controlla se la cella specificata (riga trovata e colonna n) contiene un valore
    cell_value = 'vuota'
    if row_index is not None:
        cell_value = df.iat[row_index, n]  # n-1 per l'indicizzazione 0 di Python
        
    if os.path.exists(img2_path) and os.path.exists(img1_path):
        image_1 = np.array(Image.open(img1_path))
        if image_1.ndim == 3:
            image_1 = cv2.cvtColor(image_1, cv2.COLOR_BGR2GRAY)
        elif image_1.ndim == 4:  # Per immagini con canale alfa
            image_1 = cv2.cvtColor(image_1[:, :, :3], cv2.COLOR_BGR2GRAY)
        if start >= 3:
            fascia = image_1.shape[1] - start
            if start_2 is not None and start_2 >= 3:
                fascia_2 = image_1.shape[1] - start_2

                if fascia_2 > 1.5*fascia:
                    image_cropped = image_1[:,fascia:]
                            #print(img1_path)

                    image_2 = np.array(Image.open(img2_path))
                    black_band = image_2[:,fascia:2*fascia]
                    processed_image = np.hstack((image_cropped, black_band))
                    if image_1.shape == processed_image.shape:
                        cv2.imwrite(img1_path, processed_image)
                    else:
                        processed_image = processed_image[:,:image_1.shape[1]]
                        cv2.imwrite(img1_path, processed_image)
                        
                            # Add entry to modified images log
                    modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': 'move2 o copy2'})
                    #print(processed_image.shape)
                    #print(image_1.shape)
                    return True

                else:
                    image_cropped = image_1[:, fascia:]

                    image_2 = np.array(Image.open(img2_path))
                    black_band = image_2[:, :fascia]
                                
                    processed_image = np.hstack((image_cropped, black_band))
                    if image_1.shape == processed_image.shape:
                        cv2.imwrite(img1_path, processed_image)
                    else:
                        processed_image = processed_image[:,:image_1.shape[1]]
                        cv2.imwrite(img1_path, processed_image)
                        
                            # Add entry to modified images log
                    modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': 'move o copy'})
                    #print(processed_image.shape)
                    #print(image_1.shape)
                    return True  # Indicates that an image was processed
            else:
                #print('ok')
                image_cropped = image_1[:,fascia:]
                            #print(img1_path)

                image_2 = np.zeros_like(image_1, dtype=image_1.dtype)

                black_band = image_2[:,:fascia]
                processed_image = np.hstack((image_cropped, black_band))
                if image_1.shape == processed_image.shape:
                    cv2.imwrite(img1_path, processed_image)
                else:
                    processed_image = processed_image[:,:image_1.shape[1]]
                    cv2.imwrite(img1_path, processed_image)
                        
                            # Add entry to modified images log
                modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': 'miss'})
                #print(processed_image.shape)
                #print(image_1.shape)
        else:
            #print(end)
            fascia = image_1.shape[1] - start
            if start_2 is not None and start_2 < 3:
                    #fascia_2 = image_1.shape[1] - start_2
                #if fascia_2 >= 0.9*fascia:
                    image_cropped = image_1[:, :-end]
                
                    black_band = np.zeros_like(image_1, dtype=image_1.dtype)
                    black_band = black_band[:,-end:]
                                    
                    processed_image = np.hstack((black_band,image_cropped))
                    if image_1.shape == processed_image.shape:
                        cv2.imwrite(img1_path, processed_image)
                    else:
                        processed_image = processed_image[:,:image_1.shape[1]]
                        cv2.imwrite(img1_path, processed_image)
                                
                                    # Add entry to modified images log
                
                    modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': 'sx'})
            #print(processed_image.shape)
            #print(image_1.shape)
                # Add entry to modified images log
        
                    return True  # Indicates that an image was processed
                # else:                
                #     modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''})
                #     return False
            else:
                
                modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''})
                return False
    else:
        print(f"Image not found: {img1_path} or {img2_path}")
        modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''})
        return False

def correzione_verticale(file_path, image_name_to_find, n, num_sh,img1_path,img3_path,modified_images,start,start_3):
    excel_data = pd.ExcelFile(file_path)
    #print(image_name_to_find)
    # Seleziona il foglio specificato
    sheet_name = excel_data.sheet_names[num_sh-1]
    df = pd.read_excel(file_path, sheet_name=sheet_name)

    # Trova la riga dell'immagine specifica
    row_index = None
    for row in range(df.shape[0]):
        if df.iat[row, 0] == image_name_to_find:  # Assumendo che il nome dell'immagine sia nella prima colonna
            row_index = row
            break
    #print(f"La cella nella riga {row_index}, colonna {n} and {sheet_name}")
    # Controlla se la cella specificata (riga trovata e colonna n) contiene un valore
    cell_value = 'vuota'
    if row_index is not None:
        cell_value = df.iat[row_index, n]  # n-1 per l'indicizzazione 0 di Python
        
    if os.path.exists(img1_path) and os.path.exists(img3_path):
        #if start_3 is not None:
            image_1 = np.array(Image.open(img1_path))
            fascia = image_1.shape[0] - start
            if fascia <= image_1.shape[0]/2:
                image_cropped = image_1[fascia:,:]
                                
                image_3 = np.array(Image.open(img3_path))
                black_band = image_3[:fascia, :]
                #print(img3_path)
                                
                processed_image = np.vstack((image_cropped, black_band))
                #print(processed_image.shape)
                cv2.imwrite(img1_path, processed_image)
                                # Add entry to modified images log
                modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': 'verticale'})
                    
                            
                return True  # Indicates that an image was processed
            else:
                modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''}) 
                return False
        #else:
            #modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''}) 
    else:
        print(f"Image not found: {img1_path} or {img3_path}")
        modified_images.append({'Image': image_name_to_find, 'Action': cell_value, 'Auto': ''})
        return False    

def save_to_excel(modified_images, excel_output_path,col, rig):
    df = pd.DataFrame(modified_images)

    # Check if the Excel file already exists
    if os.path.exists(excel_output_path):
        with pd.ExcelWriter(excel_output_path, engine="openpyxl", mode="a") as writer:
            # Use a new sheet name with a timestamp to avoid overwriting
            #sheet_name = f"Modified_Images_{datetime.now().strftime('%Y%m%d_%H%M%S')}"
            sheet_name = f'{rig}_{col}'
            df.to_excel(writer, index=False, sheet_name=sheet_name)
            print(f"Aggiunto allo sheet '{sheet_name}'")
    else:
        # If the file doesn't exist, create a new file
        df.to_excel(excel_output_path, index=False, sheet_name="Modified_Images")
        print(f"Creato un nuovo file {excel_output_path}")               

def Correzione_Errori(folders,GS_path,excel_output_path,folder_ver,folders_all,folder_ver_all):
    modified_images_found = False

    for idx in range(0,len(folders)-1):
            c = 0
            modified_images = []
            folder1, folder2, folder4 = folders[idx], folders[idx + 1],folders[idx - 1]
            folder1_all, folder2_all = folders_all[idx], folders_all[idx + 1]
            folder3 = folder_ver[idx]
            folder3_all =  folder_ver_all[idx]
            images1 = natsorted([f for f in os.listdir(folder1) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])
            print(len(images1))
            #ref_name = images1[1]
            #img1_p = images1[1]
            base_name, ext = images1[0].split('.')
            parts = base_name.split('_')

            
            images2 = natsorted([f for f in os.listdir(folder2) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])
            
            
            for i in range(0,len(images1)):
                print(images1[i])
                
                img1_path = os.path.join(folder1, images1[i])
                img2_path = os.path.join(folder2, images2[i])

                base_name, ext = images1[i].split('.')
                parts = base_name.split('_')
                name = base_name[:-4] + '.' + ext if base_name[-5] == 'm' else base_name[:-5] + '.' + ext
                
                #ref_name,c,img1_p = allinea_immagini(folder1_all,folder1, images1[i],n, int(parts[-1]),c,ref_name,img1_p, cambio_riferimento=10) 
                output_path =   os.path.join(folder1_all, images1[i])
                output_path_2 =   os.path.join(folder2_all, images2[i])            
                black_band_start, black_band_end = fascia(output_path)
                black_band_start_2, black_band_end_2 = fascia(output_path_2)
                
                start, end = fascia_righe(output_path, window_height=50, threshold=0)
                
                
                c += 1
                if black_band_start is not None and black_band_end is not None and start is None and end is None:
                    #print('ok')
                    # if black_band_start != 0:
                        #print('dx')
                        correzione(GS_path,name,int(parts[-1]), int(parts[-2]),img1_path,img2_path,modified_images,black_band_start,black_band_start_2,black_band_end)
                    # else:
                    #     print('sx')
                    #     images4 = natsorted([f for f in os.listdir(folder4) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])
                    #     img4_path = os.path.join(folder4, images4[i])
                    #     correzione(GS_path,name,int(parts[-1]), int(parts[-2]),img1_path,img4_path,modified_images,black_band_start,black_band_start_2,black_band_end)
                    
                        
                elif start is not None and end is not None:
                    print('verticale')
                    #print(f'fine:{black_band_end}')
                    #print(f'inizio:{black_band_start}')
                    images3 = natsorted([f for f in os.listdir(folder3) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])
                    #print(len(images3))
                    img3_path = os.path.join(folder3, images3[i])
                    output_path_3 =   os.path.join(folder3_all, images3[i])  
                    start2, end2 = fascia_righe(output_path_3, window_height=50, threshold=0)
                    correzione_verticale(GS_path,name,int(parts[-1]), int(parts[-2]),img1_path,img3_path,modified_images,start,start2)
                    if black_band_start is not None and black_band_start <= 3:
                        print('sx')
                        # images4 = natsorted([f for f in os.listdir(folder4) if f.endswith(('.jpg', '.jpeg', '.tif', '.png'))])
                        # img4_path = os.path.join(folder4, images4[i])
                        correzione(GS_path,name,int(parts[-1]), int(parts[-2]),img1_path,img2_path,modified_images,black_band_start,black_band_start_2,black_band_end)
                        
                else:
                    print("Nessuna fascia nera rilevata.")
                    GS(GS_path, name, int(parts[-1]), int(parts[-2]),modified_images)
                                                                                                                                                                
    
        # Save the modified images log to an Excel file, adding a new sheet if file exists
            if modified_images:
                 save_to_excel(modified_images, excel_output_path,int(parts[-1]), int(parts[-2]))
    return modified_images_found
