/*
 * Decompiled with CFR 0.152.
 */
package org.diplib;

import java.nio.ByteBuffer;
import loci.common.DebugTools;
import loci.common.services.ServiceFactory;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import org.diplib.FileInformation;
import org.diplib.Image;
import org.diplib.PhysicalQuantity;

public class BioFormatsInterface {
    public static FileInformation Read(String string, int n, long l) throws Exception {
        DebugTools.setRootLevel((String)"warn");
        Image image = new Image(l);
        ImageReader imageReader = new ImageReader();
        ServiceFactory serviceFactory = new ServiceFactory();
        OMEXMLService oMEXMLService = (OMEXMLService)serviceFactory.getInstance(OMEXMLService.class);
        OMEXMLMetadata oMEXMLMetadata = oMEXMLService.createOMEXMLMetadata();
        imageReader.setMetadataStore((MetadataStore)oMEXMLMetadata);
        imageReader.setId(string);
        int n2 = imageReader.getSeriesCount();
        imageReader.setSeries(n);
        PhysicalQuantity[] physicalQuantityArray = new PhysicalQuantity[]{BioFormatsInterface.GetPhysicalQuantity(oMEXMLMetadata.getPixelsPhysicalSizeX(0)), BioFormatsInterface.GetPhysicalQuantity(oMEXMLMetadata.getPixelsPhysicalSizeY(0)), BioFormatsInterface.GetPhysicalQuantity(oMEXMLMetadata.getPixelsPhysicalSizeZ(0)), BioFormatsInterface.GetPhysicalQuantity(oMEXMLMetadata.getPixelsTimeIncrement(0))};
        long[] lArray = new long[]{imageReader.getSizeX(), imageReader.getSizeY(), imageReader.getSizeZ(), imageReader.getSizeT()};
        image.SetSizes(lArray);
        image.SetTensorSizes(imageReader.getSizeC());
        String string2 = imageReader.getDimensionOrder();
        if (imageReader.isInterleaved()) {
            string2 = "CXY" + string2.charAt(3) + string2.charAt(4);
        }
        long[] lArray2 = new long[]{0L, 0L, 0L, 0L};
        long l2 = 1L;
        long l3 = 0L;
        int n3 = 0;
        for (int i = 0; i < 5; ++i) {
            long l4 = 0L;
            switch (string2.charAt(i)) {
                case 'X': {
                    l4 = imageReader.getSizeX();
                    break;
                }
                case 'Y': {
                    l4 = imageReader.getSizeY();
                    break;
                }
                case 'C': {
                    l4 = imageReader.getSizeC();
                    break;
                }
                case 'Z': {
                    l4 = imageReader.getSizeZ();
                    break;
                }
                case 'T': {
                    l4 = imageReader.getSizeT();
                }
            }
            if (string2.charAt(i) == 'C') {
                l3 = l2;
            } else {
                lArray2[n3++] = l2;
            }
            l2 *= l4;
        }
        image.SetStrides(lArray2);
        image.SetTensorStride(l3);
        switch (imageReader.getPixelType()) {
            case 0: {
                image.SetDataType("SINT8");
                break;
            }
            case 1: {
                image.SetDataType("UINT8");
                break;
            }
            case 2: {
                image.SetDataType("SINT16");
                break;
            }
            case 3: {
                image.SetDataType("UINT16");
                break;
            }
            case 4: {
                image.SetDataType("SINT32");
                break;
            }
            case 5: {
                image.SetDataType("UINT32");
                break;
            }
            case 6: {
                image.SetDataType("SFLOAT");
                break;
            }
            case 7: {
                image.SetDataType("DFLOAT");
            }
        }
        image.SetPixelSize(physicalQuantityArray);
        if (imageReader.getRGBChannelCount() == 3) {
            image.SetColorSpace("sRGB");
        }
        image.Forge();
        image.Squeeze();
        long l5 = 0L;
        for (int i = 0; i < imageReader.getImageCount(); ++i) {
            ByteBuffer byteBuffer = image.Origin(l5);
            byte[] byArray = imageReader.openBytes(i);
            byteBuffer.put(byArray);
            l5 += (long)byArray.length;
        }
        FileInformation fileInformation = new FileInformation();
        fileInformation.name = string;
        fileInformation.fileType = imageReader.getFormat();
        fileInformation.dataType = image.DataType();
        fileInformation.significantBits = ((Integer)oMEXMLMetadata.getPixelsSignificantBits(0).getValue()).intValue();
        fileInformation.sizes = image.Sizes();
        fileInformation.tensorElements = image.TensorSizes().length > 0 ? image.TensorSizes()[0] : 1L;
        fileInformation.colorSpace = image.ColorSpace();
        fileInformation.pixelSize = image.PixelSize();
        fileInformation.numberOfImages = n2;
        return fileInformation;
    }

    protected static PhysicalQuantity GetPhysicalQuantity(Length length) {
        if (length == null) {
            return new PhysicalQuantity(1.0, "px");
        }
        return new PhysicalQuantity(length.value().doubleValue(), length.unit().getSymbol());
    }

    protected static PhysicalQuantity GetPhysicalQuantity(Time time) {
        if (time == null) {
            return new PhysicalQuantity(1.0, "px");
        }
        return new PhysicalQuantity(time.value().doubleValue(), time.unit().getSymbol());
    }
}

