from cc3d.core.PySteppables import *  # Import all necessary steppables from CC3D
from cc3d.core.XMLUtils import CC3DXMLListPy  # Import XML utilities
import numpy as np  # Import NumPy for numerical operations (not used in this script)
import sys  # Import sys (not used in this script)

class SwapCellSteppable(SteppableBasePy):
    def __init__(self, frequency=1):
        super().__init__(frequency)  # Initialize the steppable with the given frequency

    def start(self):
        # Initialization of variables dependent on the simulator
        self.cell_inventory = self.simulator.getPotts().getCellInventory()  # Retrieves the cell inventory
        self.cell_list = CellList(self.cell_inventory)  # Creates a list of cells from the inventory
        self.cell_field = self.simulator.getPotts().getCellFieldG()  # Retrieves the cell field
        self.dimensions = self.cell_field.getDim()  # Stores the dimensions of the simulation domain
        
    def setFieldName(self, _fieldName):
        self.fieldName = _fieldName  # Allows setting the name of a concentration field used in this steppable

    def step(self, mcs):
        # Generates a filename based on the current Monte Carlo step (mcs)
        fileName = self.fieldName + "_" + str(mcs) + ".txt"
        self.outputField(self.fieldName, fileName)  # Calls the function to output the field data

    def outputField(self, _fieldName, _fileName):
        # Retrieves the concentration field corresponding to the given name
        field = CompuCell.getConcentrationField(self.simulator, _fieldName)
        pt = CompuCell.Point3D()  # Creates a 3D point object

        if field:
            try:
                with open(_fileName, "w") as fileHandle:  # Opens a file for writing
                    for i in range(self.dimensions.x):
                        for j in range(self.dimensions.y):
                            for k in range(self.dimensions.z):
                                pt.x = i
                                pt.y = j
                                pt.z = k
                                value = field.get(pt)  # Gets the field value at the given point
                                
                                # Retrieve the cell at this location
                                neighborCell = self.cell_field.get(pt)
                                
                                # If the cell exists and is of type 3 (ECM)
                                if neighborCell and neighborCell.type == 3:  
                                    # If the MMP concentration exceeds a threshold, degrade the ECM
                                    if value > 2.5:
                                        neighborCell.type = 0  # Convert it into Medium (background)
                                        
            except IOError:
                print("Could not open file for writing. Check if you have necessary permissions.")
