function [keG,feG]=ifem_quad_v2(glocoord,strain,mcoord,props,thk,Off,method)
%--------------------------------------------------------------------------
% iFEM
% Shell elements, 24 dofs
% {q}i={u v w thetax thetay thetaz}i, i=1,2,3,4
%--------------------------------------------------------------------------
%  
%  keG = "Stiffness" matrix based on the global coordinate system
%  feG = "Loads" vector based on the global coordinate system
%
%  Input: 
%--------------------------------------------------------------------------

%number of strain vectors
num_meas=size(strain,1);

% half thickness

t = props(9);  

% penalty factor for shear

pf_s = props(5);

% penalty factor for bending and membrane strains, x component

pf_b_x = props(6); 

% penalty factor for bending and membrane strains, y component

pf_b_y = props(7); 

% penalty factor for bending and membrane strains, xy component

pf_b_xy = props(8); 


% Rotation matrix from global to local, where the local coordinate system
%   is coincident with the material coordinate system

Rot = mcoord; 

% Local coordinates

locCoord = glocoord * Rot';

X = locCoord(:,1);
Y = locCoord(:,2);

% -------------------------------------------------------------------------
% Shape functions
% -------------------------------------------------------------------------

% Numero di punti per la quadratura di Gauss
n=3;

% Calcolo delle shape functions
[DJ,N,~,~,N_x,M_x,L_x,N_y,M_y,L_y,wi]=quad4_iis_sf_v2(X,Y,2,n);
% M=-M;
M_x=-M_x;
M_y=-M_y;


% -------------------------------------------------------------------------
% e: deformazione membranale
% -------------------------------------------------------------------------

dof1 = [1 7 13 19 6 12 18 24];

Bex=zeros(n*n,24);

Bex(:,dof1) = sqrt(pf_b_x)*[N_x L_x];

emx=zeros(1,num_meas);
if props(2)
    emx=strain(:,1)'*pf_b_x;
end

dof2 = [2 8 14 20 6 12 18 24];

Bey=zeros(n*n,24);

Bey(:,dof2) = sqrt(pf_b_y)*[N_y M_y];

emy=zeros(1,num_meas);
if props(3)
    emy=strain(:,2)'*pf_b_y;
end

dof3 = [1 7 13 19 2 8 14 20 6 12 18 24];

Bgxy=zeros(n*n,24);

Bgxy(:,dof3) = sqrt(pf_b_xy)*[N_y N_x L_y+M_x];

emxy=zeros(1,num_meas);
if props(4)
    emxy=strain(:,3)'*pf_b_xy;
end

Bm=[Bex
    Bey
    Bgxy];

em=[emx
    emy
    emxy];
           
% -------------------------------------------------------------------------
% k: bending
% -------------------------------------------------------------------------

dof4 = [5 11 17 23];

Bkx=zeros(n*n,24);

Bkx(:,dof4) = sqrt(pf_b_x)*N_x;

ekx=zeros(1,num_meas);
if props(2)
    ekx=strain(:,4)'*pf_b_x;
end

dof5 = [4 10 16 22];

Bky=zeros(n*n,24);

Bky(:,dof5) = sqrt(pf_b_y)*-N_y;

eky=zeros(1,num_meas);
if props(3)
    eky=strain(:,5)'*pf_b_y;
end

dof6 = [4 10 16 22 5 11 17 23];

Bkxy=zeros(n*n,24);

Bkxy(:,dof6) = sqrt(pf_b_xy)*[-N_x N_y];

ekxy=zeros(1,num_meas);
if props(4)
    ekxy=strain(:,6)'*pf_b_xy;
end

Bb=[Bkx
    Bky
    Bkxy];

ek=[ekx
    eky
    ekxy];

% -------------------------------------------------------------------------
% g: shear
% -------------------------------------------------------------------------

dof7 = [3 9 15 21 4 10 16 22 5 11 17 23];

Bgxz=zeros(n*n,24);

Bgxz(:,dof7) = sqrt(pf_s)*[N_x -L_x -M_x+N];

dof8 = [3 9 15 21 4 10 16 22 5 11 17 23];

Bgyz=zeros(n*n,24);

Bgyz(:,dof8) = sqrt(pf_s)*[N_y -L_y-N -M_y];

Bs=[Bgxz
    Bgyz];

% -------------------------------------------------------------------------
% Calcolo matrice ke e del vettore fe per mezzo di integrazione di Gauss su 
% n*n punti. Le matrici Bm Bb e Bs hanno blocchi di n*n colonne per gli n*n
% punti di gauss
% -------------------------------------------------------------------------

ke=zeros(24);
fe=zeros(24,1);

[~,index]=max(wi);

for i=1:n*n
    px=1;
    px=1;
    py=1;
    pt=1;
    pz=1;
 if method==2   
    if (props(2) | props(3)) & i~=index
        wi(i)=(10^-3)*wi(i);
        
        %Fattore per evitare l'eccessiva penalizzazione per la combinazione
        %del pf per l'assenza di misura e quello per i punti di gauss non
        %nel centroide
        if props(2) & props(3)==0
        px=sqrt(10^3);
        end
        if props(2)==0 & props(3)
        py=sqrt(10^3);
        end
        if props(2) & props(3)
        pt=sqrt(10^3);
        end
        if props(2) & props(3) & props(4)==0
        pz=sqrt(10^3);
        end

              
    end
 end
    Bmi=[py.*Bm(i,:)
        px.*Bm(i+n*n,:)
        px.*py.*pz.*Bm(i+2*n*n,:)];
    Bbi=[py.*Bb(i,:)
        px.*Bb(i+n*n,:)
        px.*py.*pz.*Bb(i+2*n*n,:)];
    Bsi=[px.*py.*pt.*Bs(i,:)
        px.*py.*pt.*Bs(i+n*n,:)];
      
    kei=wi(i)*((Bmi'*Bmi)+((2*t)^2*(Bbi'*Bbi))+(Bsi'*Bsi))*DJ(i);
    fei=wi(i)*((Bmi'*em)+((2*t)^2*Bbi'*ek))*DJ(i);
    ke=ke+kei;
    fe=fe+fei;
end


% -------------------------------------------------------------------------
% Trasformazione in caso di offset
% -------------------------------------------------------------------------
if Off~=0
    trans=eye(24);
    if thk(1,2)~=0
        if Off<0
        sign=1;
        else
        sign=-1;
        end
        d=sign*((thk(1)-thk(2))/2);
    else
    d=-Off;
    end
    trans(1,5)=-d;
    trans(7,11)=-d;
    trans(13,17)=-d;
    trans(19,23)=-d;
    trans(2,4)=d;
    trans(8,10)=d;
    trans(14,16)=d;
    trans(20,22)=d;
    ke=trans'*ke*trans;
    fe=trans'*fe;
end
% -------------------------------------------------------------------------
% Rotazione matrici
% -------------------------------------------------------------------------

for i=1:8
    first=(i-1)*3+1;
    last=i*3;
    T(first:last, first:last)=Rot;
end

keG=T'*ke*T;
feG=T'*fe;


    
end
           