function [nEle,nNode,Cne,index_quad,index_tria,t,Pnn,gcoord_index,thk,Off,bc,Cbar,...
                    Off_beam,Pbarl,Pbarl_index,mat_e,gcoord,mcoord]=iFem_pre_v2(bdfifem,str_coord)

% MODELLO
% -------------------------------------------------------------------------



% Lettura modello (bdf NASTRAN)
%   shell() = [PID  MID1  T]
%   quad4(e,:) = [  EID   PID   n1   n2   n3  n4  MCID  ZOFF]
%   tria3(e,:) = [  EID   PID   n1   n2   n3  MCID  ZOFF]
%   gcoord(n,:) = [  NID   x    y    z  ]
%   bc(i,:) = [DOF n1 n2 ... nn]

[gcoord,gcoord_index,quad4,tria3,Cbar,Off_beam,Pbarl,coordR,shell,shell_index,Pbarl_index,bc,mat,mat_index]=readbdf_new_v2(bdfifem);


if isempty(tria3)
    tria3=zeros(1,7);
end
if isempty(quad4)
    quad4=zeros(1,8);
end
if isempty(shell)
    shell=zeros(1,3);
end
index_tria=find(tria3(:,1));
index_quad=find(quad4(:,1));

% Espressione degli elementi aventi nodi in comune con elementi offsetati 
% come elementi unici aventi
% spessore uguale alla somma degli spessori dei singoli elementi
if isempty(find(tria3(:,7)))==0 | isempty(find(quad4(:,8)))==0

[t,thk,Off,tria3,quad4]=offsetcalc(tria3,quad4,index_tria,index_quad,shell,shell_index);

index_tria=find(tria3(:,1));
index_quad=find(quad4(:,1));
else
    thk(index_tria,1)=shell(tria3(index_tria,2),3);
    thk(index_tria,2)=0;
    thk(index_quad,1)=shell(shell_index(quad4(index_quad,2)),3);
    thk(index_quad,2)=0;
    t=thk(:,1)./2;
    Off=zeros(length([index_tria;index_quad]),1);
end

% Matrice con le caratteristiche del materiale (Isotropo)
mat_e=[];
if ~isempty(index_quad) & ~isempty(mat) & ismember(shell(shell_index(quad4(:,2)),2),mat(:,1))
    mat_e(index_quad,:)=mat(mat_index(shell(shell_index(quad4(:,2)),2)),2:3);
end
if ~isempty(index_tria) & ~isempty(mat) & ismember(shell(shell_index(tria3(:,2)),2),mat(:,1))
    mat_e(index_quad,:)=mat(mat_index(shell(shell_index(tria3(:,2)),2)),2:3);
end

% Matrice coordinate dei nodi

Pnn = gcoord(:,2:4);

% Matrice di connectivity
Cne=zeros(size(index_quad,1)+size(index_tria,1),5);
Cne(index_quad,1:5)=quad4(index_quad,[1 3:6]);
Cne(index_tria,1:4)=tria3(index_tria,[1 3:5]);




% Numero nodi

nNode = size(Pnn,1);

% Numero di elementi

nEle = size(Cne,1);


% Sistemi di coordinate
% 
%   coordSys(:,:,i) = [vx; vy; vz]  (ATTENZIONE: siccome i CID iniziano da
%       zero, i = CID+1)


% Sistema di riferimento globale (CID = 0)

coordSys(:,:,1) = [1 0 0; 0 1 0; 0 0 1];

% Eventuali altri sistemi di riferimento

for i = 1:size(coordR,1)
   
    CID = coordR(i,1);
    pointA = coordR(i,2:4);
    pointB = coordR(i,5:7);
    pointC = coordR(i,8:10);
    [vx,vy,vz] = Coord_axis(pointA,pointB,pointC);
    coordSys(:,:,CID+1) = [vx; vy; vz];
    
end



%Computation of the local system for the elements

mcoord=elm_coord(nEle,gcoord_index,Cne,Pnn,coordSys,quad4,tria3,str_coord);




end