function [xi,wi]=gaule(n)
%-----------------------------------------------------------------------------------------
% [xi,wi]=gaule(n);
%-----------------------------------------------------------------------------------------
%               n=numero di nodi di interpolazione-integrazione (n>0);
%-----------------------------------------------------------------------------------------
%  xi=ascisse degli n nodi di Gauss-Legendre basati sull'intervallo [-1,1];
%  wi=valori degli n pesi di Gauss-Legendre basati sull'intervallo [-1,1];
%-----------------------------------------------------------------------------------------

% Inserimento del polinomio P-1;

Pm1=zeros(1,n+1);

% Inserimento del polinomio P_0;

P_0=zeros(1,n+1);
P_0(end)=1;

% Calcolo di P_n;

Pmm=Pm1;
Pm=P_0;

for i=1:n
   
   conv1=fliplr(conv([1 0],Pm));
   conv1=fliplr(conv1(1,1:n+1));
   
   P_n=(1/i)*((2*i-1)*conv1-(i-1)*Pmm);
   
   Pmm=Pm;
   Pm=P_n;
   
end

% Calcolo delle ascisse degli n nodi di Gauss-Legendre;

xi(:,1)=sort(roots(P_n));

% Calcolo dei pesi degli n nodi di Gauss-Legendre;

P_nd=polyder(P_n);

wi=zeros(n,1);

for i=1:n
   
   wi(i,1)=2/((1-(xi(i))^2)*(polyval(P_nd,xi(i)))^2);
   
end
