function [Bm,Bb,Bs]=compute_B_quad(x,y,e,n,xa,ya)

% -------------------------------------------------------------------------
% Funzioni di forma
% -------------------------------------------------------------------------

[~,N,M,~,N_x,M_x,L_x,N_y,M_y,L_y,~,n]=quad4_iis_sf_v2(x,y,e,n,xa,ya);
M=-M;
M_x=-M_x;
M_y=-M_y;

% -------------------------------------------------------------------------
% e: deformazione membranale
% -------------------------------------------------------------------------


dof1 = [1 7 13 19 6 12 18 24];

Bex=zeros(n,24);

Bex(:,dof1) = [N_x L_x];

dof2 = [2 8 14 20 6 12 18 24];

Bey=zeros(n,24);

Bey(:,dof2) = [N_y M_y];

dof3 = [1 7 13 19 2 8 14 20 6 12 18 24];

Bgxy=zeros(n,24);

Bgxy(:,dof3) = [N_y N_x L_y+M_x];

Bm=[Bex
    Bey
    Bgxy];

% -------------------------------------------------------------------------
% k: bending
% -------------------------------------------------------------------------

dof4 = [5 11 17 23];

Bkx=zeros(n,24);

Bkx(:,dof4) = [N_x];

dof5 = [4 10 16 22];

Bky=zeros(n,24);

Bky(:,dof5) = [-N_y];

dof6 = [4 10 16 22 5 11 17 23];

Bkxy=zeros(n,24);

Bkxy(:,dof6) = [-N_x N_y];

Bb=[Bkx
    Bky
    Bkxy];

% -------------------------------------------------------------------------
% g: shear
% -------------------------------------------------------------------------

dof7 = [3 9 15 21 4 10 16 22 5 11 17 23];

Bgxz=zeros(n,24);

Bgxz(:,dof7) = [N_x -L_x -M_x+N];

dof8 = [3 9 15 21 4 10 16 22 5 11 17 23];

Bgyz=zeros(n,24);

Bgyz(:,dof8) = [N_y -L_y-N -M_y];

Bs=[Bgxz
    Bgyz];

end
 

