%function [trainInd,valInd,testInd] = subsets_div(Dates)
clear all, clc
CITT = load('CITT.mat');
CITT = CITT.test_file;
Dates = CITT.Time;

years = year(Dates);
months = month(Dates);
days = day(Dates);

trainInd = zeros(size(Dates));
valInd = zeros(size(Dates));
testInd = zeros(size(Dates));

num_years = unique(years);
for i = 1:length(num_years)
    current_year = num_years(i);
    for j = 1:12
            current_month = j;
            find_condition = years == current_year & months == current_month;
            idx = find(find_condition);
            if isempty(idx)
                fprintf('No data in %d %d\n', current_month, current_year);
            else
                our_days = days(idx);
                which_days = unique(our_days);
                num_days = length(which_days);
                num_train = floor(0.6 * num_days);
                num_val = floor(0.2 * num_days);
                num_test = num_days - num_train - num_val;
                shuffled_days = which_days(randperm(num_days));
                days_train = shuffled_days(1:num_train);
                days_val = shuffled_days(num_train+1:num_train+num_val);
                days_test = shuffled_days(num_train+num_val+1:end);
                trainInd = trainInd | (find_condition & ismember(days,days_train));
                valInd = valInd | (find_condition & ismember(days,days_val));
                testInd = testInd | (find_condition & ismember(days,days_test));
            end 
    end
end
trainInd = find(trainInd == 1);
valInd = find(valInd == 1);
testInd = find(testInd == 1);





