function [seq_dates, sequences, sequences_power] = extract_sequence_var(varargin)
% Check number of inputs
    if nargin >= 1
        dates = varargin{1};
    else
        dates = [];  % Valore di default se non è dato il primo input
    end
    if nargin >= 2
        variabili = varargin{2};
    else
        variabili = [];  % Valore di default se non è dato il secondo input
    end
    if nargin >= 3
        powers = varargin{3};
    else
        powers = [];  % Valore di default se non è dato il terzo input
    end
    
    % Compute depending on the number of outputs
    if nargout >= 1
        if ~isempty(dates)
            num_samples = length(dates);
            seq_dates = {};
            curr_sample_date = [];
            startDay = dates(1);
            current_date = startDay;
            i = 1;
            k = 1;
            while i<=num_samples
                curr_day = day(current_date);
                curr_month = month(current_date);
                curr_year = year(current_date);
                j = 1;
                while day(dates(i))==curr_day & month(dates(i))==curr_month & year(dates(i))==curr_year
                    curr_sample_date{j} = dates(i);
                    i = i+1;
                    j = j+1;
                    if i == num_samples+1
                        break
                    end
                end 
                seq_dates{k} = curr_sample_date';
                curr_sample_date = [];
                k = k+1;
                current_date = datetime(current_date) + days(1);
            end
        else
            seq_dates = NaN;
        end
    end
    if nargout >= 2
        if ~isempty(variabili)
            num_var = size(variabili,2);
            num_samples = length(dates);
            sequences = {};
            seq_dates = {};
            current_sequence = [];
            curr_sample_date = [];
            startDay = dates(1);
            current_date = startDay;
            i = 1;
            k = 1;
            while i<=num_samples
                curr_day = day(current_date);
                curr_month = month(current_date);
                curr_year = year(current_date);
                j = 1;
                while day(dates(i))==curr_day & month(dates(i))==curr_month & year(dates(i))==curr_year
                    for w = 1:num_var
                        current_sequence(j,w) = variabili(i,w);
                    end
                    curr_sample_date{j} = dates(i);
                    i = i+1;
                    j = j+1;
                    if i == num_samples+1
                        break
                    end
                end 
                sequences{k} = current_sequence;
                seq_dates{k} = curr_sample_date';
                current_sequence = [];
                curr_sample_date = [];
                k = k+1;
                current_date = datetime(current_date) + days(1);
            end
        else
            sequences = NaN;  
        end
    end
    if nargout >= 3
        if ~isempty(powers)
            num_var = size(variabili,2);
            num_out = size(powers,2);
            num_samples = length(dates);
            sequences = {};
            sequences_power = {};
            seq_dates = {};
            current_sequence = [];
            curr_seq_pow = [];
            curr_sample_date = [];
            startDay = dates(1);
            current_date = startDay;
            i = 1;
            k = 1;
            while i<=num_samples
                curr_day = day(current_date);
                curr_month = month(current_date);
                curr_year = year(current_date);
                j = 1;
                while day(dates(i))==curr_day & month(dates(i))==curr_month & year(dates(i))==curr_year
                    for w = 1:num_var
                        current_sequence(j,w) = variabili(i,w);
                    end
                    % current_sequence(j,1) = temperatures(i);
                    % current_sequence(j,2) = irradiances(i);
                    for y = 1:num_out
                        curr_seq_pow(j,y) = powers(i,y);
                    end
                    curr_sample_date{j} = dates(i);
                    i = i+1;
                    j = j+1;
                    if i == num_samples+1
                        break
                    end
                end 
                sequences{k} = current_sequence;
                sequences_power{k} = curr_seq_pow;
                seq_dates{k} = curr_sample_date';
                current_sequence = [];
                curr_seq_pow = [];
                curr_sample_date = [];
                k = k+1;
                current_date = datetime(current_date) + days(1);
            end
        else
            sequences_power = NaN;  
        end
    end
end