function [dataTrain,targTrain,dataVal,targVal,dataTest,targTest,pos_seq_96] = compute_subsets_corr_96(seq_for_in,...
    seq_for_pow, seq_dates_for)

    for i = 4:numel(seq_dates_for)
        inputs96{i-3} = [seq_for_in{i-3}; seq_for_in{i-2}; seq_for_in{i-1}; seq_for_in{i}];
        targets96{i-3} = [seq_for_pow{i-3}; seq_for_pow{i-2}; seq_for_pow{i-1}; seq_for_pow{i}];
    end
    
    num_sequences = numel(seq_dates_for)-3; % -4+1
    [trainInd, valInd, testInd] = seasonality_24(num_sequences);

    pos_seq_96{1} = trainInd+3;
    pos_seq_96{2} = valInd+3;
    pos_seq_96{3} = testInd+3;
 
    
    dataTrain = inputs96(trainInd);
    targTrain = targets96(trainInd);
    dataVal = inputs96(valInd);
    targVal = targets96(valInd);
    dataTest = inputs96(testInd);
    targTest = targets96(testInd);

end
