 
% Y: modeled values
% targets: measured (actual) values

function [MBE,MAE,MAD,MAPE,SMAPE,RMSPE,R_squared,RMSE,MDA,DW,KGE,NSE,MASE,MXPE,MXNE] = KPI_compute(Y,targets)
N = length(Y);
Y_mean = mean(Y);
targets_mean = mean(targets);
e = targets-Y; % residual 

% MBE
MBE = 1/N*sum(e); % Mean Bias Error [W/m^2]

% MAE
MAE = 1/N*sum(abs(e)); % Mean Absolute Error [W/m^2]

% MAD
MAD = median(abs(e)); % Median Absolute Error [W/m^2]

% MAPE, RMSPE
% to compute MAPE and RMSPE we do not have to consider the values of
% targets == 0
targets_red = targets(targets ~= 0); % ~= 0
Y_red = Y(targets ~= 0);
e_red = targets_red - Y_red;
% N must be reduced consequently
N_red = length(targets_red);
MAPE = N_red*sum(abs(e_red)./targets_red); % Mean Absolute Percentage Error [adim or in % (*100)]
RMSPE = sqrt(N_red)*norm((e_red)./targets_red); % Root Squared Mean Percentage Error [adim or in % (*100)]

% SMAPE
SMAPE = 100/N*sum(2*abs(e)./(abs(targets)+abs(Y))); % Symmetric MAPE [adim or in % (*100)]

% R_squared
RSS = norm(e)^2; % Residual Sum of Squares
TSS = norm(targets-targets_mean)^2; % Total Sum of Squares
R_squared = 1-RSS/TSS; % coefficient of determination [adim]

% RMSE
RMSE = norm(e)/sqrt(N); % Root Mean Square Error[W/m^2]

% MXPE and MXNE
MXPE = max(e); % maximum positive error [W/m^2]
MXNE = min(e); % maximum negative error [W/m^2]

% MDA 
quantity = (targets(2:N)-targets(1:N-1)).*(Y(2:N)-Y(1:N-1));
MDA = 1/N*sum(quantity > 0); % Mean Directional Accuracy [adim]

% DW
DW = (norm(e(2:N)-e(1:N-1))/norm(e))^2; % Durbin-Watson statistics [adim]

%KGE
C = sum((targets-targets_mean).*(Y-Y_mean)); % covariance
r = C/(norm(targets-targets_mean)*norm(Y-Y_mean)); % PCC (Pearson Correlation Coefficient)
a = std(Y)/std(targets);
beta = Y_mean/targets_mean;
rab_vector = [r-1,a-1,beta-1];
KGE = 1-norm(rab_vector); % kling-Gupta Efficiency [adim]

% NSE
NSE = 1-(RMSE/std(targets))^2; % Nash-Sutcliffe Efficiency [adim]

% MASE
MASE = (N-1)/N*sum(abs(e))/sum(abs(targets(2:N)-targets(1:N-1))); % Mean Absolute Scaled Error [adim]

end