#include <systemc-ams.h>
#include <iostream>
#include <WinSock2.h>
#include <thread>
#include <chrono>

//#pragma comment(lib, "ws2_32.lib")
//int number = 50;
//
//int index = 0;
//std::string test = "0"; //1 FOR STOP
//
//SCA_TDF_MODULE(End_point) {
//
//    sca_tdf::sca_out<double> out;
//
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//    void processing() {
//        number++;
//        out.write(number);
//    }
//
//    SCA_CTOR(End_point) {}
//};
//
//SCA_TDF_MODULE(End_point2) {
//
//    sca_tdf::sca_in<double> in1,in2,in3,in4;
//
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//    void processing() {
//        
//    }
//
//    SCA_CTOR(End_point2) {}
//};
//
//SCA_TDF_MODULE(server) {
//    sca_tdf::sca_in<double> in;
//    sca_tdf::sca_out<double> out, out1;
//
//    WSADATA wsaData;
//    SOCKET servSock;
//    SOCKET clntSock;
//    char buffer[1024];
//
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//
//    void initialize() {
//        if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) {
//            std::cerr << "WSAStartup failed." << std::endl;
//            return;
//        }
//        servSock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
//        if (servSock == INVALID_SOCKET) {
//            std::cerr << "Socket creation failed." << std::endl;
//            WSACleanup();
//            return;
//        }
//        std::cout << "THE SERVER IS WAITING FOR CLIENT CONNECTION" << std::endl;
//        struct sockaddr_in sockAddr;
//        memset(&sockAddr, 0, sizeof(sockAddr));
//        sockAddr.sin_family = AF_INET;
//        sockAddr.sin_addr.s_addr = inet_addr("127.0.0.1");
//        sockAddr.sin_port = htons(3000);
//
//        if (bind(servSock, (SOCKADDR*)&sockAddr, sizeof(sockAddr)) == SOCKET_ERROR) {
//            std::cerr << "Bind failed." << std::endl;
//            closesocket(servSock);
//            WSACleanup();
//            return;
//        }
//        if (listen(servSock, 20) == SOCKET_ERROR) {
//            std::cerr << "Listen failed." << std::endl;
//            closesocket(servSock);
//            WSACleanup();
//            return;
//        }
//        struct sockaddr_in clntAddr;
//        int nSize = sizeof(clntAddr);
//        clntSock = accept(servSock, (SOCKADDR*)&clntAddr, &nSize);
//        if (clntSock == INVALID_SOCKET) {
//            std::cerr << "Accept failed." << std::endl;
//            closesocket(servSock);
//            WSACleanup();
//            return;
//        }
//    }
//    void processing() {
//        char byteArray[4];
//        int bytesReceived = recv(clntSock, byteArray, sizeof(byteArray), 0);
//
//
//        send(clntSock, test.c_str(), test.size(), 0);
//        if (bytesReceived > 0) {
//            int A = static_cast<int>(byteArray[0]);
//            int B = static_cast<int>(byteArray[1]);
//            int C = static_cast<int>(byteArray[2]);
//            int D = static_cast<int>(byteArray[3]);
//            std::string number1 = std::to_string(A); // Convert int to string
//            std::string number2 = std::to_string(B); // Convert int to string
//            std::string number3 = std::to_string(C); // Convert int to string
//            std::string number4 = std::to_string(D); // Convert int to string
//            std::string sum = number1 + number2;
//            std::string sum1 = number3 + number4;
//            int E, F;
//            E = stoi(sum);
//            F = stoi(sum1);
//            //std::cout << "T1=" << E << std::endl;
//            //std::cout << "T2=" << F << std::endl;
//            out.write(E);
//            out1.write(F);
//            index = 1;
//        }
//        else {
//            index = 0;
//        }
//    }
//    SCA_CTOR(server) {}
//    ~server() {
//        closesocket(clntSock);
//        closesocket(servSock);
//        WSACleanup();
//    }
//};
//
//SCA_TDF_MODULE(super_control) {
//
//    sca_tdf::sca_in<double> in1, in2, in3, in4;
//    sca_tdf::sca_out<double> out1, out2,out3,out4;
//    double ESC1 = 0, ESC2 = 0, w1 = 0, w2 = 0;
//    int alert1 = 0;
//    int alert2 = 0;
//    double C1 = 0.03546;
//    double A = 0.002363;
//    double b = 0.0000006;
//    double Kv = 42.5605;
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//
//    void processing() {
//
//        w1 = sqrt(2 * in1.read() / (C1 * A * 100 * 8));
//        w2 = sqrt(2 * in2.read() / (C1 * A * 100 * 8));
//
//        ESC1 = (w1 + b * w1 * w1 * Kv * Kv * 0.1) / (in3.read() * 6 * Kv);   //old battery ESC
//        ESC2 = (w2 + b * w2 * w2 * Kv * Kv * 0.1) / (in4.read() * 6 * Kv);   //new battery ESC
//        std::cout << "Receiving Data..." << std::endl;
//        if (ESC1 > 1) {
//            alert1 = 1;
//        }
//        if (ESC1 <= 1) {
//            alert1 = 0;
//        }
//        if (ESC2 > 1) {
//            alert2 = 1;
//        }
//        if (ESC2 <= 1) {
//            alert2 = 0;
//        }
//        out1.write(alert1);
//        out2.write(alert2);
//        out3.write(ESC1);
//        out4.write(ESC2);
//    }
//
//    SCA_CTOR(super_control) {}
//};
//
//SCA_TDF_MODULE(ESC) {
//
//    sca_tdf::sca_in<double> in1, in2, in3, in4;
//    sca_tdf::sca_out<double> out1, out2;
//    double Vin1 = 0, Vin2 = 0,Vb1=0,Vb2=0;
//    double ESC1 = 0, ESC2 = 0;
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//
//    void processing() {
//        ESC1 = in3.read();
//        ESC2 = in4.read();
//        Vb1 = in1.read();
//        Vb2 = in2.read();
//        Vin1 = Vb1 * ESC1;
//        Vin2 = Vb2 * ESC2;
//        out1.write(Vin1);
//        out2.write(Vin2);
//    }
//
//    SCA_CTOR(ESC) {}
//};
//
//SCA_TDF_MODULE(motor_blade) {
//
//    sca_tdf::sca_in<double> in1, in2;
//    sca_tdf::sca_out<double> out1, out2;
//    double w1 = 0, w2 = 0, Ib1 = 0, Ib2 = 0, Im1 = 0, Im2 = 0,Q1=0,Q2=0,T1,T2;
//    double C1 = 0.03546;
//    double A = 0.002363;
//    double b = 0.0000006;
//    double Kv = 42.5605;
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//
//    void processing() {
//        T1 = in1.read();
//        T2 = in2.read();
//
//        w1 = sqrt(2 * T1 / (C1 * A * 100 * 8));
//        w2 = sqrt(2 * T2 / (C1 * A * 100 * 8));
//        
//        Q1 = b * w1 * w1 * 8;
//        Q2 = b * w2 * w2 * 8;
//
//        Im1 = Q1 * Kv;
//        Im2 = Q2 * Kv;
//
//        Ib1 = 1.19 + Im1;
//        Ib2 = 1.19 + Im2;
//
//        out1.write(Ib1);
//        out2.write(Ib2);
//        
//    }
//
//    SCA_CTOR(motor_blade) {}
//};
//
//SCA_TDF_MODULE(SOC_calculator) {        //SOC calculator
//    sca_tdf::sca_in<double> in1, in2;
//    sca_tdf::sca_out<double> out1, out2;
//    double w1 = 0;
//    double w = 0;
//    double prev_soc1 = 1;
//    double prev_soc2 = 1; 
//    double c_bat1 = 5000 * 3600;
//    double c_bat2 = 3000 * 3600;
//    double percentage1 = 0;
//    double percentage2 = 0;
//    double Ib1 = 0;
//    double Ib2 = 0;
//
//    void set_attributes() {
//        set_timestep(1, SC_MS);
//    }
//    void processing() {
//
//        Ib1 = in1.read();
//        Ib2 = in2.read();
//        percentage1 = prev_soc1 - Ib1 * 5 * 15 / c_bat1;   
//        percentage2 = prev_soc2 - Ib2 * 5 * 15 / c_bat2;   
//        prev_soc1 = percentage1;
//        prev_soc2 = percentage2;
//        if (percentage1 <= 0) {
//            percentage1 = 0;
//            Ib1 = 0;
//
//        }
//        if (percentage2 <= 0) {
//            percentage2 = 0;
//            Ib2 = 0;
//            test = "1";
//
//        }
//        out1.write(percentage1);
//        out2.write(percentage2);
//        
//    }
//    SCA_CTOR(SOC_calculator) {}
//};
//
//SCA_TDF_MODULE(Vocv_publisher1)           //Vvoc generator
//{
//    sca_tdf::sca_in<double> in;   // SOC
//    sca_tdf::sca_out<double> out, out1; // Vocv
//
//    void set_attributes()
//    {
//        set_timestep(1, SC_MS);
//
//    }
//
//    void processing()
//    {
//
//        double soc = in.read();
//        if (soc >= 0 && soc < 0.025)
//        {
//            out.write(2.5);
//            out1.write(0.0185);
//        }
//        if (soc >= 0.025 && soc < 0.075)
//        {
//            out.write(2.9535);
//            out1.write(0.0185);
//        }
//        if (soc >= 0.075 && soc < 0.125)
//        {
//            out.write(3.1020);
//            out1.write(0.0167);
//        }
//        if (soc >= 0.125 && soc < 0.175)
//        {
//            out.write(3.2285);
//            out1.write(0.0165);
//        }
//        if (soc >= 0.175 && soc < 0.225)
//        {
//            out.write(3.3359);
//            out1.write(0.0182);
//        }
//        if (soc >= 0.225 && soc < 0.275)
//        {
//            out.write(3.3982);
//            out1.write(0.0180);
//        }
//        if (soc >= 0.275 && soc < 0.325)
//        {
//            out.write(3.4507);
//            out1.write(0.0187);
//        }
//        if (soc >= 0.325 && soc < 0.375)
//        {
//            out.write(3.4946);
//            out1.write(0.0188);
//        }
//        if (soc >= 0.375 && soc < 0.425)
//        {
//            out.write(3.5375);
//            out1.write(0.0191);
//        }
//        if (soc >= 0.425 && soc < 0.475)
//        {
//            out.write(3.5937);
//            out1.write(0.0203);
//        }
//        if (soc >= 0.475 && soc < 0.525)
//        {
//            out.write(3.6486);
//            out1.write(0.0214);
//        }
//        if (soc >= 0.525 && soc < 0.575)
//        {
//            out.write(3.7004);
//            out1.write(0.0224);
//        }
//        if (soc >= 0.575 && soc < 0.625)
//        {
//            out.write(3.7462);
//            out1.write(0.0228);
//        }
//        if (soc >= 0.625 && soc < 0.675)
//        {
//            out.write(3.7916);
//            out1.write(0.0234);
//        }
//        if (soc >= 0.675 && soc < 0.725)
//        {
//            out.write(3.8325);
//            out1.write(0.0236);
//        }
//        if (soc >= 0.725 && soc < 0.775)
//        {
//            out.write(3.8858);
//            out1.write(0.0246);
//        }
//        if (soc >= 0.775 && soc < 0.825)
//        {
//            out.write(3.9362);
//            out1.write(0.0257);
//        }
//        if (soc >= 0.825 && soc < 0.875)
//        {
//            out.write(3.9724);
//            out1.write(0.0256);
//        }
//        if (soc >= 0.875 && soc < 0.925)
//        {
//            out.write(3.9823);
//            out1.write(0.0243);
//        }
//        if (soc >= 0.925 && soc < 0.975)
//        {
//            out.write(4.0112);
//            out1.write(0.0239);
//        }
//        if (soc >= 0.975 && soc < 1)
//        {
//            out.write(4.2);
//            out1.write(0.0239);
//        }
//    }
//
//    SCA_CTOR(Vocv_publisher1)
//    {}
//};
//
//SCA_TDF_MODULE(Vocv_publisher2)           //Vvoc generator
//{
//    sca_tdf::sca_in<double> in;   // SOC
//    sca_tdf::sca_out<double> out, out1; // Vocv
//
//    void set_attributes()
//    {
//        set_timestep(1, SC_MS);
//
//    }
//
//    void processing()
//    {
//
//        double soc = in.read();
//        if (soc >= 0 && soc < 0.025)
//        {
//            out.write(2.0);
//            out1.write(0.001);
//        }
//        if (soc >= 0.025 && soc < 0.075)
//        {
//            out.write(2.6124);
//            out1.write(0.001);
//        }
//        if (soc >= 0.075 && soc < 0.125)
//        {
//            out.write(2.8037);
//            out1.write(0.003);
//        }
//        if (soc >= 0.125 && soc < 0.175)
//        {
//            out.write(2.9745);
//            out1.write(0.009);
//        }
//        if (soc >= 0.175 && soc < 0.225)
//        {
//            out.write(3.0441);
//            out1.write(0.01131);
//        }
//        if (soc >= 0.225 && soc < 0.275)
//        {
//            out.write(3.1227);
//            out1.write(0.0142);
//        }
//        if (soc >= 0.275 && soc < 0.325)
//        {
//            out.write(3.1490);
//            out1.write(0.015);
//        }
//        if (soc >= 0.325 && soc < 0.375)
//        {
//            out.write(3.1641);
//            out1.write(0.0149);
//        }
//        if (soc >= 0.375 && soc < 0.425)
//        {
//            out.write(3.1884);
//            out1.write(0.0153);
//        }
//        if (soc >= 0.425 && soc < 0.475)
//        {
//            out.write(3.1955);
//            out1.write(0.01552);
//        }
//        if (soc >= 0.475 && soc < 0.525)
//        {
//            out.write(3.2265);
//            out1.write(0.01636);
//        }
//        if (soc >= 0.525 && soc < 0.575)
//        {
//            out.write(3.2162);
//            out1.write(0.0154);
//        }
//        if (soc >= 0.575 && soc < 0.625)
//        {
//            out.write(3.2282);
//            out1.write(0.0157);
//        }
//        if (soc >= 0.625 && soc < 0.675)
//        {
//            out.write(3.2433);
//            out1.write(0.0161);
//        }
//        if (soc >= 0.675 && soc < 0.725)
//        {
//            out.write(3.2392);
//            out1.write(0.01562);
//        }
//        if (soc >= 0.725 && soc < 0.775)
//        {
//            out.write(3.2458);
//            out1.write(0.0157);
//        }
//        if (soc >= 0.775 && soc < 0.825)
//        {
//            out.write(3.2477);
//            out1.write(0.01536);
//        }
//        if (soc >= 0.825 && soc < 0.875)
//        {
//            out.write(3.2541);
//            out1.write(0.01564);
//        }
//        if (soc >= 0.875 && soc < 0.925)
//        {
//            out.write(3.2642);
//            out1.write(0.0152);
//        }
//        if (soc >= 0.925 && soc < 0.975)
//        {
//            out.write(3.2772);
//            out1.write(0.0154);
//        }
//        if (soc >= 0.975 && soc < 1)
//        {
//            out.write(3.45);
//            out1.write(0.0154);
//        }
//    }
//
//    SCA_CTOR(Vocv_publisher2)
//    {}
//};
//
//SCA_TDF_MODULE(Vout1)   //new battery vb
//{
//    sca_tdf::sca_in<double> in1, in2, in3;
//    sca_tdf::sca_out<double> out;
//    double Vo = 0;
//    double ESC2 = 0;
//    void set_attributes()
//    {
//        set_timestep(1, SC_MS);
//    }
//
//    void processing()
//    {
//        Vo = in1.read() - in2.read() * in3.read();
//        out.write(Vo);
//    }
//
//    SCA_CTOR(Vout1)
//    {}
//};
//
//SCA_TDF_MODULE(Vout2)   //old battery vb
//{
//    sca_tdf::sca_in<double> in1, in2, in3;
//    sca_tdf::sca_out<double> out;
//    double Vo1 = 0;
//    double ESC1 = 0;
//    void set_attributes()
//    {
//        set_timestep(1, SC_MS);
//    }
//
//    void processing()
//    {
//        Vo1 = in1.read() - in2.read() * in3.read();
//        out.write(Vo1);
//    }
//
//    SCA_CTOR(Vout2)
//    {}
//};
//
//
//
//int sc_main(int argc, char* argv[]) {
//
//    sca_tdf::sca_signal<double> Vo1,Vo2,R1,R2,Voc1,Voc2,Ib1,Ib2,SOC1,SOC2,T1,T2,Vin1,Vin2,ESC1,ESC2,w1,w2,alert1,alert2,Vb1,Vb2,sig1;
//    server server("server");
//    SOC_calculator SOC_calculator("SOC_calculator");
//    End_point End_point("End_point");
//    End_point2 End_point2("End_point2");
//    ESC ESC("ESC");
//    motor_blade motor_blade("motor_blade");
//    Vocv_publisher1 Vocv1("Vocv1");
//    Vocv_publisher2 Vocv2("Vocv2");
//    super_control super_control("super_control");
//    Vout1 Vout1("Vout1");
//    Vout2 Vout2("Vout2");
//
//    End_point.out(sig1);
//    End_point2.in1(Vin1);
//    End_point2.in2(Vin2);
//    End_point2.in3(alert1);
//    End_point2.in4(alert2);
//    
//    server.in(sig1);
//    server.out(T1);
//    server.out1(T2);
//
//    motor_blade.in1(T1);
//    motor_blade.in2(T2);
//    motor_blade.out1(Ib1);
//    motor_blade.out2(Ib2);
//
//    SOC_calculator.in1(Ib1);
//    SOC_calculator.in2(Ib2);
//    SOC_calculator.out1(SOC1);
//    SOC_calculator.out2(SOC2);
//    
//    ESC.in1(Vo1); 
//    ESC.in2(Vo2);  
//    ESC.in3(ESC1);
//    ESC.in4(ESC2);
//    ESC.out1(Vin1);
//    ESC.out2(Vin2);
//
//    super_control.in1(T1);
//    super_control.in2(T2);
//    super_control.in3(Vo1);
//    super_control.in4(Vo2);
//    super_control.out1(alert1);
//    super_control.out2(alert2);
//    super_control.out3(ESC1);
//    super_control.out4(ESC2);
//
//    Vocv1.in(SOC1);
//    Vocv1.out(Voc1); 
//    Vocv1.out1(R1); 
//
//    Vocv2.in(SOC2);
//    Vocv2.out(Voc2);
//    Vocv2.out1(R2);
//
//    Vout1.in1(Voc1);
//    Vout1.in2(Ib1);
//    Vout1.in3(R1);
//    Vout1.out(Vo1);
//
//    Vout2.in1(Voc2);
//    Vout2.in2(Ib2);
//    Vout2.in3(R2);
//    Vout2.out(Vo2);
//
//
//    sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("lifepo4_5.dat");
//    sca_util::sca_trace(atf, T1, "T1");
//    sca_util::sca_trace(atf, T2, "T2");
//    sca_util::sca_trace(atf, Vo1, "Vb1");
//    sca_util::sca_trace(atf, Vo2, "Vb2");
//    sca_util::sca_trace(atf, SOC1, "SOC1");
//    sca_util::sca_trace(atf, SOC2, "SOC2");
//    sca_util::sca_trace(atf, alert1, "alert1");
//    sca_util::sca_trace(atf, alert2, "alert2");
//
//    sc_start(200000, SC_SEC);
//
//    return 0;
//}

#pragma comment(lib, "ws2_32.lib")
int number = 50;
double Vin1 = 0, Vin2 = 0;
int index = 0;
std::string test = "0";

SCA_TDF_MODULE(End_point) {

    sca_tdf::sca_out<double> out;

    void set_attributes() {
        set_timestep(1, SC_MS);
    }
    void processing() {
        number++;
        out.write(number);
    }

    SCA_CTOR(End_point) {}
};

SCA_TDF_MODULE(End_point2) {

    sca_tdf::sca_in<double> in1, in2, in3, in4;

    void set_attributes() {
        set_timestep(1, SC_MS);
    }
    void processing() {

    }

    SCA_CTOR(End_point2) {}
};

SCA_TDF_MODULE(server) {
    sca_tdf::sca_in<double> in;
    sca_tdf::sca_out<double> out, out1;

    WSADATA wsaData;
    SOCKET servSock;
    SOCKET clntSock;
    char buffer[1024];

    void set_attributes() {
        set_timestep(1, SC_MS);
    }

    void initialize() {
        if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) {
            std::cerr << "WSAStartup failed." << std::endl;
            return;
        }
        servSock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
        if (servSock == INVALID_SOCKET) {
            std::cerr << "Socket creation failed." << std::endl;
            WSACleanup();
            return;
        }
        std::cout << "THE SERVER IS WAITING FOR CLIENT CONNECTION" << std::endl;
        struct sockaddr_in sockAddr;
        memset(&sockAddr, 0, sizeof(sockAddr));
        sockAddr.sin_family = AF_INET;
        sockAddr.sin_addr.s_addr = inet_addr("127.0.0.1");
        sockAddr.sin_port = htons(3000);

        if (bind(servSock, (SOCKADDR*)&sockAddr, sizeof(sockAddr)) == SOCKET_ERROR) {
            std::cerr << "Bind failed." << std::endl;
            closesocket(servSock);
            WSACleanup();
            return;
        }
        if (listen(servSock, 20) == SOCKET_ERROR) {
            std::cerr << "Listen failed." << std::endl;
            closesocket(servSock);
            WSACleanup();
            return;
        }
        struct sockaddr_in clntAddr;
        int nSize = sizeof(clntAddr);
        clntSock = accept(servSock, (SOCKADDR*)&clntAddr, &nSize);
        if (clntSock == INVALID_SOCKET) {
            std::cerr << "Accept failed." << std::endl;
            closesocket(servSock);
            WSACleanup();
            return;
        }
    }
    void processing() {
        char byteArray[4];
        int bytesReceived = recv(clntSock, byteArray, sizeof(byteArray), 0);


        send(clntSock, test.c_str(), test.size(), 0);
        if (bytesReceived > 0) {
            int A = static_cast<int>(byteArray[0]);
            int B = static_cast<int>(byteArray[1]);
            int C = static_cast<int>(byteArray[2]);
            int D = static_cast<int>(byteArray[3]);
            std::string number1 = std::to_string(A); // Convert int to string
            std::string number2 = std::to_string(B); // Convert int to string
            std::string number3 = std::to_string(C); // Convert int to string
            std::string number4 = std::to_string(D); // Convert int to string
            std::string sum = number1 + number2;
            std::string sum1 = number3 + number4;
            int E, F;
            E = stoi(sum);
            F = stoi(sum1);
            //std::cout << "T1=" << E << std::endl;
            //std::cout << "T2=" << F << std::endl;
            out.write(E);
            out1.write(F);
            index = 1;
        }
        else {
            index = 0;
        }
    }
    SCA_CTOR(server) {}
    ~server() {
        closesocket(clntSock);
        closesocket(servSock);
        WSACleanup();
    }
};

SCA_TDF_MODULE(super_control) {

    sca_tdf::sca_in<double> in1, in2, in3, in4;
    sca_tdf::sca_out<double> out1, out2, out3, out4;
    double ESC1 = 0, ESC2 = 0, w1 = 0, w2 = 0;
    int alert1 = 0;
    int alert2 = 0;
    double C1 = 0.03546;
    double A = 0.002363;
    double b = 0.0000006;
    double Kv = 42.5605;
    void set_attributes() {
        set_timestep(1, SC_MS);
    }

    void processing() {

        w1 = sqrt(2 * in1.read() / (C1 * A * 100 * 8));
        w2 = sqrt(2 * in2.read() / (C1 * A * 100 * 8));

        ESC1 = (w1 + b * w1 * w1 * Kv * Kv * 0.1) / (in3.read() * 6 * Kv);   //old battery ESC
        ESC2 = (w2 + b * w2 * w2 * Kv * Kv * 0.1) / (in4.read() * 6 * Kv);   //new battery ESC
        std::cout << "Receiving Data..." << std::endl;
        if (ESC1 > 1) {
            alert1 = 1;
        }
        if (ESC1 <= 1) {
            alert1 = 0;
        }
        if (ESC2 > 1) {
            alert2 = 1;
        }
        if (ESC2 <= 1) {
            alert2 = 0;
        }
        out1.write(alert1);
        out2.write(alert2);
        out3.write(ESC1);
        out4.write(ESC2);
    }

    SCA_CTOR(super_control) {}
};

SCA_TDF_MODULE(ESC) {

    sca_tdf::sca_in<double> in1, in2, in3, in4;
    sca_tdf::sca_out<double> out1, out2;
    double Vb1 = 0, Vb2 = 0;
    double ESC1 = 0, ESC2 = 0;
    void set_attributes() {
        set_timestep(1, SC_MS);
    }

    void processing() {
        ESC1 = in3.read();
        ESC2 = in4.read();
        Vb1 = in1.read();
        Vb2 = in2.read();
        Vin1 = Vb1 * ESC1;
        Vin2 = Vb2 * ESC2;
        out1.write(Vin1);
        out2.write(Vin2);
    }

    SCA_CTOR(ESC) {}
};

SCA_TDF_MODULE(ESCbuffer) {

    sca_tdf::sca_out<double> out1, out2;

    void set_attributes() {
        set_timestep(1, SC_MS);
    }

    void processing() {
       
        out1.write(Vin1);
        out2.write(Vin2);
    }

    SCA_CTOR(ESCbuffer) {}
};

SCA_TDF_MODULE(motor_blade) {

    sca_tdf::sca_in<double> in1, in2,in3,in4;
    sca_tdf::sca_out<double> out1, out2;
    double w1 = 0, w2 = 0, Ib1 = 0, Ib2 = 0, Im1 = 0, Im2 = 0, Q1 = 0, Q2 = 0, T1, T2,Vin1,Vin2;
    double C1 = 0.03546;
    double A = 0.002363;
    double b = 0.0000006;
    double Kv = 42.5605;
    void set_attributes() {
        set_timestep(1, SC_MS);
    }

    void processing() {
        T1 = in1.read();
        T2 = in2.read();

        w1 = sqrt(2 * T1 / (C1 * A * 100 * 8));
        w2 = sqrt(2 * T2 / (C1 * A * 100 * 8));   //simplified by super control logic

        Q1 = b * w1 * w1 * 8;
        Q2 = b * w2 * w2 * 8;

        Im1 = Q1 * Kv;
        Im2 = Q2 * Kv;

        Ib1 = 1.19 + Im1;
        Ib2 = 1.19 + Im2;

        out1.write(Ib1);
        out2.write(Ib2);

    }

    SCA_CTOR(motor_blade) {}
};

SCA_TDF_MODULE(SOC_calculator) {        //SOC calculator
    sca_tdf::sca_in<double> in1, in2;
    sca_tdf::sca_out<double> out1, out2;
    double w1 = 0;
    double w = 0;
    double prev_soc1 = 1;
    double prev_soc2 = 1;
    double c_bat1 = 5000 * 3600;
    double c_bat2 = 3000 * 3600;
    double percentage1 = 0;
    double percentage2 = 0;
    double Ib1 = 0;
    double Ib2 = 0;

    void set_attributes() {
        set_timestep(1, SC_MS);
    }
    void processing() {

        Ib1 = in1.read();
        Ib2 = in2.read();
        percentage1 = prev_soc1 - Ib1 * 5 * 15 / c_bat1;
        percentage2 = prev_soc2 - Ib2 * 5 * 15 / c_bat2;
        prev_soc1 = percentage1;
        prev_soc2 = percentage2;
        if (percentage1 <= 0) {
            percentage1 = 0;
            Ib1 = 0;

        }
        if (percentage2 <= 0) {
            percentage2 = 0;
            Ib2 = 0;
            test = "1";

        }
        out1.write(percentage1);
        out2.write(percentage2);

    }
    SCA_CTOR(SOC_calculator) {}
};

SCA_TDF_MODULE(Vocv_publisher1)           //Vvoc generator
{
    sca_tdf::sca_in<double> in;   // SOC
    sca_tdf::sca_out<double> out, out1; // Vocv

    void set_attributes()
    {
        set_timestep(1, SC_MS);

    }

    void processing()
    {

        double soc = in.read();
        if (soc >= 0 && soc < 0.025)
        {
            out.write(2.5);
            out1.write(0.0185);
        }
        if (soc >= 0.025 && soc < 0.075)
        {
            out.write(2.9535);
            out1.write(0.0185);
        }
        if (soc >= 0.075 && soc < 0.125)
        {
            out.write(3.1020);
            out1.write(0.0167);
        }
        if (soc >= 0.125 && soc < 0.175)
        {
            out.write(3.2285);
            out1.write(0.0165);
        }
        if (soc >= 0.175 && soc < 0.225)
        {
            out.write(3.3359);
            out1.write(0.0182);
        }
        if (soc >= 0.225 && soc < 0.275)
        {
            out.write(3.3982);
            out1.write(0.0180);
        }
        if (soc >= 0.275 && soc < 0.325)
        {
            out.write(3.4507);
            out1.write(0.0187);
        }
        if (soc >= 0.325 && soc < 0.375)
        {
            out.write(3.4946);
            out1.write(0.0188);
        }
        if (soc >= 0.375 && soc < 0.425)
        {
            out.write(3.5375);
            out1.write(0.0191);
        }
        if (soc >= 0.425 && soc < 0.475)
        {
            out.write(3.5937);
            out1.write(0.0203);
        }
        if (soc >= 0.475 && soc < 0.525)
        {
            out.write(3.6486);
            out1.write(0.0214);
        }
        if (soc >= 0.525 && soc < 0.575)
        {
            out.write(3.7004);
            out1.write(0.0224);
        }
        if (soc >= 0.575 && soc < 0.625)
        {
            out.write(3.7462);
            out1.write(0.0228);
        }
        if (soc >= 0.625 && soc < 0.675)
        {
            out.write(3.7916);
            out1.write(0.0234);
        }
        if (soc >= 0.675 && soc < 0.725)
        {
            out.write(3.8325);
            out1.write(0.0236);
        }
        if (soc >= 0.725 && soc < 0.775)
        {
            out.write(3.8858);
            out1.write(0.0246);
        }
        if (soc >= 0.775 && soc < 0.825)
        {
            out.write(3.9362);
            out1.write(0.0257);
        }
        if (soc >= 0.825 && soc < 0.875)
        {
            out.write(3.9724);
            out1.write(0.0256);
        }
        if (soc >= 0.875 && soc < 0.925)
        {
            out.write(3.9823);
            out1.write(0.0243);
        }
        if (soc >= 0.925 && soc < 0.975)
        {
            out.write(4.0112);
            out1.write(0.0239);
        }
        if (soc >= 0.975 && soc < 1)
        {
            out.write(4.2);
            out1.write(0.0239);
        }
    }

    SCA_CTOR(Vocv_publisher1)
    {}
};

SCA_TDF_MODULE(Vocv_publisher2)           //Vvoc generator
{
    sca_tdf::sca_in<double> in;   // SOC
    sca_tdf::sca_out<double> out, out1; // Vocv

    void set_attributes()
    {
        set_timestep(1, SC_MS);

    }

    void processing()
    {

        double soc = in.read();
        if (soc >= 0 && soc < 0.025)
        {
            out.write(2.0);
            out1.write(0.001);
        }
        if (soc >= 0.025 && soc < 0.075)
        {
            out.write(2.6124);
            out1.write(0.001);
        }
        if (soc >= 0.075 && soc < 0.125)
        {
            out.write(2.8037);
            out1.write(0.003);
        }
        if (soc >= 0.125 && soc < 0.175)
        {
            out.write(2.9745);
            out1.write(0.009);
        }
        if (soc >= 0.175 && soc < 0.225)
        {
            out.write(3.0441);
            out1.write(0.01131);
        }
        if (soc >= 0.225 && soc < 0.275)
        {
            out.write(3.1227);
            out1.write(0.0142);
        }
        if (soc >= 0.275 && soc < 0.325)
        {
            out.write(3.1490);
            out1.write(0.015);
        }
        if (soc >= 0.325 && soc < 0.375)
        {
            out.write(3.1641);
            out1.write(0.0149);
        }
        if (soc >= 0.375 && soc < 0.425)
        {
            out.write(3.1884);
            out1.write(0.0153);
        }
        if (soc >= 0.425 && soc < 0.475)
        {
            out.write(3.1955);
            out1.write(0.01552);
        }
        if (soc >= 0.475 && soc < 0.525)
        {
            out.write(3.2265);
            out1.write(0.01636);
        }
        if (soc >= 0.525 && soc < 0.575)
        {
            out.write(3.2162);
            out1.write(0.0154);
        }
        if (soc >= 0.575 && soc < 0.625)
        {
            out.write(3.2282);
            out1.write(0.0157);
        }
        if (soc >= 0.625 && soc < 0.675)
        {
            out.write(3.2433);
            out1.write(0.0161);
        }
        if (soc >= 0.675 && soc < 0.725)
        {
            out.write(3.2392);
            out1.write(0.01562);
        }
        if (soc >= 0.725 && soc < 0.775)
        {
            out.write(3.2458);
            out1.write(0.0157);
        }
        if (soc >= 0.775 && soc < 0.825)
        {
            out.write(3.2477);
            out1.write(0.01536);
        }
        if (soc >= 0.825 && soc < 0.875)
        {
            out.write(3.2541);
            out1.write(0.01564);
        }
        if (soc >= 0.875 && soc < 0.925)
        {
            out.write(3.2642);
            out1.write(0.0152);
        }
        if (soc >= 0.925 && soc < 0.975)
        {
            out.write(3.2772);
            out1.write(0.0154);
        }
        if (soc >= 0.975 && soc < 1)
        {
            out.write(3.45);
            out1.write(0.0154);
        }
    }

    SCA_CTOR(Vocv_publisher2)
    {}
};

SCA_TDF_MODULE(Vout1)   //new battery vb
{
    sca_tdf::sca_in<double> in1, in2, in3;
    sca_tdf::sca_out<double> out;
    double Vo = 0;
    double ESC2 = 0;
    void set_attributes()
    {
        set_timestep(1, SC_MS);
    }

    void processing()
    {
        Vo = in1.read() - in2.read() * in3.read();
        out.write(Vo);
    }

    SCA_CTOR(Vout1)
    {}
};

SCA_TDF_MODULE(Vout2)   //old battery vb
{
    sca_tdf::sca_in<double> in1, in2, in3;
    sca_tdf::sca_out<double> out;
    double Vo1 = 0;
    double ESC1 = 0;
    void set_attributes()
    {
        set_timestep(1, SC_MS);
    }

    void processing()
    {
        Vo1 = in1.read() - in2.read() * in3.read();
        out.write(Vo1);
    }

    SCA_CTOR(Vout2)
    {}
};



int sc_main(int argc, char* argv[]) {

    sca_tdf::sca_signal<double> Vo1, Vo2, R1, R2, Voc1, Voc2, Ib1, Ib2, SOC1, SOC2, T1, T2, Vin1, Vin2, ESC1, ESC2, w1, w2, alert1, alert2, Vb1, Vb2, sig1,Vin1b,Vin2b;
    server server("server");
    SOC_calculator SOC_calculator("SOC_calculator");
    End_point End_point("End_point");
    End_point2 End_point2("End_point2");
    ESC ESC("ESC");
    motor_blade motor_blade("motor_blade");
    Vocv_publisher1 Vocv1("Vocv1");
    Vocv_publisher2 Vocv2("Vocv2");
    super_control super_control("super_control");
    Vout1 Vout1("Vout1");
    Vout2 Vout2("Vout2");
    ESCbuffer ESCbuffer("ESCbuffer");

    End_point.out(sig1);
    End_point2.in1(Vin1);
    End_point2.in2(Vin2);
    End_point2.in3(alert1);
    End_point2.in4(alert2);

    server.in(sig1);
    server.out(T1);
    server.out1(T2);

    ESCbuffer.out1(Vin1b);
    ESCbuffer.out2(Vin2b);

    motor_blade.in1(T1);
    motor_blade.in2(T2);
    motor_blade.in3(Vin1b);
    motor_blade.in4(Vin2b);
    motor_blade.out1(Ib1);
    motor_blade.out2(Ib2);

    SOC_calculator.in1(Ib1);
    SOC_calculator.in2(Ib2);
    SOC_calculator.out1(SOC1);
    SOC_calculator.out2(SOC2);

    ESC.in1(Vo1);
    ESC.in2(Vo2);
    ESC.in3(ESC1);
    ESC.in4(ESC2);
    ESC.out1(Vin1);
    ESC.out2(Vin2);

    super_control.in1(T1);
    super_control.in2(T2);
    super_control.in3(Vo1);
    super_control.in4(Vo2);
    super_control.out1(alert1);
    super_control.out2(alert2);
    super_control.out3(ESC1);
    super_control.out4(ESC2);

    Vocv1.in(SOC1);
    Vocv1.out(Voc1);
    Vocv1.out1(R1);

    Vocv2.in(SOC2);
    Vocv2.out(Voc2);
    Vocv2.out1(R2);

    Vout1.in1(Voc1);
    Vout1.in2(Ib1);
    Vout1.in3(R1);
    Vout1.out(Vo1);

    Vout2.in1(Voc2);
    Vout2.in2(Ib2);
    Vout2.in3(R2);
    Vout2.out(Vo2);


    sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("lifepo4_5.dat");
    sca_util::sca_trace(atf, T1, "T1");
    sca_util::sca_trace(atf, T2, "T2");
    sca_util::sca_trace(atf, Vo1, "Vb1");
    sca_util::sca_trace(atf, Vo2, "Vb2");
    sca_util::sca_trace(atf, SOC1, "SOC1");
    sca_util::sca_trace(atf, SOC2, "SOC2");
    sca_util::sca_trace(atf, alert1, "alert1");
    sca_util::sca_trace(atf, alert2, "alert2");

    sc_start(200000, SC_SEC);

    return 0;
}