from tensorflow.keras.models import load_model
import joblib
import numpy as np
import scipy.io

# Correct the path to point to the correct folder
model_path = "C:/Users/alima/PycharmProjects/pythonProject26/my_trained_model_30.keras"
input_file = "C:/Users/alima/Downloads/ALI MAKKI'S THESIS/data30.mat"
scaler_X_path = "C:/Users/alima/PycharmProjects/pythonProject26/scaler_X.pkl"
scaler_y_path = "C:/Users/alima/PycharmProjects/pythonProject26/scaler_Y.pkl"
test_file = "C:/Users/alima/Downloads/ALI MAKKI'S THESIS/lmax30.mat"

# Load the model
try:
    model = load_model(model_path)
    print("Model loaded successfully.")
except Exception as e:
    print(f"Error loading model: {e}")
    exit()

# Load the scalers
try:
    scaler_X = joblib.load(scaler_X_path)
    scaler_y = joblib.load(scaler_y_path)
    print("Scalers loaded successfully.")
except Exception as e:
    print(f"Error loading scalers: {e}")
    exit()

# Load new data from the MATLAB .mat file
try:
    mat_data = scipy.io.loadmat(input_file)

    # Extract the input vectors
    vector_3dB_cleaned = mat_data['vector_3dB_cleaned']
    vector_5dB_cleaned = mat_data['vector_5dB_cleaned']
    vector_10dB_cleaned = mat_data['vector_10dB_cleaned']
    vector_equiv_cleaned = mat_data['vector_equiv_cleaned']

    # Combine the input vectors into a single array
    new_data = np.column_stack((vector_3dB_cleaned, vector_5dB_cleaned, vector_10dB_cleaned, vector_equiv_cleaned))

    # Scale the input data using the same scaler as during training
    new_data_scaled = scaler_X.transform(new_data)
    print("Input data loaded and scaled successfully.")
except Exception as e:
    print(f"Error loading or scaling input data: {e}")
    exit()

# Load test data (actual Lmax values)
try:
    test_data = scipy.io.loadmat(test_file)
    y_test_scaled = test_data['Lmax_all_vector_cleaned']  # Assuming this is your test vector
    print("Test data loaded and inverse transformed successfully.")
except Exception as e:
    print(f"Error loading test data: {e}")
    exit()

# Make predictions on the scaled input data
try:
    y_pred_scaled = model.predict(new_data_scaled)

    # Inverse transform the predicted values back to the original scale
    y_pred = scaler_y.inverse_transform(y_pred_scaled)

    # Print the predicted values
    print("Predicted Lmax:", y_pred)

    # Calculate the percentage difference between actual and predicted values
    percentage_difference = np.abs((y_test_scaled - y_pred) / y_test_scaled) * 100
    mean_percentage_difference = np.mean(percentage_difference)
    # Print the overall mean percentage difference
    print(f"Overall Mean Percentage Difference: {mean_percentage_difference:.2f}%")
except Exception as e:
    print(f"Error making predictions: {e}")

