close all ;
% Step 1: Load data 
load('MMF_transferFunctions_OM4_400m.mat');
load('DataBER_106.25G_OM4.mat');
load('DataLmax_106.25G_OM4.mat');
% Step 2: Extract relevant variables

Lambdas = Lambdas;
Laszers = Laser;
frequencies = freq;
Transfer_fct_MMF_OM4 = Hf_MMF_OM4;
EMB_OM4 = EMB_OM4;
Group_delay_OM4 = taug_OM4;

% Step 3: Decide on the type of plot
% For example, let's say you want to plot the transfer functions for a specific wavelength and laser

% Choose a wavelength and laser index
%lambda_idx = 1; % Change this index as needed
%laser_idx = 1;  % Change this index as needed

%Extract transfer functions for the chosen wavelength and laser

laser_idx = 1;
laser_index=1;
lambda_idx = 1;
fiber_index = 1;
wavelength_index=1;
            transfer_function = squeeze(Hf_MMF_OM4(lambda_idx, laser_idx, :, 1));

                % Step 4: Generate the plot
                figure;
                plot(freq, 10*log10(abs(transfer_function)));
                xlabel('Frequency');
                ylabel('Transfer Function');
                title('Transfer Function vs. Frequency at wavelength ',Lambdas(lambda_idx));
                grid on;
                
                % Step 5: Customize the plot
                % Add legend indicating mode groups
                %legendCell = cellstr(num2str((1:size(taug_OM4, 3))', 'Mode Group %d'));
                %legend(legendCell);
 % Assuming freq and Hf_MMF_OM4 are already defined and loaded correctly

% Set reference distance and reference transfer function at 400m for a specific laser and wavelength
Lref = 400; % Reference distance in meters
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
reference_TF_dB = 10*log10(reference_TF/max(reference_TF)); % Convert to dB normalized to max
%Prepare a plot
figure;
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

desired_distances=Lengths(2:end);
% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
    TF_scaled = interp1(freq_scaled, TF, freq, "linear");
    
    % Normalize to the maximum value at 400m
    TF_scaled_dB = 10*log10(abs(TF_scaled/max(reference_TF))); % Convert to dB normalized to max at 400m

    % Plot
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;




% Prepare the plot
figure;

% Loop over the desired distances
for L = desired_distances
    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Check for at least two points after scaling within the original frequency bounds
    valid_indices = find(freq_scaled >= min(freq) & freq_scaled <= max(freq));
    if numel(valid_indices) < 2
        disp(['Not enough points to interpolate for length ' num2str(L) 'm. Skipping this length.']);
        continue;  % Skip to the next iteration if not enough points
    end

    % Interpolate using the scaled frequency within bounds
    TF_scaled = interp1(freq(valid_indices), TF(valid_indices), freq, 'linear');

    % Normalize to the peak of the transfer function at the reference length
    TF_scaled_dB = 10 * log10(TF_scaled / max(TF));

    % Plot the normalized scaled transfer function
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
    hold on;
end

% Reference transfer function in dB, normalized to its own peak value
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
reference_TF_dB = 10 * log10(reference_TF / max(reference_TF));
plot(freq/1e9, reference_TF_dB, 'LineWidth', 2, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;
... [setup code] ...

%Prepare the plot
figure;

% Plot reference TF in dB, normalized to its own max
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
reference_TF_dB = 10 * log10(reference_TF / max(reference_TF));
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

% Loop over the other lengths
for L = desired_distances
    if L == Lref
        continue; % Skip the reference length
    end

    % Calculate scaling factor K
    K = Lref / L;
    
    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF_scaled = interp1(freq, reference_TF, freq_scaled, 'linear');
    
    % Normalize to the max at reference length and convert to dB
    TF_scaled_dB = 10 * log10(TF_scaled / max(reference_TF));
    
    % Plot the scaled TF in dB
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;
... [setup code] ...

%Prepare the plot
figure;
hold on;

% Normalize the reference transfer function to its own peak
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
max_ref_TF = max(reference_TF);
reference_TF_dB = 10 * log10(reference_TF / max_ref_TF);
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz

% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate scaling factor K
    K = Lref / L;
    
    % Scale the frequency axis
    freq_scaled = freq * K;
    
    % Get the original transfer function (for each length)
    original_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));

    % Interpolate using 'pchip' method to avoid overshooting
    TF_scaled = interp1(freq_scaled, original_TF,freq , 'linear');

    % Normalize the scaled transfer function to the peak of the reference transfer function
    TF_scaled_dB = 10 * log10(TF_scaled / max_ref_TF);

    % Correct any negative infinity values that may result from log of zero
    TF_scaled_dB(isinf(TF_scaled_dB)) = min(TF_scaled_dB(~isinf(TF_scaled_dB)));
    
    % Plot the scaled and normalized TF in dB
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;


 % ... [setup code] ...

% Prepare the plot
figure;
hold on;

% Normalize the reference transfer function to its own peak
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
max_ref_TF = max(reference_TF);
reference_TF_dB = 10 * log10(reference_TF / max_ref_TF);
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz

% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate scaling factor K
    K = Lref / L;
    
    % Scale the frequency axis
    freq_scaled = freq * K;
    
    % Get the original transfer function (for each length)
    original_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));

    % Interpolate using 'pchip' method to avoid overshooting
    TF_scaled = interp1(freq_scaled, original_TF,freq , 'linear');

    % Normalize the scaled transfer function to the peak of the reference transfer function
    TF_scaled_dB = 10 * log10(TF_scaled / max_ref_TF);

    % Cap values at 0 dB
    TF_scaled_dB(TF_scaled_dB > 0) = 0;
    
    % Plot the scaled and normalized TF in dB
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend('-DynamicLegend');
grid on;

% Set the x-axis limits from 0 to 100 GHz
xlim([0 100]);

hold off;


% Assuming you have already loaded your data:
% - Hf_MMF_OM4 for transfer functions
% - BER_OM4 for Bit Error Rates

% For Transfer Functions:
% Choose a specific fiber, laser, and wavelength to analyze
fiber_index = 1;
laser_index = 1;
wavelength_index = 1;

% Extract the absolute values of the transfer function
TF_values = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index)));

% Plot histogram of the Transfer Function magnitudes
figure;
histogram(TF_values, 50); % 50 bins
title('Histogram of Transfer Function Magnitudes');
xlabel('Magnitude');
ylabel('Frequency');

% For BER values:
% Flatten the BER matrix to a single vector for simplicity
BER_values = BER_OM4(:);

% Plot histogram of the BER values
figure;
histogram(BER_values, 50); % 50 bins
title('Histogram of BER Values');
xlabel('BER');
ylabel('Frequency');

% % Assuming you've calculated -3dB bandwidths as 'bandwidth_3dB'
% % Plot histogram of the -3dB Bandwidth values
% figure;
% histogram(bandwidth_3dB, 50); % 50 bins
% title('Histogram of -3dB Bandwidths');
% xlabel('-3dB Bandwidth (Hz)');
% ylabel('Frequency');
% 
%%%%%%%%%%%%%%%%%%%%5






%%%%%%%%%%%%%%%%%%%%%%
% Initialize an array to store the -3dB bandwidth for each fiber
NOM4 = size(Hf_MMF_OM4, 4);  % Number of fibers
bandwidths_3dB = zeros(NOM4, 1);

% Select indices for the specific wavelength and laser
wavelength_index = 1;  % replace with the index of your selected wavelength
laser_index = 1;       % replace with the index of your selected laser

% Iterate over all fibers
for fiber_index = 1:NOM4
    % Extract the transfer function for this specific fiber
    TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

    % Calculate the -3dB bandwidth for the current fiber
    bandwidths_3dB(fiber_index) = calculateMinus3dBBandwidth(TF_selected, freq);
end

% Display the result for all fibers
for i = 1:NOM4
    fprintf('The -3dB bandwidth for fiber %d is %f Hz\n', i, bandwidths_3dB(i));
end

% Initialize an array to store the -3dB bandwidth for each fiber
NOM4 = size(Hf_MMF_OM4, 4);  % Number of fibers
bandwidths_5dB = zeros(NOM4, 1);

% Select indices for the specific wavelength and laser
wavelength_index = 1;  % replace with the index of your selected wavelength
laser_index = 1;       % replace with the index of your selected laser

% Iterate over all fibers
for fiber_index = 1:NOM4
    % Extract the transfer function for this specific fiber
    TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

    % Calculate the -3dB bandwidth for the current fiber
    bandwidths_5dB(fiber_index) = calculateMinus5dBBandwidth(TF_selected, freq);
end

% Display the result for all fibers
for i = 1:NOM4
    fprintf('The -3dB bandwidth for fiber %d is %f Hz\n', i, bandwidths_5dB(i));
end
% Initialize an array to store the -3dB bandwidth for each fiber
NOM4 = size(Hf_MMF_OM4, 4);  % Number of fibers
bandwidths_10dB = zeros(NOM4, 1);

% Select indices for the specific wavelength and laser
wavelength_index = 1;  % replace with the index of your selected wavelength
laser_index = 1;       % replace with the index of your selected laser

% Iterate over all fibers
for fiber_index = 1:NOM4
    % Extract the transfer function for this specific fiber
    TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

    % Calculate the -3dB bandwidth for the current fiber
    bandwidths_10dB(fiber_index) = calculateMinus10dBBandwidth(TF_selected, freq);
end

% Display the result for all fibers
for i = 1:NOM4
    fprintf('The -3dB bandwidth for fiber %d is %f Hz\n', i, bandwidths_10dB(i));
end


% Initialize an array to store the equivalent bandwidth for each fiber
NOM4 = size(Hf_MMF_OM4, 4);  % Number of fibers
equivalent_bandwidths = zeros(NOM4, 1);

% Select indices for the specific wavelength and laser
wavelength_index = 1;  % replace with the index of your selected wavelength
laser_index = 1;       % replace with the index of your selected laser

% Iterate over all fibers
for fiber_index = 1:NOM4
    % Extract the transfer function for this specific fiber
    TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

    % Calculate the equivalent bandwidth for the current fiber
    equivalent_bandwidths(fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
end

% Display the result for all fibers
for i = 1:NOM4
    fprintf('The equivalent bandwidth for fiber %d is %.2f Hz\n', i, equivalent_bandwidths(i));
end
%%%%%%%%%%%%%%%
% Assuming the dimensions for Hf_MMF_OM4 are [wavelengths, lasers, frequencies, fibers]
numWavelengths = size(Hf_MMF_OM4, 1);
numLasers = size(Hf_MMF_OM4, 2);
numFibers = size(Hf_MMF_OM4, 4);

% Initialize an array to store the equivalent bandwidths
equivalent_bandwidths_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_3dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_5dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_10dB_all = zeros(numWavelengths, numLasers, numFibers);
% Iterate over all wavelengths, lasers, and fibers
for wavelength_index = 1:numWavelengths
    for laser_index = 1:numLasers
        for fiber_index = 1:numFibers
            % Extract the transfer function for this specific combination
            TF_selected = squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, fiber_index));

            % Calculate the equivalent bandwidth for the current combination
            equivalent_bandwidths_all(wavelength_index, laser_index, fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
            bandwidths_3dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus3dBBandwidth(TF_selected, freq);
            bandwidths_5dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus5dBBandwidth(TF_selected, freq);
            bandwidths_10dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus10dBBandwidth(TF_selected, freq);
        end
    end
end
% Reshape the 3D arrays into 1D vectors
vector_equiv = reshape(equivalent_bandwidths_all, [], 1);
vector_3dB = reshape(bandwidths_3dB_all, [], 1);
vector_5dB = reshape(bandwidths_5dB_all, [], 1);
vector_10dB = reshape(bandwidths_10dB_all, [], 1);

% Display the size of the new vector to confirm the operation
disp(size(vector_equiv));
disp(size(vector_3dB));
disp(size(vector_5dB));
disp(size(vector_10dB));


% Ensure all bandwidth arrays are column vectors of the same length
bandwidths_3dB = reshape(bandwidths_3dB, [], 1);
bandwidths_5dB = reshape(bandwidths_5dB, [], 1);
bandwidths_10dB = reshape(bandwidths_10dB, [], 1);
equivalent_bandwidths = reshape(equivalent_bandwidths, [], 1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all ; 

% Assuming indices for lambda, laser, and equalizer are all 1
% Reshape the 3D arrays into 1D vectors
vector_equiv = reshape(equivalent_bandwidths_all, [], 1);
vector_3dB = reshape(bandwidths_3dB_all, [], 1);
vector_5dB = reshape(bandwidths_5dB_all, [], 1);
vector_10dB = reshape(bandwidths_10dB_all, [], 1);
Lengths = [0 30 50 70 100 150 200 250 300 350 400];  % Distances in meters
lambda_index=1;
laser_index=1;
equalizer_index=1;
% Extract the BER data for the specific setting across all fibers and distances
BER_selected_new = squeeze(BER_OM4(:, :, 1, :, :));  % Resulting size should be [NOM4 x Ndist]
BER_selected_new_reshaped =reshape(BER_selected_new, [], 11);
% Extract the last slice of the fourth dimension
last_slice = BER_selected_new(:, :, :, 11);
%BER_selected = squeeze(BER_OM4(lambda_index, laser_index, equalizer_index, :, :));  % Resulting size should be [NOM4 x Ndist]
BER_selected_test = squeeze(BER_OM4(:, :, 1, :, 11));  % Resulting size should be [8 x 4 x 3766]
BER_selected_vector = reshape(BER_selected_test, [], 1);  % The empty bracket automatically calculates the necessary size
% Reshape bandwidth matrices to match the number of rows in BER_selected (NOM4)

%Create a matrix of all bandwidths and Lmax
data_matrix = [vector_3dB vector_5dB vector_10dB vector_equiv BER_selected_vector];
correlation_matrix = corr(data_matrix, 'Rows', 'complete');  % 'complete' to ignore NaN values
% Display the correlation matrix
disp('Correlation matrix:');
disp(correlation_matrix);

figure;
labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', 'BER'};
heatmap(labels, labels, correlation_matrix);
title('Correlation Heatmap between Bandwidth Features and Lmax');

% bandwidths_3dB_repeated = repmat(bandwidths_3dB, 1, 11);
% bandwidths_5dB_repeated = repmat(bandwidths_5dB, 1, 11);
% bandwidths_10dB_repeated = repmat(bandwidths_10dB, 1, 11);
% equivalent_bandwidths_repeated = repmat(equivalent_bandwidths, 1, 11);
vector_equiv_rep = repmat(vector_equiv, 1,11);
vector_3dB_rep = repmat(vector_3dB, 1,11);
vector_5dB_rep = repmat(vector_5dB, 1,11);
vector_10dB_rep = repmat(vector_10dB, 1,11);
% Combine the data
data_matrix = [vector_3dB_rep vector_5dB_rep vector_10dB_rep vector_equiv_rep las];
% Initialize an array to store the correlation matrices for each distance
correlation_matrices = cell(1, 11);  % Assuming there are 11 distances
equivalent_bw_ber_correlations = zeros(1, 11);  % To store the correlation between equivalent bandwidth and BER

for dist_index = 11
    % Select the columns corresponding to each bandwidth metric and the BER at the current distance
    current_data_matrix = data_matrix(:, [dist_index, 11+dist_index, 22+dist_index, 33+dist_index, 44+dist_index]);

    % Calculate the correlation matrix for the current distance
    correlation_matrices{dist_index} = corr(current_data_matrix, 'Rows', 'complete');
    
    % Extract the correlation between equivalent bandwidth and BER at each distance
    equivalent_bw_ber_correlations(dist_index) = correlation_matrices{dist_index}(4, 5);  % Assuming equivalent bandwidth is the 4th metric and BER is the 5th metric
    
    % Optionally, display the correlation matrix
    fprintf('Correlation matrix for distance %d:\n', dist_index);
    disp(correlation_matrices{dist_index});

    % Create a heatmap for visualizing the correlation matrix
    labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', [sprintf('BER at %d m', Lengths(dist_index))]};
    figure;
    heatmap(labels, labels, correlation_matrices{dist_index});
    title(['Correlation Heatmap at Distance ', sprintf('BER at %d m', Lengths(dist_index))]);
end

% Plot the correlation between Equivalent Bandwidth and BER over distances
figure;
plot(Lengths, equivalent_bw_ber_correlations, '-o');
xlabel('Distance (m)');
ylabel('Correlation Coefficient');
title('Correlation between Equivalent Bandwidth and BER vs Distance');
grid on;

% Assuming indices for lambda, laser, and equalizer are all 1
lambda_index = 1;
laser_index = 1;
equalizer_index = 1;
Lengths = [0 30 50 70 100 150 200 250 300 350 400];% Distances in meters
% Extract the BER data for the specific setting across all fibers and distances
BER_selected = squeeze(BER_OM4(lambda_index, laser_index, equalizer_index, :, :));  % Resulting size should be [NOM4 x Ndist]

% Reshape bandwidth matrices to match the number of rows in BER_selected (NOM4)
bandwidths_3dB_repeated = repmat(bandwidths_3dB, 1, 11);
bandwidths_5dB_repeated = repmat(bandwidths_5dB, 1, 11);
bandwidths_10dB_repeated = repmat(bandwidths_10dB, 1, 11);
equivalent_bandwidths_repeated = repmat(equivalent_bandwidths, 1, 11);

% Combine the data
data_matrix = [bandwidths_3dB_repeated bandwidths_5dB_repeated bandwidths_10dB_repeated equivalent_bandwidths_repeated BER_selected];
% Initialize an array to store the correlation matrices for each distance
correlation_matrices = cell(1, 11);  % Assuming there are 11 distances

for dist_index = 11
    % Select the columns corresponding to each bandwidth metric and the BER at the current distance
    current_data_matrix = data_matrix(:, [dist_index, 11+dist_index, 22+dist_index, 33+dist_index, 44+dist_index]);

    % Calculate the correlation matrix for the current distance
    correlation_matrices{dist_index} = corr(current_data_matrix, 'Rows', 'complete');
    
    % Optionally, display the correlation matrix
    fprintf('Correlation matrix for distance %d:\n', dist_index);
    disp(correlation_matrices{dist_index});

    % Create a heatmap for visualizing the correlation matrix
    labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', [sprintf('BER at %d m', Lengths(dist_index))]};
    figure;
    heatmap(labels, labels, correlation_matrices{dist_index});
    title(['Correlation Heatmap at Distance ', sprintf('BER at %d m', Lengths(dist_index))]);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate combined features
mean_3dB_EqBW = (bandwidths_3dB + equivalent_bandwidths) / 2;  % Mean of -3dB and Equivalent Bandwidth
mean_3dB_5dB_EqBW = (bandwidths_3dB + bandwidths_5dB + equivalent_bandwidths) / 3;  % Mean of -3dB, -5dB, and Equivalent Bandwidth
mean_3dB_5dB = (bandwidths_3dB + bandwidths_5dB) / 2;  % Mean of -3dB and -5dB

% Add these combinations to your data matrix
data_matrix1 = [bandwidths_3dB, bandwidths_5dB, bandwidths_10dB, equivalent_bandwidths, mean_3dB_EqBW, mean_3dB_5dB_EqBW, mean_3dB_5dB, Lmax_per_fiber];
% Calculate the new correlation matrix
correlation_matrix = corr(data_matrix1, 'Rows', 'complete');  % 'complete' to ignore NaN values
% Define new labels including combined features
labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', 'Mean of -3dB & EqBW', 'Mean of -3dB, -5dB & EqBW', 'Mean of -3dB & -5dB', 'Lmax'};

% Display the correlation matrix
disp('Updated Correlation Matrix:');
disp(array2table(correlation_matrix, 'RowNames', labels, 'VariableNames', labels));

% Generate heatmap for visual correlation analysis
figure;
heatmap(labels, labels, correlation_matrix, 'Colormap', jet, 'CellLabelColor', 'none');
title('Correlation Heatmap with Combined Bandwidth Features and Lmax');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Calculate weighted averages
weighted_3dB_EqBW = (2 * bandwidths_3dB + equivalent_bandwidths) / 3;  % More weight to -3dB
weighted_3dB_5dB_EqBW = (bandwidths_3dB + 2 * bandwidths_5dB + 3 * equivalent_bandwidths) / 6;  % Different weights

% Update data matrix
data_matrix2 = [data_matrix, weighted_3dB_EqBW, weighted_3dB_5dB_EqBW];

% Calculate harmonic and geometric means
harmonic_3dB_5dB = 2 * (bandwidths_3dB .* bandwidths_5dB) ./ (bandwidths_3dB + bandwidths_5dB);
geometric_3dB_EqBW = sqrt(bandwidths_3dB .* equivalent_bandwidths);

% Update data matrix
data_matrix2 = [data_matrix2, harmonic_3dB_5dB, geometric_3dB_EqBW];



% Assuming bandwidths_3dB, bandwidths_5dB, bandwidths_10dB, and equivalent_bandwidths are defined

% Ratios
% ratios_3dB_to_10dB = bandwidths_3dB ./ bandwidths_10dB;
% 
% % Differences
% diff_equiv_3dB = equivalent_bandwidths - bandwidths_3dB;
% 
% % Polynomial Features (square of the equivalent bandwidth)
% equiv_bandwidth_squared = equivalent_bandwidths .^ 2;w
% 
% % Interaction Terms
% interaction_3dB_equiv = bandwidths_3dB .* equivalent_bandwidths;
% 
% % Combine all into a matrix
% features_matrix = [bandwidths_3dB bandwidths_5dB bandwidths_10dB equivalent_bandwidths ...
%                    ratios_3dB_to_10dB diff_equiv_3dB equiv_bandwidth_squared interaction_3dB_equiv];
% 
% % Calculate correlations with Lmax
% correlation_matrix = corr(features_matrix, Lmax_per_fiber, 'Rows', 'complete');
% disp('Enhanced Correlation Matrix:');
% disp(correlation_matrix);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Calculate new features based on your existing bandwidth data
data_matrix = [bandwidths_3dB, bandwidths_5dB, bandwidths_10dB, equivalent_bandwidths, Lmax_per_fiber];
names = {'3dB_BW', '5dB_BW', '10dB_BW', 'Eq_BW', 'Lmax'};

% Log transformations of bandwidths
log_3dB = log(bandwidths_3dB + 1);  % Avoid log(0) issues
log_5dB = log(bandwidths_5dB + 1);
log_10dB = log(bandwidths_10dB + 1);

% Square root transformation
sqrt_Eq_BW = sqrt(equivalent_bandwidths);

% Create interaction terms
% interaction_3dB_5dB = bandwidths_3dB .* bandwidths_5dB;
% interaction_all = bandwidths_3dB .* bandwidths_5dB .* equivalent_bandwidths;

% Aggregate all features
% features_matrix = [data_matrix, log_3dB, log_5dB, log_10dB, sqrt_Eq_BW, interaction_3dB_5dB, interaction_all];
features_matrix = [data_matrix, log_3dB, log_5dB, log_10dB, sqrt_Eq_BW];

% Update names for features
extended_names = [names, 'log_3dB', 'log_5dB', 'log_10dB', 'sqrt_Eq_BW'];

% Calculate the new correlation matrix
new_correlation_matrix = corr(features_matrix, 'Rows', 'complete');
disp('Extended Correlation Matrix:');
disp(array2table(new_correlation_matrix, 'RowNames', extended_names, 'VariableNames', extended_names));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prepare independent variables (all features except Lmax)
X = features_matrix(:, 1:end-1);  % Exclude Lmax from features for prediction
y = features_matrix(:, end);  % Lmax is the dependent variable

% Fit a multivariate linear regression model
model = fitlm(X, y, 'VarNames', extended_names(1:end));

% Display model summary
disp(model);

% Predict Lmax using the model
predicted_Lmax = predict(model, X);

% Calculate and display Mean Squared Error
mse = mean((y - predicted_Lmax).^2);
fprintf('Mean Squared Error of the model: %f\n', mse);

% Plot actual vs predicted Lmax
figure;
plot(y, predicted_Lmax, 'bo');
hold on;
plot(y, y, 'r--'); % Perfect prediction line
xlabel('Actual Lmax');
ylabel('Predicted Lmax');
title('Actual vs. Predicted Lmax');
legend('Predicted Lmax', 'Actual Lmax', 'Location', 'Best');
grid on;
hold off;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Function to calculate the -3dB bandwidth
function bandwidth_3dB = calculateMinus3dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -3dB from the peak
    within_3dB_indices = find(TF_dB >= max_TF_dB - 3);

    % Find the -3dB bandwidth, which is the difference between the first and last frequencies within the -3dB range
    if ~isempty(within_3dB_indices)
        bandwidth_3dB = freq(within_3dB_indices(end)) - freq(within_3dB_indices(1));
    else
        bandwidth_3dB = NaN; % Return NaN if there's no bandwidth within -3dB
    end
end
% Function to calculate the -5dB bandwidth
function bandwidth_5dB = calculateMinus5dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -5dB from the peak
    within_5dB_indices = find(TF_dB >= max_TF_dB - 5);

    % Find the -5dB bandwidth, which is the difference between the first and last frequencies within the -5dB range
    if ~isempty(within_5dB_indices)
        bandwidth_5dB = freq(within_5dB_indices(end)) - freq(within_5dB_indices(1));
    else
        bandwidth_5dB = NaN; % Return NaN if there's no bandwidth within -5dB
    end
end

% Function to calculate the -10dB bandwidth
function bandwidth_10dB = calculateMinus10dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -10dB from the peak
    within_10dB_indices = find(TF_dB >= max_TF_dB - 10);

    % Find the -10dB bandwidth, which is the difference between the first and last frequencies within the -10dB range
    if ~isempty(within_10dB_indices)
        bandwidth_10dB = freq(within_10dB_indices(end)) - freq(within_10dB_indices(1));
    else
        bandwidth_10dB = NaN; % Return NaN if there's no bandwidth within -10dB
    end
end




% Function to calculate the equivalent bandwidth
function equivalent_bandwidth = calculateEquivalentBandwidth(TF, freq)
    % Square the magnitude of the transfer function
    TF_squared = abs(TF).^2;

    % Integrate over frequency to find total power
    total_power = trapz(freq, TF_squared);

    % Calculate the equivalent bandwidth based on total power
    equivalent_bandwidth = total_power / max(TF_squared);
end
