close all ;
% Step 1: Load data 
load('MMF_transferFunctions_OM4_400m.mat');
load('DataBER_106.25G_OM4.mat');
load('DataLmax_106.25G_OM4.mat');
% Step 2: Extract relevant variables

Lambdas = Lambdas;
Laszers = Laser;
frequencies = freq;
Transfer_fct_MMF_OM4 = Hf_MMF_OM4;
EMB_OM4 = EMB_OM4;
Group_delay_OM4 = taug_OM4;

%Extract transfer functions for the chosen wavelength and laser

laser_idx = 1;
laser_index=1;
lambda_idx = 1;
fiber_index = 1;
wavelength_index=1;
            transfer_function = squeeze(Hf_MMF_OM4(lambda_idx, laser_idx, :, 1));

                % Step 4: Generate the plot
                figure;
                plot(freq, 10*log10(abs(transfer_function)));
                xlabel('Frequency');
                ylabel('Transfer Function');
                title('Transfer Function vs. Frequency at wavelength ',Lambdas(lambda_idx));
                grid on;
                
                % Step 5: Customize the plot
                % Add legend indicating mode groups
                %legendCell = cellstr(num2str((1:size(taug_OM4, 3))', 'Mode Group %d'));
                %legend(legendCell);
 % Assuming freq and Hf_MMF_OM4 are already defined and loaded correctly

% Set reference distance and reference transfer function at 400m for a specific laser and wavelength
Lref = 400; % Reference distance in meters
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
reference_TF_dB = 10*log10(reference_TF/max(reference_TF)); % Convert to dB normalized to max
%Prepare a plot
figure;
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

desired_distances = Lengths(2:end); % Exclude the first length (reference length)
Lref = 400; % Reference length, assuming 400m is the reference length

% Get a colormap with degrading colors (e.g., jet colormap)
cmap = jet(length(desired_distances)); % Colormap with the same number of colors as distances

% Loop over the other lengths
figure;
hold on;
for i = 1:length(desired_distances)
    L = desired_distances(i);
    
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
    TF_scaled = interp1(freq_scaled, TF, freq, "linear");
    
    % Normalize to the maximum value at 400m
    TF_scaled_dB = 10*log10(abs(TF_scaled / max(reference_TF))); % Convert to dB normalized to max at 400m

    % Plot with color from the colormap
    plot(freq / 1e9, TF_scaled_dB, 'Color', cmap(i, :), 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
colormap(cmap); % Apply the colormap
colorbar; % Show a colorbar to indicate the color gradient
grid on;
hold off;

% Lmax analysis:
Lmax_all = squeeze(Lmax_OM4(:, :, 1, :)); % Extract Lmax values
Lmax_all_vector = reshape(Lmax_all, [], 1); % Flatten Lmax into a vector

% Find the indices of the shortest and longest Lmax values
[~, idx_short] = min(Lmax_all_vector);  % Index of the shortest Lmax
[~, idx_long] = max(Lmax_all_vector);   % Index of the longest Lmax

% Get the corresponding fiber lengths for the shortest and longest Lmax
L_short = Lengths(idx_short);  % Fiber length corresponding to shortest Lmax
L_long = Lengths(idx_long);    % Fiber length corresponding to longest Lmax

% Get the transfer functions for both fibers
% Short fiber
K_short = Lref / L_short; % Scaling factor for short length
freq_scaled_short = freq * K_short;
TF_short = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
TF_scaled_short = interp1(freq_scaled_short, TF_short, freq, "linear");
TF_scaled_dB_short = 10*log10(abs(TF_scaled_short / max(reference_TF)));

% Long fiber
K_long = Lref / L_long; % Scaling factor for long length
freq_scaled_long = freq * K_long;
TF_long = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
TF_scaled_dB_long = interp1(freq_scaled_long, TF_long, freq, "linear");
TF_scaled_dB_long = 10*log10(abs(TF_scaled_long / max(reference_TF)));

% Plot both transfer functions for comparison
figure;
hold on;
plot(freq / 1e9, TF_scaled_dB_short, 'r-', 'DisplayName', sprintf('%d m (Short Lmax)', L_short)); % Short fiber
plot(freq / 1e9, TF_scaled_dB_long, 'b-', 'DisplayName', sprintf('%d m (Long Lmax)', L_long));  % Long fiber

% Set the same axis limits to highlight the differences
xlim([0 300]); % Set the same x-axis limits (frequency in GHz)
ylim([-20 5]); % Set the same y-axis limits (transfer function in dB)

% Add labels, title, and legend
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Comparison of Transfer Functions for Short and Long Fiber Lengths');
legend show;
grid on;
hold off;



% Define lengths
L = 400;
Lref = 400;
K = Lref / L;

% Initialize new arrays for the scaled transfer functions
new_Transfer_fct = zeros(size(Transfer_fct_MMF_OM4));
New_HF_400dB = zeros(size(Transfer_fct_MMF_OM4));

% Loop over all wavelengths, lasers, and fibers
for lambda_idx = 1:size(Transfer_fct_MMF_OM4, 1)
    for laser_idx = 1:size(Transfer_fct_MMF_OM4, 2)
        for fiber_idx = 1:size(Transfer_fct_MMF_OM4, 4)
            % Original transfer function for this combination
            TF = abs(squeeze(Transfer_fct_MMF_OM4(lambda_idx, laser_idx, :, fiber_idx)));

            % Scale the frequencies
            freq_scaled = frequencies * K;

            % Interpolate the scaled transfer function
            TF_scaled_400 = interp1(freq_scaled, TF, frequencies, 'linear', 'extrap');
            TF_scaled_400_dB = 10 * log10(TF_scaled_400 / max(reference_TF));

            % Store the scaled transfer function
            new_Transfer_fct_400(lambda_idx, laser_idx, :, fiber_idx) = TF_scaled_400;
            New_HF_400dB(lambda_idx, laser_idx, :, fiber_idx) = TF_scaled_400_dB;
        end
    end
end




numWavelengths = size(Hf_MMF_OM4, 1);
numLasers = size(Hf_MMF_OM4, 2);
numFibers = size(Hf_MMF_OM4, 4);

% Initialize an array to store the equivalent bandwidths
equivalent_bandwidths_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_3dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_5dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_10dB_all = zeros(numWavelengths, numLasers, numFibers);
% Iterate over all wavelengths, lasers, and fibers
for wavelength_index = 1:numWavelengths
    for laser_index = 1:numLasers
        for fiber_index = 1:numFibers
            % Extract the transfer function for this specific combination
            TF_selected = squeeze(new_Transfer_fct_400(wavelength_index, laser_index, :, fiber_index));

            % Calculate the equivalent bandwidth for the current combination
            equivalent_bandwidths_all(wavelength_index, laser_index, fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
            bandwidths_3dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus3dBBandwidth(TF_selected, freq);
            bandwidths_5dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus5dBBandwidth(TF_selected, freq);
            bandwidths_10dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus10dBBandwidth(TF_selected, freq);
        end
    end
end
% Reshape the 3D arrays into 1D vectors
vector_equiv = reshape(equivalent_bandwidths_all, [], 1);
vector_3dB = reshape(bandwidths_3dB_all, [], 1);
vector_5dB = reshape(bandwidths_5dB_all, [], 1);
vector_10dB = reshape(bandwidths_10dB_all, [], 1);

% Display the size of the new vector to confirm the operation
disp(size(vector_equiv));
disp(size(vector_3dB));
disp(size(vector_5dB));
disp(size(vector_10dB));
Lengths = [0 30 50 70 100 150 200 250 300 350 400];  % Distances in meters
% Extract the BER data for the specific setting across all fibers and distances
BER_selected_test = squeeze(BER_OM4(:, :, 1, :, 11));  % Resulting size should be [8 x 4 x 3766]
BER_selected_vector = reshape(BER_selected_test, [], 1);  % The empty bracket automatically calculates the necessary size
% Reshape bandwidth matrices to match the number of rows in BER_selected (NOM4)

%Create a matrix of all bandwidths and Lmax
data_matrix = [vector_3dB vector_5dB vector_10dB vector_equiv BER_selected_vector];
correlation_matrix = corr(data_matrix, 'Rows', 'complete');  % 'complete' to ignore NaN values
% Display the correlation matrix
disp('Correlation matrix:');
disp(correlation_matrix);
figure;
labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', 'BER'};
heatmap(labels, labels, correlation_matrix);
title('Correlation Heatmap between Bandwidth Features and BER at 400 m');
 


% correlation_value = correlation_matrix(5, 4);

% Initialize a matrix to store the correlations
correlation_matrix_all = zeros(numWavelengths, numLasers);

% Compute the correlation for each wavelength and laser combination
for wavelength_index = 1:numWavelengths
    for laser_index = 1:numLasers
        % Extract BER and equivalent bandwidth for the current combination
        BER_vector = squeeze(BER_OM4(wavelength_index, laser_index, 1, :, 5));  % Adjust indices based on your data
        equivalent_bandwidth_vector = squeeze(equivalent_bandwidths_all(wavelength_index, laser_index, :));
        
        % Reshape vectors to match dimensions if necessary
        BER_vector = reshape(BER_vector, [], 1);
        equivalent_bandwidth_vector = reshape(equivalent_bandwidth_vector, [], 1);
        
        % Clean data by removing NaN and Inf values
        BER_log=log10(BER_vector);
        validIndex = ~(isnan(BER_log) | isinf(BER_log) | isnan(equivalent_bandwidth_vector) | isinf(equivalent_bandwidth_vector));
        BER_cleaned = BER_log(validIndex);
        equivalent_bandwidth_cleaned = equivalent_bandwidth_vector(validIndex);
        
        % Compute correlation
        if ~isempty(BER_log) && ~isempty(equivalent_bandwidth_cleaned)
            correlation_value = corr(BER_cleaned, equivalent_bandwidth_cleaned, 'Rows', 'complete');
            correlation_matrix_all(wavelength_index, laser_index) = correlation_value;
        else
            correlation_matrix_all(wavelength_index, laser_index) = NaN; % Assign NaN if data is insufficient
        end
    end
end

% Display the correlation matrix
disp('Correlation matrix:');
disp(correlation_matrix_all);

% Generate the heatmap
figure;
heatmap(correlation_matrix, 'Colormap', parula, 'ColorbarVisible', 'on');
xlabel('Laser Index');
ylabel('Wavelength Index');
title('Heatmap of Correlation between BER and Equivalent Bandwidth');



% Reshape bandwidth matrices to match the number of rows in BER_selected (NOM4)
test_ber=log10(BER_selected_vector);

%clean 
% Create a logical index for non-NaN and non-Inf values
validIndex = ~(isnan(test_ber) | isinf(test_ber));

% Filter out NaN and Inf values from Lmax_all_vector
BER_cleaned = test_ber(validIndex);

% Apply the same valid index to the other vectors
vector_3dB_cleaned_BER = vector_3dB(validIndex);
vector_5dB_cleaned_BER  = vector_5dB(validIndex);
vector_10dB_cleaned_BER  = vector_10dB(validIndex);
vector_equiv_cleaned_BER  = vector_equiv(validIndex);


%Create a matrix of all bandwidths and Lmax
data_matrix = [vector_3dB_cleaned_BER  vector_5dB_cleaned_BER vector_10dB_cleaned_BER vector_equiv_cleaned_BER BER_cleaned];
correlation_matrix = corr(data_matrix, 'Rows', 'complete');  % 'complete' to ignore NaN values
% Display the correlation matrix
disp('Correlation matrix:');
disp(correlation_matrix);

figure;
labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', 'BER'};
heatmap(labels, labels, correlation_matrix);
title('Correlation Heatmap between Bandwidth Features and BER at 400 m with log ');











%Lmax analysis :

Lmax_all= squeeze(Lmax_OM4(:, :, 1, :));
Lmax_all_vector = reshape(Lmax_all, [], 1);

% Create a logical index for non-NaN and non-Inf values
validIndex = ~(isnan(Lmax_all_vector) | isinf(Lmax_all_vector));

% Filter out NaN and Inf values from Lmax_all_vector
Lmax_all_vector_cleaned = Lmax_all_vector(validIndex);

% Apply the same valid index to the other vectors
vector_3dB_cleaned = vector_3dB(validIndex);
vector_5dB_cleaned = vector_5dB(validIndex);
vector_10dB_cleaned = vector_10dB(validIndex);
vector_equiv_cleaned = vector_equiv(validIndex);

%Create a matrix of all bandwidths and Lmax
data_matrix = [vector_3dB_cleaned vector_5dB_cleaned vector_10dB_cleaned vector_equiv_cleaned Lmax_all_vector_cleaned];
correlation_matrix = corr(data_matrix, 'Rows', 'complete');  % 'complete' to ignore NaN values
% Display the correlation matrix
disp('Correlation matrix:');
disp(correlation_matrix);

figure;
labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', 'Lmax'};
heatmap(labels, labels, correlation_matrix);
title('Correlation Heatmap between Bandwidth Features and lmax at 400 m');





% Perform linear regression
p = polyfit(vector_equiv_cleaned, Lmax_all_vector_cleaned, 1);
regression_line = polyval(p, vector_equiv_cleaned);

% Ensure sample points are unique for interpolation
[unique_vector_equiv, unique_idx] = unique(vector_equiv_cleaned);
unique_Lmax_all = Lmax_all_vector_cleaned(unique_idx);

% Generate scatter plot with regression line
% Define the range around Equivalent Bandwidth = 100
range_min = 9;
range_max = 11;

% Find points within the specified range
range_indices = find(vector_equiv_cleaned >= range_min & vector_equiv_cleaned <= range_max);
range_points_Lmax = Lmax_all_vector_cleaned(range_indices);

% Find the highest and lowest points within the range
[max_point, max_idx] = max(range_points_Lmax);
[min_point, min_idx] = min(range_points_Lmax);

% Retrieve the corresponding indices for the original data
highest_idx = range_indices(max_idx);
lowest_idx = range_indices(min_idx);

% Generate scatter plot with regression line and highlight the highest and lowest points
figure;
scatter(vector_equiv_cleaned, Lmax_all_vector_cleaned, 20, 'filled', 'MarkerFaceAlpha', 0.6, 'MarkerEdgeColor', 'w');
hold on;
plot(vector_equiv_cleaned, regression_line, 'r', 'LineWidth', 2);

% Draw vertical line at Equivalent Bandwidth = 100
xline(100, 'k--', 'LineWidth', 2);

% Highlight the highest and lowest points
scatter(vector_equiv_cleaned(highest_idx), max_point, 50, 'g', 'filled', 'DisplayName', 'Highest Point');
scatter(vector_equiv_cleaned(lowest_idx), min_point, 50, 'm', 'filled', 'DisplayName', 'Lowest Point');

xlabel('Equivalent Bandwidth (Beq)', 'FontSize', 14);
ylabel('Maximum Length (Lmax)', 'FontSize', 14);
title('Lmax vs Beq', 'FontSize', 16);
grid on;
legend({'Data points', sprintf('Regression line (R^2=%.2f)', corr(vector_equiv_cleaned, Lmax_all_vector_cleaned)^2), ...
        'Vertical line at Beq=100', 'Highest Point', 'Lowest Point'}, 'Location', 'best');
hold off;


% Save the plot
saveas(gcf, 'Lmax_vs_Beq_400m.png');




% Define the values we want to compare
values_to_compare = [max_point, min_point]; 

% Initialize arrays to store the indices
wavelength_indices = zeros(size(values_to_compare));
laser_indices = zeros(size(values_to_compare));
fiber_indices = zeros(size(values_to_compare));
Lmax_first_equalizer=squeeze(Lmax_OM4(:,:,1,:));
% Define tolerance for finding values
tolerance = 0.00001; % Define an appropriate tolerance

for k = 1:length(values_to_compare)
    % Find the index of the value in the equivalent_bandwidths_all array
    [value_found, linear_index] = min(abs(Lmax_first_equalizer(:) - values_to_compare(k)));
    
    % Check if the value was found within an acceptable tolerance
    if value_found <= tolerance
        % Convert the linear index to subscripts
        [wavelength_index, laser_index, fiber_index] = ind2sub(size(Lmax_first_equalizer), linear_index);
        
        % Store the indices
        wavelength_indices(k) = wavelength_index;
        laser_indices(k) = laser_index;
        fiber_indices(k) = fiber_index;
        
        % Display the indices
        fprintf('The value %.6f corresponds to:\n', values_to_compare(k));
        fprintf('Wavelength index: %d\n', wavelength_index);
        fprintf('Laser index: %d\n', laser_index);
        fprintf('Fiber index: %d\n', fiber_index);
    else
        fprintf('The value %.6f was not found within the tolerance of %.6f.\n', values_to_compare(k), tolerance);
    end
end



% Assuming freq is defined as the frequency vector
% and Hf_MMF_OM4 is the 4D transfer function matrix: [wavelength_index, laser_index, frequency_index, fiber_index]

% Plot the transfer functions for each case
% Extract the transfer functions for the specified indices
TF_max = squeeze(Hf_MMF_OM4(wavelength_indices(1), laser_indices(1), :, fiber_indices(1)));
TF_min = squeeze(Hf_MMF_OM4(wavelength_indices(2), laser_indices(2), :, fiber_indices(2)));
TF_max_db = 10*log10(TF_max/max(TF_max)) ;
TF_min_db = 10*log10(TF_min/max(TF_min));
% Plot both transfer functions on the same figure
figure;
hold on;
plot(freq, TF_max_db, 'r', 'LineWidth', 2, 'DisplayName', 'Transfer Function for Hmax');
plot(freq, TF_min_db, 'b', 'LineWidth', 2, 'DisplayName', 'Transfer Function for Hmin');
hold off;

title('Transfer Functions for Hmax and Hmin 400');
xlabel('Frequency (Hz)');
ylabel('Normalized Transfer function in db');
legend('Location', 'best');
grid on;

% Save the figure as a PNG file
saveas(gcf, 'TransferFunctions_Hmax_Hmin 400.png');





%%% verification of B.L =K
A_400= vector_3dB_cleaned .*400;
B_400= vector_5dB_cleaned .*400;
C_400= vector_10dB_cleaned.*400;
D_400= vector_equiv_cleaned .*400 ;


% Function to calculate the -3dB bandwidth
function bandwidth_3dB = calculateMinus3dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -3dB from the peak
    within_3dB_indices = find(TF_dB >= max_TF_dB - 3);

    % Find the -3dB bandwidth, which is the difference between the first and last frequencies within the -3dB range
    if ~isempty(within_3dB_indices)
        bandwidth_3dB = freq(within_3dB_indices(end)) - freq(within_3dB_indices(1));
    else
        bandwidth_3dB = NaN; % Return NaN if there's no bandwidth within -3dB
    end
end
% Function to calculate the -5dB bandwidth
function bandwidth_5dB = calculateMinus5dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -5dB from the peak
    within_5dB_indices = find(TF_dB >= max_TF_dB - 5);

    % Find the -5dB bandwidth, which is the difference between the first and last frequencies within the -5dB range
    if ~isempty(within_5dB_indices)
        bandwidth_5dB = freq(within_5dB_indices(end)) - freq(within_5dB_indices(1));
    else
        bandwidth_5dB = NaN; % Return NaN if there's no bandwidth within -5dB
    end
end

% Function to calculate the -10dB bandwidth
function bandwidth_10dB = calculateMinus10dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -10dB from the peak
    within_10dB_indices = find(TF_dB >= max_TF_dB - 10);

    % Find the -10dB bandwidth, which is the difference between the first and last frequencies within the -10dB range
    if ~isempty(within_10dB_indices)
        bandwidth_10dB = freq(within_10dB_indices(end)) - freq(within_10dB_indices(1));
    else
        bandwidth_10dB = NaN; % Return NaN if there's no bandwidth within -10dB
    end
end

% Function to calculate the equivalent bandwidth
function equivalent_bandwidth = calculateEquivalentBandwidth(TF, freq)
    % Square the magnitude of the transfer function
    TF_squared = abs(TF).^2;

    % Integrate over frequency to find total power
    total_power = trapz(freq, TF_squared);

    % Calculate the equivalent bandwidth based on total power
    equivalent_bandwidth = total_power / max(TF_squared) /1e9;
end


