close all ;
% Step 1: Load data 
load('MMF_transferFunctions_OM4_400m.mat');
load('DataBER_106.25G_OM4.mat');
load('DataLmax_106.25G_OM4.mat');
% Step 2: Extract relevant variables

Lambdas = Lambdas;
Laszers = Laser;
frequencies = freq;
Transfer_fct_MMF_OM4 = Hf_MMF_OM4;
EMB_OM4 = EMB_OM4;
Group_delay_OM4 = taug_OM4;

%Extract transfer functions for the chosen wavelength and laser

laser_idx = 1;
laser_index=1;
lambda_idx = 1;
fiber_index = 1;
wavelength_index=1;
            transfer_function = squeeze(Hf_MMF_OM4(lambda_idx, laser_idx, :, 1));

                % Step 4: Generate the plot
                figure;
                plot(freq, 10*log10(abs(transfer_function)));
                xlabel('Frequency');
                ylabel('Transfer Function');
                title('Transfer Function vs. Frequency at wavelength ',Lambdas(lambda_idx));
                grid on;
                
                % Step 5: Customize the plot
                % Add legend indicating mode groups
                %legendCell = cellstr(num2str((1:size(taug_OM4, 3))', 'Mode Group %d'));
                %legend(legendCell);
 % Assuming freq and Hf_MMF_OM4 are already defined and loaded correctly

% Set reference distance and reference transfer function at 400m for a specific laser and wavelength
Lref = 400; % Reference distance in meters
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
reference_TF_dB = 10*log10(reference_TF/max(reference_TF)); % Convert to dB normalized to max
%Prepare a plot
figure;
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

desired_distances=Lengths(2:end);
% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
    TF_scaled = interp1(freq_scaled, TF, freq, "linear");
    
    % Normalize to the maximum value at 400m
    TF_scaled_dB = 10*log10(abs(TF_scaled/max(reference_TF))); % Convert to dB normalized to max at 400m

    % Plot
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;



% Define lengths
L = 50;
Lref = 400;
K = Lref / L;

% Initialize new arrays for the scaled transfer functions
new_Transfer_fct = zeros(size(Transfer_fct_MMF_OM4));
New_HF_50dB = zeros(size(Transfer_fct_MMF_OM4));

% Loop over all wavelengths, lasers, and fibers
for lambda_idx = 1:size(Transfer_fct_MMF_OM4, 1)
    for laser_idx = 1:size(Transfer_fct_MMF_OM4, 2)
        for fiber_idx = 1:size(Transfer_fct_MMF_OM4, 4)
            % Original transfer function for this combination
            TF = abs(squeeze(Transfer_fct_MMF_OM4(lambda_idx, laser_idx, :, fiber_idx)));

            % Scale the frequencies
            freq_scaled = frequencies * K;

            % Interpolate the scaled transfer function
            TF_scaled_50 = interp1(freq_scaled, TF, frequencies, 'linear', 'extrap');
            TF_scaled_50_dB = 10 * log10(TF_scaled_50 / max(reference_TF));

            % Store the scaled transfer function
            new_Transfer_fct_50(lambda_idx, laser_idx, :, fiber_idx) = TF_scaled_50;
            New_HF_50dB(lambda_idx, laser_idx, :, fiber_idx) = TF_scaled_50_dB;
        end
    end
end




numWavelengths = size(Hf_MMF_OM4, 1);
numLasers = size(Hf_MMF_OM4, 2);
numFibers = size(Hf_MMF_OM4, 4);

% Initialize an array to store the equivalent bandwidths
equivalent_bandwidths_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_3dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_5dB_all = zeros(numWavelengths, numLasers, numFibers);
bandwidths_10dB_all = zeros(numWavelengths, numLasers, numFibers);
% Iterate over all wavelengths, lasers, and fibers
for wavelength_index = 1:numWavelengths
    for laser_index = 1:numLasers
        for fiber_index = 1:numFibers
            % Extract the transfer function for this specific combination
            TF_selected = squeeze(new_Transfer_fct_50(wavelength_index, laser_index, :, fiber_index));

            % Calculate the equivalent bandwidth for the current combination
            equivalent_bandwidths_all(wavelength_index, laser_index, fiber_index) = calculateEquivalentBandwidth(TF_selected, freq);
            bandwidths_3dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus3dBBandwidth(TF_selected, freq);
            bandwidths_5dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus5dBBandwidth(TF_selected, freq);
            bandwidths_10dB_all(wavelength_index, laser_index, fiber_index) = calculateMinus10dBBandwidth(TF_selected, freq);
        end
    end
end
% Reshape the 3D arrays into 1D vectors
vector_equiv = reshape(equivalent_bandwidths_all, [], 1);
vector_3dB = reshape(bandwidths_3dB_all, [], 1);
vector_5dB = reshape(bandwidths_5dB_all, [], 1);
vector_10dB = reshape(bandwidths_10dB_all, [], 1);

% Display the size of the new vector to confirm the operation
disp(size(vector_equiv));
disp(size(vector_3dB));
disp(size(vector_5dB));
disp(size(vector_10dB));
Lengths = [0 30 50 70 100 150 200 250 300 350 400];  % Distances in meters
% Extract the BER data for the specific setting across all fibers and distances
BER_selected_new = squeeze(BER_OM4(:, :, 1, :, :));  % Resulting size should be [NOM4 x Ndist]
BER_selected_new_reshaped =reshape(BER_selected_new, [], 11);
% Extract the last slice of the fourth dimension
last_slice = BER_selected_new(:, :, :, 3);
%BER_selected = squeeze(BER_OM4(lambda_index, laser_index, equalizer_index, :, :));  % Resulting size should be [NOM4 x Ndist]
BER_selected_test = squeeze(BER_OM4(:, :, 1, :, 3));  % Resulting size should be [8 x 4 x 3766]
BER_selected_vector = reshape(BER_selected_test, [], 1);  % The empty bracket automatically calculates the necessary size
% Reshape bandwidth matrices to match the number of rows in BER_selected (NOM4)

%Create a matrix of all bandwidths and Lmax
data_matrix = [vector_3dB vector_5dB vector_10dB vector_equiv BER_selected_vector];
correlation_matrix = corr(data_matrix, 'Rows', 'complete');  % 'complete' to ignore NaN values
% Display the correlation matrix
disp('Correlation matrix:');
disp(correlation_matrix);

figure;
labels = {'-3dB Bandwidth', '-5dB Bandwidth', '-10dB Bandwidth', 'Equivalent Bandwidth', 'BER'};
heatmap(labels, labels, correlation_matrix);
title('Correlation Heatmap between Bandwidth Features and Lmax');











% Function to calculate the -3dB bandwidth
function bandwidth_3dB = calculateMinus3dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -3dB from the peak
    within_3dB_indices = find(TF_dB >= max_TF_dB - 3);

    % Find the -3dB bandwidth, which is the difference between the first and last frequencies within the -3dB range
    if ~isempty(within_3dB_indices)
        bandwidth_3dB = freq(within_3dB_indices(end)) - freq(within_3dB_indices(1));
    else
        bandwidth_3dB = NaN; % Return NaN if there's no bandwidth within -3dB
    end
end
% Function to calculate the -5dB bandwidth
function bandwidth_5dB = calculateMinus5dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -5dB from the peak
    within_5dB_indices = find(TF_dB >= max_TF_dB - 5);

    % Find the -5dB bandwidth, which is the difference between the first and last frequencies within the -5dB range
    if ~isempty(within_5dB_indices)
        bandwidth_5dB = freq(within_5dB_indices(end)) - freq(within_5dB_indices(1));
    else
        bandwidth_5dB = NaN; % Return NaN if there's no bandwidth within -5dB
    end
end

% Function to calculate the -10dB bandwidth
function bandwidth_10dB = calculateMinus10dBBandwidth(TF, freq)
    % Convert the transfer function to dB
    TF_dB = 10 * log10(abs(TF));

    % Find the maximum magnitude in dB
    max_TF_dB = max(TF_dB);

    % Find the frequencies where the magnitude is greater than -10dB from the peak
    within_10dB_indices = find(TF_dB >= max_TF_dB - 10);

    % Find the -10dB bandwidth, which is the difference between the first and last frequencies within the -10dB range
    if ~isempty(within_10dB_indices)
        bandwidth_10dB = freq(within_10dB_indices(end)) - freq(within_10dB_indices(1));
    else
        bandwidth_10dB = NaN; % Return NaN if there's no bandwidth within -10dB
    end
end

% Function to calculate the equivalent bandwidth
function equivalent_bandwidth = calculateEquivalentBandwidth(TF, freq)
    % Square the magnitude of the transfer function
    TF_squared = abs(TF).^2;

    % Integrate over frequency to find total power
    total_power = trapz(freq, TF_squared);

    % Calculate the equivalent bandwidth based on total power
    equivalent_bandwidth = total_power / max(TF_squared);
end

