close all ;
% Step 1: Load data 
load('MMF_transferFunctions_OM4_400m.mat');
load('DataBER_106.25G_OM4.mat');
load('DataLmax_106.25G_OM4.mat');
% Step 2: Extract relevant variables

Lambdas = Lambdas;
Laszers = Laser;
frequencies = freq;
Transfer_fct_MMF_OM4 = Hf_MMF_OM4;
EMB_OM4 = EMB_OM4;
Group_delay_OM4 = taug_OM4;

% Step 3: Decide on the type of plot
% For example, let's say you want to plot the transfer functions for a specific wavelength and laser

% Choose a wavelength and laser index
%lambda_idx = 1; % Change this index as needed
%laser_idx = 1;  % Change this index as needed

%Extract transfer functions for the chosen wavelength and laser

laser_idx = 1;
laser_index=1;
lambda_idx = 1;
fiber_index = 1;
wavelength_index=1;
            transfer_function = squeeze(Hf_MMF_OM4(lambda_idx, laser_idx, :, 1));

                % Step 4: Generate the plot
                figure;
                plot(freq, 10*log10(abs(transfer_function)));
                xlabel('Frequency');
                ylabel('Transfer Function');
                title('Transfer Function vs. Frequency at wavelength ',Lambdas(lambda_idx));
                grid on;
                
                % Step 5: Customize the plot
                % Add legend indicating mode groups
                %legendCell = cellstr(num2str((1:size(taug_OM4, 3))', 'Mode Group %d'));
                %legend(legendCell);
 % Assuming freq and Hf_MMF_OM4 are already defined and loaded correctly

% Set reference distance and reference transfer function at 400m for a specific laser and wavelength
Lref = 400; % Reference distance in meters
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
reference_TF_dB = 10*log10(reference_TF/max(reference_TF)); % Convert to dB normalized to max
%Prepare a plot
figure;
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

desired_distances=Lengths(2:end);
% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1))); % Absolute value for magnitude
    TF_scaled = interp1(freq_scaled, TF, freq, "linear");
    
    % Normalize to the maximum value at 400m
    TF_scaled_dB = 10*log10(abs(TF_scaled/max(reference_TF))); % Convert to dB normalized to max at 400m

    % Plot
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;




% Prepare the plot
figure;

% Loop over the desired distances
for L = desired_distances
    % Calculate the scaling factor K
    K = Lref / L;

    % Scale the frequency axis
    freq_scaled = freq * K;

    % Check for at least two points after scaling within the original frequency bounds
    valid_indices = find(freq_scaled >= min(freq) & freq_scaled <= max(freq));
    if numel(valid_indices) < 2
        disp(['Not enough points to interpolate for length ' num2str(L) 'm. Skipping this length.']);
        continue;  % Skip to the next iteration if not enough points
    end

    % Interpolate using the scaled frequency within bounds
    TF_scaled = interp1(freq(valid_indices), TF(valid_indices), freq, 'linear');

    % Normalize to the peak of the transfer function at the reference length
    TF_scaled_dB = 10 * log10(TF_scaled / max(TF));

    % Plot the normalized scaled transfer function
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
    hold on;
end

% Reference transfer function in dB, normalized to its own peak value
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
reference_TF_dB = 10 * log10(reference_TF / max(reference_TF));
plot(freq/1e9, reference_TF_dB, 'LineWidth', 2, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;
... [setup code] ...

%Prepare the plot
figure;

% Plot reference TF in dB, normalized to its own max
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
reference_TF_dB = 10 * log10(reference_TF / max(reference_TF));
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz
hold on;

% Loop over the other lengths
for L = desired_distances
    if L == Lref
        continue; % Skip the reference length
    end

    % Calculate scaling factor K
    K = Lref / L;
    
    % Scale the frequency axis
    freq_scaled = freq * K;

    % Obtain the scaled transfer function by interpolating
    TF_scaled = interp1(freq, reference_TF, freq_scaled, 'linear');
    
    % Normalize to the max at reference length and convert to dB
    TF_scaled_dB = 10 * log10(TF_scaled / max(reference_TF));
    
    % Plot the scaled TF in dB
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;
... [setup code] ...

%Prepare the plot
figure;
hold on;

% Normalize the reference transfer function to its own peak
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
max_ref_TF = max(reference_TF);
reference_TF_dB = 10 * log10(reference_TF / max_ref_TF);
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz

% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate scaling factor K
    K = Lref / L;
    
    % Scale the frequency axis
    freq_scaled = freq * K;
    
    % Get the original transfer function (for each length)
    original_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));

    % Interpolate using 'pchip' method to avoid overshooting
    TF_scaled = interp1(freq_scaled, original_TF,freq , 'linear');

    % Normalize the scaled transfer function to the peak of the reference transfer function
    TF_scaled_dB = 10 * log10(TF_scaled / max_ref_TF);

    % Correct any negative infinity values that may result from log of zero
    TF_scaled_dB(isinf(TF_scaled_dB)) = min(TF_scaled_dB(~isinf(TF_scaled_dB)));
    
    % Plot the scaled and normalized TF in dB
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend show;
grid on;
hold off;


 % ... [setup code] ...

% Prepare the plot
figure;
hold on;

% Normalize the reference transfer function to its own peak
reference_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));
max_ref_TF = max(reference_TF);
reference_TF_dB = 10 * log10(reference_TF / max_ref_TF);
plot(freq/1e9, reference_TF_dB, 'DisplayName', sprintf('%d m', Lref)); % Frequency in GHz

% Loop over the other lengths
for L = desired_distances
    % Skip the reference length
    if L == Lref
        continue;
    end

    % Calculate scaling factor K
    K = Lref / L;
    
    % Scale the frequency axis
    freq_scaled = freq * K;
    
    % Get the original transfer function (for each length)
    original_TF = abs(squeeze(Hf_MMF_OM4(wavelength_index, laser_index, :, 1)));

    % Interpolate using 'pchip' method to avoid overshooting
    TF_scaled = interp1(freq_scaled, original_TF,freq , 'linear');

    % Normalize the scaled transfer function to the peak of the reference transfer function
    TF_scaled_dB = 10 * log10(TF_scaled / max_ref_TF);

    % Cap values at 0 dB
    TF_scaled_dB(TF_scaled_dB > 0) = 0;
    
    % Plot the scaled and normalized TF in dB
    plot(freq/1e9, TF_scaled_dB, 'DisplayName', sprintf('%d m', L)); % Frequency in GHz
end

% Finalize the plot
xlabel('Frequency [GHz]');
ylabel('Normalized Transfer Function [dB]');
title('Normalized Transfer Function Scaling for Different Lengths (Fiber 1)');
legend('-DynamicLegend');
grid on;

% Set the x-axis limits from 0 to 100 GHz
xlim([0 100]);

hold off;